/*
 * OPEN Version 1.10
 * Copyright(C) 1995 Hiroyuki Sekiya
 * PSC 1999: Changes by Paulo.Custodio@snafu.de marked with PSC
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXPATH		80
#define MAXDIR		66
#define MAXFILE		9
#define MAXEXT		5
#define fnsplit		_splitpath
#define setvect		_dos_setvect
#endif


/* PSC: LXAPI includes */
#include <cap2.h>
#include <sysdefs.h>
#include <lhapi.h>
#include <lstring.h>
#include <interfac.h>
#include <event.h>
#include <keytab.h>
#include <task.h>
#include <cbcodes.h>

/* PSC: Constants for keyboard scan codes */
#define SCAN_O      0x186F      	/* O */
#define SCAN_ENTER  0x1C0D          /* Enter */
#define SCAN_SLASH	0x352F			/* / */
#define SCAN_F  	0x2166          /* F */
#define SCAN_ALT_F  0x2100          /* Alt-F */
#define SCAN_Q  	0x1071      	/* Q */
#define SCAN_ALT_Q  0x1000      	/* Alt-Q */
#define SCAN_R  	0x1372          /* R */
#define SCAN_Y  	0x1579          /* Y */
#define SCAN_ESCAPE 0x011B          /* Esc */
#define SCAN_PASTE  0xD600          /* Paste */


/* PSC: add path to 123 and quicken files */
#define DEFAULT_DBPATH		"a:\\_dat;c:\\_dat;a:\\123;c:\\123;a:\\quicken;c:\\quicken"

/* PSC: Function based on GetTaskId from Launcher (Lnch102.zip) */
struct task far *GetTaskTCB(unsigned int hotKey)
{
    struct task far *tcb;
	unsigned int	tNum;
	unsigned int	i;
	
	tcb=(struct task far *)m_get_TCB();
	tNum=(unsigned int)m_get_TCB_size();
	for(i=0;i<tNum;i++){
		if(tcb[i].t_hotkey==hotKey) return(&tcb[i]);
	}
	return(NULL);
}

/* PSC: Clipboard copy copied from LXREF */
int PutClipboard(char *owner, char *textbuffer)
{
    int err;
    m_lock();
    err = m_open_cb();
    if (err!=CB_OK) {
        m_unlock();
        return err;
    }
    /* Clipboard is now open */
    m_reset_cb(owner);
    m_new_rep("TEXT");
    err = m_cb_write(textbuffer, strlen(textbuffer));
    m_fini_rep();
    m_close_cb();
    m_unlock();
    return err;
}

/* PSC: Critical error handler: return FAIL if non-existent drive A: is accessed */
void __far criterr_handler(unsigned deverror, unsigned errcode, unsigned __far *devhdr)
{
	_hardresume( _HARDERR_FAIL );		/* Return Fail code to caller */
}
void install_criterr_handler()
{
	_harderr( criterr_handler );
}


/* PSC: Original code follows */



#define MENUKEY 0xC800
#define	countof(x) (sizeof(x)/(sizeof((x)[0])))

typedef unsigned char	BYTE;
typedef unsigned int	WORD;

typedef struct sAPPINFO {
	char *ext;
	char *envname;      /* Env file, NULL if none */
	WORD keycode;
	struct {
		BOOL clipboard : 1;		/* TRUE to store file name in clipboard */
		BOOL close_before : 1;	/* TRUE to close app before starting it */
		BOOL push_file : 1;		/* TRUE to push "filename\n" to buffer after p_open_keys */
		BOOL only_close : 1;	/* if TRUE: if app is open, close it only, do not re-open (123) */
	} flag;
	WORD *p_open_keys;  /* NULL terminated list of keys to open file, if needed */
	WORD *p_close_keys; /* NULL terminated list of keys to close app */
} APPINFO;

/* Keys for Alt-F, Open, Paste, Enter */
WORD app_afopen_keys[] = { 	
	SCAN_ESCAPE, SCAN_ESCAPE, 	/* exit from dialog box, if any */
	SCAN_ALT_F, SCAN_O, SCAN_PASTE, SCAN_ENTER, NULL
};
/* Keys for Alt-Q */
WORD app_close_keys[] = {
	SCAN_ALT_Q, NULL 
};

/* Keys to open and close wk1 */
/* The sequence of 6 Esc chars is to exit from any menu that might be open */
WORD app_wk1_open_keys[] = {
	SCAN_ESCAPE, SCAN_ESCAPE, 
	SCAN_ESCAPE, SCAN_ESCAPE, 
	SCAN_ESCAPE, SCAN_ESCAPE, 	/* exit from dialog, if any */
	SCAN_SLASH, SCAN_F, SCAN_R,	/* Menu File Retrieve */
	SCAN_ESCAPE, SCAN_ESCAPE, 	/* escape from defaults */
	NULL 						/* 123 does not accept paste, need to push each char
								   of file name */
};
WORD app_wk1_close_keys[] = {
	SCAN_ESCAPE, SCAN_ESCAPE, 
	SCAN_ESCAPE, SCAN_ESCAPE, 
	SCAN_ESCAPE, SCAN_ESCAPE, 	/* exit from dialog, if any */
	SCAN_SLASH, SCAN_Q, SCAN_Y,
	NULL
};

#define ENV_FILE_OFFSET		0		/* PSC: All env files have an offset of 0 */

APPINFO appinfo[] = {
    /* ext   env                   key    clip  close pushf onlyc open-keys         close-keys */
	{".gdb","c:\\_dat\\db.env",    0xBA00,FALSE,TRUE, FALSE,FALSE,NULL,			    app_close_keys },
	{".ndb","c:\\_dat\\note.env",  0xBE00,FALSE,TRUE, FALSE,FALSE,NULL,			    app_close_keys },
	{".pdb","c:\\_dat\\phone.env", 0xB400,FALSE,TRUE, FALSE,FALSE,NULL,			    app_close_keys },
	{".adb","c:\\_dat\\apptbk.env",0xB000,FALSE,TRUE, FALSE,FALSE,NULL,			    app_close_keys },
	{".wdb","c:\\_dat\\world.env", 0xC600,FALSE,TRUE, FALSE,FALSE,NULL,			    app_close_keys },
	/* PSC: new file types */
	{".pdt",NULL,                  0xAC00,TRUE, FALSE,FALSE,FALSE,app_afopen_keys,  app_close_keys },
	{".wk1",NULL,                  0xBC00,FALSE,TRUE, TRUE, TRUE, app_wk1_open_keys,app_wk1_close_keys },
	/* Default to MEMO, for any extension */
	{"",    NULL,                  0xB800,TRUE, FALSE,FALSE,FALSE,app_afopen_keys,  app_close_keys },
};

int fexist(const char *name)
{
	FILE *fp;

	if ((fp = fopen(name, "rb")) == NULL)
		return 0;
	else {
		fclose(fp);
		return 1;
	}
}

void PushKey(WORD keycode)
{
#ifdef __TURBOC__
	_CX = keycode;
	_AH = 0x05;
	geninterrupt(0x16);
#else
	_asm {
		mov		cx, keycode
		mov		ah, 0x05
		int		0x16
	};
#endif
}
/* PSC: Push a sequence of keys, given as an array of WORDs, NULL terminated */
void PushKeySequence( WORD *keys )
{
	for( ; *keys != NULL ; keys++ )
		PushKey( *keys );
}
/* PSC: Push an ASCII string */
void PushKeyString( char *str )
{
	for( ; *str != '\0' ; str++ )
        PushKey( (WORD)(*str) );		/* HACK: for Ascii chars, scan may be 00 */
}

int launch(const char *dir, const char *name, const char *ext)
{
	FILE *fp;
	static char path[MAXPATH];
	WORD i;
	APPINFO *thisinfo = NULL;

	if (*ext == '\0') {
		for (i=0; i<countof(appinfo); ++i) {
			strcat(strcat(strcpy(path, dir), name), appinfo[i].ext);
			if (fexist(path)) goto LAUNCH;
		}
		return 0;
	} else {
		strcat(strcat(strcpy(path, dir), name), ext);
		/* PSC: path is invariant, make test out of loop */
		if ( ! fexist(path) )
			return 0;	

        /* PSC: Bug - was counting to countof()-1 */
		for (i=0; i<countof(appinfo) ; ++i)
			if (appinfo[i].ext[0] == '\0' ||			/* Default: MEMO */
				stricmp(appinfo[i].ext, ext) == 0)		/* or extension matches */
				goto LAUNCH;
		return 0;
	}
LAUNCH:
    /* PSC: Push keys <Appkey>,<Alt-Q> to close application, if it is open */
	thisinfo = &(appinfo[i]);
	if ( thisinfo->flag.close_before ) {
		/* get application info */
		struct task far *tcb = GetTaskTCB(thisinfo->keycode);
		if (tcb) {
			if ( tcb->t_state != PS_CLOSED ) {
				/* Need to send Appkey, Alt-Q: so that application closes
				*  and reopens later with new file */
				PushKey(thisinfo->keycode);
				PushKeySequence(thisinfo->p_close_keys);
				if ( thisinfo->flag.only_close )
					return 1;			/* do not re-open, to let user Save file */
			}
		}
	}

    /* PSC: store file name in clipboard if clipboard flag is set */
    if ( thisinfo->flag.clipboard ) {
        if ( PutClipboard("OPEN", path) != CB_OK )
            return 0;
    }
    
	/* PSC: envname may be NULL, if there is no env file */
	if ( thisinfo->envname != NULL ) {
    	if ((fp = fopen(thisinfo->envname, "r+b")) == NULL)
    		return 0;

        fseek(fp, ENV_FILE_OFFSET, SEEK_SET);
        fwrite(path, sizeof(path[0]), strlen(path)+1, fp);
    
    	fclose(fp);
	}
	PushKey(thisinfo->keycode);

	/* PSC: Push keys needed to open file, if any */
	if ( thisinfo->p_open_keys ) {
	    PushKeySequence( thisinfo->p_open_keys );
	}

	/* PSC: Push "filename\n" if needed */
	if ( thisinfo->flag.push_file ) {
	    PushKeyString( path );
		PushKey( SCAN_ENTER );
	}

	return 1;
}

int main(int argc, char **argv)
{
	static char basedir[MAXPATH];
	static char dir[MAXDIR];
	static char name[MAXFILE];
	static char ext[MAXEXT];
	char *dbpath;
	char *p;
	
	if (argc < 2) {
		fputs("OPEN Version 1.00 Copyright(C) 1995 Hiroyuki Sekiya\n"
			  "             1.10 Changes (C) 1999 Paulo Custodio\n", stderr);
		fputs("Usage: open <filename>\n", stderr);
		return 1;
	}

	/* PSC: install critical error handler */
	install_criterr_handler();

	/* fBNgAt@CAgqɕ */
	fnsplit(argv[1], basedir, dir, name, ext);
	strcat(basedir, dir);
	if (launch(basedir, name, ext))
		return 0;
	else if (*basedir == '\0') {
		dbpath = getenv("DBPATH");
		if (*dbpath == '\0') 
			dbpath = DEFAULT_DBPATH;
		while (*dbpath != '\0') {
			if (*dbpath == ';') ++dbpath;
			p = basedir;
			while (*dbpath != '\0' && *dbpath != ';') *p++ = *dbpath++;
			if (*(p-1) != '\\') *p++ = '\\';
			*p = '\0';
			if (launch(basedir, name, ext)) return 0;
		}
	}
	fputs("File not found.\n", stderr);
	return 1;
}
