/*  -------------------------------------------------------------------
    lprm - remove job from line printer queue

    lprm removes a job or jobs from a print spooling queue managed by
    an LPD daemon running on a remote machine.
    Built on top of the NCSA TCP/IP package (version 2.2tn for MS-DOS).

    Paul Hilchey   May 1989

    Copyright (C) 1989  The University of British Columbia
    All rights reserved.
    -------------------------------------------------------------------
*/

#include "config.h"

#include "stdio.h"
#include <dos.h>
#include <ctype.h>
#include "string.h"
#include "stdlib.h"
#include "whatami.h"
#include "hostform.h"
#define WINMASTER
#include "windat.h"
#include "lp.h"
#include <stdarg.h>

int debug = 0;          /* 1 = print debugging info; set with -D option */
int ftppassword;        /* not used; just to avoid unresolved external */
unsigned char *localhost;

#define JOB_AND_USER_BUFF_SIZE  150     /* size of buffer for job numbers and user name specified on the command line */

/****************************************************************
 *  Main program.                                               *
 *     lprm [ -Pprinter ] [ -Sserver ] [ - ] [job# ...]         *
 ****************************************************************/
main(int argc,char *argv[])
{
    int i;
    char *ptr;
    int  ev,class,data,len;

    char username[9];       /* name of user (max 8 chars) */
    struct config *cp;      /* configuration information */

    char buff[JOB_AND_USER_BUFF_SIZE] = ""; /* string of jobs to be removed */
    int something = 0;      /* 1 = we got something back from the server */
    struct machinfo *server_info_record;
    int server_connection_id;

    char *remote_name,      /* printer name on remote system */
         *remote_host;      /* address of remote host        */

    printf("LPRM Version " VERSION " 9/11/90\n%s%s%s",
	    "    Paul Hilchey - May 1989, Brad Clements - Sept 1990\n",
	    "    Copyright (C) 1989  The University of British Columbia\n",
	    "    All rights reserved.\n\n");

    ctrlbrk(breakstop);     /* set up ctrl-c handler */

    /* Do session initialization.  Snetinit reads config file. */
    ptr = getenv("LXTCP.CFG");
    if (ptr != NULL) Shostfile(ptr);
    if (Snetinit())
        crash("network initialization failed.\n");

    /* select default printer and server */
    remote_name = getenv("PRINTER");
    if (remote_name == NULL) {
	    	struct machinfo *mp;
	    	if(mp = Shostlook("lpr_printer")) {
		       	remote_name = mp->hname;
		}
	 	else
		    	remote_name = DEFAULT_PRINTER;
    }
    remote_host = getenv("SERVER");
    if(!remote_host) {
	    	struct machinfo *mp;
		if(mp = Shostlook("lpr_server")) {
		       	remote_host = mp->hname;
		}
    }


    /* get info from the configuration file */
    cp = (struct config *)malloc(sizeof(struct config));
    Sgetconfig(cp);

        if (0 == strlen(cp->username)) crash("`username' not set in config file.");

    /* set user name.  use first part of machine name if nothing else. */
    if(!(ptr = getenv("USER")))
	  ptr = cp->username;
   
    strncpy(username,ptr,8);
    username[8]='\0';
  
    {
	    struct machinfo *mp;
static	char	*myaddress[25];

	    mp = Slookip(cp->myipnum);
	    if(!mp) {
		   sprintf(myaddress,"%d.%d.%d.%d",cp->myipnum[0],
			  	cp->myipnum[1],cp->myipnum[2],cp->myipnum[3]);
		   localhost = myaddress;
	    }
    	    else {
		   localhost = mp->hname;
    	    }
    }

    /* Loop through command line arguments */
    for (i=1; i<argc; ++i)

        if (0 == strncmp(argv[i],"-P",2))       /* select printer */
            if (argv[i][2])
                remote_name = &argv[i][2];
            else if (i+1 < argc)
                remote_name = argv[++i];
            else;

        else if (0 == strncmp(argv[i],"-S",2))  /* select server */
            if (argv[i][2])
                remote_host = &argv[i][2];
            else if (i+1 < argc)
                remote_host = argv[++i];
            else;

        else if (0 == strcmp(argv[i],"-")) {    /* delete all my jobs */
            strcat(buff," ");
            strcat(buff,username);
        }

        else if (0 == strncmp(argv[i],"-D",2))  /* turn on debug */
            debug = 1;

        else {                                  /* job number, add to list */
            strcat(buff," ");
            strcat(buff,argv[i]);
        };

    if (remote_host == NULL) crash("server not specified.");

    server_info_record = lookup(remote_host);
    if (server_info_record == 0)
        crash("domain lookup failed for %s.",remote_host);


    /* pick a source port at random from the set of privileged ports, */
    /* and open the connection                                        */
    randomize();
    server_connection_id = open_connection(server_info_record, rand() % MAX_PRIV_PORT, PRINTER_PORT);
    if (server_connection_id < 0) crash ("unable to open connection.");

    /* send the request */
    netprintf (server_connection_id, "%c%s %s%s\n", LPD_REMOVE_JOB,
             remote_name, username, buff);

    /* wait for replies from the server and print them */
    while(1) {
        len = nread(server_connection_id, buff, 132);
        if (len <= 0) break;
        if (buff[0] != LPD_ERROR) {
            printf("%.*s",len,buff);
            something = 1;
        }
    }

    netclose(server_connection_id);
    netshut();
    if (!something) puts("No applicable jobs.");
}
