/* $Id: FTPPI.C 1.2 1999/01/09 09:10:22 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/APPS/FTP/RCS/FTPPI.C $ */

/*
 * Portions developed by The Educational Resources Center, Clarkson University.
 * Portions developed by National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include "config.h"
#include "stdio.h"
#include <process.h>
#include "fcntl.h"
#include "nkeys.h"
#include "ctype.h"
#include "hostform.h"
#include "whatami.h"

#include "newwin.h"
#include <string.h>
#include <stdlib.h>
#include <io.h>

#define O_RAW O_BINARY
#include <sys/stat.h>

#define FASCII  0
#define FIMAGE  1

#define HFTP  21

#define FALSE	   0
#define TRUE	   1
#define SUCCESS	   2
#define ERROR	  -1
#define NONE	  -2
#define ABORT	  -3
#define INCOMPLETE -4
#define AMBIGUOUS -5
#define HAVEDATA   4

extern int 
	ftpnum,					/* current command port */
	ftpfilemode,				/* file open mode for transfer */
	foundbreak,				/* cntrl-break pending */
	connected,				/* not connected */
	debug,				/* debug level */
	hash,					/* hash mark printing */
	sendport,				/* to send ports or not */
	verbose,				/* informative messages */
	bell,					/* sound bell */
	autologin,				/* login on connect */
	prompt,				/* check on multiple commands */
	glob,					/* expand wildcards */
	slashflip,				/* change \ to / */
	capture,				/* capture data or not */
	fromtty;				/* default input from tty */

extern unsigned char destname[50],			/* who to connect to */
		s[2048],			/* temporary string */
		captlist[2001],			/* response string */
		ftpcommand[200];		/* command to execute */

extern char printline[100];				/* line to display */

extern char *stpblk();

#include "ftppi.h"		/* list of commands, help strings */

/********************************************************************/
/* FTP PI
*  Protocol interpreter for user interface commands
*  Will permit any command to be abbreviated uniquely.
*  Recognizes commands, translates them to the protocol commands to be
*  sent to the other server, and uses userftpd, the daemon, to do data
*  transfers.
/************************************************************************/

ftppi(command)
char *command;
{

int cmdno,i;
char cmdname[20],word[51],line[100],answer[20],ofilename[50];
char *p,*firstname(),*nextname();
struct machinfo *mp,*Sgethost();

if (debug>1) {			/* print command */
    nprintf(SCREEN,"command: %s\n",command);
}

	/* get command number */
if (!getword(command,cmdname)) return(FALSE);	/* get command name */
	/* removes first word from command */
lowercase(cmdname);
cmdno = finduniq(cmdname,ftp_cmdlist,NCMDS);	/* search cmdlist for prefix */
if (cmdno==AMBIGUOUS) {		/* not unique abbreviation */
	nprintf(SCREEN,"?Ambiguous command\n");
	return(FALSE);
}
if (cmdno==NONE) {		/* not a prefix of any command */
	nprintf(SCREEN,"?Invalid command\n");
	return(FALSE);
}

		/* change \ to / and check if command output redirected */
if (cmdno!=BANG) {		/* don't alter shell escape */
    if (cmdno!=LLS)		/* do not flip slashes for LLS */
        checkoredir(command,ofilename,slashflip);	/* check redirection, flip \ */
    else
        checkoredir(command,ofilename,FALSE);		/* check redirection */
}

	/* process commands */
switch (cmdno) {
	case QMARK:
	case HELP:
		if (!command[0]) {	/* no argument */
		    nprintf(SCREEN,"Commands may be abbreviated. Commands are:\n");

			/* display command list */
		    printline[0] = '\0';
		    for (i=0; i<NCMDS; i++) {
			sprintf(word,"%-16s",ftp_cmdlist[i]);	/* get word from list */
			strcat(printline,word);		/* add to line */
			if (i%5==4) {			/* display line */
			    printline[79] = '\0';
			    nprintf(SCREEN,"%s\n",printline);
			    printline[0] = '\0';
			}
		    }
		    if (i%5!=4) nprintf(SCREEN,"%s\n",printline);	/* last line */
		    return(TRUE);
		}

			/* help for specific commands */
		else {
		    while (getword(command,word)) {	/* loop for all args */
		        i = finduniq(word,ftp_cmdlist,NCMDS);   /* which command? */
			if (i==AMBIGUOUS)	/* non-unique command name */
			    sprintf(printline,"?Ambiguous help command %s",word);
			else if (i==NONE)	/* no such command */
			    sprintf(printline,"?Invalid help command %s",word);
			else			/* display help string */
		            sprintf(printline,"%s",helpstrings[i-1]);
			nprintf(SCREEN,"%s\n",printline);
		    }
		    return(TRUE);
		}
		break;
	case BANG:		/* shell escape */
		if (*(stpblk(command))) {	/* command specified */
		    system(command);	/* execute command */
		    return(TRUE);
		}
		dosescape();		/* subshell */
		return(TRUE);
	case BELL:
		if (getword(command,word)) {	/* scan arg */
		    lowercase(word);
		    if (!strcmp(word,"off")) bell = FALSE;
		    else if (!strcmp(word,"on")) bell = TRUE;
		    else bell = !bell;
		}
		else bell = !bell;
		if (bell) nprintf(SCREEN,"Bell mode on.\n");
		else nprintf(SCREEN,"Bell mode off.\n");
		return(TRUE);
	case BYE:
	case QUIT:
		if (connected) {
		    ftpdo("QUIT",ofilename);
		    connected = FALSE;
		}
		if (fromtty) n_cur(24,0);	/* go to bottom of screen */
		netshut();
		exit(0);
	case DEBUG:		/* turn on/off debugging, optional level */
		if (sscanf(command,"%d",&i)>0) debug = i;	/* level */
		else if (getword(command,word)) {	/* scan arg */
		    lowercase(word);
		    if (!strcmp(word,"off")) debug = FALSE;
		    else if (!strcmp(word,"on")) debug = TRUE;
		    else debug = !debug;
		}
		else debug = !debug;
		if (debug) {
		    nprintf(SCREEN,"Debugging on (debug=%d).\n",debug);
		}
		else nprintf(SCREEN,"Debugging off.\n");
		return(TRUE);
	case GLOB:		/* wildcard expansion */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) glob = FALSE;
		    else if (!strcmp(word,"on")) glob = TRUE;
		    else glob = !glob;
		}
		else glob = !glob;
		if (glob) nprintf(SCREEN,"Globbing on.\n");
		else nprintf(SCREEN,"Globbing off.\n");
		return(TRUE);
	case HASH:		/* hash mark printing */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) hash = FALSE;
		    else if (!strcmp(word,"on")) hash = TRUE;
		    else hash = !hash;
		}
		else hash = !hash;
		if (hash) nprintf(SCREEN,"Hash mark printing on (1024 bytes/hash mark).\n");
		else nprintf(SCREEN,"Hash printing off.\n");
		return(TRUE);
	case INTERACTIVE:	/* prompting on multiple transfers */
		prompt = TRUE;
		nprintf(SCREEN,"Interactive mode on.\n");
		return(TRUE);
	case LCD:		/* change local directory */
		if (command[1]==':') {		/* if disk specified */
		    setdisk(tolower(command[0]-'a'));
		    strcpy(command,&command[2]);
		}
		if (*(stpblk(command)) && chdir(command)) {	/* CD */
		    nprintf(SCREEN,"Unable to change directory\n");
		}
		getdir(0,line);		/* current directory */
		nprintf(SCREEN,"Local directory now %s\n",line);
		return(TRUE);
	case LLS:		/* local DIR */
		sprintf(line,"DIR %s",command);
		system(line);
		return(TRUE);
	case NONINTERACTIVE:	/* turn off interactive prompting */
		prompt = FALSE;
		nprintf(SCREEN,"Interactive mode off.\n");
		return(TRUE);
	case OPEN:		/* open connection to host */
		if (connected) {
		    nprintf(SCREEN,"Already connected.\n");
		    return(FALSE);
		}
		while (!(*(stpblk(command)))) {		/* no argument */
		    putstring("To: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		getword(command,destname);		/* host name */
		mp = Sgethost(destname);		/* get host info */
		if (foundbreak) {			/* abort */
			foundbreak = FALSE;
			return(FALSE);
		}
		if (mp==NULL) {				/* try domain serving */
		    Sdomain(destname);
		    while (mp==NULL)
		      switch (checkevent()) {
		        case ABORT: return(FALSE);	/* abort */
			case DOMFAIL:
		    		printerr();
		    		nprintf(SCREEN,"Unknown host: %s\n",destname);
		    		return(FALSE);
			case DOMOK:
				mp = Slooknum(ftpnum);	/* get host info */
				break;
			default: break;
		      }
		}
		if (sscanf(command,"%d",&i)>0)    /* port number specified */
		    ftpnum = Snetopen(mp,i);
		else {
		    ftpnum = Snetopen(mp,HFTP);		/* default port */
		}
		if (foundbreak) {			/* abort */
			foundbreak = FALSE;
			return(FALSE);
		}
		if (ftpnum<0) {				/* error on open */
		    printerr();
		    nprintf(SCREEN,"Unable to connect to %s\n",destname);
		    return(FALSE);
		}
		ftpreplies(ftpnum,&i);		/* response from other end */
		if (foundbreak) {
			foundbreak = FALSE;
			return(FALSE);
		}

		nprintf(SCREEN,"[Connected to %s]\n",destname);

		connected = TRUE;
		if (autologin) {		/* execute login command */
		    strcpy(command,"user");
		    ftppi(command);
		}
		return(TRUE);
	case PROMPT:			/* interactive prompting */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) prompt = FALSE;
		    else if (!strcmp(word,"on")) prompt = TRUE;
		    else prompt = !prompt;
		}
		else prompt = !prompt;
		if (prompt) nprintf(SCREEN,"Interactive mode on.\n");
		else nprintf(SCREEN,"Interactive mode off.\n");
		return(TRUE);
	case SENDPORT:			/* send PORT commands for each transfer */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) sendport = FALSE;
		    else if (!strcmp(word,"on")) sendport = TRUE;
		    else sendport = !sendport;
		}
		else sendport = !sendport;
		if (sendport) nprintf(SCREEN,"Use of PORT cmds on.\n");
		else nprintf(SCREEN,"Use of PORT cmds off.\n");
		return(TRUE);
	case SLASHFLIP:			/* change \ to / */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off")) slashflip = FALSE;
		    else if (!strcmp(word,"on")) slashflip = TRUE;
		    else slashflip = !slashflip;
		}
		else slashflip = !slashflip;
		if (slashflip) nprintf(SCREEN,"Slash translation on.\n");
		else nprintf(SCREEN,"Slash translation off.\n");
		return(TRUE);
	case STATUS:		/* display status info */
		if (connected) {
		    nprintf(SCREEN,"Connected to %s\n",destname);
		}
		if (ftpfilemode==FASCII) nprintf(SCREEN,"Transfer mode is ascii.\n");
		else nprintf(SCREEN,"Transfer mode is binary.\n");
		if (bell) nprintf(SCREEN,"Bell on.\n"); else nprintf(SCREEN,"Bell off.\n");
		if (debug) {
		    sprintf(printline,"Debugging on. (Debug=%d)",debug);
		    nprintf(SCREEN,printline);
		}
		else nprintf(SCREEN,"Debugging off.\n");
		if (glob) nprintf(SCREEN,"Filename globbing on.\n"); else nprintf(SCREEN,"Filename globbing off.\n");
		if (hash) nprintf(SCREEN,"Hash-mark printing on.\n"); else nprintf(SCREEN,"Hash-mark printing off.\n");
		if (prompt) nprintf(SCREEN,"Interactive prompting on.\n"); else nprintf(SCREEN,"Interactive prompting off.\n");
		if (sendport) nprintf(SCREEN,"Sending of port commands on.\n"); else nprintf(SCREEN,"Sending of PORT cmds off.\n");
		if (slashflip) nprintf(SCREEN,"Flipping \\ to / on.\n"); else nprintf(SCREEN,"Flipping \\ to / off.\n");
		if (verbose) nprintf(SCREEN,"Verbose mode on.\n"); else nprintf(SCREEN,"Verbose mode off.\n");
		if (connected) {		/* send STAT command */
		    nprintf(SCREEN,"\nRemote status:\n");
		    ftpdo("STAT",ofilename);
		}
		return(TRUE);
	case VERBOSE:		/* display informative messages */
		if (getword(command,word)) {
		    lowercase(word);
		    if (!strcmp(word,"off\n")) verbose = FALSE;
		    else if (!strcmp(word,"on\n")) verbose = TRUE;
		    else verbose = !verbose;
		}
		else verbose = !verbose;
		if (verbose) nprintf(SCREEN,"Verbose mode on.\n");
		else nprintf(SCREEN,"Verbose mode off.\n");
		return(TRUE);
	default:		/* The other commands valid only if connected */
		if (!connected) {
		    nprintf(SCREEN,"Not connected.\n");
		    return(FALSE);
		}
		switch (cmdno) {
	    case ASCII:			/* transfer mode */
		ftpdo("TYPE A",ofilename);
		return(TRUE);
	    case BGET:			/* get file in binary mode */
		i = ftpfilemode;	/* save current mode */
		if (i==FASCII) ftpdo("TYPE I",ofilename);
		while (!(*(stpblk(command)))) {
		    putstring("File: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"RETR %s",command);
		ftpdo(line,ofilename);		/* get file */
		if (i==FASCII) ftpdo("TYPE A",ofilename);	/* restore mode */
		return(TRUE);
	    case BINARY:		/* binary mode */
		ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case BPUT:			/* put file in binary mode */
		i = ftpfilemode;
		if (i==FASCII) ftpdo("TYPE I",ofilename);
		while (!(*(stpblk(command)))) {		/* if no arg */
		    putstring("File: ");	/* get from user */
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"STOR %s",command);
		ftpdo(line,ofilename);
		if (i==FASCII) ftpdo("TYPE A",ofilename);
		return(TRUE);
	    case CD:		/* change remote directory */
		while (!(*(stpblk(command)))) {		/* if no arg, get from user */
		    putstring("To: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		getword(command,word);
		if (!strcmp(word,"..")) {	/* special case */
		    i = ftpdo("CDUP",ofilename);
		    if (i!=ERROR) return(TRUE);		/* if CDUP understood */
		    nprintf(SCREEN,"Trying again...");
		    i = ftpdo("XCUP",ofilename);	/* try alternative */
		    if (i!=ERROR) return(TRUE);
		    nprintf(SCREEN,"Trying again...");		/* else try usual CD */
		}
		sprintf(line,"CWD %s",word);		/* try CWD */
		i = ftpdo(line,ofilename);
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		sprintf(line,"XCWD %s",word);		/* try XCWD */
		ftpdo(line,ofilename);
		return(TRUE);
	    case CLOSE:				/* drop connection */
		ftpdo("QUIT",ofilename);
		connected = FALSE;
		return(TRUE);
	    case DEL:
	    case RM:
		getword(command,word);
		while (!word[0]) {	/* get arg from user */
		    putstring("File: ");
		    if (ftpgets(word,100,1)==ABORT) return(FALSE);	/* abort */
		}
		if (prompt) {		/* check interactively */
		    sprintf(printline,"Delete %s? ",word);
		    putstring(printline);
		    ftpgets(answer,20,1);
		    if (tolower(*(stpblk(answer)))!='y') return(TRUE);
		}
		sprintf(line,"DELE %s",word);
		ftpdo(line,ofilename);
		return(TRUE);
	    case DIR:		/* get list of remote files */
		i = ftpfilemode;	/* save mode */
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		if (getword(command,word)) {	/* do DIR */
		    sprintf(line,"LIST %s",word);
		    ftpdo(line,ofilename);
		}
		else ftpdo("LIST",ofilename);
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case GET:
	    case RECV:		/* get remote file */
		while (!(*(stpblk(command)))) {		/* if no arg */
		    putstring("File: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		sprintf(line,"RETR %s",command);
		ftpdo(line,ofilename);
		return(TRUE);
	    case LS:		/* get remote file list - short */
		i = ftpfilemode;
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		if (getword(command,word)) {
		    sprintf(line,"NLST %s",word);
		    ftpdo(line,ofilename);
		}
		else ftpdo("NLST",ofilename);
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case MDELETE:
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Files: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(command,word)) {		/* for each arg */
		    if (glob) {		/* wildcard expansion */
		        sprintf(line,"NLST %s",word);
			capture = TRUE;
		        ftpdo(line,ofilename);	/* put exapnsion in captlist */
			capture = FALSE;
		    }
		    else strcpy(captlist,word);	/* captlist has name(s) now */
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {	/* check */
			    sprintf(printline,"mdelete %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {	/* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(line,"DELE %s",word);	/* delete */
		        ftpdo(line,ofilename);
		    }
		}
		return(TRUE);
	    case MDIR:		/* remote multiple DIR */
		i = ftpfilemode;	/* save mode */
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directories: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(command,word)) {		/* for each arg */
		    if (glob) {		/* expand wildcards */
		        sprintf(line,"NLST %s",word);
			capture = TRUE;
		        ftpdo(line,ofilename);
			capture = FALSE;
		    }
		    else strcpy(captlist,word);
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {	/* check */
			    sprintf(printline,"mdir %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {	/* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(line,"LIST %s",word);	/* DIR */
		        ftpdo(line,ofilename);
		    }
		}
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case MGET:		/* get multiple files */
		getword(command,line);
		while (!line[0]) {	/* no arg */
		    putstring("Files: ");
		    if (ftpgets(line,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(line,word)) {	/* for each arg */
		    if (glob) {		/* expand wildcards */
		        sprintf(command,"NLST %s",word);
			capture = TRUE;
		        ftpdo(command,ofilename);
			capture = FALSE;
		    }
		    else strcpy(captlist,word);
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {	/* check */
			    sprintf(printline,"mget %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {	/* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(command,"RETR \"%s\"",word);
		        ftpdo(command,ofilename);
		    }
		}
		return(TRUE);
	    case MKDIR:		/* create directory */
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directory: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		sprintf(line,"XMKD %s",command);	/* try XMKD */
		i = ftpdo(line,ofilename);
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		sprintf(line,"MKD %s",command);		/* else try MKD */
		ftpdo(line,ofilename);
		return(TRUE);
	    case MLS:
		i = ftpfilemode;
		if (i==FIMAGE) ftpdo("TYPE A",ofilename);
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directories: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);	/* abort */
		}
		while (getword(command,word)) {		/* for each arg */
		    if (glob) {		/* exapnd wildcards */
		        sprintf(line,"NLST %s",word);
			capture = TRUE;
		        ftpdo(line,ofilename);
			capture = FALSE;
		    }
		    else strcpy(captlist,word);
		    while (getnname(captlist,word)) {	/* for each name */
		        if (prompt) {		/* check */
			    sprintf(printline,"mls %s? ",word);
			    putstring(printline);
			    if (ftpgets(answer,20,1)==ABORT) {  /* abort */
				command[0] = '\0';	/* no more processing */
				break;			/* quit immediately */
			    }
			    if (tolower(*(stpblk(answer)))!='y') continue;
		        }
		        sprintf(line,"NLST %s",word);	/* DIR */
		        ftpdo(line,ofilename);
		    }
		}
		if (i==FIMAGE) ftpdo("TYPE I",ofilename);
		return(TRUE);
	    case MODE:		/* set stream mode */
		getword(command,word);
		lowercase(word);
		if (strncmp(word,"stream",strlen(word)))
		    nprintf(SCREEN,"We only support stream mode, sorry.\n");
		else nprintf(SCREEN,"Mode is stream.\n");
		return(TRUE);
	    case MPUT:		/* put multiple files */
		getword(command,line);
		while (!line[0]) {	/* no arg */
		    putstring("Files: ");
		    if (ftpgets(line,100,1)==ABORT) return(FALSE);	/* abort */
		}
		p = NULL;	/* no names expanded yet */
		while (getword(line,word)) {	/* for each arg */
		  do {		/* for each name */
		    if (glob) {		/* local wildcard expansion */
			if (p==NULL) {	/* if no expansions yet */
			    p = firstname(word,1);	/* get first name */
			    if (p==NULL) {	/* if no expansions */
				nprintf(SCREEN,"No match for %s\n",word);
				continue;
			    }
                            else {
                                char *c;
                                c = strchr(p,' ');
                                if(c)
                                        *c = 0;
                            }
			}
			else {		/* not first name */
			    p = nextname(word,1);		/* get next name */
			    if (p==NULL) continue;	/* if no names, next arg */
                            { char *c;
                                c = strchr(p, ' ');
                                if(c)
                                        *c = 0;
                            }
			}
		    }
		    else p = word;		/* no expansion */
		    if (prompt) {	/* check */
			sprintf(printline,"mput %s? ",p);
			putstring(printline);
			if (ftpgets(answer,20,1)==ABORT) {	/* abort */
			    command[0] = '\0';	/* no more processing */
			    break;			/* quit immediately */
			}
			if (tolower(*(stpblk(answer)))!='y') continue;
		    }
		    sprintf(command,"STOR \"%s\"",p);	/* name may have spl chars */
		    ftpdo(command,ofilename);
		  } while (glob && p!=NULL);		/* Not last expansion */
		}
		return(TRUE);
	    case PUT:			
	    case SEND:		/* put file */
		while (!(*(stpblk(command)))) {		/* no args */
		    putstring("File: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"STOR %s",command);	/* put file */
		ftpdo(line,ofilename);
		return(TRUE);
	    case PWD:
		i = ftpdo("XPWD",ofilename);		/* try XPWD */
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		ftpdo("PWD",ofilename);			/* else try PWD */
		return(TRUE);
	    case QUOTE:
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Command: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		ftpdo(command,ofilename);		/* send command */
		return(TRUE);
	    case REMOTEHELP:				/* get help */
		if (*(stpblk(command))) {		/* for specific command */
		    sprintf(line,"HELP %s",command);
		    ftpdo(line,ofilename);
		}
		else ftpdo("HELP",ofilename);		/* generic help */
		return(TRUE);
	    case RENAME:		/* rename remote file */
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("From: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		getword(command,word);
		sprintf(line,"RNFR %s",word);
		ftpdo(line,ofilename);		/* send rename from name */
		while (!(*(stpblk(command)))) {		/* no second arg */
		    putstring("To: ");
		    if (ftpgets(command,100,1)==ABORT) {
			ftpdo("ABOR",ofilename);
			return(FALSE);
		    }
		}
		sprintf(line,"RNTO %s",command); /* send rename to name */
		ftpdo(line,ofilename);
		return(TRUE);
	    case RMDIR:			/* remove remote dir */
		while (!(*(stpblk(command)))) {		/* no arg */
		    putstring("Directory: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"XRMD %s",command);	/* try XRMD */
		i = ftpdo(line,ofilename);
	        if (i!=ERROR) return(TRUE);
		nprintf(SCREEN,"Trying again...");
		sprintf(line,"RMD %s",command);		/* try RMD */
		ftpdo(line,ofilename);
		return(TRUE);
	    case STRUCT:		/* set structure type - only file */
		getword(command,word);
		lowercase(word);
		if (strncmp(word,"file",strlen(word)))
		    nprintf(SCREEN,"We only support file structure, sorry.\n");
		else nprintf(SCREEN,"Structure is file.\n");
		return(TRUE);
	    case TYPE:		/* set transfer type */
		if (!getword(command,word)) {	/* no arg, just show */
		   if (ftpfilemode==FASCII) nprintf(SCREEN,"Transfer type is ascii.\n");
		   else nprintf(SCREEN,"Transfer type is binary.\n");
		}
		lowercase(word);
		if (!strncmp(word,"ascii",strlen(word)))
		    ftpdo("TYPE A",ofilename);
		else if (!strncmp(word,"binary",strlen(word)) ||
			!strncmp(word,"image",strlen(word)))
		    ftpdo("TYPE I",ofilename);
		else {
		    nprintf(SCREEN,"Unrecognized type: %s\n",word);
		}
		return(TRUE);
	    case USER:			/* login to remote machine */
		if (!(*(stpblk(command)))) {	/* null response to prompt ok */
		    putstring("Username: ");
		    if (ftpgets(command,100,1)==ABORT) return(FALSE);
		}
		sprintf(line,"USER %s",command);	/* username */
		if (ftpdo(line,ofilename)==TRUE) return(TRUE);
		putstring("Password: ");
		if (ftpgets(word,50,0)==ABORT) return(FALSE);		/* no echoing */
		sprintf(line,"PASS %s",word);		/* password */
		if (ftpdo(line,ofilename)==INCOMPLETE) {	/* if account needed */
		    do {
		        putstring("Account: ");
		        if (ftpgets(command,100,1)==ABORT) return(FALSE);
		    } while (!(*(stpblk(command))));
		    sprintf(line,"ACCT %s",command);
		    ftpdo(line,ofilename);
		}
		return(TRUE);		
	default:	/* unknown command */
		nprintf(SCREEN,"***Program error: Unknown command no: %d\n",cmdno);
		break;
	}
	}
}

/* End of ftppi.c */