/*
  simple.c -- Simple INETD services.

  Copyright (C) 1999  Rod Whitby

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version
  2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be 
  useful, but WITHOUT ANY WARRANTY; without even the implied
  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
  USA.

  $Source: A:/SRC/TCP/INETD/RCS/SIMPLE.C $
  $Id: SIMPLE.C 1.3 2000/04/09 07:15:52 rwhitby Exp $
*/

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "lxinetd.h"
#include "simple.h"

int echo_tick(tcp_Socket *socket, void **datap) {
  int i;

  if (sock_dataready(socket) <= 0) {
    return 1;
  }

  if (((i = sock_fastread(socket, buffer, sizeof(buffer))) > 0) &&
      (sock_fastwrite(socket, buffer, i) > 0)) {
    return 1;
  }

  (void)datap;

  return 0;
}

int discard_tick(tcp_Socket *socket, void **datap) {

  if (sock_dataready(socket) <= 0) {
    return 1;
  }

  if (sock_fastread(socket, buffer, sizeof(buffer)) > 0) {
    return 1;
  }

  (void)datap;

  return 0;
}

int chargen_conn(tcp_Socket *socket, void **datap) {

  sock_mode(socket, TCP_MODE_ASCII);

  (*datap) = (void *)0;

  return 1;
}

int chargen_tick(tcp_Socket *socket, void **datap) {

  int i;
  int start = (int)(*datap);

  for (i = 0; i < 72; i++) {
    buffer[i] = ((start + i) % 95) + 32;
  }

  buffer[72] = 0;

  *datap = (void *)(++start % 95);

  if (sock_puts(socket, buffer) > 0) {
    return 1;
  }

  return 0;
}

int daytime_conn(tcp_Socket *socket, void **datap) {

  time_t now;

  sock_mode(socket, TCP_MODE_ASCII);

  now = time(NULL);
  sprintf((char *)buffer, asctime(localtime(&now)));
  buffer[strlen((char *)buffer)-1] = 0;

  if (sock_puts(socket, buffer) > 0) {
    return 1;
  }

  (void)datap;

  return 0;
}

int daytime_tick(tcp_Socket *socket, void **datap) {

  (void)socket; (void)datap;

  return 0;
}

int time_conn(tcp_Socket *socket, void **datap) {

  time_t now;

  sock_mode(socket, TCP_MODE_ASCII);

  now = time(NULL);

  sprintf((char *)buffer, "%ld", now);

  if (sock_puts(socket, buffer) > 0) {
    return 1;
  }

  (void)datap;

  return 0;
}

int time_tick(tcp_Socket *socket, void **datap) {

  (void)socket; (void)datap;

  return 0;
}

/* End of simple.c */
