hcD      D    M  `5	   The contents of the W register are added to the 8 bit constant 'k' and the result is placed in the W register.

1 clock cycle.
(   Literal;Control;File/Register;Bit 4     $         ADDLW    k Literal W = W + k          $    oN8 2         j! ?7           ) p O     ? v} V         U "           f "           w ,            6                &Name        &Type                &Operation   
     No&tes       &Z    
   &C       &DC       Cm&p     All Fields                      Name: 
@o   	
Type: 
@o  	
Operation: 
@o  	
Notes: 
@o  	

@o  	

@o  	

@o  	

@o  	
W   -  DataCard                        
@o   	
=

@o  	
-

@o  	
	D  Bit 'b' ( 0 to 7 ) of file 'f' is cleared.

1 clock cycle.
1 !   "           BCF      f,b Bit f[b] = 0 	M  Bit 'b' ( 0 to 7 ) of file 'f' is set to logic one.

1 clock cycle.
1 "   "           BSF      f,b Bit f[b] = 1 	  If bit 'b' of register 'f' is 0 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

If f[b] = 1 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
C #   *           BTFSC    f,b Bit;Control skip if (f[b]) = 0 	  If bit 'b' of register 'f' is 1 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

If f[b] = 0 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
C $   *           BTFSS    f,b Bit;Control skip if (f[b]) = 1 	  If the carry bit is set then a GOTO 'label' instruction is executed.

This instruction is equivalent to :-

BTFSC    3,0
GOTO     label

This instruction takes 2 cycles if carry is clear or 3 cycles if carry is set.
> '    (          BC       label Control branch on carry 	  If the digit carry bit is set then a GOTO 'label' instruction is executed.

This instruction is equivalent to :-

BTFSC    3,1
GOTO     label

This instruction takes 2 cycles if digit carry is clear or 3 cycles if digit carry is set.
D (    (          BDC      label Control branch on digit carry 	  If the carry bit is clear then a GOTO 'label' instruction is executed.

This instruction is equivalent to :-

BTFSS    3,0
GOTO     label

This instruction takes 2 cycles if carry is set or 3 cycles if carry is clear.
A )    (          BNC      label Control branch on no carry 	 	 If the digit carry bit is clear then a GOTO 'label' instruction is executed.

This instruction is equivalent to :-

BTFSS    3,1
GOTO     label

This instruction takes 2 cycles if digit carry is set or 3 cycles if digit carry is clear.
G *    ( 	         BNDC     label Control branch on no digit carry 	 
 If the zero bit is set then a GOTO 'label' instruction is executed.

This instruction is equivalent to :-

BTFSC    3,2
GOTO     label

This instruction takes 2 cycles if zero is clear or 3 cycles if zero is set.
= +    ( 
         BZ       label Control branch on zero 	  Calls a subroutine. The return address ( PC + 1 ) is pushed onto the stack and then the 11 bit address represented by 'label' is loaded into the lowest 11 bits of the PC, the upper bits of the PC are loaded from PCLATH.

2 clock cycles.
G     (           CALL     label Control TOS = PC + 1, PC = label 	\ 
 The contents of the file 'f' are cleared and the zero flag is set.

1 clock cycle.
6    * 
         CLRF     f File/Register f = 0 	Q  The W register is set to zero and the zero flag is set.

1 clock cycle.
0    $          CLRW File/Register W = 0 	  Clear the zero flag. This instruction clears the zero flag.

This is equivalent to :-

BCF     3,2

1 clock cycle.
* .            CLRZ Control Z = 0 	  Clear digit carry. This instruction sets the digit carry flag to zero.

This is equivalent to :-

BCF     3,1

1 clock cycle.
, -            CLRDC Control DC = 0 	  Clear carry. This instruction sets the carry flag to zero.

This is equivalent to :-

BCF     3,0

1 clock cycle.
* ,            CLRC Control C = 0 	  The CLRWDT instruction clears the watchdog timer and also the prescaler if it is assigned to the watchdog.
    __     __
The TO and PD flags are also set.

1 clock cycle.
.                CLRWDT Control WDT = 0 	'  No operation.

1 clock cycle.
0               NOP Control No operation 	^  The contents of the W register are tranfered to the OPTION register.

1 clock cycle.
1                OPTION Control OPTION = W 	  Return from interrupt. The top of the stack is transfered to the program counter and the global interrupt enable flag ( GIE ) is set to 1.

2 clock cycles.
8                RETFIE Control PC = TOS, GIE = 1 	k  Return from a subroutine. The top of stack is transfered to the program counter.

2 clock cycles.
/ 
               RETURN Control PC = TOS 	  Return a value from a subroutine. The 8 bit constant 'k' is loaded into the W register and the top of stack is transfered to the program counter.

2 clock cycles.
: 	   $           RETLW    k Control W = k, PC = TOS 	P  Set the carry flag.

Equivalent to :-

BSF     3,0

1 clock cycle.
* 1            SETC Control C = 1 	V  Set the digit carry flag.

Equivalent to :-

BSF     3,1

1 clock cycle.
, 2            SETDC Control DC = 1 	T  Set the zero flag to 1.

Equivalent to :-

BSF     3,2

1 clock cycle.
* 3            SETZ Control Z = 1 	 If the carry flag is 1 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

Equivalent to :-

BTFSS    3,0

If C = 0 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
2 4             SKPC Control skip if C = 1 	 If the digit carry flag is 1 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

Equivalent to :-

BTFSS     3,1

If DC = 0 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
4 6             SKPDC Control skip if DC = 1 	 If the carry flag is 0 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

Equivalent to :-

BTFSC    3,0

If C = 1 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
3 5             SKPNC Control skip if C = 0 	
 If the digit carry flag is 0 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

Equivalent to :-

BTFSC    3,1

If DC = 1 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
5 7              SKPNDC Control skip if DC = 0 	 If the zero flag is 0 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

Equivalent to :-

BTFSC    3,2

If Z = 1 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
3 9             SKPNZ Control skip if Z = 0 	  If the zero flag is 1 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

Equivalent to :-

BTFSS    3,2

If Z = 0 then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
2 8              SKPZ Control skip if Z = 1 	q ! If the file 'f' contains zero then the Z flag is set, otherwise the Z flag is cleared.

1 clock cycle.
 = <   * !        TSTF     f File/Register set Z on 'f' 	;" Add carry to file. The carry flag is added to the value in file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

This is equivalent to :-

BTFSC    3,0
INCF     f,d

2 clock cycles.
< %   , "        ADDCF    f,d File/Register d = f + C 	G# Add digit carry to file. The digit carry flag is added to the value in file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

This is equivalent to :-

BTFSC    3,1
INCF     f,d

2 clock cycles.
= &   , #        ADDDCF   f,d File/Register d = f + DC 	| $ The contents of file 'f' are placed in the W register.

This is equivalent to :-

MOVF     f,0

1 clock cycle.
6 /   * $        MOVFW    f File/Register W = f 	I& Subtract carry from file. The carry flag is subtracted from the value in file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

This is equivalent to :-

BTFSC    3,0
DECF     f,d

2 clock cycles.
< :   , &        SUBCF    f,d File/Register d = f - C 	[' Subtract the digit carry from a file. The digit carry flag is subtracted from the value in file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

This is equivalent to :-

BTFSC    3,1
DECF     f,d

2 clock cycles.
= ;   , '        SUBDCF   f,d File/Register d = f - DC 	) The W register is copied to the TRIS register for Port 'f' ( where f is in the range 5 to 7 ). If a bit in the TRIS register is set to 1 then the corresponding bit of the port is an input, if the bit is a 0 then the corresponding bit is an output.

1 clock cycle.
6 
   $ )          TRIS     f Control TRIS[f] = W 	* Add W and file. The contents of the W register are added to the value in file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
<    , *       ADDWF    f,d File/Register d = W + f 	 , The contents of the file 'f' are inverted and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
<    , ,         COMF     f,d File/Register d = NOT f 	 - The contents of the file 'f' are decremented and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
<    , -         DECF     f,d File/Register d = f - 1 	. The contents of the file 'f' are decremented and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

If the result of the decrement is 0 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

If the result is not zero then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
S    , .          DECFSZ   f,d File/Register d = f - 1,    skip if result = 0 	/ The contents of the file 'f' are incremented and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

If the result of the increment is 0 then the next instruction to be executed is discarded and replaced with a NOP ( no operation ).

If the result is not zero then this instruction takes 1 clock cycle, if not the instruction takes 2 clock cycles.
<    , /          INCFSZ   f,d File/Register d = f + 1 	 0 The contents of the file 'f' are incremented and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
<    , 0          INCF     f,d File/Register d = f + 1 	-+ Bitwise AND the W register with file 'f'. The contents of the W register are ANDed with the contents of file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
>    , +         ANDWF    f,d File/Register d = W AND f 	51 Bitwise inclusive OR the W register with file 'f'. The contents of the W register are ORed with the contents of file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
=    , 1         IORWF    f,d File/Register d = W OR f 	62 Bitwise exclusive OR the W register with file 'f'. The contents of the W register are XORed with the contents of file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
>     , 2         XORWF    f,d File/Register d = W XOR f 	P 3 The contents of the W register are placed in file 'f'.

1 clock cycle.
6    * 3          MOVWF    f File/Register f = W 	 4 The contents of file 'f' is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
8    , 4         MOVF     f,d File/Register d = f 	6 The contents of the file 'f' are rotated one bit right through the carry flag. If the carry is clear it is equivalent to a division by 2. The result of the rotation is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

        msb           lsb
   Ŀ  Ŀ
   C7 . . . . . . 0Ŀ
      
                         
    

1 clock cycle.
M    , 6         RRF      f,d File/Register rotate right through carry 	5 The contents of the file 'f' are rotated one bit left through the carry flag. If there is no overflow it is equivalent to a multiplication by 2. The result of the rotation is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

        msb           lsb
   Ŀ  Ŀ
   CĴ7 . . . . . . 0
      
                         
    

1 clock cycle.
L    , 5         RLF      f,d File/Register rotate left through carry 	 8 The upper and lower nibbles of file 'f' are exchanged and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.
S    , 8          SWAPF    f,d File/Register d[0:3] = f[4:7], d[4:7] = f[0:3] 	 9 The contents of the W register are inclusive ORed with the 8 bit literal 'k' and the result is placed in the W register.

1 clock cycle.
5    $ 9         IORLW    k Literal W = W OR k 	  The contents of the W register are ANDed with the 8 bit literal 'k' and the result is placed in the W register.

1 clock cycle.
6    $          ANDLW    k Literal W = W AND k 	 : The contents of the W register are exclusive ORed with the 8 bit literal 'k' and the result is placed in the W register.

1 clock cycle.
6    $ :         XORLW    k Literal W = W XOR k 	R ; The eight bit literal 'k' is loaded into the W register.

1 clock cycle.
0    $ ;          MOVLW    k Literal W = k 	~< The W register is subtracted from the eight bit literal 'k'. The result is placed in the W register.

1 clock cycle.

Subtracting W from a constant is probably not what you want to do ( except that SUBLW 0 effectively negates W ).

To subtract a fixed value from W you can use :-

ADDLW    0-k

where 'k' is the constant to subtract, the assembler works out 0 - k.
4    $ <       SUBLW    k Literal W = k - W 	;7 Subtract W from file. The contents of the W register are subtracted from the value in file 'f' and the result is placed in the destination selected by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

1 clock cycle.

Due to the strange way the PIC handles subtraction you must think of the carry flag as 'not negative' or 'no borrow'. If the result of a subtraction is positive or zero then carry will be set, if the result is negative carry will be clear. This is true for SUBLW, SUBWF and ADDLW 0-x.
<    , 7       SUBWF    f,d File/Register d = f - W 	 = If the zero bit is clear then a GOTO 'label' instruction is executed.

This instruction is equivalent to :-

BTFSS    3,2
GOTO     label

This instruction takes 2 cycles if carry is set or 3 cycles if carry is clear.
6 =    =         BNZ Control branch on not zero 	 The 11 bit address represented by 'label' is loaded into the lowest 11 bits of the PC, the upper bits of the PC are loaded from PCLATH.

2 clock cycles.

Beware of using GOTO's within interrupt routines. When an interrupt occurs the full 13 bit return address is saved on the stack BUT PCLATH ISN'T! If you are using code beyond 2k and PCLATH is set somewhere in your program and an interrupt occurs, when the GOTO instruction is executed your PIC will jump to somewhere unexpected.

Either leave PCLATH alone or don't use GOTO's in your interrupt handler or save PCLATH as part of the interrupt handler and then set PCLATH to a sensible value, restoring it at the end of the interrupt.
9     (           GOTO     label Control PC = label 	% The contents of 'f' are negated and placed in the destination specified by 'd'. If 'd' is 0 the result is placed in the W register, if 'd' is 1 the result is placed in the file 'f'.

This is equivalent to :-

COMF     f,1
INCF     f,d

NOTE: This instruction compliments the contents of the register 'f', if the destination is 'f' then this does not matter but if the destination is W then be aware that you have changed 'f'.

NOTE: you can use SUBLW 0 to megate the W register.

2 clock cycles.
9 0   , %        NEGF     f,d File/Register d = -f 	( The processor is put into a low power sleep mode with the oscillator stopped, all outputs remain at the same logic levels which they had before the instruction was executed.
    __                          __
The TO flag is set to 1 and the PD flag is cleared. The watchdog timer and any prescaler assigned to it are also cleared.
                                               ____
The processor can be woken up by an interrupt, MCLR being taken low or by the watchdog timer.

1 clock cycle.
8     (          SLEEP Control stop the processor m      nNative Instructions                                                       (!Cmp) 
P  ! " # $       	 
  
                          k      nComposite Instructions                                                    (Cmp) 
8  ' ( ) * = + , - . 1 2 3 4 6 5 7 9 8 % & / 0 : ; < b        nAll Database Items                                                        
   ! " # $ ' ( ) * = +  , -  .     	 
 1 2 3 4 6 5 7 9 8  
 % &            /  0   : ;   <                    (                        +   ;   L b  ;L k  K m  J       *< D  e M     X            	   C
         U \  
 Q  s           yC '   ^  9      ? k   P  % V   T  !       
 R     q   ;  G (  |  !  nF I ^" [ #  H  {%  & - /   (   .)  S*  y,   . 5 1 6 2 P  3   4  7  5 ; ?   :   c;   < R  = ~ 3>   \B   L 8  L P  HK 4    6  < G  
 .   9  5F 5  ; 0  > 1   8  m :   /   8  J 4  ? 6  & 6  {= <  ' >  0 6  = 0   <  ( <  * S  &, <  q/ <  L. =  M2 8  J5 6  N4 0  	 L  9 M  7 <   B S  ; >  3 1   1  ' C  F C  w <   =  o! >   D   A  
 G  = =  g *   ,  ) *  t 6  (" 9  pH *  u ,   *  u 2   3   4   5  _ 2   3   <  # =  >% =  t 6  CC W     ^            M P                     