


gdbload(1)                HP100LX Tools                gdbload(1)



NAME
     gdbload - load ASCII formatted data into an HP  100LX  data-
     base

SYNOPSIS
     gdbload [-an] database [ input ]

DESCRIPTION
     gdbload loads ASCII formatted data into an  HP  100LX  data-
     base.  database is the name of the 100LX database to modify.
     input is the name of a file of ASCII data to load  into  the
     database.  If no input file is specified, the standard input
     is used.  The ASCII file format  is  one  exported  by  many
     database packages as well as by gdbdump(1).

  Options
     gdbload recognizes the following options:

          -a   Add the records from the ASCII file to  the  data-
               base,  keeping  the records already present in the
               database.  By default, the records  in  the  ASCII
               file replace those already in the database.

          -n   Do not back up the database file.  By default, the
               original,  unmodified  database  file is left in a
               file with the same name and a .bak extension.

  Input Format Description
     The input to this program is an ASCII text file which starts
     with a line containing field names.  This line indicates the
     order in which fields appear on subsequent lines.   Not  all
     fields of the database need be specified; unspecified fields
     will be left blank in all added records.   Field  names  are
     not  case distinct and ampersands (&) are ignored in compar-
     ing field names.

     This first line is followed by one line for each  record  of
     the  database.   Note  that  any of these lines may be split
     into multiple lines if needed, by placing a backslash (\) at
     the  ends  of lines which are continued.  Each line contains
     all of the fields whose names were listed on the first line,
     in the same order as on the first line.  The fields (and the
     field names, on the first line) are separated by commas.

     Exactly how each field should appear depends  on  its  type.
     Text fields, category fields, number fields, and note fields
     should have their text quoted if it contains commas or  new-
     lines.  The following escape sequences are understood:

          \r   Carriage return (ASCII 13).

          \n   Line feed (ASCII 10).



Steve Roth et.al.   Last change: August 1993                    1






gdbload(1)                HP100LX Tools                gdbload(1)



          \nnn nnn are octal digits representing a character.

          \xnn nn are hexadecimal digits representing  a  charac-
               ter.

     Any other character following a backslash is  treated  as  a
     standard  character with no special meaning, i.e., backslash
     and quote marks can be escaped  by  preceding  them  with  a
     backslash.

     Date fields should appear in the format YYYYMMDD; for  exam-
     ple, August 15, 1993 should appear as 19930815.  Time fields
     appear in the format HHMM, where HH is in the  range  00-23.
     Date  and  time fields may also be left blank, i.e., nothing
     between the commas.

     Radio buttons and check boxes are turned off if the field is
     empty or contains a 0; they are turned on otherwise.

     No other field types, including  application-defined  types,
     are accepted by gdbload.

     The output from gdbdump(1) matches this input format, unless
     the -n flag is given to gdbdump(1).

WARNINGS
     When the newly constructed database is first opened  by  the
     100LX,  it  will  (erroneously)  be reported as being empty.
     This is because gdbload does not construct database indexes,
     and  the 100LX expects the index for the current "subset" to
     be valid.  The situation is  remedied  by  pressing  F6  and
     selecting  any  "subset"  (even the current one!)  This will
     rebuild the index for  that  "subset",  causing  records  to
     display  normally.   The delay caused by the rebuild depends
     on the size of the database (among other things), and ranges
     from   imperceptible  for  small  databases  up  to  several
     minutes. This delay will occur whenever a  new  "subset"  is
     selected for the first time.

     gdbload will not attempt to modify HP 100LX Appointment Book
     and World Time databases.

     gdbload will not allow you to specify data for  application-
     defined fields of a database.

     This program  cannot  handle  password-protected  databases.
     Attempts to load data into password-protected databases will
     have unpredictable results.

AUTHOR
     gdbload was written by Steven Roth,  stever@cup.hp.com,  and
     is   being  maintained  by  Arne  Christensen,  arc@pine.dk.



Steve Roth et.al.   Last change: August 1993                    2






gdbload(1)                HP100LX Tools                gdbload(1)



     Contact the latter for bug reports, enhancement requests, or
     to get a copy of the source code.

DISCLAIMER
     This program is released into the public domain and  neither
     the  author nor the maintainer place any restrictions on its
     use.  We make no warranties or guarantees for  this  program
     and  you  use it at your own risk.  This program is supplied
     by us personally and not by Hewlett-Packard Co. or Pine Tree
     Systems, which incur no obligations pertaining to it.

ACKNOWLEDGEMENTS
     Many thanks to Andy Gryc for publishing the details  of  the
     database file formats!

SEE ALSO
     gdbdump(1).






































Steve Roth et.al.   Last change: August 1993                    3



