


     ODIPKT(8)        UNIX System V (February 2, 1992)       ODIPKT(8)



     NAME
          odipkt - translate Open Data-Link Interface to Packet Driver
          interface

     SYNOPSIS
          odipkt [ logical_board [ vector ] ]
          odipktpn [ logical_board [ vector ] ]

     DESCRIPTION
          Odipkt.com provides a Packet Driver API over Novell's Open
          Data-Link Interface, allowing a single network adapter to
          service IPX, tcp/ip, and other protocol stacks which use
          packet drivers.  Odipkt.com understands Ethernet, Token
          Ring, and ARCnet frame types.  Ethernet and Token Ring
          frames are passed unchanged to packet driver applications,
          but ARCnet frames are internally mapped to Ethernet.  Thus,
          packet driver applications do not need specific knowledge of
          ARCnet in order to operate in such environments.

          The logical_board argument indicates which logical adapter
          odipkt should bind to.  Under ODI, there is one logical
          adapter per frame type.  There may be multiple physical
          adapters and multiple frame types per physical adapter.  The
          logical adapter number starts at zero and increases by one
          for each frame type.  For example, if a system contained two
          physical adapters with two frame types each, there would be
          four logical adapters numbered 0-3.  The frame types are
          specified in the NET.CFG file which must be in the current
          directory (or on the APPEND path) when the ODI drivers are
          loaded.

          Typically, the frame type used by default by Netware on a
          given adapter will not be appropriate for tcp/ip.  The
          correct frame type for tcp/ip on Token Ring is TOKEN-
          RING_SNAP and the correct frame type for tcp/ip on Ethernet
          is almost always ETHERNET_II.  Assuming an existing
          installation with one adapter running the default Netware
          frame type, it will usually be necessary to define a second
          frame type (as listed above) and specify the logical_board
          argument as 1.  An exception to this rule is ARCnet which
          uses only one frame type.  Below is a NET.CFG entry for a
          3c501 using the default address and interrupt.  In many
          cases, this is the only entry required in NET.CFG.  Other
          Ethernet adapters would use similar configurations:

          Link driver 3c501
               envelope type ETHERNET_802.3
               envelope type ETHERNET_II

          Given the above entry, the logical_board argument of oipkt
          would be 1.  Token Ring uses different frame types:




     Page 1                                           (printed 7/7/93)






     ODIPKT(8)        UNIX System V (February 2, 1992)       ODIPKT(8)



          Link driver token
               envelope type TOKEN-RING
               envelope type TOKEN-RING_SNAP

          Again, the logical_board should be specified as 1 for this
          example.  ARCnet installations require no frame-type
          definitions and should use a logical_board of 0.

          Vector is the packet driver interrupt at which to provide
          service.  The default is 105 and the parameter is decimal.

          Odipkt.com should be loaded after lsl.com and the adapter-
          specific driver(s).  It must, of course, be loaded before
          the packet driver applications which use it.  The Netware
          shell and ipxodi.com can be loaded before or after the
          odipkt.com program.

          Odipktpn.com supports an older version of the ODI
          specification as used in Farallon's PhoneNET Talk product.
          Operation of opipktpn.com is identical to that of opipkt.com
          but configuration of NET.CFG is somewhat different.  No
          ``envelope'' statements are required and the Link Support
          section's ``Buffers'' entry must specify the true maximum
          frame size of the network.  Because multiple frame types are
          not supported, odipktpn.com treats all Ethernet cards as
          ETHERNET_II.

     AUTHOR
          Dan Lanciani
          185 Atlantic Road
          Gloucester, MA 01930
























     Page 2                                           (printed 7/7/93)



