#! /usr/bin/awk -f
###################################################################### #
#
# Name:         htmlndx - add an index to html files
# Synopsis:     htmlndx file.html > indexedfile.html
# Description:  Adds an index base on the headings to the end of the file
# Author:       Peter Ernst
# Created:      Sun May 14 10:26:01 1995
# Modified:     Sun May 14 11:11:16 1995 (Peter Ernst) peer@laurin
# Language:     AWK
# Package:      N/A
#
# (C) Copyright 1995 Peter ERNST all rights reserved.
#
######################################################################

BEGIN {
 base="ref"
 ndx=0
}

# detect headings
/<[Hh][1-9]>/ {
 # get the heading level
 level = int(substr($0,match($0,"<[Hh][1-9]>")+2,1))

 entry = base ndx++ # calculate new reference id

 # insert tag 
 sub("<[Hh][1-9]>","&<A NAME=\"" entry  "\">")
 if (!sub("</[Hh][1-9]>","</A>&"))
  $0 = $0 "</A>"

 # remember tag
 tbl[entry]      = $0
 leveltbl[entry] = level
}

{ 
 sub("</[Bb][Oo][Dd][Yy]","")
 sub("</[Hh][Tt][Mm][Ll]","")
 print
}

END {
  print "<HR>\n<H1>Table Of Contents</H1>\n<OL>"
  listlevel=1

  for (i=0; i < ndx; i++)
  {
    entry = base i
    head  = tbl[entry]
    level = leveltbl[entry]
    gsub("<A NAME=\".*\">","",head)
    sub("<[Hh][1-9]>","",head)
    sub("</[Hh][1-9]>","",head)
    gsub("</[Aa]>","",head)

     # reduce list level
     while (level < listlevel)
     {
      print "</UL>"
      listlevel--
     }
     # increase listlevel
     while (level > listlevel)
     {
       listlevel++
       print "<UL>"
     }  
    print "<LI>" "<A HREF=\"#" entry "\">" head "</A>"
  }
  print "</BODY>\n</HTML>"
}
