@echo off
rem -------------------------------------------------------- --------
rem    Sample batch file that will capture output from your HP and
rem    send it to the printer upon a keystroke.
rem    You may have to adapt the port parameters below.
rem    Remember that 0 == COM1, 1 == COM2 etc.
rem    The temp file is stored in the current directory.
rem    Defaults are COM1 for capture and LPT2 for printing. Set these
rem    via the environment strings below. If you are editing this file,
rem    note that there is a control character at around line 51. Be sure 
rem    your editor doesn't "adjust" it or the print jobs won't be separated 
rem    with a formfeed.
rem -------------------------------------------------------- --------

:top
rem   Set path strings for input and output ports below. Be sure to note 
rem   that the com ports are 0 based, e.g. 0=COM1, 1=COM2, etc. In the 
rem   lines below, the variable _cpth is the com port where the print
rem   job is captured. The variable _ppth is the printer port where the
rem   print job is to printed. For example, if you want to hook up to 
rem   COM1 and print to LPT1, set _cpth=0 and _ppth=lpt1: below.

set _cpth=0
set _ppth=lpt1:

rem Install X00
if not exist x00.exe goto no-x00
x00 E

cls 
echo -----------------------------------------------------------------
echo  HPPRN will capture print information from your Palmtop and
echo  store it to a temporary file. When you press a key, it will
echo  send the contents of the temporary file to the printer port you 
echo  designate. HPPRN will loop around as many times as you need, and
echo  send a form feed to the printer after each time through.
echo  ...
echo  Remember to set your palmtop printer settings to 9600,N,8,1.
echo  Your current settings are as follows:
echo       Storing print information in .........~HPPRN.TMP
echo       Capturing information from COM port ..%_cpth% (plus 1)
echo       Printing to port .....................%_ppth%
echo  ...
echo  If you do not want to use these settings, press Ctrl-Break and 
echo  edit the LISTEN.BAT file to change the settings.
echo  Otherwise, press any key to begin...
echo -----------------------------------------------------------------

hpprn %_cpth% ~hpprn.tmp
copy /b ~hpprn.tmp %_ppth%
echo  >%_ppth%
 
rem remove X00 by calling it again
echo Removing communications driver...
x00

rem clear the environment strings
set _cpth=
set _ppth=

echo  Printed the file. Press Ctrl-Break to stop or press ENTER to 
echo  capture another print job.
Pause 
goto top

:no-x00
echo Couldn't find X00.EXE. Can't continue without it!
Goto end

:end
