; CB - Read HPx00LX clipboard and write it to stdout
;
; Limitations: read 8k maximum;
;
; A.Garzotto,  27-FEB-95
; last update:
;
;*****************************************************************************

prog   segment byte
       public START
       assume cs: prog, ds:prog, ss:nothing

CB_OK         EQU     0
F_M_OPEN_CB   EQU  4701h
F_M_CLOSE_CB  EQU  4702h
F_M_REP_INDEX EQU  4708h
F_M_CB_READ   EQU  470Ah
BUFLEN        EQU  8192

;*****************************************************************************
;main program

       org  100H
START  PROC FAR
       mov  cb_ptr, offset kbuf
       call cb_read             ;read clipboard data into kbuf
       mov  bx, cb_ptr
       xor  al, al
       mov  [bx], al            ;write terminating 0
       mov  si, offset kbuf
       cld
m1:    lodsb
       and  al, al
       jz   m3
       cmp  al, 13
       jne  m2
       dec  si
       mov  byte ptr [si], 10
m2:    mov  ah, 2
       mov  dl, al
       int  21h                 ;write character to stdout
       jmp  m1
m3:    int  20h                 ;terminate
START  endp

;*****************************************************************************
; call sysmgr service

c_serv PROC NEAR
       push si                  ;push anything to simulate far call
       push bp
       mov  bp, sp
       xchg di, [bp + 6]
       xchg ax, di
       pop  bp
       int 7Eh
       push bp
       mov  bp, sp
       xchg di, [bp + 6]
       pop  bp
       push cs
       pop  ds
       pop  si
       ret
c_serv ENDP

;*****************************************************************************
; read clipboard data into *cb_ptr, return end of data in cb_ptr

cb_read PROC NEAR   
       mov  ax, F_M_OPEN_CB
       push ax
       call c_serv           ;open clipboard
       pop  bx
       cmp  ax, CB_OK        ;open OK?
       je   cb1
       ret
       
cb1:   push ds
       mov  ax, offset len
       push ax
       push ds
       mov  ax, offset idx
       push ax
       push ds
       mov  ax, offset tex_t
       push ax
       mov  ax, F_M_REP_INDEX
       push ax
       call c_serv          ;get clipboard info (?)
       pop  bx
       pop  bx
       pop  bx
       pop  bx
       pop  bx
       pop  bx
       pop  bx
       cmp  ax, CB_OK
       je   cb2
cbq:   mov  ax, F_M_CLOSE_CB
       push ax
       call c_serv        ;close clipboard
       pop  bx
       ret                ;and return

cb2:   mov  ax, BUFLEN    ;read BUFLEN characters maximum
       push ax
       push ds
       push cb_ptr        ;into buffer pointed to by cb_ptr
       xor  ax, ax
       push ax
       push idx
       mov  ax, F_M_CB_READ
       push ax
       call c_serv        ;read them
       pop  bx       
       pop  bx       
       pop  bx       
       pop  bx       
       pop  bx       
       pop  bx       
       mov  bx, BUFLEN
       sub  bx, ax
       add  cb_ptr, bx    ;return pointer to end in cb_ptr
       jmp  cbq
cb_read ENDP

;*****************************************************************************

tex_t   DB "TEXT", 0
idx     DW ?
len     DW ?
cb_ptr  DW ?
kbuf    DB ?

;*****************************************************************************

prog   ends

end START
