#!/usr/bin/perl -w
# $Id: opcodes.pl,v 1.1.1.1 1999/10/06 10:54:46 mg Exp $
use strict;

my %ArgHash = (
 'r/m8' => 'argRegMem8',
 'r/m16' => 'argRegMem16',
 'r8' => 'argReg8',
 'r16' => 'argReg16',
 'seg' => 'argSegReg',
 'AL' => 'argRegAL', 'BL' => 'argRegBL', 'CL' => 'argRegCL', 'DL' => 'argRegDL',
 'AH' => 'argRegAH', 'BH' => 'argRegBH', 'CH' => 'argRegCH', 'DH' => 'argRegDH',
 'AX' => 'argRegAX', 'BX' => 'argRegBX', 'CX' => 'argRegCX', 'DX' => 'argRegDX',
 'SP' => 'argRegSP', 'BP' => 'argRegBP', 'SI' => 'argRegSI', 'DI' => 'argRegDI',
 'CS' => 'argRegCS', 'DS' => 'argRegDS', 'SS' => 'argRegSS', 'ES' => 'argRegES',
 'mem8' => 'argMem8',
 'mem16' => 'argMem16',
 'mem32' => 'argMem32',
 'memoffs8' => 'argMemOffs8',
 'memoffs16' => 'argMemOffs16',
 'near' => 'argNear',
 'far' => 'argFar',
 'short' => 'argShort',
 'imm8' => 'argImm8',
 'imm16' => 'argImm16',
 'simm8' => 'argSImm8',
 '1' => 'argConst1',
 '3' => 'argConst3',
 'prefix' => 'argNone',
 );

my (%Opcodes, %BadArgs, %MoreOps);

while (<>) {
    chomp;
    if (/^([0-9a-fA-F]{2})\s+(\S+)(?:\s+([^, \t]+)(?:,(\S+))?)?/) {
	$Opcodes{hex($1)}{MNEMONIC} = $2;
	$Opcodes{hex($1)}{ARG1} = $3 || '';
	$Opcodes{hex($1)}{ARG2} = $4 || '';
	$BadArgs{$3} = 1 if defined $3 && !defined $ArgHash{$3};
	$BadArgs{$4} = 1 if defined $4 && !defined $ArgHash{$4};
    } elsif (/^;\s*<([^>]+)>:/) {
	my $Op = $1;
        for my $i (0..7) {
	    chomp ($_ = <>);
	    if (/^;\s*([0-1]{3})(?:\s+(\S+)\s*(\S*))?/) {
		$MoreOps{$Op}[$i]{MNEMONIC} = $2 || '';
		$MoreOps{$Op}[$i]{ARGS} = $3 || '';
	    }
	}
    }
}

print <<END;
const
  Opcodes: array[Byte] of TOpcodeData = (
END

for (my $i = 0; $i < 256; $i++) {
    my $op = $Opcodes{$i};
    $op = {MNEMONIC => '', ARG1 => '', ARG2 => ''} unless defined $op;
    print "    { \$", sprintf("%02X", $i), " } (Mnemonic:'", $op->{MNEMONIC}, 
          "'; Arg1:",
          defined $ArgHash{$op->{ARG1}} ? $ArgHash{$op->{ARG1}} : "argNone",
	  "; Arg2:",
          defined $ArgHash{$op->{ARG2}} ? $ArgHash{$op->{ARG2}} : "argNone",
          "; Prefix:",
	  $op->{ARG1} eq "prefix" ? "True" : "False",
	  $i == 255 ? "));\n" : "),\n";
}

if (keys %BadArgs) {
    print "{ Invalid arguments: ",
          join("\n  ", '', sort keys %BadArgs),
	  "\n}\n";
   
}

for my $op (sort keys %MoreOps) {
    print "\n  $op: array[0..7] of string[7] = (\n";
    for my $i (0..7) {
	print "    '$MoreOps{$op}[$i]{MNEMONIC}'";
	print $i < 7 ? "," : ");";
	print "\t{ $MoreOps{$op}[$i]{ARGS} }" if $MoreOps{$op}[$i]{ARGS};
	print "\n";
    }
}

