/* --------------------------------------------------------------------
   Project: PALHELP
   Module:  testhelp.c Help File display
   Author:  Ron Crain
            Based on DFLAT help system by Al Stevens, published in
            Dr. Dobb's Journal, Nov, 1991 - Nov, 1992

				Modified by Carl Chipman, Nomadics Inc.

   Started: 02/01/95 1:40 pm

	Modified:06/04/96
	
   Subject: Implements the PAL help engine to send help text to the
            standard output.

            Invoking with
                           test help [helptag]
            will display the text for topic "helptag" from the file
            HELP.PH.

            If the helptag is ommited, all topics will be dumped. This
            version will output diagnostic information for each topic.

            To build makehelp.exe, use:
               cl /c test.c palhelp.c
               link test+palhelp;
            in MSC, or equivalent commands for your compiler.

            If window size information is required, define the
               WINSIZE variable (/DWINSIZE) in the cl command
               line.

   -------------------------------------------------------------------- */
/* --------------------------------------------------------------------
                       standard includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* --------------------------------------------------------------------
                         local includes
   -------------------------------------------------------------------- */
#include "palhelp.h"
#include "c:\pal\src\inc\pal.h"
#include "c:\pal\src\inc\palkeys.h"
#include "c:\pal\src\inc\paldlg.h"
#include "c:\pal\src\inc\palpriv.h"
#include "c:\pal\help\resource.h"
/* --------------------------------------------------------------------
                        global variables
   -------------------------------------------------------------------- */
static struct helps *TestHelp;
char szDispStr[255];
int iFontId;
char *szHTP1;   

	
HelpLine *pTopLine = NULL;
HelpLine *pBottomLine = NULL;
HelpLine *pTempLine = NULL;
HelpLine *pWindowTopLine = NULL;
HelpLine *pWindowBottomLine = NULL;
HelpTag *pFirstTag;
HelpTag *pLastTag;
HelpTag *pTempTag;
int iFontHeight;

BOOL bTag;
/* --------------------------------------------------------------------
                           functions
   -------------------------------------------------------------------- */
/* --------------------------------------------------------------------
   Process a line of help text by parsing highlighted text and identifiers
   -------------------------------------------------------------------- */
static int k = 0;
PALWIN *pHelpWin = NULL;
int iNumberOfHelpLines;
RECT rLastRect = {0,0,0,0,0,0,0,0};
RECT rThisRect;
RECT rRect;

/* --------------------------------------------------------------------
   Write the help text to the screen for a given help id
   -------------------------------------------------------------------- */

void ReleaseHelpPointers(HelpLine **pStart, HelpLine **pStop, HelpLine **pTemp,
								 HelpLine **pWindowStart, HelpLine **pWindowStop);
								 
void ReleaseTagPointers(HelpTag **pStart, HelpTag **pStop,  HelpTag **pTemp);

void FindTag()
{
	// If the tag is more than one screen away from the current bottom
	
	if(pTempTag->iLineNumber >  (iNumberOfHelpLines + pWindowBottomLine->iLineNumber))
	{
		int i;
		
		//Clear the Window
		ClrBlock(rRect.left, rRect.top, rRect.right, rRect.bottom, WHITE_COLOR);
		
		pTempLine = pWindowBottomLine;
		
		//Loop until you find the HelpLine coressponding to the tag line
		while(pTempLine != NULL)
		{
			if(pTempLine->iLineNumber == pTempTag->iLineNumber) break;
			pTempLine = pTempLine->Next;
		}
		
      //Check to see if the bottom is less than half a screen away from the helpline
      //that you found the tag on
      
		if(abs((pBottomLine->iLineNumber - pTempLine->iLineNumber)) < (iNumberOfHelpLines/2))
		{
			
			//if the bottom of the list is less than half a screen away from the tagged lined
			//then set the window bottom to the bottom of the list

			pWindowBottomLine = pBottomLine;
			pTempLine = pBottomLine;
			
			//scroll up to find the top line  (is there a better way?)
			
			for(i = 0; i<(iNumberOfHelpLines - 1);i++)
			{
				pTempLine = pTempLine->Prev;
			}
			pWindowTopLine = pTempLine;
			
		}
		else
		{
			//the bottom of the list is more than one screen away so get the top and bottom
			
			//get the top line
			for(i = 0; i < (iNumberOfHelpLines / 2); i++)
			{
				pTempLine = pTempLine->Prev;
			}
			pWindowTopLine = pTempLine;
		}
		
		//write from the top line and down from there
		for(i = 0; i < iNumberOfHelpLines;i++)
		{
			TextOut(rRect.left + 3,rRect.top + i * iFontHeight,TXT_RULE, iFontId, pTempLine->szLine);
			
			if(pTempLine->Next != NULL) pTempLine = pTempLine->Next;
			else break;
		}
		//Set the bottom line
		pWindowBottomLine = pTempLine;
	}
	else
	{
	
		//	This case is if the tag line is closer than one full screen away
		int i;
		int z = pTempTag->iLineNumber - pWindowBottomLine->iLineNumber;
		if(z > 0)
		{

			//Scroll the screen up to fit new text at the bottom

	      Scroll(SCROLL_UP, iFontHeight * z,WHITE_COLOR, rRect.left + 1, rRect.top + 1,
	      		 rRect.right - 1, rRect.bottom - 1);	

			//move the top line pointer
			for(i = 0;i<z;i++){
				pWindowTopLine = pWindowTopLine->Next;
			}

			//start from the current bottom line and write z new lines at the bottom
			pTempLine = pWindowBottomLine->Next;

			for(i = iNumberOfHelpLines - z;i<iNumberOfHelpLines;i++)
			{           	
				TextOut(rRect.left + 3,rRect.top + i * iFontHeight,TXT_RULE, iFontId, pTempLine->szLine);
			
				if(i != (iNumberOfHelpLines - 1)) pTempLine = pTempLine->Next;
				else break;
			}
         
         // Set the BottomLine = last line written
         pWindowBottomLine = pTempLine;
      }
   }

//this will be the stuff to scroll it up.

	// If the tag is more than one screen away from the current top line
	if((pTempTag->iLineNumber + iNumberOfHelpLines) <  pWindowTopLine->iLineNumber)
	{
		int i;
		
		//Clear the screen
		ClrBlock(rRect.left, rRect.top, rRect.right, rRect.bottom, WHITE_COLOR);
		
		pTempLine = pWindowTopLine;
		
		//	Find the line corresponding to the tag
		while(pTempLine != NULL)
		{
			if(pTempLine->iLineNumber == pTempTag->iLineNumber) break;
			pTempLine = pTempLine->Prev;
		}
		

		// Check to see if you are within half a screen of the top line
		if((abs(pTempLine->iLineNumber - pTopLine->iLineNumber)) < (iNumberOfHelpLines/2))
		{
			
			// If you are, set the window top line to the top line of the topic
			pWindowTopLine = pTopLine;
			pTempLine = pTopLine;
			
			//Get the Bottom Line
			for(i = 0; i<(iNumberOfHelpLines - 1);i++)
			{
				pTempLine = pTempLine->Next;
			}
			pWindowBottomLine = pTempLine;
			
		}
		else
		{

			//If you are not within a half screen of the top then center the tagged topic
			for(i = 0; i < (iNumberOfHelpLines / 2); i++)
			{
				pTempLine = pTempLine->Prev;
			}
			pWindowTopLine = pTempLine;
		}

		//Now write the topic with the tag from the top line of the screen to the bottom
		for(i = 0; i < iNumberOfHelpLines;i++)
		{
			TextOut(rRect.left + 3,rRect.top + i * iFontHeight, TXT_RULE, 
					  iFontId, pTempLine->szLine);
			
			if(i != (iNumberOfHelpLines - 1)) pTempLine = pTempLine->Next;
			else break;
		}
		// The last line written is the bottom
		pWindowBottomLine = pTempLine;
	}


	else
	{
		// The tag line is within one screen and will be scrolled to
		int i;
		int z = pWindowTopLine->iLineNumber - pTempTag->iLineNumber;
		if(z > 0)
		{
	      Scroll(SCROLL_DOWN, iFontHeight * z, WHITE_COLOR, rRect.left + 1,rRect.top + 1, 
	      	    rRect.right - 1, rRect.bottom - 1);	

			for(i = 0;i<z;i++){
				pWindowTopLine = pWindowTopLine->Prev;
				pWindowBottomLine = pWindowBottomLine->Prev;
			}
			pTempLine = pWindowTopLine;
			for(i =  0;i<z;i++)
			{           	
				TextOut(rRect.left + 3,rRect.top + i * iFontHeight,TXT_RULE, iFontId, 
						  pTempLine->szLine);
			
				if(i != (iNumberOfHelpLines - 1)) pTempLine = pTempLine->Next;
				else break;
			}
      }
   }
}

PALWIN *OpenWindow(WORD Style, int x1, int y1, int x2, int y2, char *Caption, RECT *r)
{
	PALWIN *pO;
	
	pO = OpenWin(Style,x1,y1,x2, y2, Caption);
	
    r->top = pO->PosY;
    r->left = pO->PosX;
    r->bottom = r->top + pO->Depth;
    r->right = r->left + pO->Width;
    r->height = r->bottom-r->top;
    r->width = r->right - r->left;
    r->middlex = r->left + r->width/2;
    r->middley = r->top + r->height/2;
	
	return pO;
}


RECT ResetRect(){
    RECT r;

    r.top = 0;
    r.left = 0;
    r.bottom = 0;
    r.right = 0;
    r.height = 0;
    r.width = 0;
    r.middlex = 0;
    r.middley = 0;
    return r;
}

void ReleaseHelpPointers(HelpLine **pStart, HelpLine **pStop, HelpLine **pTemp,
								 HelpLine **pWindowStart, HelpLine **pWindowStop)
{
	HelpLine *pH = *pStart;
	while(pH)
	{
		*pTemp = pH->Next;
		free(pH->szLine);
		free(pH);
		pH = *pTemp;
	}
	*pWindowStart= NULL;
	*pWindowStop = NULL;
	pH = NULL;
	*pStart = NULL;
	*pStop = NULL;
}

void ReleaseTagPointers(HelpTag **pStart, HelpTag **pStop,  HelpTag **pTemp)
{
	HelpTag *pH = *pStart;
	
	while(pH)
	{
		*pTemp = pH->Next;
		free(pH->szTag);
		free(pH);
		pH = *pTemp;
	}
	*pStart = NULL;
	*pStop  = NULL;
}

void DisplayHelp( char *HelpID )
{
   int x1,y1,x2,y2;
   static char hline[160];
   char *tline = '\0';
	int iLongLine = 0;
   int i;
   int idx = 0;
	HelpLine *pTemp = NULL;
   HelpLine *pPrint;
   const char LinkToken[] = "[..";
   const char RefToken[] = "[**";
   char *pHiLite;
   char *szCheckLink;
   size_t len;
	
   
   if( ( TestHelp = FindHelp( HelpID ) ) != NULL )
   {
		ClrBlock(1, 1, 639,180, WHITE_COLOR);
      SeekHelpLine( TestHelp->hptr, TestHelp->bit );
	   if( GetHelpLine( hline ) != NULL )
      SeekHelpLine( TestHelp->hptr, TestHelp->bit );
      if( GetHelpLine( hline ) != NULL )
         hline [strlen( hline ) - 1] = '\0';

#ifndef RELEASE
      sprintf(szDispStr, "+--Diagnostics--------------------------------------------" );
      TextOut(10,20, TXT_RULE, iFontId, szDispStr);
      sprintf(szDispStr, "|         HelpID:  %s", HelpID );
      TextOut(10,40, TXT_RULE, iFontId, szDispStr);
      sprintf(szDispStr, "|   Window Title:  %s", &hline );
      TextOut(10,60, TXT_RULE, iFontId, szDispStr);
      sprintf(szDispStr, "| NextHelp index:  %d", TestHelp->nexthlp );
      TextOut(10,80, TXT_RULE, iFontId, szDispStr);
      sprintf(szDispStr, "| PrevHelp index:  %d", TestHelp->prevhlp );
      TextOut(10,100, TXT_RULE, iFontId, szDispStr);
#ifdef WINSIZE
      sprintf(szDispStr, "|    Window Size:  %d lines x %d cols", TestHelp->hheight, TestHelp->hwidth );
      TextOut(10,120, TXT_RULE, iFontId, szDispStr);
#endif
      sprintf(szDispStr, "+---------------------------------------------------------\n" );
      TextOut(10,140, TXT_RULE, iFontId, szDispStr);
#endif
		ClrBlock(1, 1, 639,180, WHITE_COLOR);
      while( *hline != '<' )
      {
		   idx++;
		   pTemp = (HelpLine *)malloc(sizeof(HelpLine)); 

         *hline = '\0';
         if( GetHelpLine( hline ) == NULL || *hline == '<' )
            break;

		   len = strlen( hline ) - 1;
		   hline [len] = '\0';
		   hline [len + 1] = '\0';
			
			while((szCheckLink = strstr(hline, LinkToken)) != NULL)
			{
				
				char *szCheck1 = strchr(hline,'[');
				char *szCheck2 = strchr(hline,']');

				pTempTag = (HelpTag *)malloc(sizeof(HelpTag));

				*szCheck1 = 0;
				*szCheck2 = 0;
				
				pTempTag->Next = NULL;
				pTempTag->Prev = NULL;
				pTempTag->szTag = strdup(szCheck1+3);
				pTempTag->iLineNumber = idx;
				
				if(!pFirstTag)
				{
					pFirstTag = pTempTag;
					pLastTag = pTempTag;
				}
				else
				{
					pLastTag->Next = pTempTag;
					pTempTag->Prev = pLastTag;
					pLastTag = pTempTag;
				}
				
				strcat(hline, szCheck2 + 1);
	
				szCheck1 = strchr(hline,'<');
//				if(szCheck1) *szCheck1 = '*';
				if(szCheck1) *szCheck1 = '\x11';
				szCheck2 = strchr(hline,'>');
//				if(szCheck2) *szCheck2 = '*';
				if(szCheck2) *szCheck2 = '\x10';
			}
			
			pTempTag = NULL;			

			pTemp->szLine = strdup(hline);
			pTemp->Prev = NULL;
			pTemp->Next = NULL;
         pTemp->iLineNumber = idx;
         
			if(!pTopLine){
				pTopLine = pTemp;
				pBottomLine = pTemp;
			}
			else
			{
				pBottomLine->Next = pTemp;
				pTemp->Prev = pBottomLine;
				pBottomLine = pTemp;
			}
      }
	   pWindowTopLine = pTopLine;
	   pPrint = pTopLine;


      while( pPrint != NULL){
        	i = TextExt(iFontId, pPrint->szLine);
        	if(i>iLongLine) iLongLine  = i;
			pPrint = pPrint->Next;
      }
      x1 = (640 - (iLongLine + 10))/2;
      x2 = x1 +  iLongLine + 10;
      if(x1<0){
      	x1 = 0;
      	x2 = 640;
      }
      y1 = 1;
      y2 = 179;
      sprintf(szDispStr, "%s", HelpID );


      pHelpWin = OpenWindow(WS_HP200, x1, y1, x2, y2, szDispStr, &rRect);

		k = 0;
		iNumberOfHelpLines = pHelpWin->Depth / iFontHeight;
		      
      pPrint = pTopLine;
		for(i = 0;i<iNumberOfHelpLines;i++)
		{
	   	if(pPrint)
   		{
   			TextOut(rRect.left + 3,rRect.top + iFontHeight * i,
   			  			TXT_RULE, iFontId, pPrint->szLine);
	   		pWindowBottomLine = pPrint;
   		}
   		else break;
   		pPrint = pPrint->Next;
   	}
	}
	
}

/* --------------------------------------------------------------------
   -------------------------------------------------------------------- */
main( int argc, char *argv[] )
{
   char *cp = "";
   int i = 0;
   int j,y,z;
   long where;
   static char hline[160];
   WORD wKeyInput;
   FILE *helpfp;
	char *szKeyLabels[10];
	int iResult;
   HelpLine *pTempTopLine;
	char szHelpTopic[60];
	int idx;
   if(!PalInit(1)) FatalExit("Init failed - CGAGRAPH not loaded ?", 1);

	
	szKeyLabels[0] = strdup("TOC");
	szKeyLabels[1] = strdup("Index");
	szKeyLabels[2] = strdup("<-Prev");
	szKeyLabels[3] = strdup("Next->");
	szKeyLabels[4] = strdup("Scroll\x18");
	szKeyLabels[5] = strdup("Scroll\x19");
	szKeyLabels[6] = strdup("PgUp \x18");
	szKeyLabels[7] = strdup("PgDwn \x19");
	szKeyLabels[8] = strdup("Goto");
	szKeyLabels[9] = strdup("Quit");

   ShowFKeys(szKeyLabels);

   iFontId = LoadFont("FPAB0015.hfn",0);

   iFontHeight = FontHeight(iFontId);
   
   if( argc < 2 )
   {
      printf( "\nusage: helptest infile HelpID" );
      exit( 1 );
   }

   LoadIndexTable( argv [1] );

   for( i = 0; i < HelpCount; i++ ){
   	
		if(!(HelpTable + i)) break;
   	z = strlen(( HelpTable + i )->hname);
   	y = strlen(cp);
          
   	realloc(cp,z+y+1);
          
		strcat(cp,(HelpTable + i)->hname);
		strcat(cp,"|");
   }

   cp[(strlen(cp) - 1)] = 0;
   free(CBIHC_HELP.List);
   CBIHC_HELP.List = strdup(cp);
	
	free(CBIHC_HELP.Ei.Contents);
	CBIHC_HELP.Ei.Contents = strdup(HelpTable->hname);
	   

   if( ( helpfp = OpenHelpFile( argv [1], "r+b" ) ) == NULL ){
      MsDelay(1000);
      printf( "Help file, %s does not exist\n", argv [1] );
   }
   else
   {
  		do{
			wKeyInput = 0xffff;
			if(KeyWaiting())wKeyInput = GetKey();
      	if(!(wKeyInput&0x00FF)){
      		wKeyInput = wKeyInput&0xFF00; 
      	}
			else{
				wKeyInput &= 0x00FF;
			}
      	switch (wKeyInput)
      	{
      		case F1_KEY :
      		{
					if(pHelpWin)CloseWin(pHelpWin);

					rLastRect = ResetRect();

					ReleaseHelpPointers(&pTopLine, &pBottomLine, &pTempLine,
											  &pWindowTopLine, &pWindowBottomLine);

					ReleaseTagPointers(&pFirstTag, &pLastTag, &pTempTag);

      			DisplayHelp("TOC");
					idx=0;
      		}
				break;
				      	
      		case F2_KEY :
      		{
					if(pHelpWin)CloseWin(pHelpWin);

					rLastRect = ResetRect();

					ReleaseHelpPointers(&pTopLine, &pBottomLine, &pTempLine,
											  &pWindowTopLine, &pWindowBottomLine);

					ReleaseTagPointers(&pFirstTag, &pLastTag, &pTempTag);

      			DisplayHelp("Index");
					idx = HelpCount - 1;
      		}
				break;

            case LEFT_KEY:
				case F3_KEY :
				{
					rLastRect = ResetRect();

				   if(idx > 0)
				   {
						if(pHelpWin)CloseWin(pHelpWin);

						ReleaseHelpPointers(&pTopLine, &pBottomLine, &pTempLine,
											  &pWindowTopLine, &pWindowBottomLine);

						ReleaseTagPointers(&pFirstTag, &pLastTag, &pTempTag);

						idx = (HelpTable + idx )->prevhlp;

						DisplayHelp((HelpTable + idx)->hname);
					}
				}
				break;

				case RIGHT_KEY :
				case F4_KEY :
				{
					rLastRect = ResetRect();

				   if(idx + 1 < HelpCount)
				   {
						if(pHelpWin)CloseWin(pHelpWin);

						ReleaseHelpPointers(&pTopLine, &pBottomLine, &pTempLine,
											  &pWindowTopLine, &pWindowBottomLine);

						ReleaseTagPointers(&pFirstTag, &pLastTag, &pTempTag);

						idx = (HelpTable + idx )->nexthlp;

						DisplayHelp((HelpTable + idx)->hname);
					}
				}
				break;
            
				case UP_KEY :
				case F5_KEY :
				{

		         RevBlock(rLastRect.left, rLastRect.top, rLastRect.right, rLastRect.bottom);
		         			
					rLastRect = ResetRect();

					pTempTag = NULL;
					if(pTopLine)
					{
						if(pWindowTopLine->Prev != NULL)
						{
					      Scroll(SCROLL_DOWN, iFontHeight, WHITE_COLOR, rRect.left + 1,
									 rRect.top + 1, rRect.right - 1, rRect.bottom - 1);	
							
							pWindowTopLine = pWindowTopLine->Prev;
							pWindowBottomLine = pWindowBottomLine->Prev;
			   			TextOut(rRect.left + 3,rRect.top,TXT_RULE, iFontId, pWindowTopLine->szLine);
						}
					}
				}
				break;

				case DOWN_KEY :
				case F6_KEY :
				{
		         RevBlock(rLastRect.left, rLastRect.top, rLastRect.right, rLastRect.bottom);
		         			
					rLastRect = ResetRect();

					pTempTag = NULL;

					if(pTopLine)
					{
						if(pWindowBottomLine->Next != NULL)
						{
					      Scroll(SCROLL_UP, iFontHeight, WHITE_COLOR, rRect.left + 1,
									 rRect.top + 1, rRect.right - 1,rRect.bottom - 1);	
									 
							pWindowTopLine = pWindowTopLine->Next;
							pWindowBottomLine = pWindowBottomLine->Next;
			   			
			   			TextOut(rRect.left + 3,rRect.top + iFontHeight*(iNumberOfHelpLines - 1),
   			  					  TXT_RULE, iFontId, pWindowBottomLine->szLine);
						}
					}
				}
				break;

				case PGUP_KEY :
				case F7_KEY :
				{
		         RevBlock(rLastRect.left, rLastRect.top, rLastRect.right, rLastRect.bottom);
		         			
					rLastRect = ResetRect();

					pTempTag = NULL;

					if(pTopLine)
					{
						i = 0;
						while((pWindowTopLine->Prev != NULL) && (i<(iNumberOfHelpLines - 1)))
						{
								pWindowTopLine = pWindowTopLine->Prev;
								pWindowBottomLine = pWindowBottomLine->Prev;
								i++;
						}
				      
				      Scroll(SCROLL_DOWN, i * iFontHeight,WHITE_COLOR, rRect.left + 1,
								 rRect.top + 1, rRect.right - 1,rRect.bottom - 1);	
								 
						pTempTopLine = pWindowTopLine;
						for(j = 0; j<i;j++)
						{
			   			TextOut(rRect.left + 3, rRect.top + j * iFontHeight,TXT_RULE, 
			   					  iFontId, pTempTopLine->szLine);
			   					  
							pTempTopLine = pTempTopLine->Next;
						}
					}
				}
				break;

				case PGDN_KEY :
				case F8_KEY :
				{
		         RevBlock(rLastRect.left, rLastRect.top, rLastRect.right, rLastRect.bottom);
		         			
					rLastRect = ResetRect();

					pTempTag = NULL;

					if(pTopLine)
					{

						i = 0;
						while((pWindowBottomLine->Next != NULL) && (i<(iNumberOfHelpLines - 1)))
						{
								pWindowTopLine = pWindowTopLine->Next;
								pWindowBottomLine = pWindowBottomLine->Next;
								i++;
						}
				      Scroll(SCROLL_UP, i * iFontHeight,WHITE_COLOR, rRect.left + 1,rRect.top + 1, 
				      		 rRect.right - 1,rRect.bottom - 1);	
				      		 
						pTempTopLine = pWindowBottomLine;
						for(j = 0; j<i;j++)
						{
			   			TextOut(rRect.left + 3,rRect.top + (iNumberOfHelpLines-j - 1) * iFontHeight,
   			  					  TXT_RULE, iFontId, pTempTopLine->szLine);
   			  					  
							pTempTopLine = pTempTopLine->Prev;
						}
					}
				}
				break;

				case F9_KEY :
				{
					if(pHelpWin)CloseWin(pHelpWin);

					rLastRect = ResetRect();

					ReleaseHelpPointers(&pTopLine, &pBottomLine, &pTempLine,
											  &pWindowTopLine, &pWindowBottomLine);

					ReleaseTagPointers(&pFirstTag, &pLastTag, &pTempTag);

					InitDialog(&HelpHandler);                      
           		ShowDialog(&HelpHandler, 100, 20, "Select Topic"); 
           		iResult = HandleDialog(&HelpHandler, 0);    
					if(iResult == IHC_HELPOK) GetDlgItem(&HelpHandler, IHC_HELP, EDGI_TXT, szHelpTopic);
				   CloseDialog(&HelpHandler);
					DisplayHelp(szHelpTopic);
					for(idx = 0;idx<HelpCount;idx++){
						if(strstr(szHelpTopic,(HelpTable + idx)->hname)) break;
					}
				}
				break;

				case '\t' :
				{
					int i = 0;
					
		         RevBlock(rLastRect.left, rLastRect.top, rLastRect.right, rLastRect.bottom);

					if(!pTempTag)
					{
						pTempTag = pFirstTag;
					}
					else
					{
						if(pTempTag->Next != NULL) pTempTag = pTempTag->Next;
					}

					FindTag();
/*	This is where the block is actually highlighted	*/

					pTempLine = pWindowTopLine;
					i = 0;
					while(pTempTag->iLineNumber != pTempLine->iLineNumber) 
					{
						if(pTempLine->Next != pWindowBottomLine->Next)
						{
							i++;
							pTempLine = pTempLine->Next;
							bTag = TRUE;
						}
						else
						{
							bTag = FALSE;
							break;
						}
					}
					if(bTag)
					{
						char szP[100];
						
						strcpy(szP,pTempLine->szLine);
						
						if((szHTP1 = strstr(szP, pTempTag->szTag)) != NULL)
						{
							*szHTP1 = 0;
						
							rThisRect.left  = rRect.left + TextExt( iFontId, szP) + 3;
							rThisRect.right = rThisRect.left + TextExt(iFontId, pTempTag->szTag);
							rThisRect.top = rRect.top + iFontHeight * i;
							rThisRect.bottom = rThisRect.top + iFontHeight;
															
				         RevBlock(rThisRect.left, rThisRect.top, rThisRect.right, rThisRect.bottom);

							rLastRect = rThisRect;
				      }
				   }
				}
				break;

				case STAB_KEY :
				{
					int i = 0;
					
					RevBlock(rLastRect.left, rLastRect.top, rLastRect.right, rLastRect.bottom);

					if(!pTempTag)
					{
						pTempTag = pLastTag;
					}
					else
					{
						if(pTempTag->Prev != NULL) pTempTag = pTempTag->Prev;
					}
//This will be the code to get to the proper portion of the screen 

					FindTag();

//This is where the block is actually highlighted

					pTempLine = pWindowBottomLine;
					while(pTempTag->iLineNumber != pTempLine->iLineNumber) 
					{
						if(pTempLine->Prev != pWindowTopLine->Prev)
						{
							i++;
							pTempLine = pTempLine->Prev;
							bTag = TRUE;
						}
						else
						{
							bTag = FALSE;
							break;
						}
					}
					if(bTag)
					{
						char szP[100];
						
						strcpy(szP,pTempLine->szLine);
						
						if((szHTP1 = strstr(szP, pTempTag->szTag)) != NULL)
						{
							*szHTP1 = 0;
						
							rThisRect.left  = rRect.left + TextExt( iFontId, szP) + 3;
							rThisRect.right = rThisRect.left + TextExt(iFontId, pTempTag->szTag);
							rThisRect.top = rRect.top + iFontHeight * (iNumberOfHelpLines - i - 1);
							rThisRect.bottom = rThisRect.top + iFontHeight;
															
				         RevBlock(rThisRect.left, rThisRect.top, rThisRect.right, rThisRect.bottom);

							rLastRect = rThisRect;
				      }
				   }
				}
				break;

				case ENTER_KEY :
				{
					if(pTempTag)
					{
						char szHelpTag[100];

						if(pHelpWin)CloseWin(pHelpWin);
						
						strcpy(szHelpTag,pTempTag->szTag);

						ReleaseHelpPointers(&pTopLine, &pBottomLine, &pTempLine,
											  &pWindowTopLine, &pWindowBottomLine);

						ReleaseTagPointers(&pFirstTag, &pLastTag, &pTempTag);

						rLastRect = ResetRect();
						
						DisplayHelp(szHelpTag);
						
						for(idx = 0;idx<HelpCount;idx++)
						{
							if(strstr(szHelpTag,(HelpTable + idx)->hname)) break;
						}
					}
				}
				break;	
			}
   	}
   	while(wKeyInput != F10_KEY);
      fclose( helpfp );
   }
   UnLoadIndexTable();
   PalDeInit(1);
   return 0;
}
