/* --------------------------------------------------------------------
   Project: PAL: Palmtop Application Library
   Module:  PALKEYS.H
   Author:  Gilles Kohl
   Started: 21. Jan. 95
   Subject: PAL key definitions
   -------------------------------------------------------------------- */

#ifndef _PALKEYS_H
#define _PALKEYS_H

/* --------------------------------------------------------------------
                       Some handy key constants
   -------------------------------------------------------------------- */

#define F1_KEY    0x3b00
#define F2_KEY    0x3c00
#define F3_KEY    0x3d00
#define F4_KEY    0x3e00
#define F5_KEY    0x3f00
#define F6_KEY    0x4000
#define F7_KEY    0x4100
#define F8_KEY    0x4200
#define F9_KEY    0x4300
#define F10_KEY   0x4400
#define F11_KEY   0x8500
#define F12_KEY   0x8600

#define SF1_KEY   0x5400
#define SF2_KEY   0x5500
#define SF3_KEY   0x5600
#define SF4_KEY   0x5700
#define SF5_KEY   0x5800
#define SF6_KEY   0x5900
#define SF7_KEY   0x5a00
#define SF8_KEY   0x5b00
#define SF9_KEY   0x5c00
#define SF10_KEY  0x5d00
#define SF11_KEY  0x8700
#define SF12_KEY  0x8800

#define AF1_KEY   0x6800
#define AF2_KEY   0x6900
#define AF3_KEY   0x6a00
#define AF4_KEY   0x6b00
#define AF5_KEY   0x6c00
#define AF6_KEY   0x6d00
#define AF7_KEY   0x6e00
#define AF8_KEY   0x6f00
#define AF9_KEY   0x7000
#define AF10_KEY  0x7100
#define AF11_KEY  0x8B00
#define AF12_KEY  0x8C00

#define CF1_KEY   0x5e00
#define CF2_KEY   0x5f00
#define CF3_KEY   0x6000
#define CF4_KEY   0x6100
#define CF5_KEY   0x6200
#define CF6_KEY   0x6300
#define CF7_KEY   0x6400
#define CF8_KEY   0x6500
#define CF9_KEY   0x6600
#define CF11_KEY  0x8900
#define CF12_KEY  0x8a00

#define ZOOM_KEY  0xd000
#define DEL_KEY   0x5300
#define UP_KEY    0x4800
#define DOWN_KEY  0x5000
#define LEFT_KEY  0x4b00
#define RIGHT_KEY 0x4d00
#define PGUP_KEY  0x4900
#define PGDN_KEY  0x5100
#define HOME_KEY  0x4700
#define END_KEY   0x4f00
#define INS_KEY   0x5200
#define CTL_LEFT  0x7300
#define CTL_RIGHT 0x7400
#define CTL_HOME  0x7700
#define CTL_END   0x7500
#define MENU_KEY  0xC800
#define STAB_KEY  0x0f00
#define ALT_KEY   0x3800

#define BACK_KEY    8
#define ENTER_KEY  13
#define SPACE_KEY  32
#define ESC_KEY    27

#endif
