/* --------------------------------------------------------------------
   Project: PAL: Palmtop Application Library
   Module:  palhelp.h
   Author:  Ron Crain
            Based on DFLAT help system by Al Stevens, published in
            Dr. Dobb's Journal, Nov, 1991 - Nov, 1992
   Started: 02/01/95 10:56 am
   Subject: Structures for PAL help.  Not all these structures are
            currently used.  I will clean it up later.

   -------------------------------------------------------------------- */
#ifndef _PALHELP_H
#define _PALHELP_H
#define WINSIZE
#define RELEASE
/* --------------------------------------------------------------------
                      constant definitions
   -------------------------------------------------------------------- */
#define HELP_EXT ".ph"      /* standard extension for PAL help files    */

/* --------------------------------------------------------------------
                           type definitions
   -------------------------------------------------------------------- */

typedef enum { FALSE, TRUE } BOOL;
typedef unsigned int BYTECOUNTER;

/* Huffman tree structure */
typedef struct htree    {
    BYTECOUNTER cnt;        /* character frequency         */
    int parent;             /* offset to parent node       */
    int right;              /* offset to right child node  */
    int left;               /* offset to left child node   */
};

/* Huffman tree structure in compressed file */
typedef struct htr    {
    int right;              /* offset to right child node  */
    int left;               /* offset to left child node   */
};

/* Help index table structure */
typedef struct helps
{
   char *hname;            /* Pointer to Help ID String */
   char *comment;          /* Pointer to Optional comment */
   long hptr;              /* Offset to starting byte in compressed help file */
   int bit;                /* Bit in starting byte where huffman tree starts */
#define WINSIZE
#ifdef WINSIZE             /* These values are optional */
   int hheight;            /* Length of Help ID in lines */
   int hwidth;             /* Length of longest line in a Help ID */
#endif
   int nexthlp;            /* Index number of next logical Help ID */
   int prevhlp;            /* Index number of previous logical Help ID */
   char *PrevName;         /* Pointer to name string of previous logical help ID */
   char *NextName;         /* Pointer to name string of next logical help ID */
#ifdef HELP_INDEX
   struct helps *NextHelp; /* Pointer to next help table. Only used when building indexes */
#endif
};

/* Structure to Hold a 'Tag', that is a hyper-link */
typedef struct szL
{				
	unsigned int iLineNumber;  /* The line number associated with the tag*/
	struct szL *Next;          /* Pointer to the Next Tag*/
	struct szL *Prev;          /* Pointer to the Previous Tag*/
	char *szTag;               /* The Actual String describing the Tag*/
}HelpTag;

/*	Structure to construct a linked link of the help lines*/
typedef struct szP
{                             
	unsigned int iLineNumber;  /* The Line Number */
	char *szLine;              /* The actual string associated with the line*/
	struct szP *Prev;          /* Pointer to the previouse HelpLine*/
	struct szP *Next;          /* Pointer to the Next HelpLine*/
}HelpLine;
	
/* Rectangle structure*/
typedef struct {
    int top;
    int left;
    int bottom;
    int right;
    int height;
    int width;
    int middlex;
    int middley;
} RECT;




/* --------------------------------------------------------------------
                             globals
   -------------------------------------------------------------------- */
extern struct htr *HelpTree;
extern struct helps *HelpTable;
extern int HelpCount;

/* --------------------------------------------------------------------
                           prototypes
   -------------------------------------------------------------------- */
void BuildFileName( char *fn, const char *fname, const char *ext );
FILE *OpenHelpFile(const char *fn, const char *md);
void *GetHelpLine(char *);
void HelpFilePosition(long *, int *);
void SeekHelpLine(long, int);
void buildtree(void);
#ifdef WINSIZE
int HelpLength( char *s );
#endif
void LoadIndexTable( char *fname );
void UnLoadIndexTable( void );
struct helps *FindHelp( char *HelpID );


#endif

