
/* --------------------------------------------------------------------
   Project: PALHELP: Help Compiler
   Module:  indxhelp.c
   Author:  Ron Crain
            Based on DFLAT help system by Al Stevens, published in
            Dr. Dobb's Journal, Nov, 1991 - Nov, 1992
   Started: 02/01/95 11:35 am
   Subject: Builds indexes for compressed help file
   -------------------------------------------------------------------- */
/* --------------------------------------------------------------------
                       standard includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef DEBUG
#define MARKER "^^^^^"
#endif

/* --------------------------------------------------------------------
                         local includes
   -------------------------------------------------------------------- */
#define HELP_INDEX
#include "palhelp.h"

/* --------------------------------------------------------------------
                        global variables
   -------------------------------------------------------------------- */
static FILE *helpfp;
static char hline[160];

static struct helps *FirstHelp;
static struct helps *LastHelp;
static struct helps *ThisHelp;

/* --------------------------------------------------------------------
                           functions
   -------------------------------------------------------------------- */
/* --------------------------------------------------------------------
   Writes text data to binary help file by first writing the length of
   the string and then the string itself. text is a pointer to an
   ASCIIZ string.
   -------------------------------------------------------------------- */
static void WriteText( char *text )
{
   char *np = text ? text : "";
   int len = strlen( np );

   fwrite( &len, sizeof ( int ), 1, helpfp );
   if( len )
      fwrite( np, len + 1, 1, helpfp );
}

/* --------------------------------------------------------------------
   Given a pointer to a Help ID string, this function searches the help
   index and returns the offset into the help database as an integer.
   -------------------------------------------------------------------- */
int FindOffset( char *HelpID )
{
   int hlpnum = 0;
   struct helps *thishelp = FirstHelp;

   while( thishelp != NULL )
   {
      if( strcmp( HelpID, thishelp->hname ) == FALSE )
         break;
      hlpnum++;
      thishelp = thishelp->NextHelp;
   }
   return thishelp ? hlpnum : -1;
}

/* --------------------------------------------------------------------
   Opens the compressed help file, reads and parses the tokens, and
   builds an index table of the contents. The index table is then
   appended to the help file.

   -- Modified to allow easy configuration for other help text source
      formats.
   -------------------------------------------------------------------- */
int HelpIndex( char *fname )
{
   char *cp;
   int HelpCount = 0;
   long where;

   if( ( helpfp = OpenHelpFile( fname, "r+b" ) ) == NULL )
      return -1;

   *hline = '\0';
   while( *hline != '<' )
   {
      if( GetHelpLine( hline ) == NULL )
      {
         fclose( helpfp );
         return -1;
      }
   }
   while( *hline == '<' )
   {
      if( strncmp( hline, "<end>", 5 ) == 0 )
         break;

/* ---- parse the help window's text name ---- */
      if( ( cp = strchr( hline, '>' ) ) != NULL )
      {
         ThisHelp = calloc( 1, sizeof ( struct helps ) );
         if( FirstHelp == NULL )
            FirstHelp = ThisHelp;
         *cp = '\0';
         ThisHelp->hname = malloc( strlen( hline + 1 ) + 1 );
         strcpy( ThisHelp->hname, hline + 1 );

         HelpFilePosition( &ThisHelp->hptr, &ThisHelp->bit );

         if( GetHelpLine( hline ) == NULL )
            break;


         while( *hline == '[' )                            /* build the help linked list entry */
         {
            HelpFilePosition( &ThisHelp->hptr, &ThisHelp->bit );
/* ---- parse a comment ---- */
            if( strncmp( hline, "[*]", 3 ) == 0 )
            {
               ThisHelp->comment = malloc( strlen( hline + 3 ) + 1 );
               strcpy( ThisHelp->comment, hline + 3 );
               if( GetHelpLine( hline ) == NULL )
                  break;
               continue;
            }
/* ---- parse the <<prev button pointer ---- */
            if( strncmp( hline, "[<<]", 4 ) == 0 )
            {
               char *cp = strchr( hline + 4, '<' );

               if( cp != NULL )
               {
                  char *cp1 = strchr( cp, '>' );

                  if( cp1 != NULL )
                  {
                     int len = (int) ( cp1 - cp );

                     ThisHelp->PrevName = calloc( 1, len );
                     strncpy( ThisHelp->PrevName, cp + 1, len - 1 );
                  }
               }
               if( GetHelpLine( hline ) == NULL )
                  break;
               continue;
            }
/* ---- parse the next>> button pointer ---- */
            else if( strncmp( hline, "[>>]", 4 ) == 0 )
            {
               char *cp = strchr( hline + 4, '<' );

               if( cp != NULL )
               {
                  char *cp1 = strchr( cp, '>' );

                  if( cp1 != NULL )
                  {
                     int len = (int) ( cp1 - cp );

                     ThisHelp->NextName = calloc( 1, len );
                     strncpy( ThisHelp->NextName, cp + 1, len - 1 );
                  }
               }
               if( GetHelpLine( hline ) == NULL )
                  break;
               continue;
            }
            else
               break;
         }
#ifdef WINSIZE
         ThisHelp->hheight = 0;
         ThisHelp->hwidth = 0;
#endif
         ThisHelp->NextHelp = NULL;

         if( LastHelp != NULL )                            /* append entry to the linked list */
            LastHelp->NextHelp = ThisHelp;
         LastHelp = ThisHelp;
         HelpCount++;
      }

      if( GetHelpLine( hline ) == NULL )                   /* move to the next <helpname> token */
         strcpy( hline, "<end>" );
      while( *hline != '<' )
      {
#ifdef WINSIZE
         ThisHelp->hwidth = max(ThisHelp->hwidth, HelpLength(hline));
         ThisHelp->hheight++;
#endif
         if( GetHelpLine( hline ) == NULL )
            strcpy( hline, "<end>" );
      }
   }

   fseek( helpfp, 0L, SEEK_END );                          /* append the help structures to the file */
#ifdef DEBUG
   WriteText( MARKER );
#endif
   where = ftell( helpfp );
   ThisHelp = FirstHelp;
   fwrite( &HelpCount, sizeof ( int ), 1, helpfp );
   while( ThisHelp != NULL )
   {
      ThisHelp->nexthlp = FindOffset( ThisHelp->NextName );
      ThisHelp->prevhlp = FindOffset( ThisHelp->PrevName );
      WriteText( ThisHelp->hname );
      WriteText( ThisHelp->comment );
#ifdef WINSIZE
      fwrite( &ThisHelp->hptr, sizeof ( long ) + sizeof ( int ) * 5, 1, helpfp );
#else
      fwrite( &ThisHelp->hptr, sizeof ( long ) + sizeof ( int ) * 3, 1, helpfp );
#endif
		WriteText(ThisHelp->PrevName);
		WriteText(ThisHelp->NextName);
      ThisHelp = ThisHelp->NextHelp;
   }
   fwrite( &where, sizeof ( long ), 1, helpfp );
   fclose( helpfp );
   return EXIT_SUCCESS;
}
