
/* --------------------------------------------------------------------
   Project: PALHELP
   Module:  htree.c Help File compiler
   Author:  Ron Crain
            Based on DFLAT help system by Al Stevens, published in
            Dr. Dobb's Journal, Nov, 1991 - Nov, 1992
   Started: 02/01/95 10:45 am
   Subject: Builds huffmann tree for palhelp.c
   -------------------------------------------------------------------- */
/* --------------------------------------------------------------------
                       standard includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* --------------------------------------------------------------------
                         local includes
   -------------------------------------------------------------------- */
#include "palhelp.h"

/* --------------------------------------------------------------------
                        global variables
   -------------------------------------------------------------------- */
struct htree *ht;
int root;
int treect;

/* --------------------------------------------------------------------
                           functions
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
   build a Huffman tree from a frequency array
   -------------------------------------------------------------------- */
void buildtree( void )
{
   int i;

   treect = 256;

   for( i = 0; i < treect; i++ )                           /* preset node pointers to -1 */
   {
      ht [i].parent = -1;
      ht [i].right = -1;
      ht [i].left = -1;
   }
   while( 1 )                                              /* build the huffman tree */
   {
      int h1 = -1, h2 = -1;

      for( i = 0; i < treect; i++ )                        /* find the two lowest frequencies */
      {
         if( i != h1 )
         {
            struct htree *htt = ht + i;

            if( htt->cnt > 0 && htt->parent == -1 )        /* find a node without a parent */
            {
               if( h1 == -1 || htt->cnt < ht [h1].cnt )    /* h1 & h2 -> lowest nodes */
               {
                  if( h2 == -1 || ht [h1].cnt < ht [h2].cnt )
                     h2 = h1;
                  h1 = i;
               }
               else if( h2 == -1 || htt->cnt < ht [h2].cnt )
                  h2 = i;
            }
         }
      }
      if( h2 == -1 )                                       /* if only h1 -> a node, that's the root */
      {
         root = h1;
         break;
      }
      ht [h1].parent = treect;                             /* combine two nodes and add one */
      ht [h2].parent = treect;
      ht = realloc( ht, ( treect + 1 ) * sizeof ( struct htree ) );
      if( ht == NULL )
         break;
      ht [treect].cnt = ht [h1].cnt + ht [h2].cnt;         /* the new node's frequency is the sum of the two nodes with
                                                           the lowest frequencies */
      ht [treect].right = h1;                              /* the new node points to the two that it combines */
      ht [treect].left = h2;
      ht [treect].parent = -1;                             /* the new node has no parent (yet) */
      treect++;
   }
}
