/* --------------------------------------------------------------------
   Module:     APPMGR.H
   Author:     GK (CIS:100114,3146)
   Started:    23.09.1993   04:24:10
   Modified:   23.09.1993   06:00:21
   Subject:    Format of APPMGR.H - thanks to Andy Gryc and Everett Kaser
   -------------------------------------------------------------------- */

#ifndef _APPMGR_H
#define _APPMGR_H

#define FLAG_ROMAPP     1  /* If flag is 0, app is a RAM app */
#define FLAG_SYSMGR     2  /* If flag is 0, app is an .EXE, .BAT, .COM to
                              be launched through the DOS box */
#define FLAG_MUSTWRITE  4  /* Set temporarily during APNAME.LST updating so
                              if writing entries to A: fail, we can mop up
                              by putting them into C: */
#define FLAG_WRITETOA   8  /* Set temporarily for APNAME.LST entries
                              going to drive A: */
#define FLAG_PERSISTENT 16 /* Set for the Filer only */
#define FLAG_WASINVALID 32 /* Set temporarily during check so we can
                              reliably determine if any apps have changed
                              from Invalid to valid or vice versa */

typedef struct {
  int IconNumber;     /* Number of internal Icon associated with app.  If 16
                         it is using a RAM Icon--the 'RAMIconNumber'th
                         icon from RamIconArray.
                         Note,GK: apparently changed to 0 on HP200LX
                       */
  int HotKey;         /* Scan code of hot key */
  int TCB;            /* Task Control Block Number (invalid on disk) */
  int Flags;          /* See flags below */
  int RAMIconNumber;  /* Number of associated RAM Icon */
  char Title[15];
  char Path[64];
  char Comments[25];
  char OldPos;        /* Invalid on disk */
} APPDEF;

/* Format of Icons are the same as returned by the int 5Fh graphics call
   G_ImageGet for a 44 width by 32 tall image.

   First 8 bytes of icon: 0x01 0x00 0x01 0x00 0x2c 0x00 0x20 0x00

   The next 192 bytes are the graphics image
   (6 bytes per scan line x 32 lines).  */

typedef struct {
   IMGHDR Hdr;
   BYTE Bmp[32][6];
} ICON;

typedef struct {
   int Mode;             /* 0 if in Icon mode,                 */
                         /* 1 if in List mode                  */
   int Count;            /* Current number of applications     */
   APPDEF App[38];  /* Array of 38 Application Structures */
   ICON   Icn[22];  /* Array of 20/22 Icons               */
} APPMGRDAT;

#endif

