unit LXGraph;

interface

uses Dos; { has Registers type }

const   { these are used for SetReplacementRule procedure }
  G_FORCE =0;  { force pixels according to pen }
  G_AND   =1;  { "logical and" with what's already there }
  G_OR    =2;
  G_XOR   =3;
  G_FORCETEXT =8; { same as force, but text background is cleared }

type
  BufferType    =array[0..16250] of byte;
  BufPtrType    =^BufferType;
var
  Buffer        :BufPtrType;

procedure GraphicsOn;
procedure LoResGraphicsOn;
procedure GraphicsOff;
procedure Pen(value:byte);     {0=Clear, 1=Set  }
procedure Line(b1,b2:byte);  {value is 16-bit pattern}
procedure Move(horiz,vert:integer);
procedure Draw(horiz,vert:integer); {according to current pen}
procedure HorizLine(x1,y1,x2:integer);
procedure VertLine(x1,y1,y2:integer);
procedure DrawRectangle(x1,y1,x2,y2:integer;fill:byte);
procedure SetFillMask(a0,a1,a2,a3:integer);
procedure SetReplacementRule(value:byte);
procedure DrawShadowBox(x1,y1,x2,y2:integer;clear:boolean);
procedure DrawTitleBox(x1,y1,x2,y2:integer;title:String;clear:boolean);
procedure DrawDot(x,y:integer);    {according to current pen}
procedure WriteText(x,y:integer; txt:String; rotate:byte);
procedure SetFont(w,h:byte);
procedure StoreArea(x1,y1,x2,y2:integer);  { to Buffer }
procedure PlaceArea(x,y:integer);  { from Buffer }

implementation

var
  Regs  :Registers;

procedure GraphicsOn;
  { turns on 640x200 graphics and clears screen }
  begin
  Regs.AX:=$0006;
  Intr($5f,Regs);
  end;
procedure LoResGraphicsOn;
  { turns on hp95 compatible graphics }
  begin
  Regs.AX:=$0020;
  Intr($5f,Regs);
  end;
procedure GraphicsOff;
  begin
  Regs.AX:=$0003;
  Intr($5f,Regs);
  end;
procedure Pen(value:byte);
  { subsequent drawing will be done with: }
  { value=0 -> clear     value=1 -> dark }
  begin
  Regs.AX:=$0900+value;
  Intr($5f,Regs);
  end;
procedure Line(b1,b2:byte);
  { lines & rectangles will be done with value=16-bit pattern }
  begin
  Regs.AH:=$0b;
  Regs.CH:=b1;
  Regs.CL:=b2;
  Intr($5f,Regs);
  end;
procedure Move(horiz,vert:integer);
  { moves pen without drawing anything }
  begin
  Regs.AH:=$08;
  Regs.CX:=horiz;
  Regs.DX:=vert;
  Intr($5f,Regs);
  end;
procedure Draw(horiz,vert:integer);
  { draws from old pen position to (horiz,vert), using }
  { pen and line types previously set. }
  begin
  Regs.AH:=$06;
  Regs.CX:=horiz;
  Regs.DX:=vert;
  Intr($5f,Regs);
  end;
procedure HorizLine(x1,y1,x2:integer);
  begin
  Move(x1,y1); Draw(x2,y1);
  end;
procedure VertLine(x1,y1,y2:integer);
  begin
  Move(x1,y1); Draw(x1,y2);
  end;
procedure DrawRectangle(x1,y1,x2,y2:integer;fill:byte);
  { fill: 0=outline, 1=pen fill, 2=pattern fill }
  begin
  Move(x1,y1);
  Regs.AX:=$0500+fill;
  Regs.CX:=x2;
  Regs.DX:=y2;
  Intr($5f,Regs);
  end;
procedure SetFillMask(a0,a1,a2,a3:integer);
  { sets fill type for rectangles; a0,a1,a2,a3 are bit patterns }
  begin
  Regs.AH:=$01;
  Regs.ES:=Seg(a3);
  Regs.DI:=Ofs(a3);
  Intr($5f,Regs);
  end;
procedure SetReplacementRule(value:byte);
  { value: G_FORCE, G_AND, G_NOT, G_OR, G_XOR, G_FORCETEXT }
  begin
  Regs.AH:=$0A;
  Regs.AL:=value;
  Intr($5f,Regs);
  end;
procedure DrawShadowBox(x1,y1,x2,y2:integer;clear:boolean);
  { draws a box with a shadow behind it; clear says
    whether to clear first. }
  begin
  SetReplacementRule(G_FORCETEXT);
  if clear then
    begin
    Pen(0); DrawRectangle(x1-1,y1-1,x2+1,y2+1,1);
    end;
  Pen(1);  DrawRectangle(x1,y1,x2,y2,0);
  DrawRectangle(x1+1,y1+1,x2-1,y2-1,0);
  SetFillMask($55aa,$55aa,$55aa,$55aa);
  DrawRectangle(x1+8,y2+1,x2+8,y2+4,2);
  DrawRectangle(x2+1,y1+4,x2+8,y2,2);
  end;
procedure DrawTitleBox(x1,y1,x2,y2:integer;title:String;clear:boolean);
  { draws a shadow box, with a title bar on top. }
  begin
  DrawShadowBox(x1,y1,x2,y2,clear);
  DrawRectangle(x1,y1,x2,y1+12,1);
  Pen(0); SetFont(10,11); SetReplacementRule(G_FORCE);
  WriteText((x1+x2-Length(title)*10) div 2,y1+2,title,0);
  Pen(1); SetReplacementRule(G_FORCETEXT);
  end;
procedure DrawDot(x,y:integer);
  begin
  Regs.AH:=$07;
  Regs.CX:=x;
  Regs.DX:=y;
  Intr($5f,Regs);
  end;
procedure WriteText(x,y:integer; txt:String; rotate:byte);
  begin  { rotate: 0=none, other=90 deg. }
  txt:=txt + Chr(0);
  Regs.AX:=$0f00+rotate;
  Regs.CX:=x;
  Regs.DX:=y;
  Regs.ES:=Seg(txt[1]);
  Regs.DI:=Ofs(txt[1]);
  Intr($5f,Regs);
  end;
procedure SetFont(w,h:byte);
  { sets the font to one that is w pixels wide and h tall }
  { valid choices are 8x8, 10x11, and 16x12 }
  begin
  Regs.AH:=$10;
  Regs.CH:=w;
  Regs.CL:=h;
  Intr($5f,Regs);
  Regs.ES:=Regs.DX;
  Regs.DI:=Regs.AX;
  Regs.AH:=$11;
  Intr($5f,Regs);
  end;
procedure StoreArea(x1,y1,x2,y2:integer);  { to Buffer }
  { Buffer variable must already be set to the address of a
    memory area large enough to hold the image. Example:
       Buffer := @Spade; }
  begin
  if Buffer=nil then
    begin
    GraphicsOff;
    writeln('Attempt to write data to nil pointer area. Program halted.');
    Halt;
    end;
  Regs.AH:=$0d;
  Regs.CX:=x1;
  Regs.DX:=y1;
  Regs.SI:=x2;
  Regs.BP:=y2;
  Regs.ES:=Seg(Buffer^);
  Regs.DI:=Ofs(Buffer^);
  Intr($5f,Regs);
  end;
procedure PlaceArea(x,y:integer);  { from Buffer }
  { places image data contained at Buffer address to an area whose
    top left corner is (x,y) }
  begin
  Regs.AX:=$0e00;
  Regs.CX:=x;
  Regs.DX:=y;
  Regs.ES:=Seg(Buffer^);
  Regs.DI:=Ofs(Buffer^);
  Intr($5f,Regs);
  end;

begin
Buffer:=nil;
end.