unit KeyLabels;

interface

procedure SetLabel(n:integer;s:String);
procedure ClearLabel(n:integer);

implementation

uses LXGraph;

var
  x :array[1..10] of integer;

const
  t =190; w =57;

procedure SetLabel(n:integer;s:String);
  begin
  SetReplacementRule(G_FORCE); Pen(1);
  DrawRectangle(x[n],t,x[n]+w,199,1);
  if Length(s)=0 then Exit;
  Pen(0); SetFont(8,8);
  WriteText(x[n]+(w-Length(s)*8) div 2 +1,t+1,s,0);
  end;

procedure ClearLabel(n:integer);
  begin
  SetReplacementRule(G_FORCE); Pen(0);
  DrawRectangle(x[n],t,x[n]+w,199,1);
  end;

begin
x[1]:=29; x[2]:=89; x[3]:=149; x[4]:=209;
x[5]:=275; x[6]:=335; x[7]:=395; x[8]:=455;
x[9]:=522; x[10]:=582;
end.
