unit dice;

interface

type
  box =record
    l,t,r,b :integer;
  end;

var
  DotSize,DotSpacing,
  Dicey,w :integer;
  Dicex   :array[1..6] of integer;

procedure DrawDie(i,n:integer);
procedure DrawOutlines;

implementation

uses LXGraph,crt;

var
  i,j,k   :integer;
  Side    :array[0..6,0..120] of byte;

const
  { this is an example of what a bitmap image looks like. }
  Dot  :array[0..14] of byte = (1,0,1,0,7,0,7,0,56,124,254,254,230,124,56);

procedure DrawOutlines;
  var i:integer;
  begin
  Pen(1);
  for i:=1 to 5 do
    begin
    DrawRectangle(Dicex[i],Dicey,Dicex[i]+w,Dicey+w,0);
    HorizLine(Dicex[i],Dicey-1,Dicex[i]+w); VertLine(Dicex[i]+w+1,Dicey,Dicey+w);
    HorizLine(Dicex[i],Dicey+w+1,Dicex[i]+w); VertLine(Dicex[i]-1,Dicey,Dicey+w);
    VertLine(Dicex[i]+w+2,Dicey+1,Dicey+w+1); HorizLine(Dicex[i]+1,Dicey+w+2,Dicex[i]+w+1);
    end;
  end;

procedure DrawDie(i,n:integer);
  begin
  if (n<1) or (n>6) then Exit;
  SetReplacementRule(G_FORCE);
  { have we drawn one of this number yet? }
  if Side[n,0]=1 then
    begin
    { plaster it from memory }
    Buffer:=@Side[n,0];
    PlaceArea(Dicex[i]+2,Dicey+2);
    end
  else
    begin
    { draw each dot, then store to memory. }
    Pen(0); DrawRectangle(Dicex[i]+2,Dicey+2,Dicex[i]+w-2,Dicey+w-2,1); Pen(1);
    Buffer:=@Dot;
    if n in [2..6] then PlaceArea(Dicex[i]+3,Dicey+3);
    if n in [6] then PlaceArea(Dicex[i]+3,Dicey+3+(DotSize+DotSpacing));
    if n in [4..6] then PlaceArea(Dicex[i]+3+2*(DotSize+DotSpacing),Dicey+3);
    if n in [1,3,5] then PlaceArea(Dicex[i]+3+(DotSize+DotSpacing),Dicey+3+(DotSize+DotSpacing));
    if n in [4..6] then PlaceArea(Dicex[i]+3,Dicey+3+2*(DotSize+DotSpacing));
    if n in [6] then PlaceArea(Dicex[i]+3+2*(DotSize+DotSpacing),Dicey+3+(DotSize+DotSpacing));
    if n in [2..6] then PlaceArea(Dicex[i]+3+2*(DotSize+DotSpacing),Dicey+3+2*(DotSize+DotSpacing));
    Buffer:=@Side[n,0];
    StoreArea(Dicex[i]+2,Dicey+2,Dicex[i]+w-2,Dicey+w-2);
    end;
  end;

begin
FillChar(Side,SizeOf(Side),0);
DotSize:=7;
DotSpacing:=2;
w:=3*DotSize + 2*DotSpacing + 5;
Dicey:=167; Dicex[1]:=107; Dicex[2]:=168;
Dicex[3]:=228; Dicex[4]:=291; Dicex[5]:=350;

end.