program LXDemo;

{ This is a simple demo program to show how to use the graphics
  routines for the HP LX computers }

uses Dos, Crt, { Pascal's units }
     LXGraph,  { basic drawing routines }
     cards,    { routines to draw cards }
     dice,     { routines to draw dice }
     keylabels; { routines to draw softkey labels }

var
  CardArray   :array[1..5] of CardType;
  ch          :char;
  storage     :array[1..1000] of byte;

begin
{ ----- in case someone runs this on a PC, tell him how to get out }
writeln('This demo program works only on the HP 100LX and 200LX');
writeln('palmtop computers. Hit Enter nine times to exit.');

GraphicsOn;

{ ----- show some simple calls }
Pen(1);                               { make pixels dark }
SetReplacementRule(G_FORCE);          { pixels will be forced, not xor'd }
DrawRectangle(1,1,30,30,0);           { last zero means outline only }
DrawRectangle(35,1,65,30,1);          { last one means fill with pen color }
SetFillMask($55aa,$55aa,$55aa,$55aa); { half-filled pattern }
DrawRectangle(70,1,100,30,2);         { last two means fill with mask }
SetReplacementRule(G_XOR);            { toggle pixels }
DrawRectangle(50,20,80,37,1);         { draw across others }
HorizLine(1,35,110);                  { draw line }
ch:=ReadKey; if ch=#0 then ch:=ReadKey;

{ ----- show text calls }
SetReplacementRule(G_FORCE);
SetFont(10,11);                       { sets font size: 8x8, 10x11, 12x16 }
WriteText(4,40,'This is text.',0);    { last zero means don't rotate 90 deg }
DrawRectangle(0,55,80,85,1);
SetFont(8,8);
WriteText(4,58,'This text is drawn with G_FORCE.',0);
SetReplacementRule(G_FORCETEXT);
WriteText(4,70,'This text is drawn with G_FORCETEXT.',0);
ch:=ReadKey; if ch=#0 then ch:=ReadKey;

{ ----- show use of StoreArea and PlaceArea }
Buffer:=@storage;  { storage MUST be large enough to hold image! 1 pixel = 1 bit }
StoreArea(50,10,85,35);                 { copy area x1,y1,x2,y2 to Buffer }
PlaceArea(50,90);                       { place that image somewhere else }
ch:=ReadKey; if ch=#0 then ch:=ReadKey;

{ ----- show softkey labels }
SetLabel(9,'Curtis');                   { softkey label 9 says Curtis. }
SetLabel(10,'Cameron');
ch:=ReadKey; if ch=#0 then ch:=ReadKey;
ClearLabel(10);
ch:=ReadKey; if ch=#0 then ch:=ReadKey;

{ ----- show use of dice }
DrawOutlines;  { draws outlines of five dice at bottom of screen. }
DrawDie(1,3);  { puts the number three in the first one. }
DrawDie(2,4);
DrawDie(3,5);
DrawDie(4,5);
DrawDie(5,6);
ch:=ReadKey; if ch=#0 then ch:=ReadKey;

{ ----- show use of title box }
DrawTitleBox(250,30,630,150,'Title Box',false);
ch:=ReadKey; if ch=#0 then ch:=ReadKey;

{ ----- show use of cards calls }
Randomize;
Shuffle;
Shuffle;
CardArray[1]:=GetNewCard^;
CardArray[2]:=GetNewCard^;
CardArray[3]:=GetNewCard^;
CardArray[4]:=GetNewCard^;
CardArray[5]:=GetNewCard^;
DisplayCard(@CardArray[1],260,50,false);  { put it in the title box }
DisplayCard(@CardArray[2],320,50,false);
DisplayCard(@CardArray[3],380,50,false);
DisplayCard(@CardArray[4],440,50,false);
DisplayCard(@CardArray[5],500,50,true);   { true means only draw top part. }
DisplayBack(560,50);
ch:=ReadKey; if ch=#0 then ch:=ReadKey;
end.