unit cards;

interface

uses crt;

type
  CardType      =record
    card,suit  :byte;
    end;
  CardPtrType   =^CardType;

const  { card dimensions }
  w=48; h=55;

var
  Screen  :array[0..2000] of byte;

procedure DrawLine(x1,y1,x2,y2:integer);
procedure Shuffle;
function GetNewCard:CardPtrType;
procedure DisplayCard(C:CardPtrType;x,y:integer; TopOnly:boolean);
procedure DisplayBack(x,y:integer);

implementation

uses LXGraph;

var
  Deck  :array[1..52] of CardType;
  P     :array[1..13,0..19] of byte;
  i,j,CardPtr,index :integer;

const
  Spade  :array[0..15] of byte=(1,0,1,0,8,0,8,0,16,56,124,254,254,108,16,56);
  Diamond:array[0..15] of byte=(1,0,1,0,8,0,8,0,16,40,68,130,130,68,40,16);
  Club   :array[0..15] of byte=(1,0,1,0,8,0,8,0,16,56,56,108,254,108,16,56);
  Heart  :array[0..15] of byte=(1,0,1,0,8,0,8,0,108,146,130,130,130,68,40,16);
  Jack  :array[0..112] of byte=(1,0,1,0,24,0,35,0,255,255,248,135,130,8,130,60,8,129,228,8,
    129,44,8,129,66,72,130,78,200,130,228,200,132,156,104,153,2,232,240,1,184,
    152,32,232,140,113,168,158,35,24,155,6,200,141,252,200,140,81,136,140,249,
    136,140,81,136,153,253,136,155,6,200,198,35,200,172,113,136,184,32,200,
    236,0,120,186,4,200,177,201,8,153,58,8,155,146,8,146,20,8,129,164,8,129,
    60,8,129,226,8,130,15,8,255,255,248);
  Queen :array[0..112] of byte=(1,0,1,0,24,0,35,0,255,255,248,130,21,8,130,169,8,129,14,8,
    129,74,8,145,107,8,168,154,136,146,106,8,156,5,136,178,74,104,241,82,24,
    145,36,72,180,164,8,240,132,136,146,72,24,144,73,24,176,48,40,162,114,40,
    160,80,104,196,144,72,192,138,72,136,136,120,129,37,104,145,36,72,194,82,
    120,178,146,104,141,1,200,130,178,72,138,200,168,134,180,72,130,148,8,131,
    132,8,132,170,8,132,66,8,255,255,248);
  King  :array[0..112] of byte=(1,0,1,0,24,0,35,0,255,255,248,133,37,8,130,170,8,129,252,8,
    129,68,104,129,84,104,130,72,104,130,152,104,133,72,104,137,87,104,148,18,
    232,242,10,120,137,0,248,132,148,88,130,84,104,225,36,120,158,144,8,128,72,
    8,128,39,200,241,18,56,177,73,8,209,68,136,248,2,72,242,129,56,186,64,200,
    183,84,136,176,149,8,176,202,8,176,146,8,177,84,8,177,20,8,129,252,8,130,
    170,8,133,37,8,255,255,248);
  Back  :array[0..301] of byte=(1,0,1,0,42,0,49,0,
    170,170,170,170,170,160,85,85,85,85,85,80,170,170,170,170,170,160,85,85,85,85,85,80,
    170,170,170,170,170,160,85,85,85,85,85,80,170,170,170,170,170,160,85,85,85,85,85,80,
    170,170,170,170,170,160,85,85,85,85,85,80,170,170,170,170,170,160,85,85,85,85,85,80,
    170,171,254,170,170,160,85,87,2,85,85,80,170,174,43,42,170,160,85,92,85,21,85,80,
    170,168,170,170,170,160,85,93,85,85,85,80,170,168,170,170,170,160,85,93,95,245,85,80,
    170,168,184,18,170,160,85,93,113,89,85,80,170,168,226,168,170,160,85,93,69,85,85,80,
    170,168,234,170,170,160,85,93,69,85,85,80,170,172,235,170,170,160,85,86,71,21,85,80,
    170,171,254,42,170,160,85,85,64,85,85,80,170,170,234,170,170,160,85,85,69,85,85,80,
    170,170,234,170,170,160,85,85,101,93,85,80,170,170,178,184,170,160,85,85,95,241,85,80,
    170,170,168,2,170,160,85,85,85,85,85,80,170,170,170,170,170,160,85,85,85,85,85,80,
    170,170,170,170,170,160,85,85,85,85,85,80,170,170,170,170,170,160,85,85,85,85,85,80,
    170,170,170,170,170,160,85,85,85,85,85,80,170,170,170,170,170,160,85,85,85,85,85,80,
    170,170,170,170,170,160);
procedure DrawLine(x1,y1,x2,y2:integer);
  begin
  Move(x1,y1);
  Draw(x2,y2);
  end;
function CStr(n:integer):String;
  var  s:String;
  begin
  if (n>=0) and (n<250) then
    begin
    Str(n,s);
    CStr:=s;
    end
  else CStr:='';
  end;
procedure Shuffle;
  var
    i,a,b:integer;
    t:CardType;
  begin
  CardPtr:=0;
  for i:=1 to 200 do  { swap pairs of cards. }
    begin
    a:=Trunc(Random*52)+1;
    b:=Trunc(Random*52)+1;
    t:=Deck[a]; Deck[a]:=Deck[b]; Deck[b]:=t;
    end;
  CardPtr:=0;
  end;
function GetNewCard:CardPtrType;
  begin
  if CardPtr>=52 then Shuffle;
  CardPtr:=CardPtr+1;
  GetNewCard:=@Deck[CardPtr];
  end;
procedure DisplayCard(C:CardPtrType;x,y:integer; TopOnly:boolean);
  begin
  SetReplacementRule(G_FORCE);
  Pen(0);
  if TopOnly then DrawRectangle(x,y,x+w,y+13,1) else DrawRectangle(x,y,x+w,y+h,1);
  Pen(1);
  with C^ do
    begin
    HorizLine(x+1,y,x+w-1);
    if TopOnly then
      begin
      VertLine(x,y+1,y+h-1);
      VertLine(x+w,y+1,y+h-1); VertLine(x+w-1,y+1,y+h-1);
      end
    else
      begin
      VertLine(x+w,y+1,y+h-1); HorizLine(x+1,y+h,x+w-1);
      VertLine(x,y+1,y+h-1); VertLine(x+w-1,y+1,y+h-1);
      HorizLine(x+1,y+h-1,x+w-1);
      end;
    SetFont(10,11);
    case card of
      2..9 :WriteText(x+1,y+2,CStr(card),0);
      10   :begin WriteText(x+1,y+2,'1',0); WriteText(x+7,y+2,'0',0); end;
      1    :WriteText(x+1,y+2,'A',0);
      11   :WriteText(x+1,y+2,'J',0);
      12   :WriteText(x+1,y+2,'Q',0);
      13   :WriteText(x+1,y+2,'K',0);
      end;
    Pen(1);
    case suit of
      0 :Buffer:=@Spade;
      1 :Buffer:=@Diamond;
      2 :Buffer:=@Club;
      3 :Buffer:=@Heart;
      end;
    PlaceArea(x+21,y+2);
    if TopOnly then Exit;
    case card of
      1..10 : for index:=0 to (card-1) do
                PlaceArea(x+P[card,index*2]+ (w-40) div 2,y+P[card,index*2+1]+3);
      11: begin
          Buffer:=@Jack;
          PlaceArea(x+ (w-20) div 2,y+ (h-37) div 2 +3);
          end;
      12: begin
          Buffer:=@Queen;
          PlaceArea(x+ (w-20) div 2,y+ (h-37) div 2 +3);
          end;
      13: begin
          Buffer:=@King;
          PlaceArea(x+ (w-20) div 2,y+ (h-37) div 2 +3);
          end;
      end;
    end;
  end;

procedure DisplayBack(x,y:integer);
  begin
  DrawLine(x+1,y,x+w-1,y);
  DrawLine(x+w,y+1,x+w,y+h-1);
  DrawLine(x+1,y+h,x+w-1,y+h);
  DrawLine(x,y+1,x,y+h-1);
  DrawLine(x+w-1,y+1,x+w-1,y+h-1);
  DrawLine(x+1,y+h-1,x+w-1,y+h-1);
  Buffer:=@Back; PlaceArea(x+3,y+3);
  end;

begin
{ these are coordinates of suit images placed on cards <=10 }
P[1,0]:=17; P[1,1]:=25;
P[2,0]:=17; P[2,1]:=12; P[2,2]:=17; P[2,3]:=39;
P[3]:=P[2]; P[3,4]:=17; P[3,5]:=25;
P[4,0]:=9; P[4,1]:=12; P[4,2]:=25; P[4,3]:=12; P[4,4]:=9; P[4,5]:=39;
  P[4,6]:=25; P[4,7]:=39;
P[5]:=P[4]; P[5,8]:=17; P[5,9]:=25;
P[6,0]:=9; P[6,1]:=12; P[6,2]:=25; P[6,3]:=12; P[6,4]:=9; P[6,5]:=25;
  P[6,6]:=25; P[6,7]:=25; P[6,8]:=9; P[6,9]:=38; P[6,10]:=25; P[6,11]:=38;
P[7,0]:=9; P[7,1]:=12; P[7,2]:=25; P[7,3]:=12; P[7,4]:=17; P[7,5]:=19;
  P[7,6]:=9; P[7,7]:=25; P[7,8]:=25; P[7,9]:=25; P[7,10]:=9; P[7,11]:=38;
    P[7,12]:=25;P[7,13]:=38;
P[8,0]:=9; P[8,1]:=12; P[8,2]:=25; P[8,3]:=12; P[8,4]:=9; P[8,5]:=21;
  P[8,6]:=25; P[8,7]:=21; P[8,8]:=9; P[8,9]:=30; P[8,10]:=25; P[8,11]:=30;
    P[8,12]:=9;P[8,13]:=39; P[8,14]:=25; P[8,15]:=39;
P[9]:=P[8]; P[9,16]:=17; P[9,17]:=16;
P[10]:=P[9]; P[10,18]:=17; P[10,19]:=34;

CardPtr:=1;
for j:=0 to 3 do for i:=1 to 13 do
  begin
  Deck[CardPtr].card:=i;
  Deck[CardPtr].suit:=j;
  CardPtr:=CardPtr+1;
  end;
end.