/******************************
* HP100LX WINDOWS ENVIRONMENT *
*       Sept. 6, vr. 2.1      *
*  header file for: HPCLIB.C  *
*      by: Harry Konstas      *
******************************/


/* Constant declaration */

#define BLACK_COLOR 1
#define WHITE_COLOR 0

#define AN_LEFT 0x20
#define AN_RIGHT 0x60

#define SMALL_FONT 0x0808
#define MEDIUM_FONT 0x0a0b
#define LARGE_FONT 0x100c

#define FORCE_RULE 0
#define AND_RULE 1
#define OR_RULE 2
#define XOR_RULE 3
#define INVFOR_RULE 4
#define INVAND_RULE 5
#define INVOR_RULE 6
#define INVXOR_RULE 7
#define TXT_RULE 8

#define OUTLINE_FILL 0
#define SOLID_FILL 1
#define PATTERN_FILL 2

/* Macro declarations */

#define TOPMESSAGE char topmes[]
#define MENUBARMSG char mbarmes[]
#define MENUITEMS  char *menitm[8][10]
#define KEYLABELS  char botmes[]


/* FUNCTION DECLARATIONS */


/*****************
* Misc functions *
*****************/

void is100(void);
void announ(int position);
void toplin(char far *string);
void botlin(char far *labels);
void terminate(void);


/*******************************
* Low level graphics functions *
*******************************/

void setgra(void);
void setmda(void);
void setfon(int size);
void setpos(int horiz,int vert);
void setcol(int color);
void setrul(int rule);
void setlin(unsigned int line_type);
void setmsk(char far *fill_mask);
void putimg(int horiz,int vert,int rule,char far *buffer);
void getimg(int from_horiz,int from_vert,int to_horiz,int to_vert,char far *buffer);
void wrtext(int horiz,int vert,char far *string);


/********************************
* High level graphics functions *
********************************/

void line(int from_horiz,int from_vert,int to_horiz,int to_vert);
void rectan(int from_horiz,int from_vert,int to_horiz,int to_vert,int fill);
void revblk(int from_horiz,int from_vert,int to_horiz,int to_vert);


/*******************
* Window functions *
*******************/

void errwin(char far *message);
void open_win(int winid,int from_horiz,int from_vert,int to_horiz,int to_vert,char far *message);
void close_win(int winid);
void window(int from_horiz,int from_vert,int to_horiz,int to_vert,char far *message);


/*****************
* Menu functions *
*****************/

void open_mbar(void);
void close_mbar(void);
void sel_menu(int menuid);
int  open_menu(int menuid);
void close_menu();
void sel_opt(int optnum);
int navigate(int menum);

