                 /***************************
                 * HP100LX INTERACTIVE DEMO *
                 * for demonstrating the    *
                 *    HPCLIB C Library      *
                 *    September 3, 1994     *
                 *    by: Harry Konstas     *
                 ***************************/

#include "hpclib.h"     /* HPCLIB header file */

TOPMESSAGE =" HP100LX Interactive Demo Vr.2.1 by Harry Konstas freeware (9/1994).";

MENUBARMSG ="Menu1  Menu2  Menu3  Quit  Help "; /* You can add up to 8 menus */

MENUITEMS ={

/************************************
* You can change the keywords below *
* and HPCLIB will adjust the size   *
* and position of the menus         *
* accordingly. You can also add more*
* menus (up to 8) and more options  *
* for each menu (up to 10).         *
************************************/

/* menu1 */ {"Option.... 1","Option.... 2","Option.... 3",
             "Option.... 4","Option.... 5"},
/* menu2 */ {"Level  1","Level  2","Level  3"},
/* menu3 */ {"Select 1","Select 2"},
/* menu4 */ {""},      /* This menu has no option */
/* menu5 */ {"Help   F1","About"} };

KEYLABELS={    /* You can have define and display multiple key labels */

" Help   Key2    Key3   Key4   "
" Key5   key6    key7   Quit   "
" key9   key0  "};

char keylab2[]={   /* Here's another bottom line key label definition */

"                              "
"                              "
"Cancel   OK                   "};

#include "hpwenv.c"  /* to be removed if stand-alone library is created */


/***************
* MAIN PROGRAM *
***************/

int menu_stat;                    /* menu status global variable */

main()
{
    initialize();                 /* set graphics mode, etc.. */

    do
    {

    menuproc();                   /* process menus if activated      */
    if(menu_stat==0) funcproc();  /* process functions outside menus */

    }while(1);
}


/***************************************
*  menuproc(): AUTOMATIC MENU PROCESS  *
*                                      *
* Here's how the menu/option code is   *
* returned by the navigate() function: *
*                                      *
* ex: case 0x24:                       *
*            ||                        *
* menu#2_____||_______option#4 in menu *
*                                      *
* if the code returned is 0x00, the    *
* menu is not active (closed). If the  *
* code returned is 0xff, the menu is   *
* in the middle of process. Any other  *
* code has the menu & option number.   *
* Here's an example:                   *
***************************************/

menuproc(void)
{

    menu_stat=navigate(5);   /* process 5 menus (set to #of menus available) */

    switch(menu_stat)
    {

    case 0x11: demo("Menu 1, option 1");
               break;

    case 0x12: demo("Menu 1, option 2");
               break;

    case 0x13: demo("Menu 1, option 3");
               break;

    case 0x14: demo("Menu 1, option 4");
               break;

    case 0x15: demo("Menu 1, option 5");
               break;

    case 0x21: demo("Menu 2, level 1");
               break;

    case 0x22: demo("Menu 2, level 2");
               break;

    case 0x31: demo("Menu 3, select 1");
               break;

    case 0x32: demo("Menu 3, select 2");
               break;

    case 0x41: terminate(); /* Quit menu */
               break;

    case 0x51: help();  /* Menu 5, help */
               break;

    case 0x52: about(); /* Menu 5, about */
               break;
    }
}


/******************************
*      FUNCTION PROCESS       *
* Here goes code when the     *
* Menu is not active (closed) *
******************************/

funcproc(void)
{
  int f;


    if(kbhit()!=0)                 /* any key pressed? */
    {
        f=getch();                 /* get the key      */

        if(f==0x3b) help();        /* F1 pressed? */
        if(f==0x42) terminate();   /* F8 pressed? */

    }
}


/**************
* DEMO WINDOW *
**************/

demo(char *message)

{
    open_win(1,150,50,450,150,"You selected:");
    wrtext(220,90,message);
    wrtext(180,120,"Press any key to clear it.");
    while(!kbhit());
    close_win(1);
}


/**************
* HELP SCREEN *
**************/

help(void)

{
    open_win(1,40,20,600,180,"On-Line Help.");
    setfon(MEDIUM_FONT);
    wrtext(200,80,"This is the Help window.");
    wrtext(200,110,"Notice the change in the key labels");
    botlin(keylab2); /* display other set of key labels on bottom */
    while(!kbhit());
    botlin(botmes);  /* display default KEYLABELS */
    close_win(1);
}


/***************
* ABOUT WINDOW *
***************/

about(void)

{
    open_win(1,150,50,450,150,"About program");
    wrtext(180,90,"HPCLIB Interactive demo.");
    wrtext(180,120,"  Press any key...");
    while(!kbhit());
    close_win(1);
}


/*****************
* INITIALISATION *
*****************/

initialize(void)

{
    int f;
    menu_stat=0;            /* menu status cleared */

    is100();                /* Is it an HP100LX? */
    setgra();               /* Set graphics mode */
    announ(AN_LEFT);        /* place announciators left */
    toplin(topmes);         /* Create top line */
    botlin(botmes);         /* Create bottom (key-label) line */

    setfon(LARGE_FONT);
    wrtext(65,20,"Welcome to the HP100LX palmtop.");
    line(0,35,639,35);      /* draw a line */

    setfon(MEDIUM_FONT);

    wrtext(140,170,"Press ALT or MENU key, ESC to exit.");

    setfon(SMALL_FONT);     /* set text to small font */

    for (f=0;f<9;f++)
    {
        wrtext(20,50+(f*12),"This is a demo using the HPCLIB library.");
        wrtext(360,50+(f*12),"Press ALT or MENU key to navigate.");
    }
}

