/* Copyright (c) 2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _AQT1000_REG_DEFAULTS_H
#define _AQT1000_REG_DEFAULTS_H

#include <linux/types.h>
#include "aqt1000-registers.h"

#define AQT1000_REG(reg)  ((reg) & 0xFF)
#define AQT1000_PAGE_SIZE  256

enum {
	AQT1000_PAGE_0 = 0,
	AQT1000_PAGE_1,
	AQT1000_PAGE_2,
	AQT1000_PAGE_5 = 5,
	AQT1000_PAGE_6,
	AQT1000_PAGE_7,
	AQT1000_PAGE_10 = 0xA,
	AQT1000_PAGE_11,
	AQT1000_PAGE_12,
	AQT1000_PAGE_13,
	AQT1000_PAGE_15 = 0xF,
	AQT1000_PAGE_128,
	AQT1000_PAGE_MAX,
};

enum {
	AQT1000_WO = 0,
	AQT1000_RO,
	AQT1000_RW,
};

static const struct reg_default aqt1000_defaults[] = {
	{AQT1000_CHIP_CFG1_PWR_MEM_SD,                         0x07},
	{AQT1000_CHIP_CFG1_PWR_SYS_MEM_SD_RAM,                 0x00},
	{AQT1000_CHIP_CFG1_PWR_SYS_MEM_SD_ROM,                 0x00},
	{AQT1000_CHIP_CFG1_PWR_SYS_MEM_FORCE_DS_RAM,             0x00},
	{AQT1000_CHIP_CFG1_PWR_SYS_MEM_FORCE_DS_ROM,             0x00},
	{AQT1000_CHIP_CFG1_CLK_CFG_FLL,                        0x20},
	{AQT1000_CHIP_CFG1_CLK_CFG_SPI_M,                      0x01},
	{AQT1000_CHIP_CFG1_CLK_CFG_I2C_M,                      0x01},
	{AQT1000_CHIP_CFG1_CLK_CFG_UART,                       0x01},
	{AQT1000_CHIP_CFG1_RST_USB_SS,                         0x0E},
	{AQT1000_CHIP_CFG1_RST_BLSP,                           0x0F},
	{AQT1000_CHIP_CFG1_RST_BUS_MTRX,                       0x00},
	{AQT1000_CHIP_CFG1_RST_MISC,                           0x00},
	{AQT1000_CHIP_CFG1_ANA_WAIT_STATE_CTL,                 0xCC},
	{AQT1000_PAGE1_PAGE_REGISTER,                          0x00},
	{AQT1000_FLL_USER_CTL_0,                               0x71},
	{AQT1000_FLL_USER_CTL_1,                               0x34},
	{AQT1000_FLL_USER_CTL_2,                               0x0B},
	{AQT1000_FLL_USER_CTL_3,                               0x02},
	{AQT1000_FLL_USER_CTL_4,                               0x04},
	{AQT1000_FLL_USER_CTL_5,                               0x02},
	{AQT1000_FLL_USER_CTL_6,                               0x6E},
	{AQT1000_FLL_USER_CTL_7,                               0x00},
	{AQT1000_FLL_USER_CTL_8,                               0x94},
	{AQT1000_FLL_USER_CTL_9,                               0x70},
	{AQT1000_FLL_L_VAL_CTL_0,                              0x34},
	{AQT1000_FLL_L_VAL_CTL_1,                              0x00},
	{AQT1000_FLL_DSM_FRAC_CTL_0,                           0x00},
	{AQT1000_FLL_DSM_FRAC_CTL_1,                           0xFF},
	{AQT1000_FLL_CONFIG_CTL_0,                             0x6B},
	{AQT1000_FLL_CONFIG_CTL_1,                             0x05},
	{AQT1000_FLL_CONFIG_CTL_2,                             0x08},
	{AQT1000_FLL_CONFIG_CTL_3,                             0x00},
	{AQT1000_FLL_CONFIG_CTL_4,                             0x10},
	{AQT1000_FLL_TEST_CTL_0,                               0x80},
	{AQT1000_FLL_TEST_CTL_1,                               0x00},
	{AQT1000_FLL_TEST_CTL_2,                               0x00},
	{AQT1000_FLL_TEST_CTL_3,                               0x00},
	{AQT1000_FLL_TEST_CTL_4,                               0x00},
	{AQT1000_FLL_TEST_CTL_5,                               0x00},
	{AQT1000_FLL_TEST_CTL_6,                               0x04},
	{AQT1000_FLL_TEST_CTL_7,                               0x33},
	{AQT1000_FLL_FREQ_CTL_0,                               0x00},
	{AQT1000_FLL_FREQ_CTL_1,                               0x00},
	{AQT1000_FLL_FREQ_CTL_2,                               0x00},
	{AQT1000_FLL_FREQ_CTL_3,                               0x00},
	{AQT1000_FLL_SSC_CTL_0,                                0x00},
	{AQT1000_FLL_SSC_CTL_1,                                0x00},
	{AQT1000_FLL_SSC_CTL_2,                                0x00},
	{AQT1000_FLL_SSC_CTL_3,                                0x00},
	{AQT1000_FLL_FLL_MODE,                                 0xA0},
	{AQT1000_FLL_STATUS_0,                                 0x00},
	{AQT1000_FLL_STATUS_1,                                 0x00},
	{AQT1000_FLL_STATUS_2,                                 0x00},
	{AQT1000_FLL_STATUS_3,                                 0x00},
	{AQT1000_PAGE2_PAGE_REGISTER,                          0x00},
	{AQT1000_I2S_I2S_0_TX_CFG,                             0x00},
	{AQT1000_I2S_I2S_0_RX_CFG,                             0x00},
	{AQT1000_I2S_I2S_0_CTL,                                0x0C},
	{AQT1000_I2S_I2S_CLKSRC_CTL,                           0x01},
	{AQT1000_I2S_I2S_HS_CLK_CTL,                           0x00},
	{AQT1000_I2S_I2S_0_RST,                                0x00},
	{AQT1000_I2S_SHADOW_I2S_0_CTL,                         0x00},
	{AQT1000_I2S_SHADOW_I2S_0_RX_CFG,                      0x09},
	{AQT1000_PAGE5_PAGE_REGISTER,                          0x00},
	{AQT1000_INTR_CTRL_MCU_INT_POLARITY,                   0x00},
	{AQT1000_INTR_CTRL_INT_MASK_0,                         0xFE},
	{AQT1000_INTR_CTRL_INT_MASK_1,                         0xFF},
	{AQT1000_INTR_CTRL_INT_MASK_2,                         0xFF},
	{AQT1000_INTR_CTRL_INT_MASK_3,                         0xEF},
	{AQT1000_INTR_CTRL_INT_MASK_4,                         0x3B},
	{AQT1000_INTR_CTRL_INT_MASK_5,                         0xFF},
	{AQT1000_INTR_CTRL_INT_MASK_6,                         0x3F},
	{AQT1000_INTR_CTRL_INT_STATUS_0,                       0x00},
	{AQT1000_INTR_CTRL_INT_STATUS_1,                       0x00},
	{AQT1000_INTR_CTRL_INT_STATUS_2,                       0x00},
	{AQT1000_INTR_CTRL_INT_STATUS_3,                       0x00},
	{AQT1000_INTR_CTRL_INT_STATUS_4,                       0x00},
	{AQT1000_INTR_CTRL_INT_STATUS_5,                       0x00},
	{AQT1000_INTR_CTRL_INT_STATUS_6,                       0x00},
	{AQT1000_INTR_CTRL_INT_CLEAR_0,                        0x00},
	{AQT1000_INTR_CTRL_INT_CLEAR_1,                        0x00},
	{AQT1000_INTR_CTRL_INT_CLEAR_2,                        0x00},
	{AQT1000_INTR_CTRL_INT_CLEAR_3,                        0x00},
	{AQT1000_INTR_CTRL_INT_CLEAR_4,                        0x00},
	{AQT1000_INTR_CTRL_INT_CLEAR_5,                        0x00},
	{AQT1000_INTR_CTRL_INT_CLEAR_6,                        0x00},
	{AQT1000_INTR_CTRL_INT_TYPE_0,                         0xEF},
	{AQT1000_INTR_CTRL_INT_TYPE_1,                         0x03},
	{AQT1000_INTR_CTRL_INT_TYPE_2,                         0x00},
	{AQT1000_INTR_CTRL_INT_TYPE_3,                         0x20},
	{AQT1000_INTR_CTRL_INT_TYPE_4,                         0x44},
	{AQT1000_INTR_CTRL_INT_TYPE_5,                         0x00},
	{AQT1000_INTR_CTRL_INT_TYPE_6,                         0x00},
	{AQT1000_INTR_CTRL_INT_TEST_EN_0,                      0x00},
	{AQT1000_INTR_CTRL_INT_TEST_EN_1,                      0x00},
	{AQT1000_INTR_CTRL_INT_TEST_EN_2,                      0x00},
	{AQT1000_INTR_CTRL_INT_TEST_EN_3,                      0x00},
	{AQT1000_INTR_CTRL_INT_TEST_EN_4,                      0x00},
	{AQT1000_INTR_CTRL_INT_TEST_EN_5,                      0x00},
	{AQT1000_INTR_CTRL_INT_TEST_EN_6,                      0x00},
	{AQT1000_INTR_CTRL_INT_TEST_VAL_0,                     0x00},
	{AQT1000_INTR_CTRL_INT_TEST_VAL_1,                     0x00},
	{AQT1000_INTR_CTRL_INT_TEST_VAL_2,                     0x00},
	{AQT1000_INTR_CTRL_INT_TEST_VAL_3,                     0x00},
	{AQT1000_INTR_CTRL_INT_TEST_VAL_4,                     0x00},
	{AQT1000_INTR_CTRL_INT_TEST_VAL_5,                     0x00},
	{AQT1000_INTR_CTRL_INT_TEST_VAL_6,                     0x00},
	{AQT1000_INTR_CTRL_INT_DEST_0,                         0x02},
	{AQT1000_INTR_CTRL_INT_DEST_1,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_2,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_3,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_4,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_5,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_6,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_7,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_8,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_9,                         0x00},
	{AQT1000_INTR_CTRL_INT_DEST_10,                        0x00},
	{AQT1000_INTR_CTRL_INT_DEST_11,                        0x00},
	{AQT1000_INTR_CTRL_INT_DEST_12,                        0x00},
	{AQT1000_INTR_CTRL_INT_DEST_13,                        0x00},
	{AQT1000_INTR_CTRL_CLR_COMMIT,                         0x00},
	{AQT1000_ANA_PAGE_REGISTER,                            0x00},
	{AQT1000_ANA_BIAS,                                     0x00},
	{AQT1000_ANA_RX_SUPPLIES,                              0x00},
	{AQT1000_ANA_HPH,                                      0x0C},
	{AQT1000_ANA_AMIC1,                                    0x20},
	{AQT1000_ANA_AMIC2,                                    0x00},
	{AQT1000_ANA_AMIC3,                                    0x20},
	{AQT1000_ANA_AMIC3_HPF,                                0x00},
	{AQT1000_ANA_MBHC_MECH,                                0x39},
	{AQT1000_ANA_MBHC_ELECT,                               0x08},
	{AQT1000_ANA_MBHC_ZDET,                                0x00},
	{AQT1000_ANA_MBHC_RESULT_1,                            0x00},
	{AQT1000_ANA_MBHC_RESULT_2,                            0x00},
	{AQT1000_ANA_MBHC_RESULT_3,                            0x00},
	{AQT1000_ANA_MBHC_BTN0,                                0x00},
	{AQT1000_ANA_MBHC_BTN1,                                0x10},
	{AQT1000_ANA_MBHC_BTN2,                                0x20},
	{AQT1000_ANA_MBHC_BTN3,                                0x30},
	{AQT1000_ANA_MBHC_BTN4,                                0x40},
	{AQT1000_ANA_MBHC_BTN5,                                0x50},
	{AQT1000_ANA_MBHC_BTN6,                                0x60},
	{AQT1000_ANA_MBHC_BTN7,                                0x70},
	{AQT1000_ANA_MICB1,                                    0x10},
	{AQT1000_ANA_MICB1_RAMP,                               0x00},
	{AQT1000_BIAS_CTL,                                     0x28},
	{AQT1000_BIAS_CCOMP_FINE_ADJ,                          0x75},
	{AQT1000_LED_LED_MODE_SEL_R,                           0x00},
	{AQT1000_LED_LED_MISC_R,                               0x00},
	{AQT1000_LED_LED_MODE_SEL_G,                           0x00},
	{AQT1000_LED_LED_MISC_G,                               0x00},
	{AQT1000_LED_LED_MODE_SEL_B,                           0x00},
	{AQT1000_LED_LED_MISC_B,                               0x00},
	{AQT1000_LDOH_MODE,                                    0x1D},
	{AQT1000_LDOH_BIAS,                                    0x00},
	{AQT1000_LDOH_STB_LOADS,                               0x00},
	{AQT1000_LDOH_MISC1,                                   0x00},
	{AQT1000_LDOL_VDDCX_ADJUST,                            0x01},
	{AQT1000_LDOL_DISABLE_LDOL,                            0x00},
	{AQT1000_BUCK_5V_EN_CTL,                               0x03},
	{AQT1000_BUCK_5V_VOUT_SEL,                             0x03},
	{AQT1000_BUCK_5V_CTRL_VCL_1,                           0x03},
	{AQT1000_BUCK_5V_CTRL_VCL_2,                           0x21},
	{AQT1000_BUCK_5V_CTRL_CCL_2,                           0x20},
	{AQT1000_BUCK_5V_CTRL_CCL_1,                           0xA1},
	{AQT1000_BUCK_5V_CTRL_CCL_3,                           0x02},
	{AQT1000_BUCK_5V_CTRL_CCL_4,                           0x05},
	{AQT1000_BUCK_5V_CTRL_CCL_5,                           0x00},
	{AQT1000_BUCK_5V_IBIAS_CTL_1,                          0x37},
	{AQT1000_BUCK_5V_IBIAS_CTL_2,                          0x00},
	{AQT1000_BUCK_5V_IBIAS_CTL_3,                          0x33},
	{AQT1000_BUCK_5V_IBIAS_CTL_4,                          0x33},
	{AQT1000_BUCK_5V_IBIAS_CTL_5,                          0x00},
	{AQT1000_BUCK_5V_ATEST_DTEST_CTL,                      0x00},
	{AQT1000_PON_BG_CTRL,                                  0x80},
	{AQT1000_PON_TEST_CTRL,                                0x00},
	{AQT1000_MBHC_CTL_CLK,                                 0x30},
	{AQT1000_MBHC_CTL_ANA,                                 0x00},
	{AQT1000_MBHC_CTL_SPARE_1,                             0x00},
	{AQT1000_MBHC_CTL_SPARE_2,                             0x00},
	{AQT1000_MBHC_CTL_BCS,                                 0x00},
	{AQT1000_MBHC_MOISTURE_DET_FSM_STATUS,                 0x00},
	{AQT1000_MBHC_TEST_CTL,                                0x00},
	{AQT1000_MICB1_TEST_CTL_1,                             0x1A},
	{AQT1000_MICB1_TEST_CTL_2,                             0x18},
	{AQT1000_MICB1_TEST_CTL_3,                             0xA4},
	{AQT1000_MICB1_MISC_MICB1_INM_RES_BIAS,                0x00},
	{AQT1000_MICB1_MISC_MICB_MISC1,                        0x00},
	{AQT1000_MICB1_MISC_MICB_MISC2,                        0x00},
	{AQT1000_TX_COM_ADC_VCM,                               0x39},
	{AQT1000_TX_COM_BIAS_ATEST,                            0xC0},
	{AQT1000_TX_COM_ADC_INT1_IB,                           0x6F},
	{AQT1000_TX_COM_ADC_INT2_IB,                           0x4F},
	{AQT1000_TX_COM_TXFE_DIV_CTL,                          0x2E},
	{AQT1000_TX_COM_TXFE_DIV_START,                        0x00},
	{AQT1000_TX_COM_TXFE_DIV_STOP_9P6M,                    0xC7},
	{AQT1000_TX_COM_TXFE_DIV_STOP_12P288M,                 0xFF},
	{AQT1000_TX_1_2_TEST_EN,                               0xCC},
	{AQT1000_TX_1_2_ADC_IB,                                0x09},
	{AQT1000_TX_1_2_ATEST_REFCTL,                          0x0A},
	{AQT1000_TX_1_2_TEST_CTL,                              0x38},
	{AQT1000_TX_1_2_TEST_BLK_EN,                           0xFF},
	{AQT1000_TX_1_2_TXFE_CLKDIV,                           0x00},
	{AQT1000_TX_1_2_SAR1_ERR,                              0x00},
	{AQT1000_TX_1_2_SAR2_ERR,                              0x00},
	{AQT1000_TX_3_TEST_EN,                                 0xC0},
	{AQT1000_TX_3_ADC_IB,                                  0x09},
	{AQT1000_TX_3_ATEST_REFCTL,                            0x0A},
	{AQT1000_TX_3_TEST_CTL,                                0x38},
	{AQT1000_TX_3_TEST_BLK_EN,                             0xFE},
	{AQT1000_TX_3_TXFE_CLKDIV,                             0x00},
	{AQT1000_TX_3_SAR1_ERR,                                0x00},
	{AQT1000_TX_3_SAR2_ERR,                                0x00},
	{AQT1000_TX_ATEST1_2_SEL,                              0x60},
	{AQT1000_CLASSH_MODE_1,                                0x40},
	{AQT1000_CLASSH_MODE_2,                                0x3A},
	{AQT1000_CLASSH_MODE_3,                                0x00},
	{AQT1000_CLASSH_CTRL_VCL_1,                            0x70},
	{AQT1000_CLASSH_CTRL_VCL_2,                            0x82},
	{AQT1000_CLASSH_CTRL_CCL_1,                            0x31},
	{AQT1000_CLASSH_CTRL_CCL_2,                            0x80},
	{AQT1000_CLASSH_CTRL_CCL_3,                            0x80},
	{AQT1000_CLASSH_CTRL_CCL_4,                            0x51},
	{AQT1000_CLASSH_CTRL_CCL_5,                            0x00},
	{AQT1000_CLASSH_BUCK_TMUX_A_D,                         0x00},
	{AQT1000_CLASSH_BUCK_SW_DRV_CNTL,                      0x77},
	{AQT1000_CLASSH_SPARE,                                 0x00},
	{AQT1000_FLYBACK_EN,                                   0x4E},
	{AQT1000_FLYBACK_VNEG_CTRL_1,                          0x0B},
	{AQT1000_FLYBACK_VNEG_CTRL_2,                          0x45},
	{AQT1000_FLYBACK_VNEG_CTRL_3,                          0x74},
	{AQT1000_FLYBACK_VNEG_CTRL_4,                          0x7F},
	{AQT1000_FLYBACK_VNEG_CTRL_5,                          0x83},
	{AQT1000_FLYBACK_VNEG_CTRL_6,                          0x98},
	{AQT1000_FLYBACK_VNEG_CTRL_7,                          0xA9},
	{AQT1000_FLYBACK_VNEG_CTRL_8,                          0x68},
	{AQT1000_FLYBACK_VNEG_CTRL_9,                          0x64},
	{AQT1000_FLYBACK_VNEGDAC_CTRL_1,                       0xED},
	{AQT1000_FLYBACK_VNEGDAC_CTRL_2,                       0xF0},
	{AQT1000_FLYBACK_VNEGDAC_CTRL_3,                       0xA6},
	{AQT1000_FLYBACK_CTRL_1,                               0x65},
	{AQT1000_FLYBACK_TEST_CTL,                             0x00},
	{AQT1000_RX_AUX_SW_CTL,                                0x00},
	{AQT1000_RX_PA_AUX_IN_CONN,                            0x00},
	{AQT1000_RX_TIMER_DIV,                                 0x32},
	{AQT1000_RX_OCP_CTL,                                   0x1F},
	{AQT1000_RX_OCP_COUNT,                                 0x77},
	{AQT1000_RX_BIAS_ATEST,                                0x00},
	{AQT1000_RX_BIAS_MISC1,                                0xAA},
	{AQT1000_RX_BIAS_HPH_LDO,                              0xA9},
	{AQT1000_RX_BIAS_HPH_PA,                               0xAA},
	{AQT1000_RX_BIAS_HPH_RDACBUFF_CNP2,                    0x8A},
	{AQT1000_RX_BIAS_HPH_RDAC_LDO,                         0x88},
	{AQT1000_RX_BIAS_HPH_CNP1,                             0x82},
	{AQT1000_RX_BIAS_HPH_LOWPOWER,                         0x82},
	{AQT1000_RX_BIAS_MISC2,                                0x80},
	{AQT1000_RX_BIAS_MISC3,                                0x88},
	{AQT1000_RX_BIAS_MISC4,                                0x88},
	{AQT1000_RX_BIAS_MISC5,                                0xA8},
	{AQT1000_RX_BIAS_BUCK_RST,                             0x08},
	{AQT1000_RX_BIAS_BUCK_VREF_ERRAMP,                     0x44},
	{AQT1000_RX_BIAS_FLYB_ERRAMP,                          0x40},
	{AQT1000_RX_BIAS_FLYB_BUFF,                            0xAA},
	{AQT1000_RX_BIAS_FLYB_MID_RST,                         0x14},
	{AQT1000_HPH_L_STATUS,                                 0x04},
	{AQT1000_HPH_R_STATUS,                                 0x04},
	{AQT1000_HPH_CNP_EN,                                   0x80},
	{AQT1000_HPH_CNP_WG_CTL,                               0x9A},
	{AQT1000_HPH_CNP_WG_TIME,                              0x14},
	{AQT1000_HPH_OCP_CTL,                                  0x28},
	{AQT1000_HPH_AUTO_CHOP,                                0x16},
	{AQT1000_HPH_CHOP_CTL,                                 0x83},
	{AQT1000_HPH_PA_CTL1,                                  0x46},
	{AQT1000_HPH_PA_CTL2,                                  0x50},
	{AQT1000_HPH_L_EN,                                     0x80},
	{AQT1000_HPH_L_TEST,                                   0xE0},
	{AQT1000_HPH_L_ATEST,                                  0x50},
	{AQT1000_HPH_R_EN,                                     0x80},
	{AQT1000_HPH_R_TEST,                                   0xE0},
	{AQT1000_HPH_R_ATEST,                                  0x54},
	{AQT1000_HPH_RDAC_CLK_CTL1,                            0x99},
	{AQT1000_HPH_RDAC_CLK_CTL2,                            0x9B},
	{AQT1000_HPH_RDAC_LDO_CTL,                             0x33},
	{AQT1000_HPH_RDAC_CHOP_CLK_LP_CTL,                     0x00},
	{AQT1000_HPH_REFBUFF_UHQA_CTL,                         0xA8},
	{AQT1000_HPH_REFBUFF_LP_CTL,                           0x0E},
	{AQT1000_HPH_L_DAC_CTL,                                0x00},
	{AQT1000_HPH_R_DAC_CTL,                                0x00},
	{AQT1000_HPHLR_SURGE_COMP_SEL,                         0x55},
	{AQT1000_HPHLR_SURGE_EN,                               0x1D},
	{AQT1000_HPHLR_SURGE_MISC1,                            0xA0},
	{AQT1000_HPHLR_SURGE_STATUS,                           0x00},
	{AQT1000_ANA_NEW_PAGE_REGISTER,                        0x00},
	{AQT1000_HPH_NEW_ANA_HPH2,                             0x00},
	{AQT1000_HPH_NEW_ANA_HPH3,                             0x00},
	{AQT1000_CLK_SYS_MCLK1_PRG,                            0x09},
	{AQT1000_CLK_SYS_MCLK2_I2S_HS_CLK_PRG,                 0x20},
	{AQT1000_CLK_SYS_XO_CAP_XTP,                           0x3F},
	{AQT1000_CLK_SYS_XO_CAP_XTM,                           0x3F},
	{AQT1000_CLK_SYS_PLL_ENABLES,                          0x00},
	{AQT1000_CLK_SYS_PLL_PRESET,                           0x00},
	{AQT1000_CLK_SYS_PLL_STATUS,                           0x00},
	{AQT1000_MBHC_NEW_ELECT_REM_CLAMP_CTL,                 0x00},
	{AQT1000_MBHC_NEW_CTL_1,                               0x02},
	{AQT1000_MBHC_NEW_CTL_2,                               0x05},
	{AQT1000_MBHC_NEW_PLUG_DETECT_CTL,                     0x29},
	{AQT1000_MBHC_NEW_ZDET_ANA_CTL,                        0x0F},
	{AQT1000_MBHC_NEW_ZDET_RAMP_CTL,                       0x00},
	{AQT1000_MBHC_NEW_FSM_STATUS,                          0x00},
	{AQT1000_MBHC_NEW_ADC_RESULT,                          0x00},
	{AQT1000_HPH_NEW_INT_RDAC_GAIN_CTL,                    0x40},
	{AQT1000_HPH_NEW_INT_RDAC_HD2_CTL_L,                   0x81},
	{AQT1000_HPH_NEW_INT_RDAC_VREF_CTL,                    0x10},
	{AQT1000_HPH_NEW_INT_RDAC_OVERRIDE_CTL,                0x00},
	{AQT1000_HPH_NEW_INT_RDAC_HD2_CTL_R,                   0x81},
	{AQT1000_HPH_NEW_INT_PA_MISC1,                         0x22},
	{AQT1000_HPH_NEW_INT_PA_MISC2,                         0x00},
	{AQT1000_HPH_NEW_INT_PA_RDAC_MISC,                     0x00},
	{AQT1000_HPH_NEW_INT_HPH_TIMER1,                       0xFE},
	{AQT1000_HPH_NEW_INT_HPH_TIMER2,                       0x02},
	{AQT1000_HPH_NEW_INT_HPH_TIMER3,                       0x4E},
	{AQT1000_HPH_NEW_INT_HPH_TIMER4,                       0x54},
	{AQT1000_HPH_NEW_INT_PA_RDAC_MISC2,                    0x80},
	{AQT1000_HPH_NEW_INT_PA_RDAC_MISC3,                    0x00},
	{AQT1000_RX_NEW_INT_HPH_RDAC_BIAS_LOHIFI,              0x62},
	{AQT1000_RX_NEW_INT_HPH_RDAC_BIAS_ULP,                 0x01},
	{AQT1000_RX_NEW_INT_HPH_RDAC_LDO_LP,                   0x11},
	{AQT1000_CLK_SYS_INT_CLK_TEST1,                        0x00},
	{AQT1000_CLK_SYS_INT_XO_TEST1,                         0x98},
	{AQT1000_CLK_SYS_INT_XO_TEST2,                         0x00},
	{AQT1000_CLK_SYS_INT_POST_DIV_REG0,                    0x00},
	{AQT1000_CLK_SYS_INT_POST_DIV_REG1,                    0x00},
	{AQT1000_CLK_SYS_INT_REF_DIV_REG0,                     0x00},
	{AQT1000_CLK_SYS_INT_REF_DIV_REG1,                     0x00},
	{AQT1000_CLK_SYS_INT_FILTER_REG0,                      0x00},
	{AQT1000_CLK_SYS_INT_FILTER_REG1,                      0x00},
	{AQT1000_CLK_SYS_INT_PLL_L_VAL,                        0x00},
	{AQT1000_CLK_SYS_INT_PLL_M_VAL,                        0x00},
	{AQT1000_CLK_SYS_INT_PLL_N_VAL,                        0x00},
	{AQT1000_CLK_SYS_INT_TEST_REG0,                        0x00},
	{AQT1000_CLK_SYS_INT_PFD_CP_DSM_PROG,                  0x00},
	{AQT1000_CLK_SYS_INT_VCO_PROG,                         0x00},
	{AQT1000_CLK_SYS_INT_TEST_REG1,                        0x00},
	{AQT1000_CLK_SYS_INT_LDO_LOCK_CFG,                     0x00},
	{AQT1000_CLK_SYS_INT_DIG_LOCK_DET_CFG,                 0x00},
	{AQT1000_MBHC_NEW_INT_MOISTURE_DET_DC_CTRL,             0x57},
	{AQT1000_MBHC_NEW_INT_MOISTURE_DET_POLLING_CTRL,             0x01},
	{AQT1000_MBHC_NEW_INT_MECH_DET_CURRENT,                0x00},
	{AQT1000_MBHC_NEW_INT_SPARE_2,                         0x00},
	{AQT1000_PAGE10_PAGE_REGISTER,                         0x00},
	{AQT1000_CDC_ANC0_CLK_RESET_CTL,                       0x00},
	{AQT1000_CDC_ANC0_MODE_1_CTL,                          0x00},
	{AQT1000_CDC_ANC0_MODE_2_CTL,                          0x00},
	{AQT1000_CDC_ANC0_FF_SHIFT,                            0x00},
	{AQT1000_CDC_ANC0_FB_SHIFT,                            0x00},
	{AQT1000_CDC_ANC0_LPF_FF_A_CTL,                        0x00},
	{AQT1000_CDC_ANC0_LPF_FF_B_CTL,                        0x00},
	{AQT1000_CDC_ANC0_LPF_FB_CTL,                          0x00},
	{AQT1000_CDC_ANC0_SMLPF_CTL,                           0x00},
	{AQT1000_CDC_ANC0_DCFLT_SHIFT_CTL,                     0x00},
	{AQT1000_CDC_ANC0_IIR_ADAPT_CTL,                       0x00},
	{AQT1000_CDC_ANC0_IIR_COEFF_1_CTL,                     0x00},
	{AQT1000_CDC_ANC0_IIR_COEFF_2_CTL,                     0x00},
	{AQT1000_CDC_ANC0_FF_A_GAIN_CTL,                       0x00},
	{AQT1000_CDC_ANC0_FF_B_GAIN_CTL,                       0x00},
	{AQT1000_CDC_ANC0_FB_GAIN_CTL,                         0x00},
	{AQT1000_CDC_ANC0_RC_COMMON_CTL,                       0x00},
	{AQT1000_CDC_ANC0_FIFO_COMMON_CTL,                     0x88},
	{AQT1000_CDC_ANC0_RC0_STATUS_FMIN_CNTR,                0x00},
	{AQT1000_CDC_ANC0_RC1_STATUS_FMIN_CNTR,                0x00},
	{AQT1000_CDC_ANC0_RC0_STATUS_FMAX_CNTR,                0x00},
	{AQT1000_CDC_ANC0_RC1_STATUS_FMAX_CNTR,                0x00},
	{AQT1000_CDC_ANC0_STATUS_FIFO,                         0x00},
	{AQT1000_CDC_ANC1_CLK_RESET_CTL,                       0x00},
	{AQT1000_CDC_ANC1_MODE_1_CTL,                          0x00},
	{AQT1000_CDC_ANC1_MODE_2_CTL,                          0x00},
	{AQT1000_CDC_ANC1_FF_SHIFT,                            0x00},
	{AQT1000_CDC_ANC1_FB_SHIFT,                            0x00},
	{AQT1000_CDC_ANC1_LPF_FF_A_CTL,                        0x00},
	{AQT1000_CDC_ANC1_LPF_FF_B_CTL,                        0x00},
	{AQT1000_CDC_ANC1_LPF_FB_CTL,                          0x00},
	{AQT1000_CDC_ANC1_SMLPF_CTL,                           0x00},
	{AQT1000_CDC_ANC1_DCFLT_SHIFT_CTL,                     0x00},
	{AQT1000_CDC_ANC1_IIR_ADAPT_CTL,                       0x00},
	{AQT1000_CDC_ANC1_IIR_COEFF_1_CTL,                     0x00},
	{AQT1000_CDC_ANC1_IIR_COEFF_2_CTL,                     0x00},
	{AQT1000_CDC_ANC1_FF_A_GAIN_CTL,                       0x00},
	{AQT1000_CDC_ANC1_FF_B_GAIN_CTL,                       0x00},
	{AQT1000_CDC_ANC1_FB_GAIN_CTL,                         0x00},
	{AQT1000_CDC_ANC1_RC_COMMON_CTL,                       0x00},
	{AQT1000_CDC_ANC1_FIFO_COMMON_CTL,                     0x88},
	{AQT1000_CDC_ANC1_RC0_STATUS_FMIN_CNTR,                0x00},
	{AQT1000_CDC_ANC1_RC1_STATUS_FMIN_CNTR,                0x00},
	{AQT1000_CDC_ANC1_RC0_STATUS_FMAX_CNTR,                0x00},
	{AQT1000_CDC_ANC1_RC1_STATUS_FMAX_CNTR,                0x00},
	{AQT1000_CDC_ANC1_STATUS_FIFO,                         0x00},
	{AQT1000_CDC_TX0_TX_PATH_CTL,                          0x04},
	{AQT1000_CDC_TX0_TX_PATH_CFG0,                         0x10},
	{AQT1000_CDC_TX0_TX_PATH_CFG1,                         0x03},
	{AQT1000_CDC_TX0_TX_VOL_CTL,                           0x00},
	{AQT1000_CDC_TX0_TX_PATH_SEC0,                         0x00},
	{AQT1000_CDC_TX0_TX_PATH_SEC1,                         0x00},
	{AQT1000_CDC_TX0_TX_PATH_SEC2,                         0x01},
	{AQT1000_CDC_TX0_TX_PATH_SEC3,                         0x3C},
	{AQT1000_CDC_TX0_TX_PATH_SEC4,                         0x20},
	{AQT1000_CDC_TX0_TX_PATH_SEC5,                         0x00},
	{AQT1000_CDC_TX0_TX_PATH_SEC6,                         0x00},
	{AQT1000_CDC_TX1_TX_PATH_CTL,                          0x04},
	{AQT1000_CDC_TX1_TX_PATH_CFG0,                         0x10},
	{AQT1000_CDC_TX1_TX_PATH_CFG1,                         0x03},
	{AQT1000_CDC_TX1_TX_VOL_CTL,                           0x00},
	{AQT1000_CDC_TX1_TX_PATH_SEC0,                         0x00},
	{AQT1000_CDC_TX1_TX_PATH_SEC1,                         0x00},
	{AQT1000_CDC_TX1_TX_PATH_SEC2,                         0x01},
	{AQT1000_CDC_TX1_TX_PATH_SEC3,                         0x3C},
	{AQT1000_CDC_TX1_TX_PATH_SEC4,                         0x20},
	{AQT1000_CDC_TX1_TX_PATH_SEC5,                         0x00},
	{AQT1000_CDC_TX1_TX_PATH_SEC6,                         0x00},
	{AQT1000_CDC_TX2_TX_PATH_CTL,                          0x04},
	{AQT1000_CDC_TX2_TX_PATH_CFG0,                         0x10},
	{AQT1000_CDC_TX2_TX_PATH_CFG1,                         0x03},
	{AQT1000_CDC_TX2_TX_VOL_CTL,                           0x00},
	{AQT1000_CDC_TX2_TX_PATH_SEC0,                         0x00},
	{AQT1000_CDC_TX2_TX_PATH_SEC1,                         0x00},
	{AQT1000_CDC_TX2_TX_PATH_SEC2,                         0x01},
	{AQT1000_CDC_TX2_TX_PATH_SEC3,                         0x3C},
	{AQT1000_CDC_TX2_TX_PATH_SEC4,                         0x20},
	{AQT1000_CDC_TX2_TX_PATH_SEC5,                         0x00},
	{AQT1000_CDC_TX2_TX_PATH_SEC6,                         0x00},
	{AQT1000_CDC_TX2_TX_PATH_SEC7,                         0x25},
	{AQT1000_PAGE11_PAGE_REGISTER,                         0x00},
	{AQT1000_CDC_COMPANDER1_CTL0,                          0x60},
	{AQT1000_CDC_COMPANDER1_CTL1,                          0xDB},
	{AQT1000_CDC_COMPANDER1_CTL2,                          0xFF},
	{AQT1000_CDC_COMPANDER1_CTL3,                          0x35},
	{AQT1000_CDC_COMPANDER1_CTL4,                          0xFF},
	{AQT1000_CDC_COMPANDER1_CTL5,                          0x00},
	{AQT1000_CDC_COMPANDER1_CTL6,                          0x01},
	{AQT1000_CDC_COMPANDER1_CTL7,                          0x26},
	{AQT1000_CDC_COMPANDER2_CTL0,                          0x60},
	{AQT1000_CDC_COMPANDER2_CTL1,                          0xDB},
	{AQT1000_CDC_COMPANDER2_CTL2,                          0xFF},
	{AQT1000_CDC_COMPANDER2_CTL3,                          0x35},
	{AQT1000_CDC_COMPANDER2_CTL4,                          0xFF},
	{AQT1000_CDC_COMPANDER2_CTL5,                          0x00},
	{AQT1000_CDC_COMPANDER2_CTL6,                          0x01},
	{AQT1000_CDC_COMPANDER2_CTL7,                          0x26},
	{AQT1000_CDC_RX1_RX_PATH_CTL,                          0x04},
	{AQT1000_CDC_RX1_RX_PATH_CFG0,                         0x00},
	{AQT1000_CDC_RX1_RX_PATH_CFG1,                         0x64},
	{AQT1000_CDC_RX1_RX_PATH_CFG2,                         0x8F},
	{AQT1000_CDC_RX1_RX_VOL_CTL,                           0x00},
	{AQT1000_CDC_RX1_RX_PATH_MIX_CTL,                      0x04},
	{AQT1000_CDC_RX1_RX_PATH_MIX_CFG,                      0x7E},
	{AQT1000_CDC_RX1_RX_VOL_MIX_CTL,                       0x00},
	{AQT1000_CDC_RX1_RX_PATH_SEC0,                         0xFC},
	{AQT1000_CDC_RX1_RX_PATH_SEC1,                         0x08},
	{AQT1000_CDC_RX1_RX_PATH_SEC2,                         0x00},
	{AQT1000_CDC_RX1_RX_PATH_SEC3,                         0x00},
	{AQT1000_CDC_RX1_RX_PATH_SEC4,                         0x00},
	{AQT1000_CDC_RX1_RX_PATH_SEC5,                         0x00},
	{AQT1000_CDC_RX1_RX_PATH_SEC6,                         0x00},
	{AQT1000_CDC_RX1_RX_PATH_SEC7,                         0x00},
	{AQT1000_CDC_RX1_RX_PATH_MIX_SEC0,                     0x08},
	{AQT1000_CDC_RX1_RX_PATH_MIX_SEC1,                     0x00},
	{AQT1000_CDC_RX1_RX_PATH_DSMDEM_CTL,                   0x00},
	{AQT1000_CDC_RX2_RX_PATH_CTL,                          0x04},
	{AQT1000_CDC_RX2_RX_PATH_CFG0,                         0x00},
	{AQT1000_CDC_RX2_RX_PATH_CFG1,                         0x64},
	{AQT1000_CDC_RX2_RX_PATH_CFG2,                         0x8F},
	{AQT1000_CDC_RX2_RX_VOL_CTL,                           0x00},
	{AQT1000_CDC_RX2_RX_PATH_MIX_CTL,                      0x04},
	{AQT1000_CDC_RX2_RX_PATH_MIX_CFG,                      0x7E},
	{AQT1000_CDC_RX2_RX_VOL_MIX_CTL,                       0x00},
	{AQT1000_CDC_RX2_RX_PATH_SEC0,                         0xFC},
	{AQT1000_CDC_RX2_RX_PATH_SEC1,                         0x08},
	{AQT1000_CDC_RX2_RX_PATH_SEC2,                         0x00},
	{AQT1000_CDC_RX2_RX_PATH_SEC3,                         0x00},
	{AQT1000_CDC_RX2_RX_PATH_SEC4,                         0x00},
	{AQT1000_CDC_RX2_RX_PATH_SEC5,                         0x00},
	{AQT1000_CDC_RX2_RX_PATH_SEC6,                         0x00},
	{AQT1000_CDC_RX2_RX_PATH_SEC7,                         0x00},
	{AQT1000_CDC_RX2_RX_PATH_MIX_SEC0,                     0x08},
	{AQT1000_CDC_RX2_RX_PATH_MIX_SEC1,                     0x00},
	{AQT1000_CDC_RX2_RX_PATH_DSMDEM_CTL,                   0x00},
	{AQT1000_CDC_EQ_IIR0_PATH_CTL,                         0x00},
	{AQT1000_CDC_EQ_IIR0_PATH_CFG0,                        0x1F},
	{AQT1000_CDC_EQ_IIR0_PATH_CFG1,                        0x00},
	{AQT1000_CDC_EQ_IIR0_PATH_CFG2,                        0x00},
	{AQT1000_CDC_EQ_IIR0_PATH_CFG3,                        0x00},
	{AQT1000_CDC_EQ_IIR0_COEF_CFG0,                        0x00},
	{AQT1000_CDC_EQ_IIR0_COEF_CFG1,                        0x00},
	{AQT1000_CDC_EQ_IIR1_PATH_CTL,                         0x00},
	{AQT1000_CDC_EQ_IIR1_PATH_CFG0,                        0x1F},
	{AQT1000_CDC_EQ_IIR1_PATH_CFG1,                        0x00},
	{AQT1000_CDC_EQ_IIR1_PATH_CFG2,                        0x00},
	{AQT1000_CDC_EQ_IIR1_PATH_CFG3,                        0x00},
	{AQT1000_CDC_EQ_IIR1_COEF_CFG0,                        0x00},
	{AQT1000_CDC_EQ_IIR1_COEF_CFG1,                        0x00},
	{AQT1000_PAGE12_PAGE_REGISTER,                         0x00},
	{AQT1000_CDC_CLSH_CRC,                                 0x00},
	{AQT1000_CDC_CLSH_DLY_CTRL,                            0x03},
	{AQT1000_CDC_CLSH_DECAY_CTRL,                          0x02},
	{AQT1000_CDC_CLSH_HPH_V_PA,                            0x1C},
	{AQT1000_CDC_CLSH_EAR_V_PA,                            0x39},
	{AQT1000_CDC_CLSH_HPH_V_HD,                            0x0C},
	{AQT1000_CDC_CLSH_EAR_V_HD,                            0x0C},
	{AQT1000_CDC_CLSH_K1_MSB,                              0x01},
	{AQT1000_CDC_CLSH_K1_LSB,                              0x00},
	{AQT1000_CDC_CLSH_K2_MSB,                              0x00},
	{AQT1000_CDC_CLSH_K2_LSB,                              0x80},
	{AQT1000_CDC_CLSH_IDLE_CTRL,                           0x00},
	{AQT1000_CDC_CLSH_IDLE_HPH,                            0x00},
	{AQT1000_CDC_CLSH_IDLE_EAR,                            0x00},
	{AQT1000_CDC_CLSH_TEST0,                               0x07},
	{AQT1000_CDC_CLSH_TEST1,                               0x00},
	{AQT1000_CDC_CLSH_OVR_VREF,                            0x00},
	{AQT1000_MIXING_ASRC0_CLK_RST_CTL,                     0x00},
	{AQT1000_MIXING_ASRC0_CTL0,                            0x00},
	{AQT1000_MIXING_ASRC0_CTL1,                            0x00},
	{AQT1000_MIXING_ASRC0_FIFO_CTL,                        0xA8},
	{AQT1000_MIXING_ASRC0_STATUS_FMIN_CNTR_LSB,             0x00},
	{AQT1000_MIXING_ASRC0_STATUS_FMIN_CNTR_MSB,             0x00},
	{AQT1000_MIXING_ASRC0_STATUS_FMAX_CNTR_LSB,             0x00},
	{AQT1000_MIXING_ASRC0_STATUS_FMAX_CNTR_MSB,             0x00},
	{AQT1000_MIXING_ASRC0_STATUS_FIFO,                     0x00},
	{AQT1000_MIXING_ASRC1_CLK_RST_CTL,                     0x00},
	{AQT1000_MIXING_ASRC1_CTL0,                            0x00},
	{AQT1000_MIXING_ASRC1_CTL1,                            0x00},
	{AQT1000_MIXING_ASRC1_FIFO_CTL,                        0xA8},
	{AQT1000_MIXING_ASRC1_STATUS_FMIN_CNTR_LSB,             0x00},
	{AQT1000_MIXING_ASRC1_STATUS_FMIN_CNTR_MSB,             0x00},
	{AQT1000_MIXING_ASRC1_STATUS_FMAX_CNTR_LSB,             0x00},
	{AQT1000_MIXING_ASRC1_STATUS_FMAX_CNTR_MSB,             0x00},
	{AQT1000_MIXING_ASRC1_STATUS_FIFO,                     0x00},
	{AQT1000_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL,             0x04},
	{AQT1000_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1,             0x00},
	{AQT1000_SIDETONE_ASRC0_CLK_RST_CTL,                   0x00},
	{AQT1000_SIDETONE_ASRC0_CTL0,                          0x00},
	{AQT1000_SIDETONE_ASRC0_CTL1,                          0x00},
	{AQT1000_SIDETONE_ASRC0_FIFO_CTL,                      0xA8},
	{AQT1000_SIDETONE_ASRC0_STATUS_FMIN_CNTR_LSB,             0x00},
	{AQT1000_SIDETONE_ASRC0_STATUS_FMIN_CNTR_MSB,             0x00},
	{AQT1000_SIDETONE_ASRC0_STATUS_FMAX_CNTR_LSB,             0x00},
	{AQT1000_SIDETONE_ASRC0_STATUS_FMAX_CNTR_MSB,             0x00},
	{AQT1000_SIDETONE_ASRC0_STATUS_FIFO,                   0x00},
	{AQT1000_EC_REF_HQ0_EC_REF_HQ_PATH_CTL,                0x00},
	{AQT1000_EC_REF_HQ0_EC_REF_HQ_CFG0,                    0x01},
	{AQT1000_EC_REF_HQ1_EC_REF_HQ_PATH_CTL,                0x00},
	{AQT1000_EC_REF_HQ1_EC_REF_HQ_CFG0,                    0x01},
	{AQT1000_EC_ASRC0_CLK_RST_CTL,                         0x00},
	{AQT1000_EC_ASRC0_CTL0,                                0x00},
	{AQT1000_EC_ASRC0_CTL1,                                0x00},
	{AQT1000_EC_ASRC0_FIFO_CTL,                            0xA8},
	{AQT1000_EC_ASRC0_STATUS_FMIN_CNTR_LSB,                0x00},
	{AQT1000_EC_ASRC0_STATUS_FMIN_CNTR_MSB,                0x00},
	{AQT1000_EC_ASRC0_STATUS_FMAX_CNTR_LSB,                0x00},
	{AQT1000_EC_ASRC0_STATUS_FMAX_CNTR_MSB,                0x00},
	{AQT1000_EC_ASRC0_STATUS_FIFO,                         0x00},
	{AQT1000_EC_ASRC1_CLK_RST_CTL,                         0x00},
	{AQT1000_EC_ASRC1_CTL0,                                0x00},
	{AQT1000_EC_ASRC1_CTL1,                                0x00},
	{AQT1000_EC_ASRC1_FIFO_CTL,                            0xA8},
	{AQT1000_EC_ASRC1_STATUS_FMIN_CNTR_LSB,                0x00},
	{AQT1000_EC_ASRC1_STATUS_FMIN_CNTR_MSB,                0x00},
	{AQT1000_EC_ASRC1_STATUS_FMAX_CNTR_LSB,                0x00},
	{AQT1000_EC_ASRC1_STATUS_FMAX_CNTR_MSB,                0x00},
	{AQT1000_EC_ASRC1_STATUS_FIFO,                         0x00},
	{AQT1000_PAGE13_PAGE_REGISTER,                         0x00},
	{AQT1000_CDC_RX_INP_MUX_RX_INT1_CFG0,                  0x00},
	{AQT1000_CDC_RX_INP_MUX_RX_INT1_CFG1,                  0x00},
	{AQT1000_CDC_RX_INP_MUX_RX_INT2_CFG0,                  0x00},
	{AQT1000_CDC_RX_INP_MUX_RX_INT2_CFG1,                  0x00},
	{AQT1000_CDC_RX_INP_MUX_EQ_IIR_CFG0,                   0x00},
	{AQT1000_CDC_RX_INP_MUX_DSD_CFG0,                      0x00},
	{AQT1000_CDC_RX_INP_MUX_RX_MIX_CFG0,                   0x00},
	{AQT1000_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0,             0x00},
	{AQT1000_CDC_RX_INP_MUX_ANC_CFG0,                      0x00},
	{AQT1000_CDC_RX_INP_MUX_SPLINE_ASRC_CFG0,              0x00},
	{AQT1000_CDC_RX_INP_MUX_EC_REF_HQ_CFG0,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX0_CFG0,                 0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX0_CFG1,                 0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX1_CFG0,                 0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX1_CFG1,                 0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX2_CFG0,                 0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX2_CFG1,                 0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX10_CFG0,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX10_CFG1,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX11_CFG0,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX11_CFG1,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX12_CFG0,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX12_CFG1,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX13_CFG0,                0x00},
	{AQT1000_CDC_TX_INP_MUX_ADC_MUX13_CFG1,                0x00},
	{AQT1000_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0,             0x00},
	{AQT1000_CDC_IF_ROUTER_TX_MUX_CFG0,                    0x00},
	{AQT1000_CDC_CLK_RST_CTRL_MCLK_CONTROL,                0x00},
	{AQT1000_CDC_CLK_RST_CTRL_FS_CNT_CONTROL,              0x00},
	{AQT1000_CDC_CLK_RST_CTRL_DSD_CONTROL,                 0x00},
	{AQT1000_CDC_CLK_RST_CTRL_ASRC_SHARE_CONTROL,             0x0F},
	{AQT1000_CDC_CLK_RST_CTRL_GFM_CONTROL,                 0x00},
	{AQT1000_CDC_CLK_RST_CTRL_I2S_CONTROL,                 0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_PATH_CTL,               0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_CTL,                    0x40},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL,             0x00},
	{AQT1000_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL,             0x00},
	{AQT1000_CDC_TOP_TOP_CFG0,                             0x00},
	{AQT1000_CDC_TOP_HPHL_COMP_WR_LSB,                     0x00},
	{AQT1000_CDC_TOP_HPHL_COMP_WR_MSB,                     0x00},
	{AQT1000_CDC_TOP_HPHL_COMP_LUT,                        0x00},
	{AQT1000_CDC_TOP_HPHL_COMP_RD_LSB,                     0x00},
	{AQT1000_CDC_TOP_HPHL_COMP_RD_MSB,                     0x00},
	{AQT1000_CDC_TOP_HPHR_COMP_WR_LSB,                     0x00},
	{AQT1000_CDC_TOP_HPHR_COMP_WR_MSB,                     0x00},
	{AQT1000_CDC_TOP_HPHR_COMP_LUT,                        0x00},
	{AQT1000_CDC_TOP_HPHR_COMP_RD_LSB,                     0x00},
	{AQT1000_CDC_TOP_HPHR_COMP_RD_MSB,                     0x00},
	{AQT1000_CDC_DSD0_PATH_CTL,                            0x00},
	{AQT1000_CDC_DSD0_CFG0,                                0x00},
	{AQT1000_CDC_DSD0_CFG1,                                0x00},
	{AQT1000_CDC_DSD0_CFG2,                                0x42},
	{AQT1000_CDC_DSD0_CFG3,                                0x00},
	{AQT1000_CDC_DSD0_CFG4,                                0x02},
	{AQT1000_CDC_DSD0_CFG5,                                0x00},
	{AQT1000_CDC_DSD1_PATH_CTL,                            0x00},
	{AQT1000_CDC_DSD1_CFG0,                                0x00},
	{AQT1000_CDC_DSD1_CFG1,                                0x00},
	{AQT1000_CDC_DSD1_CFG2,                                0x42},
	{AQT1000_CDC_DSD1_CFG3,                                0x00},
	{AQT1000_CDC_DSD1_CFG4,                                0x02},
	{AQT1000_CDC_DSD1_CFG5,                                0x00},
	{AQT1000_CDC_RX_IDLE_DET_PATH_CTL,                     0x00},
	{AQT1000_CDC_RX_IDLE_DET_CFG0,                         0x07},
	{AQT1000_CDC_RX_IDLE_DET_CFG1,                         0x3C},
	{AQT1000_CDC_RX_IDLE_DET_CFG2,                         0x00},
	{AQT1000_CDC_RX_IDLE_DET_CFG3,                         0x00},
	{AQT1000_CDC_DOP_DET_CTL,                              0x00},
	{AQT1000_CDC_DOP_DET_CFG0,                             0xFA},
	{AQT1000_CDC_DOP_DET_CFG1,                             0x05},
	{AQT1000_CDC_DOP_DET_CFG2,                             0x00},
	{AQT1000_CDC_DOP_DET_CFG3,                             0x33},
	{AQT1000_CDC_DOP_DET_CFG4,                             0x20},
	{AQT1000_CDC_DOP_DET_STATUS0,                          0x00},
	{AQT1000_PAGE15_PAGE_REGISTER,                         0x00},
	{AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG0,                    0x1B},
	{AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG1,                    0x24},
	{AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG2,                    0x00},
	{AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG3,                    0x08},
	{AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG0,                    0x1B},
	{AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG1,                    0x24},
	{AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG2,                    0x00},
	{AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG3,                    0x08},
	{AQT1000_CDC_DEBUG_RC_RE_ASRC_DEBUG_CFG0,              0x00},
	{AQT1000_CDC_DEBUG_ANC0_RC0_FIFO_CTL,                  0x4C},
	{AQT1000_CDC_DEBUG_ANC0_RC1_FIFO_CTL,                  0x4C},
	{AQT1000_CDC_DEBUG_ANC1_RC0_FIFO_CTL,                  0x4C},
	{AQT1000_CDC_DEBUG_ANC1_RC1_FIFO_CTL,                  0x4C},
	{AQT1000_CDC_DEBUG_ANC_RC_RST_DBG_CNTR,                0x00},
	{AQT1000_PAGE128_PAGE_REGISTER,                        0x00},
	{AQT1000_TLMM_SPI_CLK_PINCFG,                          0x00},
	{AQT1000_TLMM_SPI_MOSI_PINCFG,                         0x00},
	{AQT1000_TLMM_SPI_MISO_PINCFG,                         0x00},
	{AQT1000_TLMM_SPI_CS_N_PINCFG,                         0x00},
	{AQT1000_TLMM_GPIO1_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO2_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO3_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO4_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO5_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO6_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO7_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO8_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO9_PINCFG,                            0x00},
	{AQT1000_TLMM_GPIO10_PINCFG,                           0x00},
	{AQT1000_PAD_CTRL_PAD_PDN_CTRL_0,                      0x00},
	{AQT1000_PAD_CTRL_PAD_PDN_CTRL_1,                      0x00},
	{AQT1000_PAD_CTRL_PAD_PU_CTRL_0,                       0x00},
	{AQT1000_PAD_CTRL_PAD_PU_CTRL_1,                       0x00},
	{AQT1000_PAD_CTRL_GPIO_CTL_0_OE,                       0x00},
	{AQT1000_PAD_CTRL_GPIO_CTL_1_OE,                       0x00},
	{AQT1000_PAD_CTRL_GPIO_CTL_0_DATA,                     0x00},
	{AQT1000_PAD_CTRL_GPIO_CTL_1_DATA,                     0x00},
	{AQT1000_PAD_CTRL_PAD_DRVCTL,                          0x00},
	{AQT1000_PAD_CTRL_PIN_STATUS,                          0x00},
	{AQT1000_PAD_CTRL_MEM_CTRL,                            0x00},
	{AQT1000_PAD_CTRL_PAD_INP_DISABLE_0,                   0x00},
	{AQT1000_PAD_CTRL_PAD_INP_DISABLE_1,                   0x00},
	{AQT1000_PAD_CTRL_PIN_CTL_OE_0,                        0x00},
	{AQT1000_PAD_CTRL_PIN_CTL_OE_1,                        0x00},
	{AQT1000_PAD_CTRL_PIN_CTL_DATA_0,                      0x00},
	{AQT1000_PAD_CTRL_PIN_CTL_DATA_1,                      0x00},
	{AQT1000_PAD_CTRL_USB_PHY_CLK_DIV,                     0x0F},
	{AQT1000_PAD_CTRL_DEBUG_BUS_CDC,                       0x00},
	{AQT1000_PAD_CTRL_DEBUG_BUS_SEL,                       0x00},
	{AQT1000_PAD_CTRL_DEBUG_EN_1,                          0x00},
	{AQT1000_PAD_CTRL_DEBUG_EN_2,                          0x00},
	{AQT1000_PAD_CTRL_DEBUG_EN_3,                          0x00},
	{AQT1000_PAD_CTRL_DEBUG_EN_4,                          0x00},
	{AQT1000_PAD_CTRL_DEBUG_EN_5,                          0x00},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_0,                     0x00},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_1,                     0x01},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_2,                     0x02},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_3,                     0x03},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_4,                     0x04},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_5,                     0x05},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_6,                     0x06},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_7,                     0x07},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_8,                     0x08},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_9,                     0x09},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_10,                    0x0A},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_11,                    0x0B},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_12,                    0x0C},
	{AQT1000_PAD_CTRL_DEBUG_MUX_BIT_13,                    0x0D},
	{AQT1000_PAD_CTRL_DEBUG_READ_0,                        0x0D},
	{AQT1000_PAD_CTRL_DEBUG_READ_1,                        0x0D},
	{AQT1000_PAD_CTRL_DEBUG_READ_2,                        0x0D},
	{AQT1000_PAD_CTRL_DEBUG_READ_3,                        0x0D},
	{AQT1000_PAD_CTRL_FPGA_CTL,                            0x00},
};

const u8 aqt1000_page0_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE0_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_CHIP_ID_BYTE0)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_CHIP_ID_BYTE1)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_CHIP_ID_BYTE2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_CHIP_ID_BYTE3)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_TEST0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_TEST1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT0)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT1)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT3)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT4)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT5)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT6)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT7)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT8)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT9)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT10)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT11)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT12)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT13)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT14)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_VAL_OUT15)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_I2C_SLAVE_ID_NONNEGO)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_I2C_SLAVE_ID_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_I2C_SLAVE_ID_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_I2C_SLAVE_ID_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_I2C_ACTIVE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_CLK_CFG_MCLK)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_CLK_CFG_MCLK2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_CLK_CTL_CDC_DIG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_RST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_TEST0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_TEST1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT0)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT1)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT3)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT4)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT5)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT6)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT7)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT8)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT9)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT10)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT11)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT12)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT13)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT14)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_VAL_OUT15)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG0_EFUSE2_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CHIP_CFG1_PWR_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_BUS_MTRX_CFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_DMA_BUS_VOTE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_USB_BUS_VOTE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_BLSP_BUS_VOTE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_PWR_MEM_SD)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_PWR_SYS_MEM_SD_RAM)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_PWR_SYS_MEM_SD_ROM)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_PWR_SYS_MEM_FORCE_DS_RAM)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_PWR_SYS_MEM_FORCE_DS_ROM)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_CLK_CFG_FLL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_CLK_CFG_SPI_M)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_CLK_CFG_I2C_M)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_CLK_CFG_UART)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_RST_USB_SS)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_RST_BLSP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_RST_BUS_MTRX)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_RST_MISC)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CHIP_CFG1_ANA_WAIT_STATE_CTL)] = AQT1000_RW,
};

const u8 aqt1000_page1_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE1_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_8)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_USER_CTL_9)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_L_VAL_CTL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_L_VAL_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_DSM_FRAC_CTL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_DSM_FRAC_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_CONFIG_CTL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_CONFIG_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_CONFIG_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_CONFIG_CTL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_CONFIG_CTL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_TEST_CTL_7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_FREQ_CTL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_FREQ_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_FREQ_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_FREQ_CTL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_SSC_CTL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_SSC_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_SSC_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_SSC_CTL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_FLL_MODE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLL_STATUS_0)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_FLL_STATUS_1)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_FLL_STATUS_2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_FLL_STATUS_3)] = AQT1000_RO,
};

const u8 aqt1000_page2_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE2_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_I2S_0_TX_CFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_I2S_0_RX_CFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_I2S_0_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_I2S_CLKSRC_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_I2S_HS_CLK_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_I2S_0_RST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_SHADOW_I2S_0_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_I2S_SHADOW_I2S_0_RX_CFG)] = AQT1000_RW,
};

const u8 aqt1000_page5_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE5_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_MCU_INT_POLARITY)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_MASK_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_MASK_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_MASK_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_MASK_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_MASK_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_MASK_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_MASK_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_STATUS_0)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_STATUS_1)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_STATUS_2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_STATUS_3)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_STATUS_4)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_STATUS_5)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_STATUS_6)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_CLEAR_0)] = AQT1000_WO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_CLEAR_1)] = AQT1000_WO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_CLEAR_2)] = AQT1000_WO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_CLEAR_3)] = AQT1000_WO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_CLEAR_4)] = AQT1000_WO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_CLEAR_5)] = AQT1000_WO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_CLEAR_6)] = AQT1000_WO,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TYPE_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TYPE_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TYPE_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TYPE_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TYPE_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TYPE_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TYPE_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_EN_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_EN_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_EN_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_EN_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_EN_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_EN_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_EN_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_VAL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_VAL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_VAL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_VAL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_VAL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_VAL_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_TEST_VAL_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_8)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_9)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_10)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_11)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_12)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_INT_DEST_13)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_INTR_CTRL_CLR_COMMIT)] = AQT1000_WO,
};

const u8 aqt1000_page6_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_ANA_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_BIAS)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_RX_SUPPLIES)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_HPH)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_AMIC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_AMIC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_AMIC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_AMIC3_HPF)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_MECH)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_ELECT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_ZDET)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_RESULT_1)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_ANA_MBHC_RESULT_2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_ANA_MBHC_RESULT_3)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MBHC_BTN7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MICB1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_ANA_MICB1_RAMP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BIAS_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BIAS_CCOMP_FINE_ADJ)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LED_LED_MODE_SEL_R)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LED_LED_MISC_R)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LED_LED_MODE_SEL_G)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LED_LED_MISC_G)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LED_LED_MODE_SEL_B)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LED_LED_MISC_B)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LDOH_MODE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LDOH_BIAS)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LDOH_STB_LOADS)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LDOH_MISC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LDOL_VDDCX_ADJUST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_LDOL_DISABLE_LDOL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_EN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_VOUT_SEL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_CTRL_VCL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_CTRL_VCL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_CTRL_CCL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_CTRL_CCL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_CTRL_CCL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_CTRL_CCL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_CTRL_CCL_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_IBIAS_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_IBIAS_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_IBIAS_CTL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_IBIAS_CTL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_IBIAS_CTL_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_BUCK_5V_ATEST_DTEST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PON_BG_CTRL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PON_TEST_CTRL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_CTL_CLK)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_CTL_ANA)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_CTL_SPARE_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_CTL_SPARE_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_CTL_BCS)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_MOISTURE_DET_FSM_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MBHC_TEST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MICB1_TEST_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MICB1_TEST_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MICB1_TEST_CTL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MICB1_MISC_MICB1_INM_RES_BIAS)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MICB1_MISC_MICB_MISC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MICB1_MISC_MICB_MISC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_ADC_VCM)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_BIAS_ATEST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_ADC_INT1_IB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_ADC_INT2_IB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_TXFE_DIV_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_TXFE_DIV_START)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_TXFE_DIV_STOP_9P6M)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_COM_TXFE_DIV_STOP_12P288M)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_1_2_TEST_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_1_2_ADC_IB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_1_2_ATEST_REFCTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_1_2_TEST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_1_2_TEST_BLK_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_1_2_TXFE_CLKDIV)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_1_2_SAR1_ERR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_TX_1_2_SAR2_ERR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_TX_3_TEST_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_3_ADC_IB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_3_ATEST_REFCTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_3_TEST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_3_TEST_BLK_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_3_TXFE_CLKDIV)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TX_3_SAR1_ERR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_TX_3_SAR2_ERR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_TX_ATEST1_2_SEL)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CLASSH_MODE_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_MODE_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_MODE_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_CTRL_VCL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_CTRL_VCL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_CTRL_CCL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_CTRL_CCL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_CTRL_CCL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_CTRL_CCL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_CTRL_CCL_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_BUCK_TMUX_A_D)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_BUCK_SW_DRV_CNTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLASSH_SPARE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_8)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEG_CTRL_9)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEGDAC_CTRL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEGDAC_CTRL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_VNEGDAC_CTRL_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_CTRL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_FLYBACK_TEST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_AUX_SW_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_PA_AUX_IN_CONN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_TIMER_DIV)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_OCP_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_OCP_COUNT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_ATEST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_MISC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_HPH_LDO)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_HPH_PA)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_HPH_RDACBUFF_CNP2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_HPH_RDAC_LDO)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_HPH_CNP1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_HPH_LOWPOWER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_MISC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_MISC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_MISC4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_MISC5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_BUCK_RST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_BUCK_VREF_ERRAMP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_FLYB_ERRAMP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_FLYB_BUFF)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_BIAS_FLYB_MID_RST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_L_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_HPH_R_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_HPH_CNP_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_CNP_WG_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_CNP_WG_TIME)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_OCP_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_AUTO_CHOP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_CHOP_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_PA_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_PA_CTL2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_L_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_L_TEST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_L_ATEST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_R_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_R_TEST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_R_ATEST)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_RDAC_CLK_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_RDAC_CLK_CTL2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_RDAC_LDO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_RDAC_CHOP_CLK_LP_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_REFBUFF_UHQA_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_REFBUFF_LP_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_L_DAC_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_R_DAC_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPHLR_SURGE_COMP_SEL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPHLR_SURGE_EN)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPHLR_SURGE_MISC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPHLR_SURGE_STATUS)] = AQT1000_RO,
};

const u8 aqt1000_page7_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_ANA_NEW_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_ANA_HPH2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_ANA_HPH3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_MCLK1_PRG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_MCLK2_I2S_HS_CLK_PRG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_XO_CAP_XTP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_XO_CAP_XTM)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_PLL_ENABLES)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_PLL_PRESET)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_PLL_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MBHC_NEW_ELECT_REM_CLAMP_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_CTL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_CTL_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_PLUG_DETECT_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_ZDET_ANA_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_ZDET_RAMP_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_FSM_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MBHC_NEW_ADC_RESULT)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_RDAC_GAIN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_RDAC_HD2_CTL_L)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_RDAC_VREF_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_RDAC_OVERRIDE_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_RDAC_HD2_CTL_R)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_PA_MISC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_PA_MISC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_PA_RDAC_MISC)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_HPH_TIMER1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_HPH_TIMER2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_HPH_TIMER3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_HPH_TIMER4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_PA_RDAC_MISC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_HPH_NEW_INT_PA_RDAC_MISC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_NEW_INT_HPH_RDAC_BIAS_LOHIFI)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_NEW_INT_HPH_RDAC_BIAS_ULP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_RX_NEW_INT_HPH_RDAC_LDO_LP)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_CLK_TEST1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_XO_TEST1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_XO_TEST2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_POST_DIV_REG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_POST_DIV_REG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_REF_DIV_REG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_REF_DIV_REG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_FILTER_REG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_FILTER_REG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_PLL_L_VAL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_PLL_M_VAL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_PLL_N_VAL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_TEST_REG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_PFD_CP_DSM_PROG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_VCO_PROG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_TEST_REG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_LDO_LOCK_CFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CLK_SYS_INT_DIG_LOCK_DET_CFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_INT_MOISTURE_DET_DC_CTRL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_INT_MOISTURE_DET_POLLING_CTRL)] =
								   AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_INT_MECH_DET_CURRENT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MBHC_NEW_INT_SPARE_2)] = AQT1000_RW,
};

const u8 aqt1000_page10_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE10_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_CLK_RESET_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_MODE_1_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_MODE_2_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_FF_SHIFT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_FB_SHIFT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_LPF_FF_A_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_LPF_FF_B_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_LPF_FB_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_SMLPF_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_DCFLT_SHIFT_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_IIR_ADAPT_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_IIR_COEFF_1_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_IIR_COEFF_2_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_FF_A_GAIN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_FF_B_GAIN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_FB_GAIN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_RC_COMMON_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_FIFO_COMMON_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC0_RC0_STATUS_FMIN_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC0_RC1_STATUS_FMIN_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC0_RC0_STATUS_FMAX_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC0_RC1_STATUS_FMAX_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC0_STATUS_FIFO)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC1_CLK_RESET_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_MODE_1_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_MODE_2_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_FF_SHIFT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_FB_SHIFT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_LPF_FF_A_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_LPF_FF_B_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_LPF_FB_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_SMLPF_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_DCFLT_SHIFT_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_IIR_ADAPT_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_IIR_COEFF_1_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_IIR_COEFF_2_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_FF_A_GAIN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_FF_B_GAIN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_FB_GAIN_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_RC_COMMON_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_FIFO_COMMON_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_ANC1_RC0_STATUS_FMIN_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC1_RC1_STATUS_FMIN_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC1_RC0_STATUS_FMAX_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC1_RC1_STATUS_FMAX_CNTR)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_ANC1_STATUS_FIFO)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_VOL_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_SEC0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_SEC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_SEC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_SEC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_SEC4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_SEC5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX0_TX_PATH_SEC6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_VOL_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_SEC0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_SEC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_SEC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_SEC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_SEC4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_SEC5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX1_TX_PATH_SEC6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_VOL_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX2_TX_PATH_SEC7)] = AQT1000_RW,
};

const u8 aqt1000_page11_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE11_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL6)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_COMPANDER1_CTL7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL6)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_COMPANDER2_CTL7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_VOL_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_MIX_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_MIX_CFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_VOL_MIX_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_SEC7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_MIX_SEC0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_MIX_SEC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX1_RX_PATH_DSMDEM_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_VOL_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_MIX_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_MIX_CFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_VOL_MIX_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_SEC7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_MIX_SEC0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_MIX_SEC1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX2_RX_PATH_DSMDEM_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR0_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR0_PATH_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR0_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR0_PATH_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR0_PATH_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR0_COEF_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR0_COEF_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR1_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR1_PATH_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR1_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR1_PATH_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR1_PATH_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR1_COEF_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_EQ_IIR1_COEF_CFG1)] = AQT1000_RW,
};

const u8 aqt1000_page12_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE12_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_CRC)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_DLY_CTRL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_DECAY_CTRL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_HPH_V_PA)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_EAR_V_PA)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_HPH_V_HD)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_EAR_V_HD)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_K1_MSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_K1_LSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_K2_MSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_K2_LSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_IDLE_CTRL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_IDLE_HPH)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_IDLE_EAR)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_TEST0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_TEST1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLSH_OVR_VREF)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_CLK_RST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_CTL0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_STATUS_FMIN_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_STATUS_FMIN_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_STATUS_FMAX_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_STATUS_FMAX_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC0_STATUS_FIFO)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_CLK_RST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_CTL0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_STATUS_FMIN_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_STATUS_FMIN_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_STATUS_FMAX_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_STATUS_FMAX_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_MIXING_ASRC1_STATUS_FIFO)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_CLK_RST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_CTL0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_STATUS_FMIN_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_STATUS_FMIN_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_STATUS_FMAX_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_STATUS_FMAX_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_SIDETONE_ASRC0_STATUS_FIFO)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_REF_HQ0_EC_REF_HQ_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_REF_HQ0_EC_REF_HQ_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_REF_HQ1_EC_REF_HQ_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_REF_HQ1_EC_REF_HQ_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC0_CLK_RST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC0_CTL0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC0_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC0_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC0_STATUS_FMIN_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC0_STATUS_FMIN_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC0_STATUS_FMAX_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC0_STATUS_FMAX_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC0_STATUS_FIFO)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC1_CLK_RST_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC1_CTL0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC1_CTL1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC1_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_EC_ASRC1_STATUS_FMIN_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC1_STATUS_FMIN_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC1_STATUS_FMAX_CNTR_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC1_STATUS_FMAX_CNTR_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_EC_ASRC1_STATUS_FIFO)] = AQT1000_RO,
};

const u8 aqt1000_page13_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE13_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_RX_INT1_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_RX_INT1_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_RX_INT2_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_RX_INT2_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_EQ_IIR_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_DSD_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_RX_MIX_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_ANC_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_SPLINE_ASRC_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_INP_MUX_EC_REF_HQ_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX0_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX0_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX1_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX1_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX2_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX2_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX10_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX10_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX11_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX11_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX12_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX12_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX13_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TX_INP_MUX_ADC_MUX13_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0)] =
								AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_IF_ROUTER_TX_MUX_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLK_RST_CTRL_MCLK_CONTROL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLK_RST_CTRL_FS_CNT_CONTROL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLK_RST_CTRL_DSD_CONTROL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLK_RST_CTRL_ASRC_SHARE_CONTROL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLK_RST_CTRL_GFM_CONTROL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_CLK_RST_CTRL_I2S_CONTROL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL)] =
								AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_TOP_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHL_COMP_WR_LSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHL_COMP_WR_MSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHL_COMP_LUT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHL_COMP_RD_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHL_COMP_RD_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHR_COMP_WR_LSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHR_COMP_WR_MSB)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHR_COMP_LUT)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHR_COMP_RD_LSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_TOP_HPHR_COMP_RD_MSB)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_DSD0_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD0_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD0_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD0_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD0_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD0_CFG4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD0_CFG5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD1_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD1_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD1_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD1_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD1_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD1_CFG4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DSD1_CFG5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_IDLE_DET_PATH_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_IDLE_DET_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_IDLE_DET_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_IDLE_DET_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_RX_IDLE_DET_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DOP_DET_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DOP_DET_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DOP_DET_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DOP_DET_CFG2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DOP_DET_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DOP_DET_CFG4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DOP_DET_STATUS0)] = AQT1000_RO,
};

const u8 aqt1000_page15_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE15_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD0_DEBUG_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_CDC_DEBUG_DSD1_DEBUG_CFG3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_RC_RE_ASRC_DEBUG_CFG0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_ANC0_RC0_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_ANC0_RC1_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_ANC1_RC0_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_ANC1_RC1_FIFO_CTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_CDC_DEBUG_ANC_RC_RST_DBG_CNTR)] = AQT1000_RW,
};

const u8 aqt1000_page128_reg_access[AQT1000_PAGE_SIZE] = {
	[AQT1000_REG(AQT1000_PAGE128_PAGE_REGISTER)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_SPI_CLK_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_SPI_MOSI_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_SPI_MISO_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_SPI_CS_N_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO1_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO2_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO3_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO4_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO5_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO6_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO7_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO8_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO9_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_TLMM_GPIO10_PINCFG)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PAD_PDN_CTRL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PAD_PDN_CTRL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PAD_PU_CTRL_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PAD_PU_CTRL_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_GPIO_CTL_0_OE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_GPIO_CTL_1_OE)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_GPIO_CTL_0_DATA)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_GPIO_CTL_1_DATA)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PAD_DRVCTL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PIN_STATUS)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_PAD_CTRL_MEM_CTRL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PAD_INP_DISABLE_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PAD_INP_DISABLE_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PIN_CTL_OE_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PIN_CTL_OE_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PIN_CTL_DATA_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_PIN_CTL_DATA_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_USB_PHY_CLK_DIV)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_BUS_CDC)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_BUS_SEL)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_EN_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_EN_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_EN_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_EN_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_EN_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_0)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_1)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_2)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_3)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_4)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_5)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_6)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_7)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_8)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_9)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_10)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_11)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_12)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_MUX_BIT_13)] = AQT1000_RW,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_READ_0)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_READ_1)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_READ_2)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_PAD_CTRL_DEBUG_READ_3)] = AQT1000_RO,
	[AQT1000_REG(AQT1000_PAD_CTRL_FPGA_CTL)] = AQT1000_RW,
};

const u8 * const aqt1000_reg[AQT1000_PAGE_MAX] = {
	[AQT1000_PAGE_0] = aqt1000_page0_reg_access,
	[AQT1000_PAGE_1] = aqt1000_page1_reg_access,
	[AQT1000_PAGE_2] = aqt1000_page2_reg_access,
	[AQT1000_PAGE_5] = aqt1000_page5_reg_access,
	[AQT1000_PAGE_6] = aqt1000_page6_reg_access,
	[AQT1000_PAGE_7] = aqt1000_page7_reg_access,
	[AQT1000_PAGE_10] = aqt1000_page10_reg_access,
	[AQT1000_PAGE_11] = aqt1000_page11_reg_access,
	[AQT1000_PAGE_12] = aqt1000_page12_reg_access,
	[AQT1000_PAGE_13] = aqt1000_page13_reg_access,
	[AQT1000_PAGE_15] = aqt1000_page15_reg_access,
	[AQT1000_PAGE_128] = aqt1000_page128_reg_access,
};

#endif /* _AQT1000_REG_DEFAULTS_H */
