/*
 * Copyright (c) 2015, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _WCD9335_REGISTERS_H
#define _WCD9335_REGISTERS_H

#define WCD9335_PAGE_SIZE 256
#define WCD9335_NUM_PAGES 256

extern const u8 *wcd9335_reg[WCD9335_NUM_PAGES];

enum {
	PAGE_0 = 0,
	PAGE_1,
	PAGE_2,
	PAGE_6 = 6,
	PAGE_10 = 0xA,
	PAGE_11,
	PAGE_12,
	PAGE_13,
	PAGE_0X80,
};

/* Page-0 Registers */
#define WCD9335_PAGE0_PAGE_REGISTER                      0x0000
#define WCD9335_CODEC_RPM_CLK_BYPASS                     0x0001
#define WCD9335_CODEC_RPM_CLK_GATE                       0x0002
#define WCD9335_CODEC_RPM_CLK_MCLK_CFG                   0x0003
#define WCD9335_CODEC_RPM_RST_CTL                        0x0009
#define WCD9335_CODEC_RPM_PWR_CDC_DIG_HM_CTL             0x0011
#define WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_1              0x0012
#define WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_2              0x0013
#define WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_3              0x0014
#define WCD9335_CODEC_RPM_PWR_CPE_IRAM_SHUTDOWN          0x0015
#define WCD9335_CODEC_RPM_PWR_CPE_DRAM1_SHUTDOWN         0x0016
#define WCD9335_CODEC_RPM_PWR_CPE_DRAM0_SHUTDOWN_1       0x0017
#define WCD9335_CODEC_RPM_PWR_CPE_DRAM0_SHUTDOWN_2       0x0018
#define WCD9335_CODEC_RPM_INT_MASK                       0x001d
#define WCD9335_CODEC_RPM_INT_STATUS                     0x001e
#define WCD9335_CODEC_RPM_INT_CLEAR                      0x001f
#define WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE0             0x0021
#define WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE1             0x0022
#define WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE2             0x0023
#define WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE3             0x0024
#define WCD9335_CHIP_TIER_CTRL_EFUSE_CTL                 0x0025
#define WCD9335_CHIP_TIER_CTRL_EFUSE_TEST0               0x0026
#define WCD9335_CHIP_TIER_CTRL_EFUSE_TEST1               0x0027
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT0            0x0029
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT1            0x002a
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT2            0x002b
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT3            0x002c
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT4            0x002d
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT5            0x002e
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT6            0x002f
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT7            0x0030
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT8            0x0031
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT9            0x0032
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT10           0x0033
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT11           0x0034
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT12           0x0035
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT13           0x0036
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT14           0x0037
#define WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT15           0x0038
#define WCD9335_CHIP_TIER_CTRL_EFUSE_STATUS              0x0039
#define WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_NONNEGO      0x003a
#define WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_1            0x003b
#define WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_2            0x003c
#define WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_3            0x003d
#define WCD9335_CHIP_TIER_CTRL_ANA_WAIT_STATE_CTL        0x003e
#define WCD9335_CHIP_TIER_CTRL_I2C_ACTIVE                0x003f
#define WCD9335_CHIP_TIER_CTRL_PROC1_MON_CTL             0x0041
#define WCD9335_CHIP_TIER_CTRL_PROC1_MON_STATUS          0x0042
#define WCD9335_CHIP_TIER_CTRL_PROC1_MON_CNT_MSB         0x0043
#define WCD9335_CHIP_TIER_CTRL_PROC1_MON_CNT_LSB         0x0044
#define WCD9335_CHIP_TIER_CTRL_PROC2_MON_CTL             0x0045
#define WCD9335_CHIP_TIER_CTRL_PROC2_MON_STATUS          0x0046
#define WCD9335_CHIP_TIER_CTRL_PROC2_MON_CNT_MSB         0x0047
#define WCD9335_CHIP_TIER_CTRL_PROC2_MON_CNT_LSB         0x0048
#define WCD9335_CHIP_TIER_CTRL_PROC3_MON_CTL             0x0049
#define WCD9335_CHIP_TIER_CTRL_PROC3_MON_STATUS          0x004a
#define WCD9335_CHIP_TIER_CTRL_PROC3_MON_CNT_MSB         0x004b
#define WCD9335_CHIP_TIER_CTRL_PROC3_MON_CNT_LSB         0x004c
#define WCD9335_DATA_HUB_DATA_HUB_RX_I2S_CTL             0x0051
#define WCD9335_DATA_HUB_DATA_HUB_TX_I2S_CTL             0x0052
#define WCD9335_DATA_HUB_DATA_HUB_I2S_CLK                0x0053
#define WCD9335_DATA_HUB_DATA_HUB_RX0_INP_CFG            0x0054
#define WCD9335_DATA_HUB_DATA_HUB_RX1_INP_CFG            0x0055
#define WCD9335_DATA_HUB_DATA_HUB_RX2_INP_CFG            0x0056
#define WCD9335_DATA_HUB_DATA_HUB_RX3_INP_CFG            0x0057
#define WCD9335_DATA_HUB_DATA_HUB_RX4_INP_CFG            0x0058
#define WCD9335_DATA_HUB_DATA_HUB_RX5_INP_CFG            0x0059
#define WCD9335_DATA_HUB_DATA_HUB_RX6_INP_CFG            0x005a
#define WCD9335_DATA_HUB_DATA_HUB_RX7_INP_CFG            0x005b
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX0_INP_CFG         0x0061
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX1_INP_CFG         0x0062
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX2_INP_CFG         0x0063
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX3_INP_CFG         0x0064
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX4_INP_CFG         0x0065
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX5_INP_CFG         0x0066
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX6_INP_CFG         0x0067
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX7_INP_CFG         0x0068
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX8_INP_CFG         0x0069
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX9_INP_CFG         0x006a
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX10_INP_CFG        0x006b
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX11_INP_CFG        0x006c
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX13_INP_CFG        0x006e
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX14_INP_CFG        0x006f
#define WCD9335_DATA_HUB_DATA_HUB_SB_TX15_INP_CFG        0x0070
#define WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD0_L_CFG       0x0071
#define WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD0_R_CFG       0x0072
#define WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD1_L_CFG       0x0073
#define WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD1_R_CFG       0x0074
#define WCD9335_DATA_HUB_NATIVE_FIFO_SYNC                0x0075
#define WCD9335_DATA_HUB_NATIVE_FIFO_STATUS              0x007D
#define WCD9335_INTR_CFG                                 0x0081
#define WCD9335_INTR_CLR_COMMIT                          0x0082
#define WCD9335_INTR_PIN1_MASK0                          0x0089
#define WCD9335_INTR_PIN1_MASK1                          0x008a
#define WCD9335_INTR_PIN1_MASK2                          0x008b
#define WCD9335_INTR_PIN1_MASK3                          0x008c
#define WCD9335_INTR_PIN1_STATUS0                        0x0091
#define WCD9335_INTR_PIN1_STATUS1                        0x0092
#define WCD9335_INTR_PIN1_STATUS2                        0x0093
#define WCD9335_INTR_PIN1_STATUS3                        0x0094
#define WCD9335_INTR_PIN1_CLEAR0                         0x0099
#define WCD9335_INTR_PIN1_CLEAR1                         0x009a
#define WCD9335_INTR_PIN1_CLEAR2                         0x009b
#define WCD9335_INTR_PIN1_CLEAR3                         0x009c
#define WCD9335_INTR_PIN2_MASK0                          0x00a1
#define WCD9335_INTR_PIN2_MASK1                          0x00a2
#define WCD9335_INTR_PIN2_MASK2                          0x00a3
#define WCD9335_INTR_PIN2_MASK3                          0x00a4
#define WCD9335_INTR_PIN2_STATUS0                        0x00a9
#define WCD9335_INTR_PIN2_STATUS1                        0x00aa
#define WCD9335_INTR_PIN2_STATUS2                        0x00ab
#define WCD9335_INTR_PIN2_STATUS3                        0x00ac
#define WCD9335_INTR_PIN2_CLEAR0                         0x00b1
#define WCD9335_INTR_PIN2_CLEAR1                         0x00b2
#define WCD9335_INTR_PIN2_CLEAR2                         0x00b3
#define WCD9335_INTR_PIN2_CLEAR3                         0x00b4
#define WCD9335_INTR_LEVEL0                              0x00e1
#define WCD9335_INTR_LEVEL1                              0x00e2
#define WCD9335_INTR_LEVEL2                              0x00e3
#define WCD9335_INTR_LEVEL3                              0x00e4
#define WCD9335_INTR_BYPASS0                             0x00e9
#define WCD9335_INTR_BYPASS1                             0x00ea
#define WCD9335_INTR_BYPASS2                             0x00eb
#define WCD9335_INTR_BYPASS3                             0x00ec
#define WCD9335_INTR_SET0                                0x00f1
#define WCD9335_INTR_SET1                                0x00f2
#define WCD9335_INTR_SET2                                0x00f3
#define WCD9335_INTR_SET3                                0x00f4

/* Page-1 Registers */
#define WCD9335_PAGE1_PAGE_REGISTER                      0x0100
#define WCD9335_CPE_FLL_USER_CTL_0                       0x0101
#define WCD9335_CPE_FLL_USER_CTL_1                       0x0102
#define WCD9335_CPE_FLL_USER_CTL_2                       0x0103
#define WCD9335_CPE_FLL_USER_CTL_3                       0x0104
#define WCD9335_CPE_FLL_USER_CTL_4                       0x0105
#define WCD9335_CPE_FLL_USER_CTL_5                       0x0106
#define WCD9335_CPE_FLL_USER_CTL_6                       0x0107
#define WCD9335_CPE_FLL_USER_CTL_7                       0x0108
#define WCD9335_CPE_FLL_USER_CTL_8                       0x0109
#define WCD9335_CPE_FLL_USER_CTL_9                       0x010a
#define WCD9335_CPE_FLL_L_VAL_CTL_0                      0x010b
#define WCD9335_CPE_FLL_L_VAL_CTL_1                      0x010c
#define WCD9335_CPE_FLL_DSM_FRAC_CTL_0                   0x010d
#define WCD9335_CPE_FLL_DSM_FRAC_CTL_1                   0x010e
#define WCD9335_CPE_FLL_CONFIG_CTL_0                     0x010f
#define WCD9335_CPE_FLL_CONFIG_CTL_1                     0x0110
#define WCD9335_CPE_FLL_CONFIG_CTL_2                     0x0111
#define WCD9335_CPE_FLL_CONFIG_CTL_3                     0x0112
#define WCD9335_CPE_FLL_CONFIG_CTL_4                     0x0113
#define WCD9335_CPE_FLL_TEST_CTL_0                       0x0114
#define WCD9335_CPE_FLL_TEST_CTL_1                       0x0115
#define WCD9335_CPE_FLL_TEST_CTL_2                       0x0116
#define WCD9335_CPE_FLL_TEST_CTL_3                       0x0117
#define WCD9335_CPE_FLL_TEST_CTL_4                       0x0118
#define WCD9335_CPE_FLL_TEST_CTL_5                       0x0119
#define WCD9335_CPE_FLL_TEST_CTL_6                       0x011a
#define WCD9335_CPE_FLL_TEST_CTL_7                       0x011b
#define WCD9335_CPE_FLL_FREQ_CTL_0                       0x011c
#define WCD9335_CPE_FLL_FREQ_CTL_1                       0x011d
#define WCD9335_CPE_FLL_FREQ_CTL_2                       0x011e
#define WCD9335_CPE_FLL_FREQ_CTL_3                       0x011f
#define WCD9335_CPE_FLL_SSC_CTL_0                        0x0120
#define WCD9335_CPE_FLL_SSC_CTL_1                        0x0121
#define WCD9335_CPE_FLL_SSC_CTL_2                        0x0122
#define WCD9335_CPE_FLL_SSC_CTL_3                        0x0123
#define WCD9335_CPE_FLL_FLL_MODE                         0x0124
#define WCD9335_CPE_FLL_STATUS_0                         0x0125
#define WCD9335_CPE_FLL_STATUS_1                         0x0126
#define WCD9335_CPE_FLL_STATUS_2                         0x0127
#define WCD9335_CPE_FLL_STATUS_3                         0x0128
#define WCD9335_I2S_FLL_USER_CTL_0                       0x0141
#define WCD9335_I2S_FLL_USER_CTL_1                       0x0142
#define WCD9335_I2S_FLL_USER_CTL_2                       0x0143
#define WCD9335_I2S_FLL_USER_CTL_3                       0x0144
#define WCD9335_I2S_FLL_USER_CTL_4                       0x0145
#define WCD9335_I2S_FLL_USER_CTL_5                       0x0146
#define WCD9335_I2S_FLL_USER_CTL_6                       0x0147
#define WCD9335_I2S_FLL_USER_CTL_7                       0x0148
#define WCD9335_I2S_FLL_USER_CTL_8                       0x0149
#define WCD9335_I2S_FLL_USER_CTL_9                       0x014a
#define WCD9335_I2S_FLL_L_VAL_CTL_0                      0x014b
#define WCD9335_I2S_FLL_L_VAL_CTL_1                      0x014c
#define WCD9335_I2S_FLL_DSM_FRAC_CTL_0                   0x014d
#define WCD9335_I2S_FLL_DSM_FRAC_CTL_1                   0x014e
#define WCD9335_I2S_FLL_CONFIG_CTL_0                     0x014f
#define WCD9335_I2S_FLL_CONFIG_CTL_1                     0x0150
#define WCD9335_I2S_FLL_CONFIG_CTL_2                     0x0151
#define WCD9335_I2S_FLL_CONFIG_CTL_3                     0x0152
#define WCD9335_I2S_FLL_CONFIG_CTL_4                     0x0153
#define WCD9335_I2S_FLL_TEST_CTL_0                       0x0154
#define WCD9335_I2S_FLL_TEST_CTL_1                       0x0155
#define WCD9335_I2S_FLL_TEST_CTL_2                       0x0156
#define WCD9335_I2S_FLL_TEST_CTL_3                       0x0157
#define WCD9335_I2S_FLL_TEST_CTL_4                       0x0158
#define WCD9335_I2S_FLL_TEST_CTL_5                       0x0159
#define WCD9335_I2S_FLL_TEST_CTL_6                       0x015a
#define WCD9335_I2S_FLL_TEST_CTL_7                       0x015b
#define WCD9335_I2S_FLL_FREQ_CTL_0                       0x015c
#define WCD9335_I2S_FLL_FREQ_CTL_1                       0x015d
#define WCD9335_I2S_FLL_FREQ_CTL_2                       0x015e
#define WCD9335_I2S_FLL_FREQ_CTL_3                       0x015f
#define WCD9335_I2S_FLL_SSC_CTL_0                        0x0160
#define WCD9335_I2S_FLL_SSC_CTL_1                        0x0161
#define WCD9335_I2S_FLL_SSC_CTL_2                        0x0162
#define WCD9335_I2S_FLL_SSC_CTL_3                        0x0163
#define WCD9335_I2S_FLL_FLL_MODE                         0x0164
#define WCD9335_I2S_FLL_STATUS_0                         0x0165
#define WCD9335_I2S_FLL_STATUS_1                         0x0166
#define WCD9335_I2S_FLL_STATUS_2                         0x0167
#define WCD9335_I2S_FLL_STATUS_3                         0x0168
#define WCD9335_SB_FLL_USER_CTL_0                        0x0181
#define WCD9335_SB_FLL_USER_CTL_1                        0x0182
#define WCD9335_SB_FLL_USER_CTL_2                        0x0183
#define WCD9335_SB_FLL_USER_CTL_3                        0x0184
#define WCD9335_SB_FLL_USER_CTL_4                        0x0185
#define WCD9335_SB_FLL_USER_CTL_5                        0x0186
#define WCD9335_SB_FLL_USER_CTL_6                        0x0187
#define WCD9335_SB_FLL_USER_CTL_7                        0x0188
#define WCD9335_SB_FLL_USER_CTL_8                        0x0189
#define WCD9335_SB_FLL_USER_CTL_9                        0x018a
#define WCD9335_SB_FLL_L_VAL_CTL_0                       0x018b
#define WCD9335_SB_FLL_L_VAL_CTL_1                       0x018c
#define WCD9335_SB_FLL_DSM_FRAC_CTL_0                    0x018d
#define WCD9335_SB_FLL_DSM_FRAC_CTL_1                    0x018e
#define WCD9335_SB_FLL_CONFIG_CTL_0                      0x018f
#define WCD9335_SB_FLL_CONFIG_CTL_1                      0x0190
#define WCD9335_SB_FLL_CONFIG_CTL_2                      0x0191
#define WCD9335_SB_FLL_CONFIG_CTL_3                      0x0192
#define WCD9335_SB_FLL_CONFIG_CTL_4                      0x0193
#define WCD9335_SB_FLL_TEST_CTL_0                        0x0194
#define WCD9335_SB_FLL_TEST_CTL_1                        0x0195
#define WCD9335_SB_FLL_TEST_CTL_2                        0x0196
#define WCD9335_SB_FLL_TEST_CTL_3                        0x0197
#define WCD9335_SB_FLL_TEST_CTL_4                        0x0198
#define WCD9335_SB_FLL_TEST_CTL_5                        0x0199
#define WCD9335_SB_FLL_TEST_CTL_6                        0x019a
#define WCD9335_SB_FLL_TEST_CTL_7                        0x019b
#define WCD9335_SB_FLL_FREQ_CTL_0                        0x019c
#define WCD9335_SB_FLL_FREQ_CTL_1                        0x019d
#define WCD9335_SB_FLL_FREQ_CTL_2                        0x019e
#define WCD9335_SB_FLL_FREQ_CTL_3                        0x019f
#define WCD9335_SB_FLL_SSC_CTL_0                         0x01a0
#define WCD9335_SB_FLL_SSC_CTL_1                         0x01a1
#define WCD9335_SB_FLL_SSC_CTL_2                         0x01a2
#define WCD9335_SB_FLL_SSC_CTL_3                         0x01a3
#define WCD9335_SB_FLL_FLL_MODE                          0x01a4
#define WCD9335_SB_FLL_STATUS_0                          0x01a5
#define WCD9335_SB_FLL_STATUS_1                          0x01a6
#define WCD9335_SB_FLL_STATUS_2                          0x01a7
#define WCD9335_SB_FLL_STATUS_3                          0x01a8

/* Page-2 Registers */
#define WCD9335_PAGE2_PAGE_REGISTER                      0x0200
#define WCD9335_CPE_SS_MEM_PTR_0                         0x0201
#define WCD9335_CPE_SS_MEM_PTR_1                         0x0202
#define WCD9335_CPE_SS_MEM_PTR_2                         0x0203
#define WCD9335_CPE_SS_MEM_CTRL                          0x0205
#define WCD9335_CPE_SS_MEM_BANK_0                        0x0206
#define WCD9335_CPE_SS_MEM_BANK_1                        0x0207
#define WCD9335_CPE_SS_MEM_BANK_2                        0x0208
#define WCD9335_CPE_SS_MEM_BANK_3                        0x0209
#define WCD9335_CPE_SS_MEM_BANK_4                        0x020a
#define WCD9335_CPE_SS_MEM_BANK_5                        0x020b
#define WCD9335_CPE_SS_MEM_BANK_6                        0x020c
#define WCD9335_CPE_SS_MEM_BANK_7                        0x020d
#define WCD9335_CPE_SS_MEM_BANK_8                        0x020e
#define WCD9335_CPE_SS_MEM_BANK_9                        0x020f
#define WCD9335_CPE_SS_MEM_BANK_10                       0x0210
#define WCD9335_CPE_SS_MEM_BANK_11                       0x0211
#define WCD9335_CPE_SS_MEM_BANK_12                       0x0212
#define WCD9335_CPE_SS_MEM_BANK_13                       0x0213
#define WCD9335_CPE_SS_MEM_BANK_14                       0x0214
#define WCD9335_CPE_SS_MEM_BANK_15                       0x0215
#define WCD9335_CPE_SS_INBOX1_TRG                        0x0216
#define WCD9335_CPE_SS_INBOX2_TRG                        0x0217
#define WCD9335_CPE_SS_INBOX1_0                          0x0218
#define WCD9335_CPE_SS_INBOX1_1                          0x0219
#define WCD9335_CPE_SS_INBOX1_2                          0x021a
#define WCD9335_CPE_SS_INBOX1_3                          0x021b
#define WCD9335_CPE_SS_INBOX1_4                          0x021c
#define WCD9335_CPE_SS_INBOX1_5                          0x021d
#define WCD9335_CPE_SS_INBOX1_6                          0x021e
#define WCD9335_CPE_SS_INBOX1_7                          0x021f
#define WCD9335_CPE_SS_INBOX1_8                          0x0220
#define WCD9335_CPE_SS_INBOX1_9                          0x0221
#define WCD9335_CPE_SS_INBOX1_10                         0x0222
#define WCD9335_CPE_SS_INBOX1_11                         0x0223
#define WCD9335_CPE_SS_INBOX1_12                         0x0224
#define WCD9335_CPE_SS_INBOX1_13                         0x0225
#define WCD9335_CPE_SS_INBOX1_14                         0x0226
#define WCD9335_CPE_SS_INBOX1_15                         0x0227
#define WCD9335_CPE_SS_OUTBOX1_0                         0x0228
#define WCD9335_CPE_SS_OUTBOX1_1                         0x0229
#define WCD9335_CPE_SS_OUTBOX1_2                         0x022a
#define WCD9335_CPE_SS_OUTBOX1_3                         0x022b
#define WCD9335_CPE_SS_OUTBOX1_4                         0x022c
#define WCD9335_CPE_SS_OUTBOX1_5                         0x022d
#define WCD9335_CPE_SS_OUTBOX1_6                         0x022e
#define WCD9335_CPE_SS_OUTBOX1_7                         0x022f
#define WCD9335_CPE_SS_OUTBOX1_8                         0x0230
#define WCD9335_CPE_SS_OUTBOX1_9                         0x0231
#define WCD9335_CPE_SS_OUTBOX1_10                        0x0232
#define WCD9335_CPE_SS_OUTBOX1_11                        0x0233
#define WCD9335_CPE_SS_OUTBOX1_12                        0x0234
#define WCD9335_CPE_SS_OUTBOX1_13                        0x0235
#define WCD9335_CPE_SS_OUTBOX1_14                        0x0236
#define WCD9335_CPE_SS_OUTBOX1_15                        0x0237
#define WCD9335_CPE_SS_INBOX2_0                          0x0238
#define WCD9335_CPE_SS_INBOX2_1                          0x0239
#define WCD9335_CPE_SS_INBOX2_2                          0x023a
#define WCD9335_CPE_SS_INBOX2_3                          0x023b
#define WCD9335_CPE_SS_INBOX2_4                          0x023c
#define WCD9335_CPE_SS_INBOX2_5                          0x023d
#define WCD9335_CPE_SS_INBOX2_6                          0x023e
#define WCD9335_CPE_SS_INBOX2_7                          0x023f
#define WCD9335_CPE_SS_INBOX2_8                          0x0240
#define WCD9335_CPE_SS_INBOX2_9                          0x0241
#define WCD9335_CPE_SS_INBOX2_10                         0x0242
#define WCD9335_CPE_SS_INBOX2_11                         0x0243
#define WCD9335_CPE_SS_INBOX2_12                         0x0244
#define WCD9335_CPE_SS_INBOX2_13                         0x0245
#define WCD9335_CPE_SS_INBOX2_14                         0x0246
#define WCD9335_CPE_SS_INBOX2_15                         0x0247
#define WCD9335_CPE_SS_OUTBOX2_0                         0x0248
#define WCD9335_CPE_SS_OUTBOX2_1                         0x0249
#define WCD9335_CPE_SS_OUTBOX2_2                         0x024a
#define WCD9335_CPE_SS_OUTBOX2_3                         0x024b
#define WCD9335_CPE_SS_OUTBOX2_4                         0x024c
#define WCD9335_CPE_SS_OUTBOX2_5                         0x024d
#define WCD9335_CPE_SS_OUTBOX2_6                         0x024e
#define WCD9335_CPE_SS_OUTBOX2_7                         0x024f
#define WCD9335_CPE_SS_OUTBOX2_8                         0x0250
#define WCD9335_CPE_SS_OUTBOX2_9                         0x0251
#define WCD9335_CPE_SS_OUTBOX2_10                        0x0252
#define WCD9335_CPE_SS_OUTBOX2_11                        0x0253
#define WCD9335_CPE_SS_OUTBOX2_12                        0x0254
#define WCD9335_CPE_SS_OUTBOX2_13                        0x0255
#define WCD9335_CPE_SS_OUTBOX2_14                        0x0256
#define WCD9335_CPE_SS_OUTBOX2_15                        0x0257
#define WCD9335_CPE_SS_OUTBOX1_ACK                       0x0258
#define WCD9335_CPE_SS_OUTBOX2_ACK                       0x0259
#define WCD9335_CPE_SS_EC_BUF_INT_PERIOD                 0x025a
#define WCD9335_CPE_SS_US_BUF_INT_PERIOD                 0x025b
#define WCD9335_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD         0x025c
#define WCD9335_CPE_SS_CFG                               0x025d
#define WCD9335_CPE_SS_US_EC_MUX_CFG                     0x025e
#define WCD9335_CPE_SS_MAD_CTL                           0x025f
#define WCD9335_CPE_SS_CPAR_CTL                          0x0260
#define WCD9335_CPE_SS_TX_PP_BUF_INT_PERIOD              0x0261
#define WCD9335_CPE_SS_TX_PP_CFG                         0x0262
#define WCD9335_CPE_SS_DMIC0_CTL                         0x0263
#define WCD9335_CPE_SS_DMIC1_CTL                         0x0264
#define WCD9335_CPE_SS_DMIC2_CTL                         0x0265
#define WCD9335_CPE_SS_DMIC_CFG                          0x0266
#define WCD9335_CPE_SS_SVA_CFG                           0x0267
#define WCD9335_CPE_SS_CPAR_CFG                          0x0271
#define WCD9335_CPE_SS_WDOG_CFG                          0x0272
#define WCD9335_CPE_SS_BACKUP_INT                        0x0273
#define WCD9335_CPE_SS_STATUS                            0x0274
#define WCD9335_CPE_SS_CPE_OCD_CFG                       0x0275
#define WCD9335_CPE_SS_SS_ERROR_INT_MASK                 0x0276
#define WCD9335_CPE_SS_SS_ERROR_INT_STATUS               0x0277
#define WCD9335_CPE_SS_SS_ERROR_INT_CLEAR                0x0278
#define WCD9335_SOC_MAD_MAIN_CTL_1                       0x0281
#define WCD9335_SOC_MAD_MAIN_CTL_2                       0x0282
#define WCD9335_SOC_MAD_AUDIO_CTL_1                      0x0283
#define WCD9335_SOC_MAD_AUDIO_CTL_2                      0x0284
#define WCD9335_SOC_MAD_AUDIO_CTL_3                      0x0285
#define WCD9335_SOC_MAD_AUDIO_CTL_4                      0x0286
#define WCD9335_SOC_MAD_AUDIO_CTL_5                      0x0287
#define WCD9335_SOC_MAD_AUDIO_CTL_6                      0x0288
#define WCD9335_SOC_MAD_AUDIO_CTL_7                      0x0289
#define WCD9335_SOC_MAD_AUDIO_CTL_8                      0x028a
#define WCD9335_SOC_MAD_AUDIO_IIR_CTL_PTR                0x028b
#define WCD9335_SOC_MAD_AUDIO_IIR_CTL_VAL                0x028c
#define WCD9335_SOC_MAD_ULTR_CTL_1                       0x028d
#define WCD9335_SOC_MAD_ULTR_CTL_2                       0x028e
#define WCD9335_SOC_MAD_ULTR_CTL_3                       0x028f
#define WCD9335_SOC_MAD_ULTR_CTL_4                       0x0290
#define WCD9335_SOC_MAD_ULTR_CTL_5                       0x0291
#define WCD9335_SOC_MAD_ULTR_CTL_6                       0x0292
#define WCD9335_SOC_MAD_ULTR_CTL_7                       0x0293
#define WCD9335_SOC_MAD_BEACON_CTL_1                     0x0294
#define WCD9335_SOC_MAD_BEACON_CTL_2                     0x0295
#define WCD9335_SOC_MAD_BEACON_CTL_3                     0x0296
#define WCD9335_SOC_MAD_BEACON_CTL_4                     0x0297
#define WCD9335_SOC_MAD_BEACON_CTL_5                     0x0298
#define WCD9335_SOC_MAD_BEACON_CTL_6                     0x0299
#define WCD9335_SOC_MAD_BEACON_CTL_7                     0x029a
#define WCD9335_SOC_MAD_BEACON_CTL_8                     0x029b
#define WCD9335_SOC_MAD_BEACON_IIR_CTL_PTR               0x029c
#define WCD9335_SOC_MAD_BEACON_IIR_CTL_VAL               0x029d
#define WCD9335_SOC_MAD_INP_SEL                          0x029e

/* Page-6 Registers */
#define WCD9335_PAGE6_PAGE_REGISTER                      0x0600
#define WCD9335_ANA_BIAS                                 0x0601
#define WCD9335_ANA_CLK_TOP                              0x0602
#define WCD9335_ANA_RCO                                  0x0603
#define WCD9335_ANA_BUCK_VOUT_A                          0x0604
#define WCD9335_ANA_BUCK_VOUT_D                          0x0605
#define WCD9335_ANA_BUCK_CTL                             0x0606
#define WCD9335_ANA_BUCK_STATUS                          0x0607
#define WCD9335_ANA_RX_SUPPLIES                          0x0608
#define WCD9335_ANA_HPH                                  0x0609
#define WCD9335_ANA_EAR                                  0x060a
#define WCD9335_ANA_LO_1_2                               0x060b
#define WCD9335_ANA_LO_3_4                               0x060c
#define WCD9335_ANA_MAD_SETUP                            0x060d
#define WCD9335_ANA_AMIC1                                0x060e
#define WCD9335_ANA_AMIC2                                0x060f
#define WCD9335_ANA_AMIC3                                0x0610
#define WCD9335_ANA_AMIC4                                0x0611
#define WCD9335_ANA_AMIC5                                0x0612
#define WCD9335_ANA_AMIC6                                0x0613
#define WCD9335_ANA_MBHC_MECH                            0x0614
#define WCD9335_ANA_MBHC_ELECT                           0x0615
#define WCD9335_ANA_MBHC_ZDET                            0x0616
#define WCD9335_ANA_MBHC_RESULT_1                        0x0617
#define WCD9335_ANA_MBHC_RESULT_2                        0x0618
#define WCD9335_ANA_MBHC_RESULT_3                        0x0619
#define WCD9335_ANA_MBHC_BTN0                            0x061a
#define WCD9335_ANA_MBHC_BTN1                            0x061b
#define WCD9335_ANA_MBHC_BTN2                            0x061c
#define WCD9335_ANA_MBHC_BTN3                            0x061d
#define WCD9335_ANA_MBHC_BTN4                            0x061e
#define WCD9335_ANA_MBHC_BTN5                            0x061f
#define WCD9335_ANA_MBHC_BTN6                            0x0620
#define WCD9335_ANA_MBHC_BTN7                            0x0621
#define WCD9335_ANA_MICB1                                0x0622
#define WCD9335_ANA_MICB2                                0x0623
#define WCD9335_ANA_MICB2_RAMP                           0x0624
#define WCD9335_ANA_MICB3                                0x0625
#define WCD9335_ANA_MICB4                                0x0626
#define WCD9335_ANA_VBADC                                0x0627
#define WCD9335_BIAS_CTL                                 0x0628
#define WCD9335_BIAS_VBG_FINE_ADJ                        0x0629
#define WCD9335_CLOCK_TEST_CTL                           0x062d
#define WCD9335_RCO_CTRL_1                               0x062e
#define WCD9335_RCO_CTRL_2                               0x062f
#define WCD9335_RCO_CAL                                  0x0630
#define WCD9335_RCO_CAL_1                                0x0631
#define WCD9335_RCO_CAL_2                                0x0632
#define WCD9335_RCO_TEST_CTRL                            0x0633
#define WCD9335_RCO_CAL_OUT_1                            0x0634
#define WCD9335_RCO_CAL_OUT_2                            0x0635
#define WCD9335_RCO_CAL_OUT_3                            0x0636
#define WCD9335_RCO_CAL_OUT_4                            0x0637
#define WCD9335_RCO_CAL_OUT_5                            0x0638
#define WCD9335_SIDO_SIDO_MODE_1                         0x063a
#define WCD9335_SIDO_SIDO_MODE_2                         0x063b
#define WCD9335_SIDO_SIDO_MODE_3                         0x063c
#define WCD9335_SIDO_SIDO_MODE_4                         0x063d
#define WCD9335_SIDO_SIDO_VCL_1                          0x063e
#define WCD9335_SIDO_SIDO_VCL_2                          0x063f
#define WCD9335_SIDO_SIDO_VCL_3                          0x0640
#define WCD9335_SIDO_SIDO_CCL_1                          0x0641
#define WCD9335_SIDO_SIDO_CCL_2                          0x0642
#define WCD9335_SIDO_SIDO_CCL_3                          0x0643
#define WCD9335_SIDO_SIDO_CCL_4                          0x0644
#define WCD9335_SIDO_SIDO_CCL_5                          0x0645
#define WCD9335_SIDO_SIDO_CCL_6                          0x0646
#define WCD9335_SIDO_SIDO_CCL_7                          0x0647
#define WCD9335_SIDO_SIDO_CCL_8                          0x0648
#define WCD9335_SIDO_SIDO_CCL_9                          0x0649
#define WCD9335_SIDO_SIDO_CCL_10                         0x064a
#define WCD9335_SIDO_SIDO_FILTER_1                       0x064b
#define WCD9335_SIDO_SIDO_FILTER_2                       0x064c
#define WCD9335_SIDO_SIDO_DRIVER_1                       0x064d
#define WCD9335_SIDO_SIDO_DRIVER_2                       0x064e
#define WCD9335_SIDO_SIDO_DRIVER_3                       0x064f
#define WCD9335_SIDO_SIDO_CAL_CODE_EXT_1                 0x0650
#define WCD9335_SIDO_SIDO_CAL_CODE_EXT_2                 0x0651
#define WCD9335_SIDO_SIDO_CAL_CODE_OUT_1                 0x0652
#define WCD9335_SIDO_SIDO_CAL_CODE_OUT_2                 0x0653
#define WCD9335_SIDO_SIDO_TEST_1                         0x0654
#define WCD9335_SIDO_SIDO_TEST_2                         0x0655
#define WCD9335_MBHC_CTL_1                               0x0656
#define WCD9335_MBHC_CTL_2                               0x0657
#define WCD9335_MBHC_PLUG_DETECT_CTL                     0x0658
#define WCD9335_MBHC_ZDET_ANA_CTL                        0x0659
#define WCD9335_MBHC_ZDET_RAMP_CTL                       0x065a
#define WCD9335_MBHC_FSM_DEBUG                           0x065b /* v1.x */
#define WCD9335_MBHC_FSM_STATUS                          0x065b /* v2.0 */
#define WCD9335_MBHC_TEST_CTL                            0x065c
#define WCD9335_VBADC_SUBBLOCK_EN                        0x065d
#define WCD9335_VBADC_IBIAS_FE                           0x065e
#define WCD9335_VBADC_BIAS_ADC                           0x065f
#define WCD9335_VBADC_FE_CTRL                            0x0660
#define WCD9335_VBADC_ADC_REF                            0x0661
#define WCD9335_VBADC_ADC_IO                             0x0662
#define WCD9335_VBADC_ADC_SAR                            0x0663
#define WCD9335_VBADC_DEBUG                              0x0664
#define WCD9335_VBADC_ADC_DOUTMSB                        0x0665
#define WCD9335_VBADC_ADC_DOUTLSB                        0x0666
#define WCD9335_LDOH_MODE                                0x0667
#define WCD9335_LDOH_BIAS                                0x0668
#define WCD9335_LDOH_STB_LOADS                           0x0669
#define WCD9335_LDOH_SLOWRAMP                            0x066a
#define WCD9335_MICB1_TEST_CTL_1                         0x066b
#define WCD9335_MICB1_TEST_CTL_2                         0x066c
#define WCD9335_MICB1_TEST_CTL_3                         0x066d
#define WCD9335_MICB2_TEST_CTL_1                         0x066e
#define WCD9335_MICB2_TEST_CTL_2                         0x066f
#define WCD9335_MICB2_TEST_CTL_3                         0x0670
#define WCD9335_MICB3_TEST_CTL_1                         0x0671
#define WCD9335_MICB3_TEST_CTL_2                         0x0672
#define WCD9335_MICB3_TEST_CTL_3                         0x0673
#define WCD9335_MICB4_TEST_CTL_1                         0x0674
#define WCD9335_MICB4_TEST_CTL_2                         0x0675
#define WCD9335_MICB4_TEST_CTL_3                         0x0676
#define WCD9335_TX_COM_ADC_VCM                           0x0677
#define WCD9335_TX_COM_BIAS_ATEST                        0x0678
#define WCD9335_TX_COM_ADC_INT1_IB                       0x0679
#define WCD9335_TX_COM_ADC_INT2_IB                       0x067a
#define WCD9335_TX_COM_TXFE_DIV_CTL                      0x067b
#define WCD9335_TX_COM_TXFE_DIV_START                    0x067c
#define WCD9335_TX_COM_TXFE_DIV_STOP_9P6M                0x067d
#define WCD9335_TX_COM_TXFE_DIV_STOP_12P288M             0x067e
#define WCD9335_TX_1_2_TEST_EN                           0x067f
#define WCD9335_TX_1_2_ADC_IB                            0x0680
#define WCD9335_TX_1_2_ATEST_REFCTL                      0x0681
#define WCD9335_TX_1_2_TEST_CTL                          0x0682
#define WCD9335_TX_1_2_TEST_BLK_EN                       0x0683
#define WCD9335_TX_1_2_TXFE_CLKDIV                       0x0684
#define WCD9335_TX_1_2_SAR1_ERR                          0x0685
#define WCD9335_TX_1_2_SAR2_ERR                          0x0686
#define WCD9335_TX_3_4_TEST_EN                           0x0687
#define WCD9335_TX_3_4_ADC_IB                            0x0688
#define WCD9335_TX_3_4_ATEST_REFCTL                      0x0689
#define WCD9335_TX_3_4_TEST_CTL                          0x068a
#define WCD9335_TX_3_4_TEST_BLK_EN                       0x068b
#define WCD9335_TX_3_4_TXFE_CLKDIV                       0x068c
#define WCD9335_TX_3_4_SAR1_ERR                          0x068d
#define WCD9335_TX_3_4_SAR2_ERR                          0x068e
#define WCD9335_TX_5_6_TEST_EN                           0x068f
#define WCD9335_TX_5_6_ADC_IB                            0x0690
#define WCD9335_TX_5_6_ATEST_REFCTL                      0x0691
#define WCD9335_TX_5_6_TEST_CTL                          0x0692
#define WCD9335_TX_5_6_TEST_BLK_EN                       0x0693
#define WCD9335_TX_5_6_TXFE_CLKDIV                       0x0694
#define WCD9335_TX_5_6_SAR1_ERR                          0x0695
#define WCD9335_TX_5_6_SAR2_ERR                          0x0696
#define WCD9335_CLASSH_MODE_1                            0x0697
#define WCD9335_CLASSH_MODE_2                            0x0698
#define WCD9335_CLASSH_MODE_3                            0x0699
#define WCD9335_CLASSH_CTRL_VCL_1                        0x069a
#define WCD9335_CLASSH_CTRL_VCL_2                        0x069b
#define WCD9335_CLASSH_CTRL_CCL_1                        0x069c
#define WCD9335_CLASSH_CTRL_CCL_2                        0x069d
#define WCD9335_CLASSH_CTRL_CCL_3                        0x069e
#define WCD9335_CLASSH_CTRL_CCL_4                        0x069f
#define WCD9335_CLASSH_CTRL_CCL_5                        0x06a0
#define WCD9335_CLASSH_BUCK_TMUX_A_D                     0x06a1
#define WCD9335_CLASSH_BUCK_SW_DRV_CNTL                  0x06a2
#define WCD9335_CLASSH_SPARE                             0x06a3
#define WCD9335_FLYBACK_EN                               0x06a4
#define WCD9335_FLYBACK_VNEG_CTRL_1                      0x06a5
#define WCD9335_FLYBACK_VNEG_CTRL_2                      0x06a6
#define WCD9335_FLYBACK_VNEG_CTRL_3                      0x06a7
#define WCD9335_FLYBACK_VNEG_CTRL_4                      0x06a8
#define WCD9335_FLYBACK_VNEG_CTRL_5                      0x06a9
#define WCD9335_FLYBACK_VNEG_CTRL_6                      0x06aa
#define WCD9335_FLYBACK_VNEG_CTRL_7                      0x06ab
#define WCD9335_FLYBACK_VNEG_CTRL_8                      0x06ac
#define WCD9335_FLYBACK_VNEG_CTRL_9                      0x06ad
#define WCD9335_FLYBACK_VNEG_DAC_CTRL_1                  0x06ae
#define WCD9335_FLYBACK_VNEG_DAC_CTRL_2                  0x06af
#define WCD9335_FLYBACK_VNEG_DAC_CTRL_3                  0x06b0
#define WCD9335_FLYBACK_VNEG_DAC_CTRL_4                  0x06b1 /* v1.x */
#define WCD9335_FLYBACK_CTRL_1                           0x06b1 /* v2.0 */
#define WCD9335_FLYBACK_TEST_CTL                         0x06b2
#define WCD9335_RX_AUX_SW_CTL                            0x06b3
#define WCD9335_RX_PA_AUX_IN_CONN                        0x06b4
#define WCD9335_RX_TIMER_DIV                             0x06b5
#define WCD9335_RX_OCP_CTL                               0x06b6
#define WCD9335_RX_OCP_COUNT                             0x06b7
#define WCD9335_RX_BIAS_EAR_DAC                          0x06b8
#define WCD9335_RX_BIAS_EAR_AMP                          0x06b9
#define WCD9335_RX_BIAS_HPH_LDO                          0x06ba
#define WCD9335_RX_BIAS_HPH_PA                           0x06bb
#define WCD9335_RX_BIAS_HPH_RDACBUFF_CNP2                0x06bc
#define WCD9335_RX_BIAS_HPH_RDAC_LDO                     0x06bd
#define WCD9335_RX_BIAS_HPH_CNP1                         0x06be
#define WCD9335_RX_BIAS_HPH_LOWPOWER                     0x06bf
#define WCD9335_RX_BIAS_DIFFLO_PA                        0x06c0
#define WCD9335_RX_BIAS_DIFFLO_REF                       0x06c1
#define WCD9335_RX_BIAS_DIFFLO_LDO                       0x06c2
#define WCD9335_RX_BIAS_SELO_DAC_PA                      0x06c3
#define WCD9335_RX_BIAS_BUCK_RST                         0x06c4
#define WCD9335_RX_BIAS_BUCK_VREF_ERRAMP                 0x06c5
#define WCD9335_RX_BIAS_FLYB_ERRAMP                      0x06c6
#define WCD9335_RX_BIAS_FLYB_BUFF                        0x06c7
#define WCD9335_RX_BIAS_FLYB_MID_RST                     0x06c8
#define WCD9335_HPH_L_STATUS                             0x06c9
#define WCD9335_HPH_R_STATUS                             0x06ca
#define WCD9335_HPH_CNP_EN                               0x06cb
#define WCD9335_HPH_CNP_WG_CTL                           0x06cc
#define WCD9335_HPH_CNP_WG_TIME                          0x06cd
#define WCD9335_HPH_OCP_CTL                              0x06ce
#define WCD9335_HPH_AUTO_CHOP                            0x06cf
#define WCD9335_HPH_CHOP_CTL                             0x06d0
#define WCD9335_HPH_PA_CTL1                              0x06d1
#define WCD9335_HPH_PA_CTL2                              0x06d2
#define WCD9335_HPH_L_EN                                 0x06d3
#define WCD9335_HPH_L_TEST                               0x06d4
#define WCD9335_HPH_L_ATEST                              0x06d5
#define WCD9335_HPH_R_EN                                 0x06d6
#define WCD9335_HPH_R_TEST                               0x06d7
#define WCD9335_HPH_R_ATEST                              0x06d8
#define WCD9335_HPH_RDAC_CLK_CTL1                        0x06d9
#define WCD9335_HPH_RDAC_CLK_CTL2                        0x06da
#define WCD9335_HPH_RDAC_LDO_CTL                         0x06db
#define WCD9335_HPH_RDAC_CHOP_CLK_LP_CTL                 0x06dc
#define WCD9335_HPH_REFBUFF_UHQA_CTL                     0x06dd
#define WCD9335_HPH_REFBUFF_LP_CTL                       0x06de
#define WCD9335_HPH_L_DAC_CTL                            0x06df
#define WCD9335_HPH_R_DAC_CTL                            0x06e0
#define WCD9335_EAR_EN_REG                               0x06e1
#define WCD9335_EAR_CMBUFF                               0x06e2
#define WCD9335_EAR_ICTL                                 0x06e3
#define WCD9335_EAR_EN_DBG_CTL                           0x06e4
#define WCD9335_EAR_CNP                                  0x06e5
#define WCD9335_EAR_DAC_CTL_ATEST                        0x06e6
#define WCD9335_EAR_STATUS_REG                           0x06e7
#define WCD9335_EAR_OUT_SHORT                            0x06e8
#define WCD9335_DIFF_LO_MISC                             0x06e9
#define WCD9335_DIFF_LO_LO2_COMPANDER                    0x06ea
#define WCD9335_DIFF_LO_LO1_COMPANDER                    0x06eb
#define WCD9335_DIFF_LO_COMMON                           0x06ec
#define WCD9335_DIFF_LO_BYPASS_EN                        0x06ed
#define WCD9335_DIFF_LO_CNP                              0x06ee
#define WCD9335_DIFF_LO_CORE_OUT_PROG                    0x06ef
#define WCD9335_DIFF_LO_LDO_OUT_PROG                     0x06f0
#define WCD9335_DIFF_LO_COM_SWCAP_REFBUF_FREQ            0x06f1
#define WCD9335_DIFF_LO_COM_PA_FREQ                      0x06f2
#define WCD9335_DIFF_LO_RESERVED_REG                     0x06f3
#define WCD9335_DIFF_LO_LO1_STATUS_1                     0x06f4
#define WCD9335_DIFF_LO_LO1_STATUS_2                     0x06f5
#define WCD9335_SE_LO_COM1                               0x06f6
#define WCD9335_SE_LO_COM2                               0x06f7
#define WCD9335_SE_LO_LO3_GAIN                           0x06f8
#define WCD9335_SE_LO_LO3_CTRL                           0x06f9
#define WCD9335_SE_LO_LO4_GAIN                           0x06fa
#define WCD9335_SE_LO_LO4_CTRL                           0x06fb
#define WCD9335_SE_LO_LO3_STATUS                         0x06fe
#define WCD9335_SE_LO_LO4_STATUS                         0x06ff

/* Page-10 Registers */
#define WCD9335_PAGE10_PAGE_REGISTER                     0x0a00
#define WCD9335_CDC_ANC0_CLK_RESET_CTL                   0x0a01
#define WCD9335_CDC_ANC0_MODE_1_CTL                      0x0a02
#define WCD9335_CDC_ANC0_MODE_2_CTL                      0x0a03
#define WCD9335_CDC_ANC0_FF_SHIFT                        0x0a04
#define WCD9335_CDC_ANC0_FB_SHIFT                        0x0a05
#define WCD9335_CDC_ANC0_LPF_FF_A_CTL                    0x0a06
#define WCD9335_CDC_ANC0_LPF_FF_B_CTL                    0x0a07
#define WCD9335_CDC_ANC0_LPF_FB_CTL                      0x0a08
#define WCD9335_CDC_ANC0_SMLPF_CTL                       0x0a09
#define WCD9335_CDC_ANC0_DCFLT_SHIFT_CTL                 0x0a0a
#define WCD9335_CDC_ANC0_IIR_ADAPT_CTL                   0x0a0b
#define WCD9335_CDC_ANC0_IIR_COEFF_1_CTL                 0x0a0c
#define WCD9335_CDC_ANC0_IIR_COEFF_2_CTL                 0x0a0d
#define WCD9335_CDC_ANC0_FF_A_GAIN_CTL                   0x0a0e
#define WCD9335_CDC_ANC0_FF_B_GAIN_CTL                   0x0a0f
#define WCD9335_CDC_ANC0_FB_GAIN_CTL                     0x0a10
#define WCD9335_CDC_ANC1_CLK_RESET_CTL                   0x0a19
#define WCD9335_CDC_ANC1_MODE_1_CTL                      0x0a1a
#define WCD9335_CDC_ANC1_MODE_2_CTL                      0x0a1b
#define WCD9335_CDC_ANC1_FF_SHIFT                        0x0a1c
#define WCD9335_CDC_ANC1_FB_SHIFT                        0x0a1d
#define WCD9335_CDC_ANC1_LPF_FF_A_CTL                    0x0a1e
#define WCD9335_CDC_ANC1_LPF_FF_B_CTL                    0x0a1f
#define WCD9335_CDC_ANC1_LPF_FB_CTL                      0x0a20
#define WCD9335_CDC_ANC1_SMLPF_CTL                       0x0a21
#define WCD9335_CDC_ANC1_DCFLT_SHIFT_CTL                 0x0a22
#define WCD9335_CDC_ANC1_IIR_ADAPT_CTL                   0x0a23
#define WCD9335_CDC_ANC1_IIR_COEFF_1_CTL                 0x0a24
#define WCD9335_CDC_ANC1_IIR_COEFF_2_CTL                 0x0a25
#define WCD9335_CDC_ANC1_FF_A_GAIN_CTL                   0x0a26
#define WCD9335_CDC_ANC1_FF_B_GAIN_CTL                   0x0a27
#define WCD9335_CDC_ANC1_FB_GAIN_CTL                     0x0a28
#define WCD9335_CDC_TX0_TX_PATH_CTL                      0x0a31
#define WCD9335_CDC_TX0_TX_PATH_CFG0                     0x0a32
#define WCD9335_CDC_TX0_TX_PATH_CFG1                     0x0a33
#define WCD9335_CDC_TX0_TX_VOL_CTL                       0x0a34
#define WCD9335_CDC_TX0_TX_PATH_192_CTL                  0x0a35
#define WCD9335_CDC_TX0_TX_PATH_192_CFG                  0x0a36
#define WCD9335_CDC_TX0_TX_PATH_SEC0                     0x0a37
#define WCD9335_CDC_TX0_TX_PATH_SEC1                     0x0a38
#define WCD9335_CDC_TX0_TX_PATH_SEC2                     0x0a39
#define WCD9335_CDC_TX0_TX_PATH_SEC3                     0x0a3a
#define WCD9335_CDC_TX0_TX_PATH_SEC4                     0x0a3b
#define WCD9335_CDC_TX0_TX_PATH_SEC5                     0x0a3c
#define WCD9335_CDC_TX0_TX_PATH_SEC6                     0x0a3d
#define WCD9335_CDC_TX0_TX_PATH_SEC7                     0x0a3e
#define WCD9335_CDC_TX1_TX_PATH_CTL                      0x0a41
#define WCD9335_CDC_TX1_TX_PATH_CFG0                     0x0a42
#define WCD9335_CDC_TX1_TX_PATH_CFG1                     0x0a43
#define WCD9335_CDC_TX1_TX_VOL_CTL                       0x0a44
#define WCD9335_CDC_TX1_TX_PATH_192_CTL                  0x0a45
#define WCD9335_CDC_TX1_TX_PATH_192_CFG                  0x0a46
#define WCD9335_CDC_TX1_TX_PATH_SEC0                     0x0a47
#define WCD9335_CDC_TX1_TX_PATH_SEC1                     0x0a48
#define WCD9335_CDC_TX1_TX_PATH_SEC2                     0x0a49
#define WCD9335_CDC_TX1_TX_PATH_SEC3                     0x0a4a
#define WCD9335_CDC_TX1_TX_PATH_SEC4                     0x0a4b
#define WCD9335_CDC_TX1_TX_PATH_SEC5                     0x0a4c
#define WCD9335_CDC_TX1_TX_PATH_SEC6                     0x0a4d
#define WCD9335_CDC_TX2_TX_PATH_CTL                      0x0a51
#define WCD9335_CDC_TX2_TX_PATH_CFG0                     0x0a52
#define WCD9335_CDC_TX2_TX_PATH_CFG1                     0x0a53
#define WCD9335_CDC_TX2_TX_VOL_CTL                       0x0a54
#define WCD9335_CDC_TX2_TX_PATH_192_CTL                  0x0a55
#define WCD9335_CDC_TX2_TX_PATH_192_CFG                  0x0a56
#define WCD9335_CDC_TX2_TX_PATH_SEC0                     0x0a57
#define WCD9335_CDC_TX2_TX_PATH_SEC1                     0x0a58
#define WCD9335_CDC_TX2_TX_PATH_SEC2                     0x0a59
#define WCD9335_CDC_TX2_TX_PATH_SEC3                     0x0a5a
#define WCD9335_CDC_TX2_TX_PATH_SEC4                     0x0a5b
#define WCD9335_CDC_TX2_TX_PATH_SEC5                     0x0a5c
#define WCD9335_CDC_TX2_TX_PATH_SEC6                     0x0a5d
#define WCD9335_CDC_TX3_TX_PATH_CTL                      0x0a61
#define WCD9335_CDC_TX3_TX_PATH_CFG0                     0x0a62
#define WCD9335_CDC_TX3_TX_PATH_CFG1                     0x0a63
#define WCD9335_CDC_TX3_TX_VOL_CTL                       0x0a64
#define WCD9335_CDC_TX3_TX_PATH_192_CTL                  0x0a65
#define WCD9335_CDC_TX3_TX_PATH_192_CFG                  0x0a66
#define WCD9335_CDC_TX3_TX_PATH_SEC0                     0x0a67
#define WCD9335_CDC_TX3_TX_PATH_SEC1                     0x0a68
#define WCD9335_CDC_TX3_TX_PATH_SEC2                     0x0a69
#define WCD9335_CDC_TX3_TX_PATH_SEC3                     0x0a6a
#define WCD9335_CDC_TX3_TX_PATH_SEC4                     0x0a6b
#define WCD9335_CDC_TX3_TX_PATH_SEC5                     0x0a6c
#define WCD9335_CDC_TX3_TX_PATH_SEC6                     0x0a6d
#define WCD9335_CDC_TX4_TX_PATH_CTL                      0x0a71
#define WCD9335_CDC_TX4_TX_PATH_CFG0                     0x0a72
#define WCD9335_CDC_TX4_TX_PATH_CFG1                     0x0a73
#define WCD9335_CDC_TX4_TX_VOL_CTL                       0x0a74
#define WCD9335_CDC_TX4_TX_PATH_192_CTL                  0x0a75
#define WCD9335_CDC_TX4_TX_PATH_192_CFG                  0x0a76
#define WCD9335_CDC_TX4_TX_PATH_SEC0                     0x0a77
#define WCD9335_CDC_TX4_TX_PATH_SEC1                     0x0a78
#define WCD9335_CDC_TX4_TX_PATH_SEC2                     0x0a79
#define WCD9335_CDC_TX4_TX_PATH_SEC3                     0x0a7a
#define WCD9335_CDC_TX4_TX_PATH_SEC4                     0x0a7b
#define WCD9335_CDC_TX4_TX_PATH_SEC5                     0x0a7c
#define WCD9335_CDC_TX4_TX_PATH_SEC6                     0x0a7d
#define WCD9335_CDC_TX5_TX_PATH_CTL                      0x0a81
#define WCD9335_CDC_TX5_TX_PATH_CFG0                     0x0a82
#define WCD9335_CDC_TX5_TX_PATH_CFG1                     0x0a83
#define WCD9335_CDC_TX5_TX_VOL_CTL                       0x0a84
#define WCD9335_CDC_TX5_TX_PATH_192_CTL                  0x0a85
#define WCD9335_CDC_TX5_TX_PATH_192_CFG                  0x0a86
#define WCD9335_CDC_TX5_TX_PATH_SEC0                     0x0a87
#define WCD9335_CDC_TX5_TX_PATH_SEC1                     0x0a88
#define WCD9335_CDC_TX5_TX_PATH_SEC2                     0x0a89
#define WCD9335_CDC_TX5_TX_PATH_SEC3                     0x0a8a
#define WCD9335_CDC_TX5_TX_PATH_SEC4                     0x0a8b
#define WCD9335_CDC_TX5_TX_PATH_SEC5                     0x0a8c
#define WCD9335_CDC_TX5_TX_PATH_SEC6                     0x0a8d
#define WCD9335_CDC_TX6_TX_PATH_CTL                      0x0a91
#define WCD9335_CDC_TX6_TX_PATH_CFG0                     0x0a92
#define WCD9335_CDC_TX6_TX_PATH_CFG1                     0x0a93
#define WCD9335_CDC_TX6_TX_VOL_CTL                       0x0a94
#define WCD9335_CDC_TX6_TX_PATH_192_CTL                  0x0a95
#define WCD9335_CDC_TX6_TX_PATH_192_CFG                  0x0a96
#define WCD9335_CDC_TX6_TX_PATH_SEC0                     0x0a97
#define WCD9335_CDC_TX6_TX_PATH_SEC1                     0x0a98
#define WCD9335_CDC_TX6_TX_PATH_SEC2                     0x0a99
#define WCD9335_CDC_TX6_TX_PATH_SEC3                     0x0a9a
#define WCD9335_CDC_TX6_TX_PATH_SEC4                     0x0a9b
#define WCD9335_CDC_TX6_TX_PATH_SEC5                     0x0a9c
#define WCD9335_CDC_TX6_TX_PATH_SEC6                     0x0a9d
#define WCD9335_CDC_TX7_TX_PATH_CTL                      0x0aa1
#define WCD9335_CDC_TX7_TX_PATH_CFG0                     0x0aa2
#define WCD9335_CDC_TX7_TX_PATH_CFG1                     0x0aa3
#define WCD9335_CDC_TX7_TX_VOL_CTL                       0x0aa4
#define WCD9335_CDC_TX7_TX_PATH_192_CTL                  0x0aa5
#define WCD9335_CDC_TX7_TX_PATH_192_CFG                  0x0aa6
#define WCD9335_CDC_TX7_TX_PATH_SEC0                     0x0aa7
#define WCD9335_CDC_TX7_TX_PATH_SEC1                     0x0aa8
#define WCD9335_CDC_TX7_TX_PATH_SEC2                     0x0aa9
#define WCD9335_CDC_TX7_TX_PATH_SEC3                     0x0aaa
#define WCD9335_CDC_TX7_TX_PATH_SEC4                     0x0aab
#define WCD9335_CDC_TX7_TX_PATH_SEC5                     0x0aac
#define WCD9335_CDC_TX7_TX_PATH_SEC6                     0x0aad
#define WCD9335_CDC_TX8_TX_PATH_CTL                      0x0ab1
#define WCD9335_CDC_TX8_TX_PATH_CFG0                     0x0ab2
#define WCD9335_CDC_TX8_TX_PATH_CFG1                     0x0ab3
#define WCD9335_CDC_TX8_TX_VOL_CTL                       0x0ab4
#define WCD9335_CDC_TX8_TX_PATH_192_CTL                  0x0ab5
#define WCD9335_CDC_TX8_TX_PATH_192_CFG                  0x0ab6
#define WCD9335_CDC_TX8_TX_PATH_SEC0                     0x0ab7
#define WCD9335_CDC_TX8_TX_PATH_SEC1                     0x0ab8
#define WCD9335_CDC_TX8_TX_PATH_SEC2                     0x0ab9
#define WCD9335_CDC_TX8_TX_PATH_SEC3                     0x0aba
#define WCD9335_CDC_TX8_TX_PATH_SEC4                     0x0abb
#define WCD9335_CDC_TX8_TX_PATH_SEC5                     0x0abc
#define WCD9335_CDC_TX8_TX_PATH_SEC6                     0x0abd
#define WCD9335_CDC_TX9_SPKR_PROT_PATH_CTL               0x0ac2
#define WCD9335_CDC_TX9_SPKR_PROT_PATH_CFG0              0x0ac3
#define WCD9335_CDC_TX10_SPKR_PROT_PATH_CTL              0x0ac6
#define WCD9335_CDC_TX10_SPKR_PROT_PATH_CFG0             0x0ac7
#define WCD9335_CDC_TX11_SPKR_PROT_PATH_CTL              0x0aca
#define WCD9335_CDC_TX11_SPKR_PROT_PATH_CFG0             0x0acb
#define WCD9335_CDC_TX12_SPKR_PROT_PATH_CTL              0x0ace
#define WCD9335_CDC_TX12_SPKR_PROT_PATH_CFG0             0x0acf

/* Page-11 Registers */
#define WCD9335_PAGE11_PAGE_REGISTER                     0x0b00
#define WCD9335_CDC_COMPANDER1_CTL0                      0x0b01
#define WCD9335_CDC_COMPANDER1_CTL1                      0x0b02
#define WCD9335_CDC_COMPANDER1_CTL2                      0x0b03
#define WCD9335_CDC_COMPANDER1_CTL3                      0x0b04
#define WCD9335_CDC_COMPANDER1_CTL4                      0x0b05
#define WCD9335_CDC_COMPANDER1_CTL5                      0x0b06
#define WCD9335_CDC_COMPANDER1_CTL6                      0x0b07
#define WCD9335_CDC_COMPANDER1_CTL7                      0x0b08
#define WCD9335_CDC_COMPANDER2_CTL0                      0x0b09
#define WCD9335_CDC_COMPANDER2_CTL1                      0x0b0a
#define WCD9335_CDC_COMPANDER2_CTL2                      0x0b0b
#define WCD9335_CDC_COMPANDER2_CTL3                      0x0b0c
#define WCD9335_CDC_COMPANDER2_CTL4                      0x0b0d
#define WCD9335_CDC_COMPANDER2_CTL5                      0x0b0e
#define WCD9335_CDC_COMPANDER2_CTL6                      0x0b0f
#define WCD9335_CDC_COMPANDER2_CTL7                      0x0b10
#define WCD9335_CDC_COMPANDER3_CTL0                      0x0b11
#define WCD9335_CDC_COMPANDER3_CTL1                      0x0b12
#define WCD9335_CDC_COMPANDER3_CTL2                      0x0b13
#define WCD9335_CDC_COMPANDER3_CTL3                      0x0b14
#define WCD9335_CDC_COMPANDER3_CTL4                      0x0b15
#define WCD9335_CDC_COMPANDER3_CTL5                      0x0b16
#define WCD9335_CDC_COMPANDER3_CTL6                      0x0b17
#define WCD9335_CDC_COMPANDER3_CTL7                      0x0b18
#define WCD9335_CDC_COMPANDER4_CTL0                      0x0b19
#define WCD9335_CDC_COMPANDER4_CTL1                      0x0b1a
#define WCD9335_CDC_COMPANDER4_CTL2                      0x0b1b
#define WCD9335_CDC_COMPANDER4_CTL3                      0x0b1c
#define WCD9335_CDC_COMPANDER4_CTL4                      0x0b1d
#define WCD9335_CDC_COMPANDER4_CTL5                      0x0b1e
#define WCD9335_CDC_COMPANDER4_CTL6                      0x0b1f
#define WCD9335_CDC_COMPANDER4_CTL7                      0x0b20
#define WCD9335_CDC_COMPANDER5_CTL0                      0x0b21
#define WCD9335_CDC_COMPANDER5_CTL1                      0x0b22
#define WCD9335_CDC_COMPANDER5_CTL2                      0x0b23
#define WCD9335_CDC_COMPANDER5_CTL3                      0x0b24
#define WCD9335_CDC_COMPANDER5_CTL4                      0x0b25
#define WCD9335_CDC_COMPANDER5_CTL5                      0x0b26
#define WCD9335_CDC_COMPANDER5_CTL6                      0x0b27
#define WCD9335_CDC_COMPANDER5_CTL7                      0x0b28
#define WCD9335_CDC_COMPANDER6_CTL0                      0x0b29
#define WCD9335_CDC_COMPANDER6_CTL1                      0x0b2a
#define WCD9335_CDC_COMPANDER6_CTL2                      0x0b2b
#define WCD9335_CDC_COMPANDER6_CTL3                      0x0b2c
#define WCD9335_CDC_COMPANDER6_CTL4                      0x0b2d
#define WCD9335_CDC_COMPANDER6_CTL5                      0x0b2e
#define WCD9335_CDC_COMPANDER6_CTL6                      0x0b2f
#define WCD9335_CDC_COMPANDER6_CTL7                      0x0b30
#define WCD9335_CDC_COMPANDER7_CTL0                      0x0b31
#define WCD9335_CDC_COMPANDER7_CTL1                      0x0b32
#define WCD9335_CDC_COMPANDER7_CTL2                      0x0b33
#define WCD9335_CDC_COMPANDER7_CTL3                      0x0b34
#define WCD9335_CDC_COMPANDER7_CTL4                      0x0b35
#define WCD9335_CDC_COMPANDER7_CTL5                      0x0b36
#define WCD9335_CDC_COMPANDER7_CTL6                      0x0b37
#define WCD9335_CDC_COMPANDER7_CTL7                      0x0b38
#define WCD9335_CDC_COMPANDER8_CTL0                      0x0b39
#define WCD9335_CDC_COMPANDER8_CTL1                      0x0b3a
#define WCD9335_CDC_COMPANDER8_CTL2                      0x0b3b
#define WCD9335_CDC_COMPANDER8_CTL3                      0x0b3c
#define WCD9335_CDC_COMPANDER8_CTL4                      0x0b3d
#define WCD9335_CDC_COMPANDER8_CTL5                      0x0b3e
#define WCD9335_CDC_COMPANDER8_CTL6                      0x0b3f
#define WCD9335_CDC_COMPANDER8_CTL7                      0x0b40
#define WCD9335_CDC_RX0_RX_PATH_CTL                      0x0b41
#define WCD9335_CDC_RX0_RX_PATH_CFG0                     0x0b42
#define WCD9335_CDC_RX0_RX_PATH_CFG1                     0x0b43
#define WCD9335_CDC_RX0_RX_PATH_CFG2                     0x0b44
#define WCD9335_CDC_RX0_RX_VOL_CTL                       0x0b45
#define WCD9335_CDC_RX0_RX_PATH_MIX_CTL                  0x0b46
#define WCD9335_CDC_RX0_RX_PATH_MIX_CFG                  0x0b47
#define WCD9335_CDC_RX0_RX_VOL_MIX_CTL                   0x0b48
#define WCD9335_CDC_RX0_RX_PATH_SEC0                     0x0b49
#define WCD9335_CDC_RX0_RX_PATH_SEC1                     0x0b4a
#define WCD9335_CDC_RX0_RX_PATH_SEC2                     0x0b4b
#define WCD9335_CDC_RX0_RX_PATH_SEC3                     0x0b4c
#define WCD9335_CDC_RX0_RX_PATH_SEC5                     0x0b4e
#define WCD9335_CDC_RX0_RX_PATH_SEC6                     0x0b4f
#define WCD9335_CDC_RX0_RX_PATH_SEC7                     0x0b50
#define WCD9335_CDC_RX0_RX_PATH_MIX_SEC0                 0x0b51
#define WCD9335_CDC_RX0_RX_PATH_MIX_SEC1                 0x0b52
#define WCD9335_CDC_RX1_RX_PATH_CTL                      0x0b55
#define WCD9335_CDC_RX1_RX_PATH_CFG0                     0x0b56
#define WCD9335_CDC_RX1_RX_PATH_CFG1                     0x0b57
#define WCD9335_CDC_RX1_RX_PATH_CFG2                     0x0b58
#define WCD9335_CDC_RX1_RX_VOL_CTL                       0x0b59
#define WCD9335_CDC_RX1_RX_PATH_MIX_CTL                  0x0b5a
#define WCD9335_CDC_RX1_RX_PATH_MIX_CFG                  0x0b5b
#define WCD9335_CDC_RX1_RX_VOL_MIX_CTL                   0x0b5c
#define WCD9335_CDC_RX1_RX_PATH_SEC0                     0x0b5d
#define WCD9335_CDC_RX1_RX_PATH_SEC1                     0x0b5e
#define WCD9335_CDC_RX1_RX_PATH_SEC2                     0x0b5f
#define WCD9335_CDC_RX1_RX_PATH_SEC3                     0x0b60
#define WCD9335_CDC_RX1_RX_PATH_SEC4                     0x0b61
#define WCD9335_CDC_RX1_RX_PATH_SEC5                     0x0b62
#define WCD9335_CDC_RX1_RX_PATH_SEC6                     0x0b63
#define WCD9335_CDC_RX1_RX_PATH_SEC7                     0x0b64
#define WCD9335_CDC_RX1_RX_PATH_MIX_SEC0                 0x0b65
#define WCD9335_CDC_RX1_RX_PATH_MIX_SEC1                 0x0b66
#define WCD9335_CDC_RX2_RX_PATH_CTL                      0x0b69
#define WCD9335_CDC_RX2_RX_PATH_CFG0                     0x0b6a
#define WCD9335_CDC_RX2_RX_PATH_CFG1                     0x0b6b
#define WCD9335_CDC_RX2_RX_PATH_CFG2                     0x0b6c
#define WCD9335_CDC_RX2_RX_VOL_CTL                       0x0b6d
#define WCD9335_CDC_RX2_RX_PATH_MIX_CTL                  0x0b6e
#define WCD9335_CDC_RX2_RX_PATH_MIX_CFG                  0x0b6f
#define WCD9335_CDC_RX2_RX_VOL_MIX_CTL                   0x0b70
#define WCD9335_CDC_RX2_RX_PATH_SEC0                     0x0b71
#define WCD9335_CDC_RX2_RX_PATH_SEC1                     0x0b72
#define WCD9335_CDC_RX2_RX_PATH_SEC2                     0x0b73
#define WCD9335_CDC_RX2_RX_PATH_SEC3                     0x0b74
#define WCD9335_CDC_RX2_RX_PATH_SEC4                     0x0b75
#define WCD9335_CDC_RX2_RX_PATH_SEC5                     0x0b76
#define WCD9335_CDC_RX2_RX_PATH_SEC6                     0x0b77
#define WCD9335_CDC_RX2_RX_PATH_SEC7                     0x0b78
#define WCD9335_CDC_RX2_RX_PATH_MIX_SEC0                 0x0b79
#define WCD9335_CDC_RX2_RX_PATH_MIX_SEC1                 0x0b7a
#define WCD9335_CDC_RX3_RX_PATH_CTL                      0x0b7d
#define WCD9335_CDC_RX3_RX_PATH_CFG0                     0x0b7e
#define WCD9335_CDC_RX3_RX_PATH_CFG1                     0x0b7f
#define WCD9335_CDC_RX3_RX_PATH_CFG2                     0x0b80
#define WCD9335_CDC_RX3_RX_VOL_CTL                       0x0b81
#define WCD9335_CDC_RX3_RX_PATH_MIX_CTL                  0x0b82
#define WCD9335_CDC_RX3_RX_PATH_MIX_CFG                  0x0b83
#define WCD9335_CDC_RX3_RX_VOL_MIX_CTL                   0x0b84
#define WCD9335_CDC_RX3_RX_PATH_SEC0                     0x0b85
#define WCD9335_CDC_RX3_RX_PATH_SEC1                     0x0b86
#define WCD9335_CDC_RX3_RX_PATH_SEC2                     0x0b87
#define WCD9335_CDC_RX3_RX_PATH_SEC3                     0x0b88
#define WCD9335_CDC_RX3_RX_PATH_SEC5                     0x0b8a
#define WCD9335_CDC_RX3_RX_PATH_SEC6                     0x0b8b
#define WCD9335_CDC_RX3_RX_PATH_SEC7                     0x0b8c
#define WCD9335_CDC_RX3_RX_PATH_MIX_SEC0                 0x0b8d
#define WCD9335_CDC_RX3_RX_PATH_MIX_SEC1                 0x0b8e
#define WCD9335_CDC_RX4_RX_PATH_CTL                      0x0b91
#define WCD9335_CDC_RX4_RX_PATH_CFG0                     0x0b92
#define WCD9335_CDC_RX4_RX_PATH_CFG1                     0x0b93
#define WCD9335_CDC_RX4_RX_PATH_CFG2                     0x0b94
#define WCD9335_CDC_RX4_RX_VOL_CTL                       0x0b95
#define WCD9335_CDC_RX4_RX_PATH_MIX_CTL                  0x0b96
#define WCD9335_CDC_RX4_RX_PATH_MIX_CFG                  0x0b97
#define WCD9335_CDC_RX4_RX_VOL_MIX_CTL                   0x0b98
#define WCD9335_CDC_RX4_RX_PATH_SEC0                     0x0b99
#define WCD9335_CDC_RX4_RX_PATH_SEC1                     0x0b9a
#define WCD9335_CDC_RX4_RX_PATH_SEC2                     0x0b9b
#define WCD9335_CDC_RX4_RX_PATH_SEC3                     0x0b9c
#define WCD9335_CDC_RX4_RX_PATH_SEC5                     0x0b9e
#define WCD9335_CDC_RX4_RX_PATH_SEC6                     0x0b9f
#define WCD9335_CDC_RX4_RX_PATH_SEC7                     0x0ba0
#define WCD9335_CDC_RX4_RX_PATH_MIX_SEC0                 0x0ba1
#define WCD9335_CDC_RX4_RX_PATH_MIX_SEC1                 0x0ba2
#define WCD9335_CDC_RX5_RX_PATH_CTL                      0x0ba5
#define WCD9335_CDC_RX5_RX_PATH_CFG0                     0x0ba6
#define WCD9335_CDC_RX5_RX_PATH_CFG1                     0x0ba7
#define WCD9335_CDC_RX5_RX_PATH_CFG2                     0x0ba8
#define WCD9335_CDC_RX5_RX_VOL_CTL                       0x0ba9
#define WCD9335_CDC_RX5_RX_PATH_MIX_CTL                  0x0baa
#define WCD9335_CDC_RX5_RX_PATH_MIX_CFG                  0x0bab
#define WCD9335_CDC_RX5_RX_VOL_MIX_CTL                   0x0bac
#define WCD9335_CDC_RX5_RX_PATH_SEC0                     0x0bad
#define WCD9335_CDC_RX5_RX_PATH_SEC1                     0x0bae
#define WCD9335_CDC_RX5_RX_PATH_SEC2                     0x0baf
#define WCD9335_CDC_RX5_RX_PATH_SEC3                     0x0bb0
#define WCD9335_CDC_RX5_RX_PATH_SEC5                     0x0bb2
#define WCD9335_CDC_RX5_RX_PATH_SEC6                     0x0bb3
#define WCD9335_CDC_RX5_RX_PATH_SEC7                     0x0bb4
#define WCD9335_CDC_RX5_RX_PATH_MIX_SEC0                 0x0bb5
#define WCD9335_CDC_RX5_RX_PATH_MIX_SEC1                 0x0bb6
#define WCD9335_CDC_RX6_RX_PATH_CTL                      0x0bb9
#define WCD9335_CDC_RX6_RX_PATH_CFG0                     0x0bba
#define WCD9335_CDC_RX6_RX_PATH_CFG1                     0x0bbb
#define WCD9335_CDC_RX6_RX_PATH_CFG2                     0x0bbc
#define WCD9335_CDC_RX6_RX_VOL_CTL                       0x0bbd
#define WCD9335_CDC_RX6_RX_PATH_MIX_CTL                  0x0bbe
#define WCD9335_CDC_RX6_RX_PATH_MIX_CFG                  0x0bbf
#define WCD9335_CDC_RX6_RX_VOL_MIX_CTL                   0x0bc0
#define WCD9335_CDC_RX6_RX_PATH_SEC0                     0x0bc1
#define WCD9335_CDC_RX6_RX_PATH_SEC1                     0x0bc2
#define WCD9335_CDC_RX6_RX_PATH_SEC2                     0x0bc3
#define WCD9335_CDC_RX6_RX_PATH_SEC3                     0x0bc4
#define WCD9335_CDC_RX6_RX_PATH_SEC5                     0x0bc6
#define WCD9335_CDC_RX6_RX_PATH_SEC6                     0x0bc7
#define WCD9335_CDC_RX6_RX_PATH_SEC7                     0x0bc8
#define WCD9335_CDC_RX6_RX_PATH_MIX_SEC0                 0x0bc9
#define WCD9335_CDC_RX6_RX_PATH_MIX_SEC1                 0x0bca
#define WCD9335_CDC_RX7_RX_PATH_CTL                      0x0bcd
#define WCD9335_CDC_RX7_RX_PATH_CFG0                     0x0bce
#define WCD9335_CDC_RX7_RX_PATH_CFG1                     0x0bcf
#define WCD9335_CDC_RX7_RX_PATH_CFG2                     0x0bd0
#define WCD9335_CDC_RX7_RX_VOL_CTL                       0x0bd1
#define WCD9335_CDC_RX7_RX_PATH_MIX_CTL                  0x0bd2
#define WCD9335_CDC_RX7_RX_PATH_MIX_CFG                  0x0bd3
#define WCD9335_CDC_RX7_RX_VOL_MIX_CTL                   0x0bd4
#define WCD9335_CDC_RX7_RX_PATH_SEC0                     0x0bd5
#define WCD9335_CDC_RX7_RX_PATH_SEC1                     0x0bd6
#define WCD9335_CDC_RX7_RX_PATH_SEC2                     0x0bd7
#define WCD9335_CDC_RX7_RX_PATH_SEC3                     0x0bd8
#define WCD9335_CDC_RX7_RX_PATH_SEC5                     0x0bda
#define WCD9335_CDC_RX7_RX_PATH_SEC6                     0x0bdb
#define WCD9335_CDC_RX7_RX_PATH_SEC7                     0x0bdc
#define WCD9335_CDC_RX7_RX_PATH_MIX_SEC0                 0x0bdd
#define WCD9335_CDC_RX7_RX_PATH_MIX_SEC1                 0x0bde
#define WCD9335_CDC_RX8_RX_PATH_CTL                      0x0be1
#define WCD9335_CDC_RX8_RX_PATH_CFG0                     0x0be2
#define WCD9335_CDC_RX8_RX_PATH_CFG1                     0x0be3
#define WCD9335_CDC_RX8_RX_PATH_CFG2                     0x0be4
#define WCD9335_CDC_RX8_RX_VOL_CTL                       0x0be5
#define WCD9335_CDC_RX8_RX_PATH_MIX_CTL                  0x0be6
#define WCD9335_CDC_RX8_RX_PATH_MIX_CFG                  0x0be7
#define WCD9335_CDC_RX8_RX_VOL_MIX_CTL                   0x0be8
#define WCD9335_CDC_RX8_RX_PATH_SEC0                     0x0be9
#define WCD9335_CDC_RX8_RX_PATH_SEC1                     0x0bea
#define WCD9335_CDC_RX8_RX_PATH_SEC2                     0x0beb
#define WCD9335_CDC_RX8_RX_PATH_SEC3                     0x0bec
#define WCD9335_CDC_RX8_RX_PATH_SEC5                     0x0bee
#define WCD9335_CDC_RX8_RX_PATH_SEC6                     0x0bef
#define WCD9335_CDC_RX8_RX_PATH_SEC7                     0x0bf0
#define WCD9335_CDC_RX8_RX_PATH_MIX_SEC0                 0x0bf1
#define WCD9335_CDC_RX8_RX_PATH_MIX_SEC1                 0x0bf2

/* Page-12 Registers */
#define WCD9335_PAGE12_PAGE_REGISTER                     0x0c00
#define WCD9335_CDC_CLSH_CRC                             0x0c01
#define WCD9335_CDC_CLSH_DLY_CTRL                        0x0c02
#define WCD9335_CDC_CLSH_DECAY_CTRL                      0x0c03
#define WCD9335_CDC_CLSH_HPH_V_PA                        0x0c04
#define WCD9335_CDC_CLSH_EAR_V_PA                        0x0c05
#define WCD9335_CDC_CLSH_HPH_V_HD                        0x0c06
#define WCD9335_CDC_CLSH_EAR_V_HD                        0x0c07
#define WCD9335_CDC_CLSH_K1_MSB                          0x0c08
#define WCD9335_CDC_CLSH_K1_LSB                          0x0c09
#define WCD9335_CDC_CLSH_K2_MSB                          0x0c0a
#define WCD9335_CDC_CLSH_K2_LSB                          0x0c0b
#define WCD9335_CDC_CLSH_IDLE_CTRL                       0x0c0c
#define WCD9335_CDC_CLSH_IDLE_HPH                        0x0c0d
#define WCD9335_CDC_CLSH_IDLE_EAR                        0x0c0e
#define WCD9335_CDC_CLSH_TEST0                           0x0c0f
#define WCD9335_CDC_CLSH_TEST1                           0x0c10
#define WCD9335_CDC_CLSH_OVR_VREF                        0x0c11
#define WCD9335_CDC_BOOST0_BOOST_PATH_CTL                0x0c19
#define WCD9335_CDC_BOOST0_BOOST_CTL                     0x0c1a
#define WCD9335_CDC_BOOST0_BOOST_CFG1                    0x0c1b
#define WCD9335_CDC_BOOST0_BOOST_CFG2                    0x0c1c
#define WCD9335_CDC_BOOST1_BOOST_PATH_CTL                0x0c21
#define WCD9335_CDC_BOOST1_BOOST_CTL                     0x0c22
#define WCD9335_CDC_BOOST1_BOOST_CFG1                    0x0c23
#define WCD9335_CDC_BOOST1_BOOST_CFG2                    0x0c24
#define WCD9335_SWR_AHB_BRIDGE_WR_DATA_0                 0x0c29
#define WCD9335_SWR_AHB_BRIDGE_WR_DATA_1                 0x0c2a
#define WCD9335_SWR_AHB_BRIDGE_WR_DATA_2                 0x0c2b
#define WCD9335_SWR_AHB_BRIDGE_WR_DATA_3                 0x0c2c
#define WCD9335_SWR_AHB_BRIDGE_WR_ADDR_0                 0x0c2d
#define WCD9335_SWR_AHB_BRIDGE_WR_ADDR_1                 0x0c2e
#define WCD9335_SWR_AHB_BRIDGE_WR_ADDR_2                 0x0c2f
#define WCD9335_SWR_AHB_BRIDGE_WR_ADDR_3                 0x0c30
#define WCD9335_SWR_AHB_BRIDGE_RD_ADDR_0                 0x0c31
#define WCD9335_SWR_AHB_BRIDGE_RD_ADDR_1                 0x0c32
#define WCD9335_SWR_AHB_BRIDGE_RD_ADDR_2                 0x0c33
#define WCD9335_SWR_AHB_BRIDGE_RD_ADDR_3                 0x0c34
#define WCD9335_SWR_AHB_BRIDGE_RD_DATA_0                 0x0c35
#define WCD9335_SWR_AHB_BRIDGE_RD_DATA_1                 0x0c36
#define WCD9335_SWR_AHB_BRIDGE_RD_DATA_2                 0x0c37
#define WCD9335_SWR_AHB_BRIDGE_RD_DATA_3                 0x0c38
#define WCD9335_SWR_AHB_BRIDGE_ACCESS_CFG                0x0c39
#define WCD9335_SWR_AHB_BRIDGE_ACCESS_STATUS             0x0c3a
#define WCD9335_CDC_VBAT_VBAT_PATH_CTL                   0x0c3d
#define WCD9335_CDC_VBAT_VBAT_CFG                        0x0c3e
#define WCD9335_CDC_VBAT_VBAT_ADC_CAL1                   0x0c3f
#define WCD9335_CDC_VBAT_VBAT_ADC_CAL2                   0x0c40
#define WCD9335_CDC_VBAT_VBAT_ADC_CAL3                   0x0c41
#define WCD9335_CDC_VBAT_VBAT_PK_EST1                    0x0c42
#define WCD9335_CDC_VBAT_VBAT_PK_EST2                    0x0c43
#define WCD9335_CDC_VBAT_VBAT_PK_EST3                    0x0c44
#define WCD9335_CDC_VBAT_VBAT_RF_PROC1                   0x0c45
#define WCD9335_CDC_VBAT_VBAT_RF_PROC2                   0x0c46
#define WCD9335_CDC_VBAT_VBAT_TAC1                       0x0c47
#define WCD9335_CDC_VBAT_VBAT_TAC2                       0x0c48
#define WCD9335_CDC_VBAT_VBAT_TAC3                       0x0c49
#define WCD9335_CDC_VBAT_VBAT_TAC4                       0x0c4a
#define WCD9335_CDC_VBAT_VBAT_GAIN_UPD1                  0x0c4b
#define WCD9335_CDC_VBAT_VBAT_GAIN_UPD2                  0x0c4c
#define WCD9335_CDC_VBAT_VBAT_GAIN_UPD3                  0x0c4d
#define WCD9335_CDC_VBAT_VBAT_GAIN_UPD4                  0x0c4e
#define WCD9335_CDC_VBAT_VBAT_DEBUG1                     0x0c4f
#define WCD9335_CDC_VBAT_VBAT_GAIN_UPD_MON               0x0c50
#define WCD9335_CDC_VBAT_VBAT_GAIN_MON_VAL               0x0c51
#define WCD9335_SPLINE_SRC0_CLK_RST_CTL_0                0x0c55
#define WCD9335_SPLINE_SRC0_STATUS                       0x0c56
#define WCD9335_SPLINE_SRC1_CLK_RST_CTL_0                0x0c6d
#define WCD9335_SPLINE_SRC1_STATUS                       0x0c6e
#define WCD9335_SPLINE_SRC2_CLK_RST_CTL_0                0x0c85
#define WCD9335_SPLINE_SRC2_STATUS                       0x0c86
#define WCD9335_SPLINE_SRC3_CLK_RST_CTL_0                0x0c9d
#define WCD9335_SPLINE_SRC3_STATUS                       0x0c9e
#define WCD9335_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL        0x0cb5
#define WCD9335_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1       0x0cb6
#define WCD9335_CDC_SIDETONE_SRC1_ST_SRC_PATH_CTL        0x0cb9
#define WCD9335_CDC_SIDETONE_SRC1_ST_SRC_PATH_CFG1       0x0cba

/* Page-13 Registers */
#define WCD9335_PAGE13_PAGE_REGISTER                     0x0d00
#define WCD9335_CDC_RX_INP_MUX_RX_INT0_CFG0              0x0d01
#define WCD9335_CDC_RX_INP_MUX_RX_INT0_CFG1              0x0d02
#define WCD9335_CDC_RX_INP_MUX_RX_INT1_CFG0              0x0d03
#define WCD9335_CDC_RX_INP_MUX_RX_INT1_CFG1              0x0d04
#define WCD9335_CDC_RX_INP_MUX_RX_INT2_CFG0              0x0d05
#define WCD9335_CDC_RX_INP_MUX_RX_INT2_CFG1              0x0d06
#define WCD9335_CDC_RX_INP_MUX_RX_INT3_CFG0              0x0d07
#define WCD9335_CDC_RX_INP_MUX_RX_INT3_CFG1              0x0d08
#define WCD9335_CDC_RX_INP_MUX_RX_INT4_CFG0              0x0d09
#define WCD9335_CDC_RX_INP_MUX_RX_INT4_CFG1              0x0d0a
#define WCD9335_CDC_RX_INP_MUX_RX_INT5_CFG0              0x0d0b
#define WCD9335_CDC_RX_INP_MUX_RX_INT5_CFG1              0x0d0c
#define WCD9335_CDC_RX_INP_MUX_RX_INT6_CFG0              0x0d0d
#define WCD9335_CDC_RX_INP_MUX_RX_INT6_CFG1              0x0d0e
#define WCD9335_CDC_RX_INP_MUX_RX_INT7_CFG0              0x0d0f
#define WCD9335_CDC_RX_INP_MUX_RX_INT7_CFG1              0x0d10
#define WCD9335_CDC_RX_INP_MUX_RX_INT8_CFG0              0x0d11
#define WCD9335_CDC_RX_INP_MUX_RX_INT8_CFG1              0x0d12
#define WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG0               0x0d13
#define WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG1               0x0d14
#define WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG2               0x0d15
#define WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG3               0x0d16
#define WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG4               0x0d17
#define WCD9335_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0         0x0d18
#define WCD9335_CDC_RX_INP_MUX_SIDETONE_SRC_CFG1         0x0d19
#define WCD9335_CDC_RX_INP_MUX_ANC_CFG0                  0x0d1a
#define WCD9335_CDC_RX_INP_MUX_SPLINE_SRC_CFG0           0x0d1b
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX0_CFG0             0x0d1d
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX0_CFG1             0x0d1e
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX1_CFG0             0x0d1f
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX1_CFG1             0x0d20
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX2_CFG0             0x0d21
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX2_CFG1             0x0d22
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX3_CFG0             0x0d23
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX3_CFG1             0x0d24
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX4_CFG0             0x0d25
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX5_CFG0             0x0d26
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX6_CFG0             0x0d27
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX7_CFG0             0x0d28
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX8_CFG0             0x0d29
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX10_CFG0            0x0d2b
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX11_CFG0            0x0d2c
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX12_CFG0            0x0d2d
#define WCD9335_CDC_TX_INP_MUX_ADC_MUX13_CFG0            0x0d2e
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0   0x0d31
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG1   0x0d32
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG2   0x0d33
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG3   0x0d34
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG0   0x0d35
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG1   0x0d36
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG2   0x0d37
#define WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG3   0x0d38
#define WCD9335_CDC_IF_ROUTER_TX_MUX_CFG0                0x0d3a
#define WCD9335_CDC_IF_ROUTER_TX_MUX_CFG1                0x0d3b
#define WCD9335_CDC_IF_ROUTER_TX_MUX_CFG2                0x0d3c
#define WCD9335_CDC_IF_ROUTER_TX_MUX_CFG3                0x0d3d
#define WCD9335_CDC_CLK_RST_CTRL_MCLK_CONTROL            0x0d41
#define WCD9335_CDC_CLK_RST_CTRL_FS_CNT_CONTROL          0x0d42
#define WCD9335_CDC_CLK_RST_CTRL_SWR_CONTROL             0x0d43
#define WCD9335_CDC_PROX_DETECT_PROX_CTL                 0x0d49
#define WCD9335_CDC_PROX_DETECT_PROX_POLL_PERIOD0        0x0d4a
#define WCD9335_CDC_PROX_DETECT_PROX_POLL_PERIOD1        0x0d4b
#define WCD9335_CDC_PROX_DETECT_PROX_SIG_PATTERN_LSB     0x0d4c
#define WCD9335_CDC_PROX_DETECT_PROX_SIG_PATTERN_MSB     0x0d4d
#define WCD9335_CDC_PROX_DETECT_PROX_STATUS              0x0d4e
#define WCD9335_CDC_PROX_DETECT_PROX_TEST_CTRL           0x0d4f
#define WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB       0x0d50
#define WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB       0x0d51
#define WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB_RD    0x0d52
#define WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB_RD    0x0d53
#define WCD9335_CDC_PROX_DETECT_PROX_CTL_REPEAT_PAT      0x0d54
#define WCD9335_CDC_SIDETONE_IIR0_IIR_PATH_CTL           0x0d55
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL        0x0d56
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL        0x0d57
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL        0x0d58
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL        0x0d59
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL        0x0d5a
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL        0x0d5b
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL        0x0d5c
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL        0x0d5d
#define WCD9335_CDC_SIDETONE_IIR0_IIR_CTL                0x0d5e
#define WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL     0x0d5f
#define WCD9335_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL        0x0d60
#define WCD9335_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL        0x0d61
#define WCD9335_CDC_SIDETONE_IIR1_IIR_PATH_CTL           0x0d65
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B1_CTL        0x0d66
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B2_CTL        0x0d67
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B3_CTL        0x0d68
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B4_CTL        0x0d69
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B5_CTL        0x0d6a
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B6_CTL        0x0d6b
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B7_CTL        0x0d6c
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B8_CTL        0x0d6d
#define WCD9335_CDC_SIDETONE_IIR1_IIR_CTL                0x0d6e
#define WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_TIMER_CTL     0x0d6f
#define WCD9335_CDC_SIDETONE_IIR1_IIR_COEF_B1_CTL        0x0d70
#define WCD9335_CDC_SIDETONE_IIR1_IIR_COEF_B2_CTL        0x0d71
#define WCD9335_CDC_TOP_TOP_CFG0                         0x0d81
#define WCD9335_CDC_TOP_TOP_CFG1                         0x0d82
#define WCD9335_CDC_TOP_TOP_CFG2                         0x0d83
#define WCD9335_CDC_TOP_TOP_CFG3                         0x0d84
#define WCD9335_CDC_TOP_TOP_CFG4                         0x0d85
#define WCD9335_CDC_TOP_TOP_CFG5                         0x0d86
#define WCD9335_CDC_TOP_TOP_CFG6                         0x0d87
#define WCD9335_CDC_TOP_TOP_CFG7                         0x0d88
#define WCD9335_CDC_TOP_HPHL_COMP_WR_LSB                 0x0d89
#define WCD9335_CDC_TOP_HPHL_COMP_WR_MSB                 0x0d8a
#define WCD9335_CDC_TOP_HPHL_COMP_LUT                    0x0d8b
#define WCD9335_CDC_TOP_HPHL_COMP_RD_LSB                 0x0d8c
#define WCD9335_CDC_TOP_HPHL_COMP_RD_MSB                 0x0d8d
#define WCD9335_CDC_TOP_HPHR_COMP_WR_LSB                 0x0d8e
#define WCD9335_CDC_TOP_HPHR_COMP_WR_MSB                 0x0d8f
#define WCD9335_CDC_TOP_HPHR_COMP_LUT                    0x0d90
#define WCD9335_CDC_TOP_HPHR_COMP_RD_LSB                 0x0d91
#define WCD9335_CDC_TOP_HPHR_COMP_RD_MSB                 0x0d92
#define WCD9335_CDC_TOP_DIFFL_COMP_WR_LSB                0x0d93
#define WCD9335_CDC_TOP_DIFFL_COMP_WR_MSB                0x0d94
#define WCD9335_CDC_TOP_DIFFL_COMP_LUT                   0x0d95
#define WCD9335_CDC_TOP_DIFFL_COMP_RD_LSB                0x0d96
#define WCD9335_CDC_TOP_DIFFL_COMP_RD_MSB                0x0d97
#define WCD9335_CDC_TOP_DIFFR_COMP_WR_LSB                0x0d98
#define WCD9335_CDC_TOP_DIFFR_COMP_WR_MSB                0x0d99
#define WCD9335_CDC_TOP_DIFFR_COMP_LUT                   0x0d9a
#define WCD9335_CDC_TOP_DIFFR_COMP_RD_LSB                0x0d9b
#define WCD9335_CDC_TOP_DIFFR_COMP_RD_MSB                0x0d9c

/* Page-0x80 Registers */
#define WCD9335_PAGE80_PAGE_REGISTER                     0x8000
#define WCD9335_TLMM_BIST_MODE_PINCFG                    0x8001
#define WCD9335_TLMM_RF_PA_ON_PINCFG                     0x8002
#define WCD9335_TLMM_INTR1_PINCFG                        0x8003
#define WCD9335_TLMM_INTR2_PINCFG                        0x8004
#define WCD9335_TLMM_SWR_DATA_PINCFG                     0x8005
#define WCD9335_TLMM_SWR_CLK_PINCFG                      0x8006
#define WCD9335_TLMM_SLIMBUS_DATA2_PINCFG                0x8007
#define WCD9335_TLMM_I2C_CLK_PINCFG                      0x8008
#define WCD9335_TLMM_I2C_DATA_PINCFG                     0x8009
#define WCD9335_TLMM_I2S_RX_SD0_PINCFG                   0x800a
#define WCD9335_TLMM_I2S_RX_SD1_PINCFG                   0x800b
#define WCD9335_TLMM_I2S_RX_SCK_PINCFG                   0x800c
#define WCD9335_TLMM_I2S_RX_WS_PINCFG                    0x800d
#define WCD9335_TLMM_I2S_TX_SD0_PINCFG                   0x800e
#define WCD9335_TLMM_I2S_TX_SD1_PINCFG                   0x800f
#define WCD9335_TLMM_I2S_TX_SCK_PINCFG                   0x8010
#define WCD9335_TLMM_I2S_TX_WS_PINCFG                    0x8011
#define WCD9335_TLMM_DMIC1_CLK_PINCFG                    0x8012
#define WCD9335_TLMM_DMIC1_DATA_PINCFG                   0x8013
#define WCD9335_TLMM_DMIC2_CLK_PINCFG                    0x8014
#define WCD9335_TLMM_DMIC2_DATA_PINCFG                   0x8015
#define WCD9335_TLMM_DMIC3_CLK_PINCFG                    0x8016
#define WCD9335_TLMM_DMIC3_DATA_PINCFG                   0x8017
#define WCD9335_TLMM_JTDI_PINCFG                         0x8018
#define WCD9335_TLMM_JTDO_PINCFG                         0x8019
#define WCD9335_TLMM_JTMS_PINCFG                         0x801a
#define WCD9335_TLMM_JTCK_PINCFG                         0x801b
#define WCD9335_TLMM_JTRST_PINCFG                        0x801c
#define WCD9335_TEST_DEBUG_PIN_CTL_OE_0                  0x8031
#define WCD9335_TEST_DEBUG_PIN_CTL_OE_1                  0x8032
#define WCD9335_TEST_DEBUG_PIN_CTL_OE_2                  0x8033
#define WCD9335_TEST_DEBUG_PIN_CTL_OE_3                  0x8034
#define WCD9335_TEST_DEBUG_PIN_CTL_DATA_0                0x8035
#define WCD9335_TEST_DEBUG_PIN_CTL_DATA_1                0x8036
#define WCD9335_TEST_DEBUG_PIN_CTL_DATA_2                0x8037
#define WCD9335_TEST_DEBUG_PIN_CTL_DATA_3                0x8038
#define WCD9335_TEST_DEBUG_PAD_DRVCTL                    0x8039
#define WCD9335_TEST_DEBUG_PIN_STATUS                    0x803a
#define WCD9335_TEST_DEBUG_NPL_DLY_TEST_1                0x803b
#define WCD9335_TEST_DEBUG_NPL_DLY_TEST_2                0x803c
#define WCD9335_TEST_DEBUG_MEM_CTRL                      0x803d
#define WCD9335_TEST_DEBUG_DEBUG_BUS_SEL                 0x8041
#define WCD9335_TEST_DEBUG_DEBUG_JTAG                    0x8042
#define WCD9335_TEST_DEBUG_DEBUG_EN_1                    0x8043
#define WCD9335_TEST_DEBUG_DEBUG_EN_2                    0x8044
#define WCD9335_TEST_DEBUG_DEBUG_EN_3                    0x8045
#define WCD9335_MAX_REGISTER                             0x80FF

/* SLIMBUS Slave Registers */
#define TASHA_SLIM_PGD_PORT_INT_EN0                     (0x30)
#define TASHA_SLIM_PGD_PORT_INT_STATUS_RX_0             (0x34)
#define TASHA_SLIM_PGD_PORT_INT_STATUS_RX_1             (0x35)
#define TASHA_SLIM_PGD_PORT_INT_STATUS_TX_0             (0x36)
#define TASHA_SLIM_PGD_PORT_INT_STATUS_TX_1             (0x37)
#define TASHA_SLIM_PGD_PORT_INT_CLR_RX_0                (0x38)
#define TASHA_SLIM_PGD_PORT_INT_CLR_RX_1                (0x39)
#define TASHA_SLIM_PGD_PORT_INT_CLR_TX_0                (0x3A)
#define TASHA_SLIM_PGD_PORT_INT_CLR_TX_1                (0x3B)
#define TASHA_SLIM_PGD_PORT_INT_RX_SOURCE0		(0x60)
#define TASHA_SLIM_PGD_PORT_INT_TX_SOURCE0		(0x70)

/* Macros for Packing Register Writes into a U32 */
#define TASHA_PACKED_REG_SIZE sizeof(u32)

#define TASHA_CODEC_PACK_ENTRY(reg, mask, val) ((val & 0xff)|\
	((mask & 0xff) << 8)|((reg & 0xffff) << 16))
#define TASHA_CODEC_UNPACK_ENTRY(packed, reg, mask, val) \
	do { \
		((reg) = ((packed >> 16) & (0xffff))); \
		((mask) = ((packed >> 8) & (0xff))); \
		((val) = ((packed) & (0xff))); \
	} while (0)
#endif
