//*****************************************************************************
//*****************************************************************************
//  FILENAME: Driver.h
//  TrueTouch Host Emulator Version Information: 3.13, b232
//  TrueTouch Firmware Version Information: 1.10.930587
//
//  DESCRIPTION: This file contains configuration values.
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2009 - 2015. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************
//-----------------------------------------------------------------------------
/* Touchscreen Version Information */
static u8 ttconfig_fw_ver[] = {
	0x00, 0x00, 0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x33, 0x1B, 0x0B, 0x11, 0x12, 0x9B, 0x00, 0x06
};

/* Touchscreen Parameters Endianess (Endianess: 0:Little; 1:Big)*/
static const uint8_t cyttsp4_param_endianess = 0;

/* Touchscreen Parameters */
static const uint8_t cyttsp4_param_regs[] = {
/*	Value	Name	*/
	0x10, 0x05,  /* CONFIG_DATA_SIZE */
	0x10, 0x05,  /* CONFIG_DATA_MAX_SIZE */
	0x80, 0x02,  /* X_RESOLUTION */
	0x68, 0x01,  /* Y_RESOLUTION */
	0x06, 0x00,  /* CONFIG_VER */
	0x5F, 0x13,  /* X_LEN_PHY */
	0xC2, 0x06,  /* Y_LEN_PHY */
	0x18, 0x00,  /* CROSS_NUM */
	0x03,  /* TX_NUM */
	0x08,  /* RX_NUM */
	0x0B,  /* SENS_NUM */
	0x00,  /* SENSOR_ASSIGNMENT */
	0x00,  /* Reserved20 */
	0x01,  /* BL_H20_RJCT */
	0x00,  /* CHARGER_ARMOR_ENABLE */
	0x01,  /* TOUCHMODE_ENABLED */
	0x00,  /* Reserved24 */
	0x00,  /* Reserved25 */
	0x02,  /* LRG_OBJ_CFG */
	0x00,  /* BUTTON_NUM */
	0x00,  /* Reserved28 */
	0x02,  /* MAX_NUM_OF_REPORTED_TOUCHES */
	0x02,  /* MAX_NUM_OF_SUPPORTED_TOUCHES */
	0x03,  /* SCANNING_MODE_BUTTON */
	0x08,  /* OPMODE_CFG */
	0x01,  /* SELF_Z_MODE */
	0x01,  /* WF_ENABLE */
	0x00,  /* Reserved35 */
	0x00, 0x00, 0x00, 0x00,  /* PQ_CTRL */
	0x00, 0x00, 0x00, 0x00,  /* PQ_CTRL2 */
	0x00, 0x00, 0x00, 0x00,  /* PQ_CTRL3 */
	0x00, 0xB0, 0x1B, 0xA0,  /* REFGEN_CTL */
	0x00, 0x00, 0xEE, 0x80,  /* TX_CTRL */
	0x00, 0x00, 0x27, 0x00,  /* RX_CTRL */
	0x00, 0x20, 0x00, 0x00,  /* INFRA_CTRL */
	0x64,  /* STARTUP_DELAY */
	0x00,  /* FORCE_SINGLE_TX */
	0x01,  /* SLOTS_MUT */
	0x01,  /* SLOTS_SELF_RX */
	0x01,  /* SLOTS_SELF_TX */
	0x02,  /* SLOTS_SELF */
	0x2C, 0x01,  /* SCALING_FACTOR_MUTUAL */
	0xB4, 0x00,  /* SCALING_FACTOR_SELF */
	0xC8, 0x00,  /* SCALING_FACTOR_BUTTON_MUTUAL */
	0xC8, 0x00,  /* SCALING_FACTOR_BUTTON_SELF */
	0x00, 0x00,  /* Reserved78 */
	0x02,  /* TX_PUMP_VOLTAGE */
	0x08,  /* DISCARD_TIME */
	0x00,  /* VDDA_MODE */
	0x00,  /* BUTTON_LAYOUT */
	0x01,  /* MTX_ORDER */
	0x00,  /* EXT_SYNC */
	0x00,  /* TX_FREQ_METHOD_MUTUAL */
	0x02,  /* TX_FREQ_METHOD_SELF */
	0x00,  /* Reserved88 */
	0x00,  /* Reserved89 */
	0x00,  /* Reserved90 */
	0x00,  /* Reserved91 */
	0x00,  /* RX_ATTEN_RES_BYPASS */
	0x19,  /* SAFE_RAW_RANGE_PERCENT_MUTUAL */
	0x32,  /* SAFE_RAW_RANGE_PERCENT_SELF */
	0x32,  /* SAFE_RAW_RANGE_PERCENT_BTN_MUTUAL */
	0x32,  /* SAFE_RAW_RANGE_PERCENT_BTN_SELF */
	0x00,  /* Reserved97 */
	0xFA, 0x00,  /* INTEGRATOR_VOLTAGE_MUTUAL */
	0xFA, 0x00,  /* INTEGRATOR_VOLTAGE_SELF */
	0xFA, 0x00,  /* INTEGRATOR_VOLTAGE_BUTTON_MUTUAL */
	0xFA, 0x00,  /* INTEGRATOR_VOLTAGE_BUTTON_SELF */
	0x1E,  /* BALANCING_TARGET_MUTUAL */
	0x32,  /* BALANCING_TARGET_SELF */
	0x1E,  /* BALANCING_TARGET_BUTTON_MUTUAL */
	0x1E,  /* BALANCING_TARGET_BUTTON_SELF */
	0x14, 0x05,  /* ILEAK_MAX */
	0xF0, 0x0A,  /* VDDA_LEVEL */
	0xE8, 0x03,  /* DELAY_TIME_FOR_PUMP */
	0x2C, 0x01,  /* DELTA_CM */
	0xE8, 0x03,  /* DELTA_CS_RX */
	0xFA, 0x00,  /* MAX_FTX */
	0x00,  /* BURST_NOISE_REJECTION_ENABLE */
	0x00,  /* Reserved123 */
	0x00,  /* Reserved124 */
	0x00,  /* Reserved125 */
	0x32, 0x00,  /* OVERFLOW_CNT_THRESHOLD */
	0x32, 0x00,  /* OVERFLOW_CNT_BUTTON_THRESHOLD */
	0xF4, 0x01,  /* OVERFLOW_DEBOUNCE_TIME */
	0xF4, 0x01,  /* OVERFLOW_BUTTON_DEBOUNCE_TIME */
	0x5A, 0x00,  /* TX_PERIOD_MUTUAL */
	0x30, 0x00,  /* CA_HOP0_TX_PERIOD_MUTUAL */
	0x38, 0x00,  /* CA_HOP1_TX_PERIOD_MUTUAL */
	0x3C, 0x00,  /* CA_HOP2_TX_PERIOD_MUTUAL */
	0xC8, 0x00,  /* Reserved142 */
	0xC8, 0x00,  /* Reserved144 */
	0x5A, 0x00,  /* TX_PERIOD_SELF */
	0xC8, 0x00,  /* TX_PERIOD_BTN_MUTUAL */
	0xA0, 0x00,  /* TX_PERIOD_BTN_SELF */
	0x20, 0x00,  /* TX_PULSES_NUM_MUTUAL */
	0x20, 0x00,  /* CA_BASE_TX_PULSES_NUM_MUTUAL */
	0x20, 0x00,  /* CA_HOP0_TX_PULSES_NUM_MUTUAL */
	0x20, 0x00,  /* CA_HOP1_TX_PULSES_NUM_MUTUAL */
	0x20, 0x00,  /* CA_HOP2_TX_PULSES_NUM_MUTUAL */
	0x40, 0x00,  /* Reserved162 */
	0x40, 0x00,  /* Reserved164 */
	0x20, 0x00,  /* TX_PULSES_NUM_SELF */
	0x40, 0x00,  /* TX_PULSES_NUM_BUTTON_MUTUAL */
	0x20, 0x00,  /* TX_PULSES_NUM_BUTTON_SELF */
	0x40,  /* Reserved172 */
	0x00,  /* Reserved173 */
	0x40, 0x00,  /* TX_PULSES_NUM_GLOVE_MUTUAL */
	0x40, 0x00,  /* TX_PULSES_NUM_GLOVE_SELF */
	0x40, 0x00,  /* TX_PULSES_NUM_GLOVE_BUTTON_MUTUAL */
	0x20, 0x00,  /* TX_PULSES_NUM_GLOVE_BUTTON_SELF */
	0x40,  /* Reserved182 */
	0x00,  /* Reserved183 */
	0x40,  /* Reserved184 */
	0x00,  /* Reserved185 */
	0x00, 0x00,  /* Reserved186 */
	0x00, 0x40, 0x51, 0x55, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x15, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x55, 0x51, 0x55, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_SENSOR_MASKS */
	0x1E, 0x1C, 0x1A, 0x18, 
	0x16, 0x14, 0x10, 0x0E, 
	0x0C, 0x0A, 0x08, 0x09, 
	0x08, 0x07, 0x06, 0x05, 
	0x04, 0x03, 0x02, 0x01, 
	0x00, 0x17, 0x16, 0x15, 
	0x14, 0x13, 0x12, 0x11, 
	0x10, 0x0F, 0x0E, 0x0D, 
	0x0C, 0x18, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_PIN_INDEX_TABLE */
	0x16, 0x14, 0x12, 0x10, 
	0x0E, 0x0C, 0x0A, 0x08, 
	0x06, 0x04, 0x02, 0x09, 
	0x08, 0x07, 0x06, 0x05, 
	0x04, 0x03, 0x02, 0x01, 
	0x00, 0x17, 0x16, 0x15, 
	0x14, 0x13, 0x12, 0x11, 
	0x10, 0x0F, 0x0E, 0x0D, 
	0x0C, 0x18, 0x23, 0x22, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00,  /* CDC_REAL_PIN_INDEX_TABLE */
	0x00, 0x00, 0x00,  /* Reserved341 */
	0x01, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_MTX_PHASE_VECTOR */
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_MTX_DECONV_COEF */
	0x00, 0x40, 0x51, 0x55, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x28, 0x3F, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x08, 0xFF, 0xFF, 
	0xFF, 0x07, 0xFF, 0x06, 
	0xFF, 0xFF, 0x02, 0x05, 
	0x01, 0x04, 0x00, 0x03, 
	0x00, 0x15, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x52, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x03, 0xFF, 0x08, 
	0xFF, 0xFF, 0x0A, 0xFF, 
	0x09, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x00, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x00, 
	0x18, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x0C, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0xFF, 0x02, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 
	0x01, 0x00, 0xFF, 0xFF, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00,  /* CDC_SLOT_TABLE */
	0xF4, 0x01,  /* MAX_SELF_SIG_THRESHOLD */
	0x08, 0x07,  /* MAX_POSITIVE_THRESHOLD */
	0x03, 0x00,  /* RANGE_DATA_RESET */
	0x32,  /* BL_THRESHOLD_MUT */
	0x64,  /* BL_THRESHOLD_SELF */
	0x07,  /* RATIO_MAXMUT_TO_MAXSELF */
	0x1E,  /* MIN_POSITIVE_THRESHOLD */
	0x07,  /* RATIO_SUMALL_TO_POSITIVE */
	0x01,  /* COUNTS_TO_BL_RESET_MUT */
	0x01,  /* COUNTS_TO_BL_RESET_SELF */
	0x32,  /* BL_THRESHOLD_MUT_GLOVE */
	0x64,  /* BL_THRESHOLD_SELF_GLOVE */
	0x01,  /* COUNTS_TO_BL_RESET_MUT_GLOVE */
	0x01,  /* COUNTS_TO_BL_RESET_SELF_GLOVE */
	0x03,  /* SELF_LIFTOFF_SENSOR_NUM_GLOVE */
	0x64, 0x00,  /* SELF_LIFTOFF_THRESHOLD_GLOVE */
	0x00,  /* Reserved656 */
	0x03,  /* BL_DELAY_BTN */
	0x50,  /* BL_FILT_BTN_MUT */
	0x50,  /* BL_FILT_BTN_SELF */
	0x00, 0x00,  /* Reserved660 */
	0xC8, 0x00,  /* SELF_LIFTOFF_THRESHOLD */
	0x03, 0x00,  /* SELF_LIFTOFF_SENSOR_NUM */
	0x88, 0x13,  /* SELF_LIFTOFF_TIMEOUT */
	0x64, 0x00,  /* MAX_MUTUAL_SCAN_INTERVAL */
	0x64, 0x00,  /* MAX_SELF_SCAN_INTERVAL */
	0x0A, 0x00,  /* BL_BTN_THRSH_MUT */
	0x0A, 0x00,  /* BL_BTN_THRSH_SELF */
	0x0A, 0x00,  /* BL_BTN_THRSH_MUT_CA */
	0x0A, 0x00,  /* BL_BTN_THRSH_MUT_GLOVE */
	0x0A, 0x00,  /* BL_BTN_THRSH_SELF_GLOVE */
	0x00, 0x00,  /* Reserved682 */
	0x00,  /* SD_CORRECTION_ENABLE */
	0x00,  /* Reserved685 */
	0xB8, 0x0B,  /* SD_CORRECTION_TARGET */
	0xF4, 0x01,  /* SD_CORRECTION_MIN_COEF */
	0xC8, 0x00,  /* SD_CORRECTION_FINGER_THR */
	0x96, 0x00,  /* SD_CORRECTION_SELF_THR */
	0x00, 0x00,  /* Reserved694 */
	0x03,  /* CMF_DELTA_TEMPCO_INCREMENT */
	0x00,  /* SELF_MUTUAL_ENABLE */
	0x0A,  /* SELF_MUTUAL_DIVIDER */
	0x00,  /* Reserved699 */
	0x00,  /* DYNAMIC_CMF_ENABLE */
	0x03,  /* DYNAMIC_CMF_TOUCH_NUMBER_LIMIT */
	0x20, 0x03,  /* DYNAMIC_CMF_UPPER_LIMIT_MUTUAL */
	0x20, 0x03,  /* DYNAMIC_CMF_UPPER_LIMIT_SELF */
	0xF4, 0x01,  /* DYNAMIC_CMF_UPPER_LIMIT_BTN_MUT */
	0xF4, 0x01,  /* DYNAMIC_CMF_UPPER_LIMIT_BTN_SELF */
	0x32, 0x00,  /* DYNAMIC_CMF_MARGIN */
	0xDC, 0x05,  /* WF_RAW_VAR_THOLD */
	0xAC, 0x0D,  /* WF_RAW_HIGH_THOLD */
	0xF4, 0x01,  /* WF_DIFF_VAR_THOLD */
	0xFA, 0x00,  /* WF_RAW_CALC_THOLD */
	0xC8, 0x00,  /* WF_DIFF_CALC_THOLD */
	0x0A,  /* WF_ENTER_DEBOUNCE */
	0x0A,  /* WF_EXIT_DEBOUNCE */
	0x03,  /* FILT_FILTER_MASK */
	0x01,  /* FILT_IIR_COEFF_MUT */
	0x1E, 0x00,  /* FILT_IIR_THRESHOLD_MUT */
	0x3C, 0x00,  /* FILT_CMF_THRESHOLD_MUT */
	0x03,  /* FILT_FILTER_MASK_BASE_SELF */
	0x01,  /* FILT_IIR_COEFF_SELF */
	0x1E, 0x00,  /* FILT_IIR_THRESHOLD_SELF */
	0x3C, 0x00,  /* CMF_THR_SELF */
	0x03,  /* FILT_FILTER_MASK_BTN_MUT */
	0x01,  /* FILT_IIR_COEFF_BUT */
	0x14, 0x00,  /* FILT_IIR_THRESHOLD_BUT */
	0x3C, 0x00,  /* CMF_THR_BTN_MUT */
	0x03,  /* FILT_FILTER_MASK_BTN_SELF */
	0x01,  /* FILT_IIR_COEFF_BUT_BASE_SELF */
	0x14, 0x00,  /* FILT_IIR_THRESHOLD_BUT_BASE_SELF */
	0x3C, 0x00,  /* CMF_THR_BTN_SELF */
	0x03,  /* Reserved748 */
	0x01,  /* Reserved749 */
	0x14,  /* Reserved750 */
	0x00,  /* Reserved751 */
	0x3C,  /* Reserved752 */
	0x00,  /* Reserved753 */
	0x03,  /* CAFILT_FILTER_MASK */
	0x01,  /* CAFILT_IIR_COEFF_MUT */
	0x14, 0x00,  /* CAFILT_IIR_THRESHOLD_MUT */
	0x3C, 0x00,  /* CAFILT_CMF_THRESHOLD_MUT */
	0x03,  /* CAFILT_FILT_BTN_MUT */
	0x01,  /* CAFILT_IIR_COEFF_BUT */
	0x14, 0x00,  /* CAFILT_IIR_THRESHOLD_BUT */
	0x3C, 0x00,  /* CAFILT_CMF_THRESHOLD_BUT_MUT */
	0x03,  /* FILT_FILTER_MASK_GLOVE_MUT */
	0x01,  /* FILT_IIR_COEFF_GLOVE_MUT */
	0x1E, 0x00,  /* FILT_IIR_THRESHOLD_GLOVE_MUT */
	0x3C, 0x00,  /* FILT_CMF_THRESHOLD_GLOVE_MUT */
	0x03,  /* FILT_FILTER_MASK_GLOVE_SELF */
	0x01,  /* FILT_IIR_COEFF_GLOVE_SELF */
	0x1E, 0x00,  /* FILT_IIR_THRESHOLD_GLOVE_SELF */
	0x3C, 0x00,  /* FILT_CMF_THRESHOLD_GLOVE_SELF */
	0x03,  /* FILT_FILTER_MASK_BUT_GLOVE_MUT */
	0x01,  /* FILT_IIR_COEFF_BUT_GLOVE_MUT */
	0x14, 0x00,  /* FILT_IIR_THRESHOLD_BUT_GLOVE_MUT */
	0x3C, 0x00,  /* FILT_CMF_THRESHOLD_GLOVE_BUT_MUT */
	0x03,  /* FILT_FILTER_MASK_BUT_GLOVE_SELF */
	0x01,  /* FILT_IIR_COEFF_BUT_GLOVE_SELF */
	0x14, 0x00,  /* FILT_IIR_THRESHOLD_BUT_GLOVE_SELF */
	0x3C, 0x00,  /* FILT_CMF_THRESHOLD_GLOVE_BUT_SELF */
	0x03,  /* Reserved790 */
	0x01,  /* Reserved791 */
	0x14,  /* Reserved792 */
	0x00,  /* Reserved793 */
	0x3C,  /* Reserved794 */
	0x00,  /* Reserved795 */
	0x03,  /* Reserved796 */
	0x01,  /* Reserved797 */
	0x14,  /* Reserved798 */
	0x00,  /* Reserved799 */
	0x3C,  /* Reserved800 */
	0x00,  /* Reserved801 */
	0x00,  /* FILT_FILTER_MASK_NOFILT */
	0x00,  /* FILT_IIR_COEFF_NOFILT */
	0x14, 0x00,  /* FILT_IIR_THRESHOLD_NOFILT */
	0x3C, 0x00,  /* FILT_CMF_THRESHOLD_NOFILT */
	0x00,  /* CA_HOST_CONTROLLED_CHARGER */
	0x00,  /* CHARGER_STATUS */
	0x06,  /* AFH_LISTEN_SCAN_CYCLE_REPEATS */
	0x06,  /* AFH_LISTENING_SCAN_COUNT */
	0xB4, 0x00,  /* Reserved812 */
	0x5A, 0x00,  /* Reserved814 */
	0x00,  /* CA_UNSTABLE_DETECTION_ENABLE */
	0x01,  /* CA_UNSTABLE_DEBOUNCE */
	0x00,  /* CA_LO_UNSTABLE_GAIN */
	0x00,  /* Reserved819 */
	0xE8, 0x03, 0x00, 0x00,  /* CA_UNSTABLE_REVERT_TIME */
	0xE8, 0x03, 0x00, 0x00,  /* CA_DEFAULT_REVERT_TIME */
	0x00, 0x00, 0x00, 0x00,  /* CA_DIFF_ABS_DELTA_SUM_THRESHOLD */
	0x88, 0x13, 0x00, 0x00,  /* CA_STUCKTOUCH_REVERT_TIME */
	0x0F, 0x00,  /* Reserved836 */
	0x0F, 0x00,  /* NM_INJ_TCH_THRESHOLD */
	0x01,  /* Reserved840 */
	0x0F,  /* Reserved841 */
	0x00,  /* Reserved842 */
	0x4B,  /* CA_DYN_CAL_NUM_SENSOR_THLD_PERCENT */
	0xD2, 0x00,  /* CA_DYN_CAL_SAFE_RAW_RANGE */
	0x00, 0x80,  /* CA_MIN_SELF_ALLOWED */
	0x41,  /* NM_INJ_TCH_THRESHOLD_HOP */
	0x00, 0x00, 0x00,  /* Reserved849 */
	0x01,  /* ACT_LFT_EN */
	0x08,  /* INNER_EDGE_GAIN */
	0x78,  /* OUTER_EDGE_GAIN */
	0x0C,  /* ACT_INTRVL0 */
	0x03, 0x00,  /* ACT_LFT_INTRVL0 */
	0x64, 0x00,  /* LP_INTRVL0 */
	0xE8, 0x03,  /* TCH_TMOUT0 */
	0x64, 0x00,  /* FINGER_THRESH_SELF */
	0x50, 0x00,  /* GLOVE_THRSH_SELF */
	0x80, 0x00,  /* Z_SCALING */
	0x01,  /* LOW_POWER_ENABLE */
	0x00, 0x00, 0x00,  /* Reserved869 */
	0x01,  /* ACT_DIST0 */
	0x01,  /* ACT_DIST2 */
	0x00,  /* ACT_PRECISE_DIST */
	0x00,  /* ACT_DIST_TOUCHDOWN */
	0x00,  /* ACT_DIST_LIFTOFF */
	0x00,  /* ACT_DIST_COUNTER */
	0xFF,  /* ACT_DIST_Z_THRESHOLD */
	0x00,  /* FIRST_TOUCH_SUPPRESSION */
	0x01,  /* OBJ_WITHHOLD_CFG */
	0x00, 0x00, 0x00,  /* Reserved881 */
	0x04, 0x17, 0x03, 0x00,  /* FINGER_ID_MAX_FINGER_VELOCITY2 */
	0x79, 0x00, 0x00, 0x00,  /* CA_FINGER_ID_MAX_FINGER_VELOCITY2 */
	0x50, 0xC3, 0x00, 0x00,  /* FINGER_ID_MAX_FINGER_ACCELERATION2 */
	0x00, 0x00, 0x00, 0x00,  /* FINGER_ID_MIN_PREV_FINGER_VELOCITY */
	0x00, 0x00,  /* GRIP_XEDG_A */
	0x00, 0x00,  /* GRIP_XEDG_B */
	0x00, 0x00,  /* GRIP_XEXC_A */
	0x00, 0x00,  /* GRIP_XEXC_B */
	0x00, 0x00,  /* GRIP_YEDG_A */
	0x00, 0x00,  /* GRIP_YEDG_B */
	0x00, 0x00,  /* GRIP_YEXC_A */
	0x00, 0x00,  /* GRIP_YEXC_B */
	0x01,  /* GRIP_FIRST_EXC */
	0x00,  /* GRIP_EXC_EDGE_ORIGIN */
	0x00,  /* GRIP_ENABLE */
	0x00,  /* LIFTOFF_DEBOUNCE */
	0x00,  /* Reserved920 */
	0x00,  /* Reserved921 */
	0x00,  /* LIFTOFF_DEBOUNCE_HOVER */
	0x00,  /* GLOVE_LIFTOFF_DEBOUNCE */
	0x01,  /* TOUCHMODE_KEEP_FIRST_REPORT_TYPE */
	0x00, 0x00, 0x00,  /* Reserved925 */
	0x00, 0x00,  /* TOUCHMODE_FINGER_SWITCH_DEBOUNCE */
	0x00, 0x00,  /* TOUCHMODE_FINGER_EXIT_DELAY */
	0x50, 0x00,  /* SELF_Z_THRSH */
	0x00, 0x00,  /* TOUCHMODE_GLOVE_SWITCH_DEBOUNCE */
	0x00, 0x00,  /* TOUCHMODE_GLOVE_FINGER_SWITCH_DEBOUNCE */
	0x00, 0x00,  /* TOUCHMODE_GLOVE_EXIT_DELAY */
	0x32,  /* TOUCHMODE_GLOVE_NOISE_DEBOUNCE */
	0x00,  /* Reserved941 */
	0x00, 0x00,  /* Reserved942 */
	0x00,  /* CLIPPING_X_LOW */
	0x00,  /* CLIPPING_X_HIGH */
	0x00,  /* CLIPPING_Y_LOW */
	0x00,  /* CLIPPING_Y_HIGH */
	0x00,  /* H2O_REJECTION_SNS_WIDTH */
	0x00,  /* SLIM_POSITION_OFFSET_ALONG_TX */
	0x00,  /* SLIM_POSITION_OFFSET_ALONG_RX */
	0x01,  /* OBJECT_INDEX_MAX_VELOCITY */
	0x05,  /* LARGE_OBJECT_DEBOUNCE */
	0x00,  /* Reserved953 */
	0x00, 0x00,  /* Reserved954 */
	0x00,  /* BR2_ALWAYS_ON_FLAG */
	0x03,  /* EDGE_DEBOUNCE_COUNT */
	0x02, 0x00,  /* CALC_THRESHOLD */
	0x05, 0x00,  /* OFFSET_S1 */
	0x02, 0x00,  /* OFFSET_S2 */
	0xB8, 0x0B, 0x00, 0x00,  /* Z1_SUM_8MM */
	0xB0, 0x04, 0x00, 0x00,  /* Z2_SUM_4MM */
	0x4A, 0x01, 0x00, 0x00,  /* Z1_SUM_3MM */
	0x82, 0x00, 0x00, 0x00,  /* Z2_SUM_1MM */
	0xF4, 0x01, 0x00, 0x00,  /* LOW_PIVOT */
	0x40, 0x06, 0x00, 0x00,  /* HIGH_PIVOT */
	0x78, 0x00, 0x00, 0x00,  /* LOW_PIVOT2 */
	0xB4, 0x00, 0x00, 0x00,  /* HIGH_PIVOT2 */
	0xE8, 0x03,  /* EDGE_DEBOUNCE_COUNT_THRESHOLD */
	0x78, 0x00,  /* CENTER_MAGNITUDE_SCALE */
	0x03,  /* CENTROID_CORNER_NUMER */
	0x04,  /* CENTROID_CORNER_DENOM */
	0x03,  /* CENTROID_FINGER_MAX_JUMP */
	0x68,  /* GRADIENT_OUTER_EDGE_CONST_GAIN */
	0x80,  /* GRADIENT_OUTER_EDGE_CONST_RESPONSE */
	0x40,  /* GRADIENT_EDGE_COEF */
	0x04,  /* GRADIENT_COEF */
	0x19,  /* GRADIENT_THRESHOLD */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1008 */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1012 */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1016 */
	0x17, 0x09, 0x99, 0x04,  /* Reserved1020 */
	0xD9, 0x06, 0x99, 0x04,  /* Reserved1024 */
	0x3C, 0x32, 0xAD, 0x09,  /* Reserved1028 */
	0xFF, 0x15, 0xFD, 0x14,  /* Reserved1032 */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1036 */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1040 */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1044 */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1048 */
	0x00, 0x00, 0x00, 0x00,  /* Reserved1052 */
	0x00,  /* Reserved1056 */
	0x00,  /* FIXED_FINGER_SIZE */
	0x00, 0x00,  /* Reserved1058 */
	0xE8, 0x03, 0x00, 0x00,  /* MIN_FAT_FINGER_Z9 */
	0xA0, 0x0F, 0x00, 0x00,  /* MAX_MULTI_FINGER_Z9 */
	0xE8, 0x03, 0x00, 0x00,  /* MIN_FAT_FINGER_SIG_SUM_ON_EDGE */
	0x2E,  /* CENTER_SIGNAL_TO_MIN_PEAK_RATIO */
	0x5A,  /* SD_SIZE_THRESHOLD */
	0x09,  /* SD_FEW_PEAK_SIZE_THRESHOLD */
	0x00,  /* Reserved1075 */
	0x9F, 0x24,  /* SD_ENTER_SIGNAL_THRESHOLD */
	0x45, 0x33,  /* SD_EXIT_SIGNAL_THRESHOLD */
	0x05,  /* FAT_AXIS_LENGTH_THRESHOLD */
	0x00,  /* TOUCH_IGNORE_COEFF */
	0x00, 0x00,  /* Reserved1082 */
	0x64, 0x00,  /* SELF_CENTROID_THR_RX */
	0x14, 0x00,  /* SELF_CENTROID_THR_RX_HYST */
	0x64, 0x00,  /* SELF_CENTROID_THR_TX */
	0x14, 0x00,  /* SELF_CENTROID_THR_TX_HYST */
	0x00,  /* SELF_GRIP_RX_SNS_NUM */
	0x00,  /* SELF_GRIP_TX_SNS_NUM */
	0x80,  /* SELF_MULT_PEAK_FILTER_COEF */
	0x03,  /* SELF_CENTROID_WINDOW_SIZE */
	0x90, 0x01,  /* FINGER_THRESH_MUTUAL_ON */
	0xFA, 0x00,  /* FINGER_THRESH_MUTUAL_OFF */
	0x90, 0x01,  /* CA_FINGER_THRESHOLD_MUTUAL */
	0x01,  /* MULTI_TOUCH_DEBOUNCE */
	0x04,  /* Z9_FILTER_SCALE */
	0x05,  /* CA_MULTI_TOUCH_DEBOUNCE */
	0x04,  /* CA_Z9_FILTER_SCALE */
	0x04, 0x00,  /* MAX_FAT_FINGER_SIZE_HYST */
	0x0D, 0x00,  /* MAX_FAT_FINGER_SIZE_ON */
	0x28, 0x00,  /* CA_MAX_FAT_FINGER_SIZE */
	0x01,  /* MIN_FAT_FINGER_SIZE_HYST */
	0x03,  /* MIN_FAT_FINGER_SIZE_ON */
	0x0F,  /* CA_MIN_FAT_FINGER_SIZE */
	0x03,  /* TOUCH_TRACKING_FEATURES */
	0x40,  /* SIGNAL_THRESHOLD_MULTIPLIER */
	0x30,  /* SD_SIGNAL_THRESHOLD_MULTIPLIER */
	0x32,  /* WF_FT_COEF */
	0x05,  /* WF_MT_DEBOUNCE */
	0x40,  /* WF_SIGNAL_THRESHOLD_MULTIPLIER */
	0x80,  /* WF_1STFINGER_VS_2NDFINGER */
	0x01,  /* RX_LINE_FILTER */
	0x58,  /* RX_LINE_FILTER_DEBOUNCE */
	0x0A,  /* RX_LINE_FILTER_THRESHOLD */
	0x05,  /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_FINGER_MODE */
	0x00,  /* RX_LINE_IGNORE_FILTER */
	0x02,  /* RX_LINE_IGNORE_FILTER_DEBOUNCE */
	0x28,  /* RX_LINE_IGNORE_FILTER_THRESHOLD */
	0x73,  /* TRACKING_EDGE_OUTER_GAIN */
	0x00, 0x00,  /* Reserved1130 */
	0x0F,  /* WF_Z8_MULTIPLIER */
	0x02,  /* WF_DETECT_PEAK_Z9_SCALE */
	0x64, 0x00,  /* WF_DETECT_PEAK_THR */
	0xE8, 0x03, 0x00, 0x00,  /* WF_DETECT_PEAK_Z9_THR */
	0x0C,  /* WF_DETECT_PEAK_Z8_SCALE */
	0x03,  /* WF_DETECT_PEAK_DEBOUNCE */
	0x01,  /* WF_DETECT_PEAK_COUNT */
	0x00,  /* Reserved1143 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_0 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_1 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_2 */
	0x50,  /* BTN_LS_ON_THRSH_MUT_3 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_0 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_1 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_2 */
	0x46,  /* BTN_LS_OFF_THRSH_MUT_3 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_0 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_1 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_2 */
	0x41,  /* BTN_LS_ON_THRSH_SELF_3 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_0 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_1 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_2 */
	0x28,  /* BTN_LS_OFF_THRSH_SELF_3 */
	0x00, 0x00,  /* BTN_LS_TOUCHDOWN_DEBOUNCE */
	0x00, 0x00,  /* Reserved1162 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_0 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_1 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_2 */
	0x14,  /* BTN_HS_ON_THRSH_MUT_3 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_0 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_1 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_2 */
	0x0A,  /* BTN_HS_OFF_THRSH_MUT_3 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_0 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_1 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_2 */
	0x1E,  /* BTN_HS_ON_THRSH_SELF_3 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_0 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_1 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_2 */
	0x0A,  /* BTN_HS_OFF_THRSH_SELF_3 */
	0x01, 0x00,  /* BTN_HS_TOUCHDOWN_DEBOUNCE */
	0x00, 0x00,  /* Reserved1182 */
	0x0A, 0x00,  /* GLOVE_BTN_FORBID_DEBOUNCE */
	0x28, 0x00,  /* GLOVE_BTN_TO_HIGHSEN_MODE_SWITCH_THRSH_MUT */
	0x28, 0x00,  /* GLOVE_BTN_TO_HIGHSEN_MODE_SWITCH_THRSH_SELF */
	0xC8, 0x00,  /* GLOVE_BTN_TO_LOWSEN_MODE_SWITCH_THRSH_MUT */
	0x5E, 0x01,  /* GLOVE_BTN_TO_LOWSEN_MODE_SWITCH_THRSH_SELF */
	0x01, 0x00,  /* GLOVE_BTN_MODE_SWITCH_DEBOUNCE */
	0x00,  /* BTN_REPORT_IF_TOUCH_DETECTED */
	0x00,  /* Reserved1197 */
	0x00, 0x00,  /* Reserved1198 */
	0x90, 0x01,  /* TOUCHMODE_GLOVE_MAX_PEAK */
	0x64, 0x00,  /* GLOVE_ON_THRSH_MUTUAL */
	0x32, 0x00,  /* GLOVE_OFF_THRSH_MUTUAL */
	0x02,  /* GLOVE_FIRST_TOUCH_DEBOUNCE */
	0x00,  /* GLOVE_FIRST_TOUCH_DEBOUNCE_EDGE_MASK */
	0x00,  /* GLOVE_MULTI_TOUCH_DEBOUNCE */
	0x01,  /* GLOVE_Z8_FILTER_SCALE */
	0x04,  /* GLOVE_Z9_FILTER_SCALE */
	0x14,  /* GLOVE_GRIP_FILTER_SCALE */
	0xE8, 0x03,  /* GLOVE_Z_SCALING */
	0x0D, 0x00,  /* GLOVE_MAX_FAT_FINGER_SIZE */
	0x04, 0x00,  /* GLOVE_MAX_FAT_FINGER_HYST */
	0x03,  /* GLOVE_MIN_FAT_FINGER_SIZE */
	0x01,  /* GLOVE_MIN_FAT_FINGER_HYST */
	0x40,  /* GLOVE_SIGNAL_THRESHOLD_MULTIPLIER */
	0x08,  /* GLOVE_INNER_EDGE_GAIN */
	0x78,  /* GLOVE_OUTER_EDGE_GAIN */
	0x00,  /* Reserved1223 */
	0xF0, 0x00, 0x00, 0x00,  /* XY_FILTER_MASK */
	0x02, 0x00, 0x00, 0x00,  /* XY_FILT_IIR_COEFF */
	0x01, 0x00, 0x00, 0x00,  /* XY_FILT_Z_IIR_COEFF */
	0x64,  /* XY_FILT_XY_FAST_THR */
	0x32,  /* XY_FILT_XY_SLOW_THR */
	0x01,  /* XY_FILT_IIR_FAST_COEFF */
	0x00,  /* XY_FILT_PREDICTION_COEF */
	0xF0, 0x00, 0x00, 0x00,  /* XY_FILTER_MASK_CA */
	0x02, 0x00, 0x00, 0x00,  /* XY_FILT_IIR_COEFF_CA */
	0x02, 0x00, 0x00, 0x00,  /* XY_FILT_Z_IIR_COEFF_CA */
	0xC8,  /* XY_FILT_XY_FAST_THR_CA */
	0x64,  /* XY_FILT_XY_SLOW_THR_CA */
	0x01,  /* XY_FILT_IIR_FAST_COEFF_CA */
	0x00,  /* XY_FILT_PREDICTION_COEF_CA */
	0x00,  /* XY_FILT_EXTRA_IIR_FILTER */
	0x00,  /* XY_FILT_TOUCH_SIZE_IIR_COEFF */
	0x00,  /* XY_FILT_TOUCH_SIZE_HYST */
	0x00,  /* XY_FILT_TOUCH_ORIENTATION_IIR_COEFF */
	0x00,  /* XY_FILT_TOUCH_ORIENTATION_HYST */
	0x00, 0x00, 0x00,  /* Reserved1261 */
	0x00,  /* SIZE_ORIENTATION_ENABLE */
	0x00, 0x00, 0x00,  /* Reserved1265 */
	0x32,  /* ACTIVE_AREA_TO_EDGE */
	0x00,  /* SINGLE_OR_DOUBLE_CLICK_SEL */
	0x64, 0x00,  /* SINGLE_CLICK_MAX_JITTER */
	0x0A, 0x00,  /* SINGLE_CLICK_MIN_DURATION */
	0x2C, 0x01,  /* SINGLE_CLICK_MAX_DURATION */
	0x32,  /* DCLICK_MIN_INTERVAL */
	0x00,  /* Reserved1277 */
	0x2C, 0x01,  /* DCLICK_MAX_INTERVAL */
	0x64, 0x00,  /* DCLICK_MAX_JITTER_DIST */
	0x26, 0x02,  /* SLIDE_MAX_SPACE */
	0x32,  /* SLIDE_MAX_JITTER_DIST */
	0x00, 0x00, 0x00,  /* Reserved1285 */
	0x00,  /* POST_CFG */
	0x01,  /* PWR_CFG */
	0x00,  /* SEND_REPORT_AFTER_ACTIVE_INTERVAL_CFG */
	0x00,  /* PIP_REPORTING_DISABLE */
	0x00, 0x00,  /* INTERRUPT_PIN_OVERRIDE */
	0x00,  /* Reserved1294 */
	0x00,  /* IMO_CLOCK_FREQUENCY_SELECT */
	0x25, 0xD2,  /* CONFIG_CRC */
};

/* Touchscreen Parameters Field Sizes (Writable: 0:Readonly; 1:Writable) */
static const uint16_t cyttsp4_param_size[] = {
/*	Size	Name	*/
	2, /* CONFIG_DATA_SIZE */
	2, /* CONFIG_DATA_MAX_SIZE */
	2, /* X_RESOLUTION */
	2, /* Y_RESOLUTION */
	2, /* CONFIG_VER */
	2, /* X_LEN_PHY */
	2, /* Y_LEN_PHY */
	2, /* CROSS_NUM */
	1, /* TX_NUM */
	1, /* RX_NUM */
	1, /* SENS_NUM */
	1, /* SENSOR_ASSIGNMENT */
	1, /* Reserved20 */
	1, /* BL_H20_RJCT */
	1, /* CHARGER_ARMOR_ENABLE */
	1, /* TOUCHMODE_ENABLED */
	1, /* Reserved24 */
	1, /* Reserved25 */
	1, /* LRG_OBJ_CFG */
	1, /* BUTTON_NUM */
	1, /* Reserved28 */
	1, /* MAX_NUM_OF_REPORTED_TOUCHES */
	1, /* MAX_NUM_OF_SUPPORTED_TOUCHES */
	1, /* SCANNING_MODE_BUTTON */
	1, /* OPMODE_CFG */
	1, /* SELF_Z_MODE */
	1, /* WF_ENABLE */
	1, /* Reserved35 */
	4, /* PQ_CTRL */
	4, /* PQ_CTRL2 */
	4, /* PQ_CTRL3 */
	4, /* REFGEN_CTL */
	4, /* TX_CTRL */
	4, /* RX_CTRL */
	4, /* INFRA_CTRL */
	1, /* STARTUP_DELAY */
	1, /* FORCE_SINGLE_TX */
	1, /* SLOTS_MUT */
	1, /* SLOTS_SELF_RX */
	1, /* SLOTS_SELF_TX */
	1, /* SLOTS_SELF */
	2, /* SCALING_FACTOR_MUTUAL */
	2, /* SCALING_FACTOR_SELF */
	2, /* SCALING_FACTOR_BUTTON_MUTUAL */
	2, /* SCALING_FACTOR_BUTTON_SELF */
	2, /* Reserved78 */
	1, /* TX_PUMP_VOLTAGE */
	1, /* DISCARD_TIME */
	1, /* VDDA_MODE */
	1, /* BUTTON_LAYOUT */
	1, /* MTX_ORDER */
	1, /* EXT_SYNC */
	1, /* TX_FREQ_METHOD_MUTUAL */
	1, /* TX_FREQ_METHOD_SELF */
	1, /* Reserved88 */
	1, /* Reserved89 */
	1, /* Reserved90 */
	1, /* Reserved91 */
	1, /* RX_ATTEN_RES_BYPASS */
	1, /* SAFE_RAW_RANGE_PERCENT_MUTUAL */
	1, /* SAFE_RAW_RANGE_PERCENT_SELF */
	1, /* SAFE_RAW_RANGE_PERCENT_BTN_MUTUAL */
	1, /* SAFE_RAW_RANGE_PERCENT_BTN_SELF */
	1, /* Reserved97 */
	2, /* INTEGRATOR_VOLTAGE_MUTUAL */
	2, /* INTEGRATOR_VOLTAGE_SELF */
	2, /* INTEGRATOR_VOLTAGE_BUTTON_MUTUAL */
	2, /* INTEGRATOR_VOLTAGE_BUTTON_SELF */
	1, /* BALANCING_TARGET_MUTUAL */
	1, /* BALANCING_TARGET_SELF */
	1, /* BALANCING_TARGET_BUTTON_MUTUAL */
	1, /* BALANCING_TARGET_BUTTON_SELF */
	2, /* ILEAK_MAX */
	2, /* VDDA_LEVEL */
	2, /* DELAY_TIME_FOR_PUMP */
	2, /* DELTA_CM */
	2, /* DELTA_CS_RX */
	2, /* MAX_FTX */
	1, /* BURST_NOISE_REJECTION_ENABLE */
	1, /* Reserved123 */
	1, /* Reserved124 */
	1, /* Reserved125 */
	2, /* OVERFLOW_CNT_THRESHOLD */
	2, /* OVERFLOW_CNT_BUTTON_THRESHOLD */
	2, /* OVERFLOW_DEBOUNCE_TIME */
	2, /* OVERFLOW_BUTTON_DEBOUNCE_TIME */
	2, /* TX_PERIOD_MUTUAL */
	2, /* CA_HOP0_TX_PERIOD_MUTUAL */
	2, /* CA_HOP1_TX_PERIOD_MUTUAL */
	2, /* CA_HOP2_TX_PERIOD_MUTUAL */
	2, /* Reserved142 */
	2, /* Reserved144 */
	2, /* TX_PERIOD_SELF */
	2, /* TX_PERIOD_BTN_MUTUAL */
	2, /* TX_PERIOD_BTN_SELF */
	2, /* TX_PULSES_NUM_MUTUAL */
	2, /* CA_BASE_TX_PULSES_NUM_MUTUAL */
	2, /* CA_HOP0_TX_PULSES_NUM_MUTUAL */
	2, /* CA_HOP1_TX_PULSES_NUM_MUTUAL */
	2, /* CA_HOP2_TX_PULSES_NUM_MUTUAL */
	2, /* Reserved162 */
	2, /* Reserved164 */
	2, /* TX_PULSES_NUM_SELF */
	2, /* TX_PULSES_NUM_BUTTON_MUTUAL */
	2, /* TX_PULSES_NUM_BUTTON_SELF */
	1, /* Reserved172 */
	1, /* Reserved173 */
	2, /* TX_PULSES_NUM_GLOVE_MUTUAL */
	2, /* TX_PULSES_NUM_GLOVE_SELF */
	2, /* TX_PULSES_NUM_GLOVE_BUTTON_MUTUAL */
	2, /* TX_PULSES_NUM_GLOVE_BUTTON_SELF */
	1, /* Reserved182 */
	1, /* Reserved183 */
	1, /* Reserved184 */
	1, /* Reserved185 */
	2, /* Reserved186 */
	48, /* CDC_SENSOR_MASKS */
	52, /* CDC_PIN_INDEX_TABLE */
	53, /* CDC_REAL_PIN_INDEX_TABLE */
	3, /* Reserved341 */
	8, /* CDC_MTX_PHASE_VECTOR */
	64, /* CDC_MTX_DECONV_COEF */
	220, /* CDC_SLOT_TABLE */
	2, /* MAX_SELF_SIG_THRESHOLD */
	2, /* MAX_POSITIVE_THRESHOLD */
	2, /* RANGE_DATA_RESET */
	1, /* BL_THRESHOLD_MUT */
	1, /* BL_THRESHOLD_SELF */
	1, /* RATIO_MAXMUT_TO_MAXSELF */
	1, /* MIN_POSITIVE_THRESHOLD */
	1, /* RATIO_SUMALL_TO_POSITIVE */
	1, /* COUNTS_TO_BL_RESET_MUT */
	1, /* COUNTS_TO_BL_RESET_SELF */
	1, /* BL_THRESHOLD_MUT_GLOVE */
	1, /* BL_THRESHOLD_SELF_GLOVE */
	1, /* COUNTS_TO_BL_RESET_MUT_GLOVE */
	1, /* COUNTS_TO_BL_RESET_SELF_GLOVE */
	1, /* SELF_LIFTOFF_SENSOR_NUM_GLOVE */
	2, /* SELF_LIFTOFF_THRESHOLD_GLOVE */
	1, /* Reserved656 */
	1, /* BL_DELAY_BTN */
	1, /* BL_FILT_BTN_MUT */
	1, /* BL_FILT_BTN_SELF */
	2, /* Reserved660 */
	2, /* SELF_LIFTOFF_THRESHOLD */
	2, /* SELF_LIFTOFF_SENSOR_NUM */
	2, /* SELF_LIFTOFF_TIMEOUT */
	2, /* MAX_MUTUAL_SCAN_INTERVAL */
	2, /* MAX_SELF_SCAN_INTERVAL */
	2, /* BL_BTN_THRSH_MUT */
	2, /* BL_BTN_THRSH_SELF */
	2, /* BL_BTN_THRSH_MUT_CA */
	2, /* BL_BTN_THRSH_MUT_GLOVE */
	2, /* BL_BTN_THRSH_SELF_GLOVE */
	2, /* Reserved682 */
	1, /* SD_CORRECTION_ENABLE */
	1, /* Reserved685 */
	2, /* SD_CORRECTION_TARGET */
	2, /* SD_CORRECTION_MIN_COEF */
	2, /* SD_CORRECTION_FINGER_THR */
	2, /* SD_CORRECTION_SELF_THR */
	2, /* Reserved694 */
	1, /* CMF_DELTA_TEMPCO_INCREMENT */
	1, /* SELF_MUTUAL_ENABLE */
	1, /* SELF_MUTUAL_DIVIDER */
	1, /* Reserved699 */
	1, /* DYNAMIC_CMF_ENABLE */
	1, /* DYNAMIC_CMF_TOUCH_NUMBER_LIMIT */
	2, /* DYNAMIC_CMF_UPPER_LIMIT_MUTUAL */
	2, /* DYNAMIC_CMF_UPPER_LIMIT_SELF */
	2, /* DYNAMIC_CMF_UPPER_LIMIT_BTN_MUT */
	2, /* DYNAMIC_CMF_UPPER_LIMIT_BTN_SELF */
	2, /* DYNAMIC_CMF_MARGIN */
	2, /* WF_RAW_VAR_THOLD */
	2, /* WF_RAW_HIGH_THOLD */
	2, /* WF_DIFF_VAR_THOLD */
	2, /* WF_RAW_CALC_THOLD */
	2, /* WF_DIFF_CALC_THOLD */
	1, /* WF_ENTER_DEBOUNCE */
	1, /* WF_EXIT_DEBOUNCE */
	1, /* FILT_FILTER_MASK */
	1, /* FILT_IIR_COEFF_MUT */
	2, /* FILT_IIR_THRESHOLD_MUT */
	2, /* FILT_CMF_THRESHOLD_MUT */
	1, /* FILT_FILTER_MASK_BASE_SELF */
	1, /* FILT_IIR_COEFF_SELF */
	2, /* FILT_IIR_THRESHOLD_SELF */
	2, /* CMF_THR_SELF */
	1, /* FILT_FILTER_MASK_BTN_MUT */
	1, /* FILT_IIR_COEFF_BUT */
	2, /* FILT_IIR_THRESHOLD_BUT */
	2, /* CMF_THR_BTN_MUT */
	1, /* FILT_FILTER_MASK_BTN_SELF */
	1, /* FILT_IIR_COEFF_BUT_BASE_SELF */
	2, /* FILT_IIR_THRESHOLD_BUT_BASE_SELF */
	2, /* CMF_THR_BTN_SELF */
	1, /* Reserved748 */
	1, /* Reserved749 */
	1, /* Reserved750 */
	1, /* Reserved751 */
	1, /* Reserved752 */
	1, /* Reserved753 */
	1, /* CAFILT_FILTER_MASK */
	1, /* CAFILT_IIR_COEFF_MUT */
	2, /* CAFILT_IIR_THRESHOLD_MUT */
	2, /* CAFILT_CMF_THRESHOLD_MUT */
	1, /* CAFILT_FILT_BTN_MUT */
	1, /* CAFILT_IIR_COEFF_BUT */
	2, /* CAFILT_IIR_THRESHOLD_BUT */
	2, /* CAFILT_CMF_THRESHOLD_BUT_MUT */
	1, /* FILT_FILTER_MASK_GLOVE_MUT */
	1, /* FILT_IIR_COEFF_GLOVE_MUT */
	2, /* FILT_IIR_THRESHOLD_GLOVE_MUT */
	2, /* FILT_CMF_THRESHOLD_GLOVE_MUT */
	1, /* FILT_FILTER_MASK_GLOVE_SELF */
	1, /* FILT_IIR_COEFF_GLOVE_SELF */
	2, /* FILT_IIR_THRESHOLD_GLOVE_SELF */
	2, /* FILT_CMF_THRESHOLD_GLOVE_SELF */
	1, /* FILT_FILTER_MASK_BUT_GLOVE_MUT */
	1, /* FILT_IIR_COEFF_BUT_GLOVE_MUT */
	2, /* FILT_IIR_THRESHOLD_BUT_GLOVE_MUT */
	2, /* FILT_CMF_THRESHOLD_GLOVE_BUT_MUT */
	1, /* FILT_FILTER_MASK_BUT_GLOVE_SELF */
	1, /* FILT_IIR_COEFF_BUT_GLOVE_SELF */
	2, /* FILT_IIR_THRESHOLD_BUT_GLOVE_SELF */
	2, /* FILT_CMF_THRESHOLD_GLOVE_BUT_SELF */
	1, /* Reserved790 */
	1, /* Reserved791 */
	1, /* Reserved792 */
	1, /* Reserved793 */
	1, /* Reserved794 */
	1, /* Reserved795 */
	1, /* Reserved796 */
	1, /* Reserved797 */
	1, /* Reserved798 */
	1, /* Reserved799 */
	1, /* Reserved800 */
	1, /* Reserved801 */
	1, /* FILT_FILTER_MASK_NOFILT */
	1, /* FILT_IIR_COEFF_NOFILT */
	2, /* FILT_IIR_THRESHOLD_NOFILT */
	2, /* FILT_CMF_THRESHOLD_NOFILT */
	1, /* CA_HOST_CONTROLLED_CHARGER */
	1, /* CHARGER_STATUS */
	1, /* AFH_LISTEN_SCAN_CYCLE_REPEATS */
	1, /* AFH_LISTENING_SCAN_COUNT */
	2, /* Reserved812 */
	2, /* Reserved814 */
	1, /* CA_UNSTABLE_DETECTION_ENABLE */
	1, /* CA_UNSTABLE_DEBOUNCE */
	1, /* CA_LO_UNSTABLE_GAIN */
	1, /* Reserved819 */
	4, /* CA_UNSTABLE_REVERT_TIME */
	4, /* CA_DEFAULT_REVERT_TIME */
	4, /* CA_DIFF_ABS_DELTA_SUM_THRESHOLD */
	4, /* CA_STUCKTOUCH_REVERT_TIME */
	2, /* Reserved836 */
	2, /* NM_INJ_TCH_THRESHOLD */
	1, /* Reserved840 */
	1, /* Reserved841 */
	1, /* Reserved842 */
	1, /* CA_DYN_CAL_NUM_SENSOR_THLD_PERCENT */
	2, /* CA_DYN_CAL_SAFE_RAW_RANGE */
	2, /* CA_MIN_SELF_ALLOWED */
	1, /* NM_INJ_TCH_THRESHOLD_HOP */
	3, /* Reserved849 */
	1, /* ACT_LFT_EN */
	1, /* INNER_EDGE_GAIN */
	1, /* OUTER_EDGE_GAIN */
	1, /* ACT_INTRVL0 */
	2, /* ACT_LFT_INTRVL0 */
	2, /* LP_INTRVL0 */
	2, /* TCH_TMOUT0 */
	2, /* FINGER_THRESH_SELF */
	2, /* GLOVE_THRSH_SELF */
	2, /* Z_SCALING */
	1, /* LOW_POWER_ENABLE */
	3, /* Reserved869 */
	1, /* ACT_DIST0 */
	1, /* ACT_DIST2 */
	1, /* ACT_PRECISE_DIST */
	1, /* ACT_DIST_TOUCHDOWN */
	1, /* ACT_DIST_LIFTOFF */
	1, /* ACT_DIST_COUNTER */
	1, /* ACT_DIST_Z_THRESHOLD */
	1, /* FIRST_TOUCH_SUPPRESSION */
	1, /* OBJ_WITHHOLD_CFG */
	3, /* Reserved881 */
	4, /* FINGER_ID_MAX_FINGER_VELOCITY2 */
	4, /* CA_FINGER_ID_MAX_FINGER_VELOCITY2 */
	4, /* FINGER_ID_MAX_FINGER_ACCELERATION2 */
	4, /* FINGER_ID_MIN_PREV_FINGER_VELOCITY */
	2, /* GRIP_XEDG_A */
	2, /* GRIP_XEDG_B */
	2, /* GRIP_XEXC_A */
	2, /* GRIP_XEXC_B */
	2, /* GRIP_YEDG_A */
	2, /* GRIP_YEDG_B */
	2, /* GRIP_YEXC_A */
	2, /* GRIP_YEXC_B */
	1, /* GRIP_FIRST_EXC */
	1, /* GRIP_EXC_EDGE_ORIGIN */
	1, /* GRIP_ENABLE */
	1, /* LIFTOFF_DEBOUNCE */
	1, /* Reserved920 */
	1, /* Reserved921 */
	1, /* LIFTOFF_DEBOUNCE_HOVER */
	1, /* GLOVE_LIFTOFF_DEBOUNCE */
	1, /* TOUCHMODE_KEEP_FIRST_REPORT_TYPE */
	3, /* Reserved925 */
	2, /* TOUCHMODE_FINGER_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_FINGER_EXIT_DELAY */
	2, /* SELF_Z_THRSH */
	2, /* TOUCHMODE_GLOVE_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_GLOVE_FINGER_SWITCH_DEBOUNCE */
	2, /* TOUCHMODE_GLOVE_EXIT_DELAY */
	1, /* TOUCHMODE_GLOVE_NOISE_DEBOUNCE */
	1, /* Reserved941 */
	2, /* Reserved942 */
	1, /* CLIPPING_X_LOW */
	1, /* CLIPPING_X_HIGH */
	1, /* CLIPPING_Y_LOW */
	1, /* CLIPPING_Y_HIGH */
	1, /* H2O_REJECTION_SNS_WIDTH */
	1, /* SLIM_POSITION_OFFSET_ALONG_TX */
	1, /* SLIM_POSITION_OFFSET_ALONG_RX */
	1, /* OBJECT_INDEX_MAX_VELOCITY */
	1, /* LARGE_OBJECT_DEBOUNCE */
	1, /* Reserved953 */
	2, /* Reserved954 */
	1, /* BR2_ALWAYS_ON_FLAG */
	1, /* EDGE_DEBOUNCE_COUNT */
	2, /* CALC_THRESHOLD */
	2, /* OFFSET_S1 */
	2, /* OFFSET_S2 */
	4, /* Z1_SUM_8MM */
	4, /* Z2_SUM_4MM */
	4, /* Z1_SUM_3MM */
	4, /* Z2_SUM_1MM */
	4, /* LOW_PIVOT */
	4, /* HIGH_PIVOT */
	4, /* LOW_PIVOT2 */
	4, /* HIGH_PIVOT2 */
	2, /* EDGE_DEBOUNCE_COUNT_THRESHOLD */
	2, /* CENTER_MAGNITUDE_SCALE */
	1, /* CENTROID_CORNER_NUMER */
	1, /* CENTROID_CORNER_DENOM */
	1, /* CENTROID_FINGER_MAX_JUMP */
	1, /* GRADIENT_OUTER_EDGE_CONST_GAIN */
	1, /* GRADIENT_OUTER_EDGE_CONST_RESPONSE */
	1, /* GRADIENT_EDGE_COEF */
	1, /* GRADIENT_COEF */
	1, /* GRADIENT_THRESHOLD */
	4, /* Reserved1008 */
	4, /* Reserved1012 */
	4, /* Reserved1016 */
	4, /* Reserved1020 */
	4, /* Reserved1024 */
	4, /* Reserved1028 */
	4, /* Reserved1032 */
	4, /* Reserved1036 */
	4, /* Reserved1040 */
	4, /* Reserved1044 */
	4, /* Reserved1048 */
	4, /* Reserved1052 */
	1, /* Reserved1056 */
	1, /* FIXED_FINGER_SIZE */
	2, /* Reserved1058 */
	4, /* MIN_FAT_FINGER_Z9 */
	4, /* MAX_MULTI_FINGER_Z9 */
	4, /* MIN_FAT_FINGER_SIG_SUM_ON_EDGE */
	1, /* CENTER_SIGNAL_TO_MIN_PEAK_RATIO */
	1, /* SD_SIZE_THRESHOLD */
	1, /* SD_FEW_PEAK_SIZE_THRESHOLD */
	1, /* Reserved1075 */
	2, /* SD_ENTER_SIGNAL_THRESHOLD */
	2, /* SD_EXIT_SIGNAL_THRESHOLD */
	1, /* FAT_AXIS_LENGTH_THRESHOLD */
	1, /* TOUCH_IGNORE_COEFF */
	2, /* Reserved1082 */
	2, /* SELF_CENTROID_THR_RX */
	2, /* SELF_CENTROID_THR_RX_HYST */
	2, /* SELF_CENTROID_THR_TX */
	2, /* SELF_CENTROID_THR_TX_HYST */
	1, /* SELF_GRIP_RX_SNS_NUM */
	1, /* SELF_GRIP_TX_SNS_NUM */
	1, /* SELF_MULT_PEAK_FILTER_COEF */
	1, /* SELF_CENTROID_WINDOW_SIZE */
	2, /* FINGER_THRESH_MUTUAL_ON */
	2, /* FINGER_THRESH_MUTUAL_OFF */
	2, /* CA_FINGER_THRESHOLD_MUTUAL */
	1, /* MULTI_TOUCH_DEBOUNCE */
	1, /* Z9_FILTER_SCALE */
	1, /* CA_MULTI_TOUCH_DEBOUNCE */
	1, /* CA_Z9_FILTER_SCALE */
	2, /* MAX_FAT_FINGER_SIZE_HYST */
	2, /* MAX_FAT_FINGER_SIZE_ON */
	2, /* CA_MAX_FAT_FINGER_SIZE */
	1, /* MIN_FAT_FINGER_SIZE_HYST */
	1, /* MIN_FAT_FINGER_SIZE_ON */
	1, /* CA_MIN_FAT_FINGER_SIZE */
	1, /* TOUCH_TRACKING_FEATURES */
	1, /* SIGNAL_THRESHOLD_MULTIPLIER */
	1, /* SD_SIGNAL_THRESHOLD_MULTIPLIER */
	1, /* WF_FT_COEF */
	1, /* WF_MT_DEBOUNCE */
	1, /* WF_SIGNAL_THRESHOLD_MULTIPLIER */
	1, /* WF_1STFINGER_VS_2NDFINGER */
	1, /* RX_LINE_FILTER */
	1, /* RX_LINE_FILTER_DEBOUNCE */
	1, /* RX_LINE_FILTER_THRESHOLD */
	1, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_FINGER_MODE */
	1, /* RX_LINE_IGNORE_FILTER */
	1, /* RX_LINE_IGNORE_FILTER_DEBOUNCE */
	1, /* RX_LINE_IGNORE_FILTER_THRESHOLD */
	1, /* TRACKING_EDGE_OUTER_GAIN */
	2, /* Reserved1130 */
	1, /* WF_Z8_MULTIPLIER */
	1, /* WF_DETECT_PEAK_Z9_SCALE */
	2, /* WF_DETECT_PEAK_THR */
	4, /* WF_DETECT_PEAK_Z9_THR */
	1, /* WF_DETECT_PEAK_Z8_SCALE */
	1, /* WF_DETECT_PEAK_DEBOUNCE */
	1, /* WF_DETECT_PEAK_COUNT */
	1, /* Reserved1143 */
	1, /* BTN_LS_ON_THRSH_MUT_0 */
	1, /* BTN_LS_ON_THRSH_MUT_1 */
	1, /* BTN_LS_ON_THRSH_MUT_2 */
	1, /* BTN_LS_ON_THRSH_MUT_3 */
	1, /* BTN_LS_OFF_THRSH_MUT_0 */
	1, /* BTN_LS_OFF_THRSH_MUT_1 */
	1, /* BTN_LS_OFF_THRSH_MUT_2 */
	1, /* BTN_LS_OFF_THRSH_MUT_3 */
	1, /* BTN_LS_ON_THRSH_SELF_0 */
	1, /* BTN_LS_ON_THRSH_SELF_1 */
	1, /* BTN_LS_ON_THRSH_SELF_2 */
	1, /* BTN_LS_ON_THRSH_SELF_3 */
	1, /* BTN_LS_OFF_THRSH_SELF_0 */
	1, /* BTN_LS_OFF_THRSH_SELF_1 */
	1, /* BTN_LS_OFF_THRSH_SELF_2 */
	1, /* BTN_LS_OFF_THRSH_SELF_3 */
	2, /* BTN_LS_TOUCHDOWN_DEBOUNCE */
	2, /* Reserved1162 */
	1, /* BTN_HS_ON_THRSH_MUT_0 */
	1, /* BTN_HS_ON_THRSH_MUT_1 */
	1, /* BTN_HS_ON_THRSH_MUT_2 */
	1, /* BTN_HS_ON_THRSH_MUT_3 */
	1, /* BTN_HS_OFF_THRSH_MUT_0 */
	1, /* BTN_HS_OFF_THRSH_MUT_1 */
	1, /* BTN_HS_OFF_THRSH_MUT_2 */
	1, /* BTN_HS_OFF_THRSH_MUT_3 */
	1, /* BTN_HS_ON_THRSH_SELF_0 */
	1, /* BTN_HS_ON_THRSH_SELF_1 */
	1, /* BTN_HS_ON_THRSH_SELF_2 */
	1, /* BTN_HS_ON_THRSH_SELF_3 */
	1, /* BTN_HS_OFF_THRSH_SELF_0 */
	1, /* BTN_HS_OFF_THRSH_SELF_1 */
	1, /* BTN_HS_OFF_THRSH_SELF_2 */
	1, /* BTN_HS_OFF_THRSH_SELF_3 */
	2, /* BTN_HS_TOUCHDOWN_DEBOUNCE */
	2, /* Reserved1182 */
	2, /* GLOVE_BTN_FORBID_DEBOUNCE */
	2, /* GLOVE_BTN_TO_HIGHSEN_MODE_SWITCH_THRSH_MUT */
	2, /* GLOVE_BTN_TO_HIGHSEN_MODE_SWITCH_THRSH_SELF */
	2, /* GLOVE_BTN_TO_LOWSEN_MODE_SWITCH_THRSH_MUT */
	2, /* GLOVE_BTN_TO_LOWSEN_MODE_SWITCH_THRSH_SELF */
	2, /* GLOVE_BTN_MODE_SWITCH_DEBOUNCE */
	1, /* BTN_REPORT_IF_TOUCH_DETECTED */
	1, /* Reserved1197 */
	2, /* Reserved1198 */
	2, /* TOUCHMODE_GLOVE_MAX_PEAK */
	2, /* GLOVE_ON_THRSH_MUTUAL */
	2, /* GLOVE_OFF_THRSH_MUTUAL */
	1, /* GLOVE_FIRST_TOUCH_DEBOUNCE */
	1, /* GLOVE_FIRST_TOUCH_DEBOUNCE_EDGE_MASK */
	1, /* GLOVE_MULTI_TOUCH_DEBOUNCE */
	1, /* GLOVE_Z8_FILTER_SCALE */
	1, /* GLOVE_Z9_FILTER_SCALE */
	1, /* GLOVE_GRIP_FILTER_SCALE */
	2, /* GLOVE_Z_SCALING */
	2, /* GLOVE_MAX_FAT_FINGER_SIZE */
	2, /* GLOVE_MAX_FAT_FINGER_HYST */
	1, /* GLOVE_MIN_FAT_FINGER_SIZE */
	1, /* GLOVE_MIN_FAT_FINGER_HYST */
	1, /* GLOVE_SIGNAL_THRESHOLD_MULTIPLIER */
	1, /* GLOVE_INNER_EDGE_GAIN */
	1, /* GLOVE_OUTER_EDGE_GAIN */
	1, /* Reserved1223 */
	4, /* XY_FILTER_MASK */
	4, /* XY_FILT_IIR_COEFF */
	4, /* XY_FILT_Z_IIR_COEFF */
	1, /* XY_FILT_XY_FAST_THR */
	1, /* XY_FILT_XY_SLOW_THR */
	1, /* XY_FILT_IIR_FAST_COEFF */
	1, /* XY_FILT_PREDICTION_COEF */
	4, /* XY_FILTER_MASK_CA */
	4, /* XY_FILT_IIR_COEFF_CA */
	4, /* XY_FILT_Z_IIR_COEFF_CA */
	1, /* XY_FILT_XY_FAST_THR_CA */
	1, /* XY_FILT_XY_SLOW_THR_CA */
	1, /* XY_FILT_IIR_FAST_COEFF_CA */
	1, /* XY_FILT_PREDICTION_COEF_CA */
	1, /* XY_FILT_EXTRA_IIR_FILTER */
	1, /* XY_FILT_TOUCH_SIZE_IIR_COEFF */
	1, /* XY_FILT_TOUCH_SIZE_HYST */
	1, /* XY_FILT_TOUCH_ORIENTATION_IIR_COEFF */
	1, /* XY_FILT_TOUCH_ORIENTATION_HYST */
	3, /* Reserved1261 */
	1, /* SIZE_ORIENTATION_ENABLE */
	3, /* Reserved1265 */
	1, /* ACTIVE_AREA_TO_EDGE */
	1, /* SINGLE_OR_DOUBLE_CLICK_SEL */
	2, /* SINGLE_CLICK_MAX_JITTER */
	2, /* SINGLE_CLICK_MIN_DURATION */
	2, /* SINGLE_CLICK_MAX_DURATION */
	1, /* DCLICK_MIN_INTERVAL */
	1, /* Reserved1277 */
	2, /* DCLICK_MAX_INTERVAL */
	2, /* DCLICK_MAX_JITTER_DIST */
	2, /* SLIDE_MAX_SPACE */
	1, /* SLIDE_MAX_JITTER_DIST */
	3, /* Reserved1285 */
	1, /* POST_CFG */
	1, /* PWR_CFG */
	1, /* SEND_REPORT_AFTER_ACTIVE_INTERVAL_CFG */
	1, /* PIP_REPORTING_DISABLE */
	2, /* INTERRUPT_PIN_OVERRIDE */
	1, /* Reserved1294 */
	1, /* IMO_CLOCK_FREQUENCY_SELECT */
	2, /* CONFIG_CRC */
};

/* Touchscreen Parameters Field Address*/
static const uint8_t cyttsp4_param_addr[] = {
/*	Address	Name	*/
	0xF4, 0x80, /* CONFIG_DATA_SIZE */
	0xF4, 0x82, /* CONFIG_DATA_MAX_SIZE */
	0xF4, 0x84, /* X_RESOLUTION */
	0xF4, 0x86, /* Y_RESOLUTION */
	0xF4, 0x88, /* CONFIG_VER */
	0xF4, 0x8A, /* X_LEN_PHY */
	0xF4, 0x8C, /* Y_LEN_PHY */
	0xF4, 0x8E, /* CROSS_NUM */
	0xF4, 0x90, /* TX_NUM */
	0xF4, 0x91, /* RX_NUM */
	0xF4, 0x92, /* SENS_NUM */
	0xF4, 0x93, /* SENSOR_ASSIGNMENT */
	0xF4, 0x94, /* Reserved20 */
	0xF4, 0x95, /* BL_H20_RJCT */
	0xF4, 0x96, /* CHARGER_ARMOR_ENABLE */
	0xF4, 0x97, /* TOUCHMODE_ENABLED */
	0xF4, 0x98, /* Reserved24 */
	0xF4, 0x99, /* Reserved25 */
	0xF4, 0x9A, /* LRG_OBJ_CFG */
	0xF4, 0x9B, /* BUTTON_NUM */
	0xF4, 0x9C, /* Reserved28 */
	0xF4, 0x9D, /* MAX_NUM_OF_REPORTED_TOUCHES */
	0xF4, 0x9E, /* MAX_NUM_OF_SUPPORTED_TOUCHES */
	0xF4, 0x9F, /* SCANNING_MODE_BUTTON */
	0xF4, 0xA0, /* OPMODE_CFG */
	0xF4, 0xA1, /* SELF_Z_MODE */
	0xF4, 0xA2, /* WF_ENABLE */
	0xF4, 0xA3, /* Reserved35 */
	0xF4, 0xA4, /* PQ_CTRL */
	0xF4, 0xA8, /* PQ_CTRL2 */
	0xF4, 0xAC, /* PQ_CTRL3 */
	0xF4, 0xB0, /* REFGEN_CTL */
	0xF4, 0xB4, /* TX_CTRL */
	0xF4, 0xB8, /* RX_CTRL */
	0xF4, 0xBC, /* INFRA_CTRL */
	0xF4, 0xC0, /* STARTUP_DELAY */
	0xF4, 0xC1, /* FORCE_SINGLE_TX */
	0xF4, 0xC2, /* SLOTS_MUT */
	0xF4, 0xC3, /* SLOTS_SELF_RX */
	0xF4, 0xC4, /* SLOTS_SELF_TX */
	0xF4, 0xC5, /* SLOTS_SELF */
	0xF4, 0xC6, /* SCALING_FACTOR_MUTUAL */
	0xF4, 0xC8, /* SCALING_FACTOR_SELF */
	0xF4, 0xCA, /* SCALING_FACTOR_BUTTON_MUTUAL */
	0xF4, 0xCC, /* SCALING_FACTOR_BUTTON_SELF */
	0xF4, 0xCE, /* Reserved78 */
	0xF4, 0xD0, /* TX_PUMP_VOLTAGE */
	0xF4, 0xD1, /* DISCARD_TIME */
	0xF4, 0xD2, /* VDDA_MODE */
	0xF4, 0xD3, /* BUTTON_LAYOUT */
	0xF4, 0xD4, /* MTX_ORDER */
	0xF4, 0xD5, /* EXT_SYNC */
	0xF4, 0xD6, /* TX_FREQ_METHOD_MUTUAL */
	0xF4, 0xD7, /* TX_FREQ_METHOD_SELF */
	0xF4, 0xD8, /* Reserved88 */
	0xF4, 0xD9, /* Reserved89 */
	0xF4, 0xDA, /* Reserved90 */
	0xF4, 0xDB, /* Reserved91 */
	0xF4, 0xDC, /* RX_ATTEN_RES_BYPASS */
	0xF4, 0xDD, /* SAFE_RAW_RANGE_PERCENT_MUTUAL */
	0xF4, 0xDE, /* SAFE_RAW_RANGE_PERCENT_SELF */
	0xF4, 0xDF, /* SAFE_RAW_RANGE_PERCENT_BTN_MUTUAL */
	0xF4, 0xE0, /* SAFE_RAW_RANGE_PERCENT_BTN_SELF */
	0xF4, 0xE1, /* Reserved97 */
	0xF4, 0xE2, /* INTEGRATOR_VOLTAGE_MUTUAL */
	0xF4, 0xE4, /* INTEGRATOR_VOLTAGE_SELF */
	0xF4, 0xE6, /* INTEGRATOR_VOLTAGE_BUTTON_MUTUAL */
	0xF4, 0xE8, /* INTEGRATOR_VOLTAGE_BUTTON_SELF */
	0xF4, 0xEA, /* BALANCING_TARGET_MUTUAL */
	0xF4, 0xEB, /* BALANCING_TARGET_SELF */
	0xF4, 0xEC, /* BALANCING_TARGET_BUTTON_MUTUAL */
	0xF4, 0xED, /* BALANCING_TARGET_BUTTON_SELF */
	0xF4, 0xEE, /* ILEAK_MAX */
	0xF4, 0xF0, /* VDDA_LEVEL */
	0xF4, 0xF2, /* DELAY_TIME_FOR_PUMP */
	0xF4, 0xF4, /* DELTA_CM */
	0xF4, 0xF6, /* DELTA_CS_RX */
	0xF4, 0xF8, /* MAX_FTX */
	0xF4, 0xFA, /* BURST_NOISE_REJECTION_ENABLE */
	0xF4, 0xFB, /* Reserved123 */
	0xF4, 0xFC, /* Reserved124 */
	0xF4, 0xFD, /* Reserved125 */
	0xF4, 0xFE, /* OVERFLOW_CNT_THRESHOLD */
	0xF5, 0x00, /* OVERFLOW_CNT_BUTTON_THRESHOLD */
	0xF5, 0x02, /* OVERFLOW_DEBOUNCE_TIME */
	0xF5, 0x04, /* OVERFLOW_BUTTON_DEBOUNCE_TIME */
	0xF5, 0x06, /* TX_PERIOD_MUTUAL */
	0xF5, 0x08, /* CA_HOP0_TX_PERIOD_MUTUAL */
	0xF5, 0x0A, /* CA_HOP1_TX_PERIOD_MUTUAL */
	0xF5, 0x0C, /* CA_HOP2_TX_PERIOD_MUTUAL */
	0xF5, 0x0E, /* Reserved142 */
	0xF5, 0x10, /* Reserved144 */
	0xF5, 0x12, /* TX_PERIOD_SELF */
	0xF5, 0x14, /* TX_PERIOD_BTN_MUTUAL */
	0xF5, 0x16, /* TX_PERIOD_BTN_SELF */
	0xF5, 0x18, /* TX_PULSES_NUM_MUTUAL */
	0xF5, 0x1A, /* CA_BASE_TX_PULSES_NUM_MUTUAL */
	0xF5, 0x1C, /* CA_HOP0_TX_PULSES_NUM_MUTUAL */
	0xF5, 0x1E, /* CA_HOP1_TX_PULSES_NUM_MUTUAL */
	0xF5, 0x20, /* CA_HOP2_TX_PULSES_NUM_MUTUAL */
	0xF5, 0x22, /* Reserved162 */
	0xF5, 0x24, /* Reserved164 */
	0xF5, 0x26, /* TX_PULSES_NUM_SELF */
	0xF5, 0x28, /* TX_PULSES_NUM_BUTTON_MUTUAL */
	0xF5, 0x2A, /* TX_PULSES_NUM_BUTTON_SELF */
	0xF5, 0x2C, /* Reserved172 */
	0xF5, 0x2D, /* Reserved173 */
	0xF5, 0x2E, /* TX_PULSES_NUM_GLOVE_MUTUAL */
	0xF5, 0x30, /* TX_PULSES_NUM_GLOVE_SELF */
	0xF5, 0x32, /* TX_PULSES_NUM_GLOVE_BUTTON_MUTUAL */
	0xF5, 0x34, /* TX_PULSES_NUM_GLOVE_BUTTON_SELF */
	0xF5, 0x36, /* Reserved182 */
	0xF5, 0x37, /* Reserved183 */
	0xF5, 0x38, /* Reserved184 */
	0xF5, 0x39, /* Reserved185 */
	0xF5, 0x3A, /* Reserved186 */
	0xF5, 0x3C, /* CDC_SENSOR_MASKS */
	0xF5, 0x6C, /* CDC_PIN_INDEX_TABLE */
	0xF5, 0xA0, /* CDC_REAL_PIN_INDEX_TABLE */
	0xF5, 0xD5, /* Reserved341 */
	0xF5, 0xD8, /* CDC_MTX_PHASE_VECTOR */
	0xF5, 0xE0, /* CDC_MTX_DECONV_COEF */
	0xF6, 0x20, /* CDC_SLOT_TABLE */
	0xF6, 0xFC, /* MAX_SELF_SIG_THRESHOLD */
	0xF6, 0xFE, /* MAX_POSITIVE_THRESHOLD */
	0xF7, 0x00, /* RANGE_DATA_RESET */
	0xF7, 0x02, /* BL_THRESHOLD_MUT */
	0xF7, 0x03, /* BL_THRESHOLD_SELF */
	0xF7, 0x04, /* RATIO_MAXMUT_TO_MAXSELF */
	0xF7, 0x05, /* MIN_POSITIVE_THRESHOLD */
	0xF7, 0x06, /* RATIO_SUMALL_TO_POSITIVE */
	0xF7, 0x07, /* COUNTS_TO_BL_RESET_MUT */
	0xF7, 0x08, /* COUNTS_TO_BL_RESET_SELF */
	0xF7, 0x09, /* BL_THRESHOLD_MUT_GLOVE */
	0xF7, 0x0A, /* BL_THRESHOLD_SELF_GLOVE */
	0xF7, 0x0B, /* COUNTS_TO_BL_RESET_MUT_GLOVE */
	0xF7, 0x0C, /* COUNTS_TO_BL_RESET_SELF_GLOVE */
	0xF7, 0x0D, /* SELF_LIFTOFF_SENSOR_NUM_GLOVE */
	0xF7, 0x0E, /* SELF_LIFTOFF_THRESHOLD_GLOVE */
	0xF7, 0x10, /* Reserved656 */
	0xF7, 0x11, /* BL_DELAY_BTN */
	0xF7, 0x12, /* BL_FILT_BTN_MUT */
	0xF7, 0x13, /* BL_FILT_BTN_SELF */
	0xF7, 0x14, /* Reserved660 */
	0xF7, 0x16, /* SELF_LIFTOFF_THRESHOLD */
	0xF7, 0x18, /* SELF_LIFTOFF_SENSOR_NUM */
	0xF7, 0x1A, /* SELF_LIFTOFF_TIMEOUT */
	0xF7, 0x1C, /* MAX_MUTUAL_SCAN_INTERVAL */
	0xF7, 0x1E, /* MAX_SELF_SCAN_INTERVAL */
	0xF7, 0x20, /* BL_BTN_THRSH_MUT */
	0xF7, 0x22, /* BL_BTN_THRSH_SELF */
	0xF7, 0x24, /* BL_BTN_THRSH_MUT_CA */
	0xF7, 0x26, /* BL_BTN_THRSH_MUT_GLOVE */
	0xF7, 0x28, /* BL_BTN_THRSH_SELF_GLOVE */
	0xF7, 0x2A, /* Reserved682 */
	0xF7, 0x2C, /* SD_CORRECTION_ENABLE */
	0xF7, 0x2D, /* Reserved685 */
	0xF7, 0x2E, /* SD_CORRECTION_TARGET */
	0xF7, 0x30, /* SD_CORRECTION_MIN_COEF */
	0xF7, 0x32, /* SD_CORRECTION_FINGER_THR */
	0xF7, 0x34, /* SD_CORRECTION_SELF_THR */
	0xF7, 0x36, /* Reserved694 */
	0xF7, 0x38, /* CMF_DELTA_TEMPCO_INCREMENT */
	0xF7, 0x39, /* SELF_MUTUAL_ENABLE */
	0xF7, 0x3A, /* SELF_MUTUAL_DIVIDER */
	0xF7, 0x3B, /* Reserved699 */
	0xF7, 0x3C, /* DYNAMIC_CMF_ENABLE */
	0xF7, 0x3D, /* DYNAMIC_CMF_TOUCH_NUMBER_LIMIT */
	0xF7, 0x3E, /* DYNAMIC_CMF_UPPER_LIMIT_MUTUAL */
	0xF7, 0x40, /* DYNAMIC_CMF_UPPER_LIMIT_SELF */
	0xF7, 0x42, /* DYNAMIC_CMF_UPPER_LIMIT_BTN_MUT */
	0xF7, 0x44, /* DYNAMIC_CMF_UPPER_LIMIT_BTN_SELF */
	0xF7, 0x46, /* DYNAMIC_CMF_MARGIN */
	0xF7, 0x48, /* WF_RAW_VAR_THOLD */
	0xF7, 0x4A, /* WF_RAW_HIGH_THOLD */
	0xF7, 0x4C, /* WF_DIFF_VAR_THOLD */
	0xF7, 0x4E, /* WF_RAW_CALC_THOLD */
	0xF7, 0x50, /* WF_DIFF_CALC_THOLD */
	0xF7, 0x52, /* WF_ENTER_DEBOUNCE */
	0xF7, 0x53, /* WF_EXIT_DEBOUNCE */
	0xF7, 0x54, /* FILT_FILTER_MASK */
	0xF7, 0x55, /* FILT_IIR_COEFF_MUT */
	0xF7, 0x56, /* FILT_IIR_THRESHOLD_MUT */
	0xF7, 0x58, /* FILT_CMF_THRESHOLD_MUT */
	0xF7, 0x5A, /* FILT_FILTER_MASK_BASE_SELF */
	0xF7, 0x5B, /* FILT_IIR_COEFF_SELF */
	0xF7, 0x5C, /* FILT_IIR_THRESHOLD_SELF */
	0xF7, 0x5E, /* CMF_THR_SELF */
	0xF7, 0x60, /* FILT_FILTER_MASK_BTN_MUT */
	0xF7, 0x61, /* FILT_IIR_COEFF_BUT */
	0xF7, 0x62, /* FILT_IIR_THRESHOLD_BUT */
	0xF7, 0x64, /* CMF_THR_BTN_MUT */
	0xF7, 0x66, /* FILT_FILTER_MASK_BTN_SELF */
	0xF7, 0x67, /* FILT_IIR_COEFF_BUT_BASE_SELF */
	0xF7, 0x68, /* FILT_IIR_THRESHOLD_BUT_BASE_SELF */
	0xF7, 0x6A, /* CMF_THR_BTN_SELF */
	0xF7, 0x6C, /* Reserved748 */
	0xF7, 0x6D, /* Reserved749 */
	0xF7, 0x6E, /* Reserved750 */
	0xF7, 0x6F, /* Reserved751 */
	0xF7, 0x70, /* Reserved752 */
	0xF7, 0x71, /* Reserved753 */
	0xF7, 0x72, /* CAFILT_FILTER_MASK */
	0xF7, 0x73, /* CAFILT_IIR_COEFF_MUT */
	0xF7, 0x74, /* CAFILT_IIR_THRESHOLD_MUT */
	0xF7, 0x76, /* CAFILT_CMF_THRESHOLD_MUT */
	0xF7, 0x78, /* CAFILT_FILT_BTN_MUT */
	0xF7, 0x79, /* CAFILT_IIR_COEFF_BUT */
	0xF7, 0x7A, /* CAFILT_IIR_THRESHOLD_BUT */
	0xF7, 0x7C, /* CAFILT_CMF_THRESHOLD_BUT_MUT */
	0xF7, 0x7E, /* FILT_FILTER_MASK_GLOVE_MUT */
	0xF7, 0x7F, /* FILT_IIR_COEFF_GLOVE_MUT */
	0xF7, 0x80, /* FILT_IIR_THRESHOLD_GLOVE_MUT */
	0xF7, 0x82, /* FILT_CMF_THRESHOLD_GLOVE_MUT */
	0xF7, 0x84, /* FILT_FILTER_MASK_GLOVE_SELF */
	0xF7, 0x85, /* FILT_IIR_COEFF_GLOVE_SELF */
	0xF7, 0x86, /* FILT_IIR_THRESHOLD_GLOVE_SELF */
	0xF7, 0x88, /* FILT_CMF_THRESHOLD_GLOVE_SELF */
	0xF7, 0x8A, /* FILT_FILTER_MASK_BUT_GLOVE_MUT */
	0xF7, 0x8B, /* FILT_IIR_COEFF_BUT_GLOVE_MUT */
	0xF7, 0x8C, /* FILT_IIR_THRESHOLD_BUT_GLOVE_MUT */
	0xF7, 0x8E, /* FILT_CMF_THRESHOLD_GLOVE_BUT_MUT */
	0xF7, 0x90, /* FILT_FILTER_MASK_BUT_GLOVE_SELF */
	0xF7, 0x91, /* FILT_IIR_COEFF_BUT_GLOVE_SELF */
	0xF7, 0x92, /* FILT_IIR_THRESHOLD_BUT_GLOVE_SELF */
	0xF7, 0x94, /* FILT_CMF_THRESHOLD_GLOVE_BUT_SELF */
	0xF7, 0x96, /* Reserved790 */
	0xF7, 0x97, /* Reserved791 */
	0xF7, 0x98, /* Reserved792 */
	0xF7, 0x99, /* Reserved793 */
	0xF7, 0x9A, /* Reserved794 */
	0xF7, 0x9B, /* Reserved795 */
	0xF7, 0x9C, /* Reserved796 */
	0xF7, 0x9D, /* Reserved797 */
	0xF7, 0x9E, /* Reserved798 */
	0xF7, 0x9F, /* Reserved799 */
	0xF7, 0xA0, /* Reserved800 */
	0xF7, 0xA1, /* Reserved801 */
	0xF7, 0xA2, /* FILT_FILTER_MASK_NOFILT */
	0xF7, 0xA3, /* FILT_IIR_COEFF_NOFILT */
	0xF7, 0xA4, /* FILT_IIR_THRESHOLD_NOFILT */
	0xF7, 0xA6, /* FILT_CMF_THRESHOLD_NOFILT */
	0xF7, 0xA8, /* CA_HOST_CONTROLLED_CHARGER */
	0xF7, 0xA9, /* CHARGER_STATUS */
	0xF7, 0xAA, /* AFH_LISTEN_SCAN_CYCLE_REPEATS */
	0xF7, 0xAB, /* AFH_LISTENING_SCAN_COUNT */
	0xF7, 0xAC, /* Reserved812 */
	0xF7, 0xAE, /* Reserved814 */
	0xF7, 0xB0, /* CA_UNSTABLE_DETECTION_ENABLE */
	0xF7, 0xB1, /* CA_UNSTABLE_DEBOUNCE */
	0xF7, 0xB2, /* CA_LO_UNSTABLE_GAIN */
	0xF7, 0xB3, /* Reserved819 */
	0xF7, 0xB4, /* CA_UNSTABLE_REVERT_TIME */
	0xF7, 0xB8, /* CA_DEFAULT_REVERT_TIME */
	0xF7, 0xBC, /* CA_DIFF_ABS_DELTA_SUM_THRESHOLD */
	0xF7, 0xC0, /* CA_STUCKTOUCH_REVERT_TIME */
	0xF7, 0xC4, /* Reserved836 */
	0xF7, 0xC6, /* NM_INJ_TCH_THRESHOLD */
	0xF7, 0xC8, /* Reserved840 */
	0xF7, 0xC9, /* Reserved841 */
	0xF7, 0xCA, /* Reserved842 */
	0xF7, 0xCB, /* CA_DYN_CAL_NUM_SENSOR_THLD_PERCENT */
	0xF7, 0xCC, /* CA_DYN_CAL_SAFE_RAW_RANGE */
	0xF7, 0xCE, /* CA_MIN_SELF_ALLOWED */
	0xF7, 0xD0, /* NM_INJ_TCH_THRESHOLD_HOP */
	0xF7, 0xD1, /* Reserved849 */
	0xF7, 0xD4, /* ACT_LFT_EN */
	0xF7, 0xD5, /* INNER_EDGE_GAIN */
	0xF7, 0xD6, /* OUTER_EDGE_GAIN */
	0xF7, 0xD7, /* ACT_INTRVL0 */
	0xF7, 0xD8, /* ACT_LFT_INTRVL0 */
	0xF7, 0xDA, /* LP_INTRVL0 */
	0xF7, 0xDC, /* TCH_TMOUT0 */
	0xF7, 0xDE, /* FINGER_THRESH_SELF */
	0xF7, 0xE0, /* GLOVE_THRSH_SELF */
	0xF7, 0xE2, /* Z_SCALING */
	0xF7, 0xE4, /* LOW_POWER_ENABLE */
	0xF7, 0xE5, /* Reserved869 */
	0xF7, 0xE8, /* ACT_DIST0 */
	0xF7, 0xE9, /* ACT_DIST2 */
	0xF7, 0xEA, /* ACT_PRECISE_DIST */
	0xF7, 0xEB, /* ACT_DIST_TOUCHDOWN */
	0xF7, 0xEC, /* ACT_DIST_LIFTOFF */
	0xF7, 0xED, /* ACT_DIST_COUNTER */
	0xF7, 0xEE, /* ACT_DIST_Z_THRESHOLD */
	0xF7, 0xEF, /* FIRST_TOUCH_SUPPRESSION */
	0xF7, 0xF0, /* OBJ_WITHHOLD_CFG */
	0xF7, 0xF1, /* Reserved881 */
	0xF7, 0xF4, /* FINGER_ID_MAX_FINGER_VELOCITY2 */
	0xF7, 0xF8, /* CA_FINGER_ID_MAX_FINGER_VELOCITY2 */
	0xF7, 0xFC, /* FINGER_ID_MAX_FINGER_ACCELERATION2 */
	0xF8, 0x00, /* FINGER_ID_MIN_PREV_FINGER_VELOCITY */
	0xF8, 0x04, /* GRIP_XEDG_A */
	0xF8, 0x06, /* GRIP_XEDG_B */
	0xF8, 0x08, /* GRIP_XEXC_A */
	0xF8, 0x0A, /* GRIP_XEXC_B */
	0xF8, 0x0C, /* GRIP_YEDG_A */
	0xF8, 0x0E, /* GRIP_YEDG_B */
	0xF8, 0x10, /* GRIP_YEXC_A */
	0xF8, 0x12, /* GRIP_YEXC_B */
	0xF8, 0x14, /* GRIP_FIRST_EXC */
	0xF8, 0x15, /* GRIP_EXC_EDGE_ORIGIN */
	0xF8, 0x16, /* GRIP_ENABLE */
	0xF8, 0x17, /* LIFTOFF_DEBOUNCE */
	0xF8, 0x18, /* Reserved920 */
	0xF8, 0x19, /* Reserved921 */
	0xF8, 0x1A, /* LIFTOFF_DEBOUNCE_HOVER */
	0xF8, 0x1B, /* GLOVE_LIFTOFF_DEBOUNCE */
	0xF8, 0x1C, /* TOUCHMODE_KEEP_FIRST_REPORT_TYPE */
	0xF8, 0x1D, /* Reserved925 */
	0xF8, 0x20, /* TOUCHMODE_FINGER_SWITCH_DEBOUNCE */
	0xF8, 0x22, /* TOUCHMODE_FINGER_EXIT_DELAY */
	0xF8, 0x24, /* SELF_Z_THRSH */
	0xF8, 0x26, /* TOUCHMODE_GLOVE_SWITCH_DEBOUNCE */
	0xF8, 0x28, /* TOUCHMODE_GLOVE_FINGER_SWITCH_DEBOUNCE */
	0xF8, 0x2A, /* TOUCHMODE_GLOVE_EXIT_DELAY */
	0xF8, 0x2C, /* TOUCHMODE_GLOVE_NOISE_DEBOUNCE */
	0xF8, 0x2D, /* Reserved941 */
	0xF8, 0x2E, /* Reserved942 */
	0xF8, 0x30, /* CLIPPING_X_LOW */
	0xF8, 0x31, /* CLIPPING_X_HIGH */
	0xF8, 0x32, /* CLIPPING_Y_LOW */
	0xF8, 0x33, /* CLIPPING_Y_HIGH */
	0xF8, 0x34, /* H2O_REJECTION_SNS_WIDTH */
	0xF8, 0x35, /* SLIM_POSITION_OFFSET_ALONG_TX */
	0xF8, 0x36, /* SLIM_POSITION_OFFSET_ALONG_RX */
	0xF8, 0x37, /* OBJECT_INDEX_MAX_VELOCITY */
	0xF8, 0x38, /* LARGE_OBJECT_DEBOUNCE */
	0xF8, 0x39, /* Reserved953 */
	0xF8, 0x3A, /* Reserved954 */
	0xF8, 0x3C, /* BR2_ALWAYS_ON_FLAG */
	0xF8, 0x3D, /* EDGE_DEBOUNCE_COUNT */
	0xF8, 0x3E, /* CALC_THRESHOLD */
	0xF8, 0x40, /* OFFSET_S1 */
	0xF8, 0x42, /* OFFSET_S2 */
	0xF8, 0x44, /* Z1_SUM_8MM */
	0xF8, 0x48, /* Z2_SUM_4MM */
	0xF8, 0x4C, /* Z1_SUM_3MM */
	0xF8, 0x50, /* Z2_SUM_1MM */
	0xF8, 0x54, /* LOW_PIVOT */
	0xF8, 0x58, /* HIGH_PIVOT */
	0xF8, 0x5C, /* LOW_PIVOT2 */
	0xF8, 0x60, /* HIGH_PIVOT2 */
	0xF8, 0x64, /* EDGE_DEBOUNCE_COUNT_THRESHOLD */
	0xF8, 0x66, /* CENTER_MAGNITUDE_SCALE */
	0xF8, 0x68, /* CENTROID_CORNER_NUMER */
	0xF8, 0x69, /* CENTROID_CORNER_DENOM */
	0xF8, 0x6A, /* CENTROID_FINGER_MAX_JUMP */
	0xF8, 0x6B, /* GRADIENT_OUTER_EDGE_CONST_GAIN */
	0xF8, 0x6C, /* GRADIENT_OUTER_EDGE_CONST_RESPONSE */
	0xF8, 0x6D, /* GRADIENT_EDGE_COEF */
	0xF8, 0x6E, /* GRADIENT_COEF */
	0xF8, 0x6F, /* GRADIENT_THRESHOLD */
	0xF8, 0x70, /* Reserved1008 */
	0xF8, 0x74, /* Reserved1012 */
	0xF8, 0x78, /* Reserved1016 */
	0xF8, 0x7C, /* Reserved1020 */
	0xF8, 0x80, /* Reserved1024 */
	0xF8, 0x84, /* Reserved1028 */
	0xF8, 0x88, /* Reserved1032 */
	0xF8, 0x8C, /* Reserved1036 */
	0xF8, 0x90, /* Reserved1040 */
	0xF8, 0x94, /* Reserved1044 */
	0xF8, 0x98, /* Reserved1048 */
	0xF8, 0x9C, /* Reserved1052 */
	0xF8, 0xA0, /* Reserved1056 */
	0xF8, 0xA1, /* FIXED_FINGER_SIZE */
	0xF8, 0xA2, /* Reserved1058 */
	0xF8, 0xA4, /* MIN_FAT_FINGER_Z9 */
	0xF8, 0xA8, /* MAX_MULTI_FINGER_Z9 */
	0xF8, 0xAC, /* MIN_FAT_FINGER_SIG_SUM_ON_EDGE */
	0xF8, 0xB0, /* CENTER_SIGNAL_TO_MIN_PEAK_RATIO */
	0xF8, 0xB1, /* SD_SIZE_THRESHOLD */
	0xF8, 0xB2, /* SD_FEW_PEAK_SIZE_THRESHOLD */
	0xF8, 0xB3, /* Reserved1075 */
	0xF8, 0xB4, /* SD_ENTER_SIGNAL_THRESHOLD */
	0xF8, 0xB6, /* SD_EXIT_SIGNAL_THRESHOLD */
	0xF8, 0xB8, /* FAT_AXIS_LENGTH_THRESHOLD */
	0xF8, 0xB9, /* TOUCH_IGNORE_COEFF */
	0xF8, 0xBA, /* Reserved1082 */
	0xF8, 0xBC, /* SELF_CENTROID_THR_RX */
	0xF8, 0xBE, /* SELF_CENTROID_THR_RX_HYST */
	0xF8, 0xC0, /* SELF_CENTROID_THR_TX */
	0xF8, 0xC2, /* SELF_CENTROID_THR_TX_HYST */
	0xF8, 0xC4, /* SELF_GRIP_RX_SNS_NUM */
	0xF8, 0xC5, /* SELF_GRIP_TX_SNS_NUM */
	0xF8, 0xC6, /* SELF_MULT_PEAK_FILTER_COEF */
	0xF8, 0xC7, /* SELF_CENTROID_WINDOW_SIZE */
	0xF8, 0xC8, /* FINGER_THRESH_MUTUAL_ON */
	0xF8, 0xCA, /* FINGER_THRESH_MUTUAL_OFF */
	0xF8, 0xCC, /* CA_FINGER_THRESHOLD_MUTUAL */
	0xF8, 0xCE, /* MULTI_TOUCH_DEBOUNCE */
	0xF8, 0xCF, /* Z9_FILTER_SCALE */
	0xF8, 0xD0, /* CA_MULTI_TOUCH_DEBOUNCE */
	0xF8, 0xD1, /* CA_Z9_FILTER_SCALE */
	0xF8, 0xD2, /* MAX_FAT_FINGER_SIZE_HYST */
	0xF8, 0xD4, /* MAX_FAT_FINGER_SIZE_ON */
	0xF8, 0xD6, /* CA_MAX_FAT_FINGER_SIZE */
	0xF8, 0xD8, /* MIN_FAT_FINGER_SIZE_HYST */
	0xF8, 0xD9, /* MIN_FAT_FINGER_SIZE_ON */
	0xF8, 0xDA, /* CA_MIN_FAT_FINGER_SIZE */
	0xF8, 0xDB, /* TOUCH_TRACKING_FEATURES */
	0xF8, 0xDC, /* SIGNAL_THRESHOLD_MULTIPLIER */
	0xF8, 0xDD, /* SD_SIGNAL_THRESHOLD_MULTIPLIER */
	0xF8, 0xDE, /* WF_FT_COEF */
	0xF8, 0xDF, /* WF_MT_DEBOUNCE */
	0xF8, 0xE0, /* WF_SIGNAL_THRESHOLD_MULTIPLIER */
	0xF8, 0xE1, /* WF_1STFINGER_VS_2NDFINGER */
	0xF8, 0xE2, /* RX_LINE_FILTER */
	0xF8, 0xE3, /* RX_LINE_FILTER_DEBOUNCE */
	0xF8, 0xE4, /* RX_LINE_FILTER_THRESHOLD */
	0xF8, 0xE5, /* TOUCHMODE_FRAME_NUM_TO_CONFIRM_FINGER_MODE */
	0xF8, 0xE6, /* RX_LINE_IGNORE_FILTER */
	0xF8, 0xE7, /* RX_LINE_IGNORE_FILTER_DEBOUNCE */
	0xF8, 0xE8, /* RX_LINE_IGNORE_FILTER_THRESHOLD */
	0xF8, 0xE9, /* TRACKING_EDGE_OUTER_GAIN */
	0xF8, 0xEA, /* Reserved1130 */
	0xF8, 0xEC, /* WF_Z8_MULTIPLIER */
	0xF8, 0xED, /* WF_DETECT_PEAK_Z9_SCALE */
	0xF8, 0xEE, /* WF_DETECT_PEAK_THR */
	0xF8, 0xF0, /* WF_DETECT_PEAK_Z9_THR */
	0xF8, 0xF4, /* WF_DETECT_PEAK_Z8_SCALE */
	0xF8, 0xF5, /* WF_DETECT_PEAK_DEBOUNCE */
	0xF8, 0xF6, /* WF_DETECT_PEAK_COUNT */
	0xF8, 0xF7, /* Reserved1143 */
	0xF8, 0xF8, /* BTN_LS_ON_THRSH_MUT_0 */
	0xF8, 0xF9, /* BTN_LS_ON_THRSH_MUT_1 */
	0xF8, 0xFA, /* BTN_LS_ON_THRSH_MUT_2 */
	0xF8, 0xFB, /* BTN_LS_ON_THRSH_MUT_3 */
	0xF8, 0xFC, /* BTN_LS_OFF_THRSH_MUT_0 */
	0xF8, 0xFD, /* BTN_LS_OFF_THRSH_MUT_1 */
	0xF8, 0xFE, /* BTN_LS_OFF_THRSH_MUT_2 */
	0xF8, 0xFF, /* BTN_LS_OFF_THRSH_MUT_3 */
	0xF9, 0x00, /* BTN_LS_ON_THRSH_SELF_0 */
	0xF9, 0x01, /* BTN_LS_ON_THRSH_SELF_1 */
	0xF9, 0x02, /* BTN_LS_ON_THRSH_SELF_2 */
	0xF9, 0x03, /* BTN_LS_ON_THRSH_SELF_3 */
	0xF9, 0x04, /* BTN_LS_OFF_THRSH_SELF_0 */
	0xF9, 0x05, /* BTN_LS_OFF_THRSH_SELF_1 */
	0xF9, 0x06, /* BTN_LS_OFF_THRSH_SELF_2 */
	0xF9, 0x07, /* BTN_LS_OFF_THRSH_SELF_3 */
	0xF9, 0x08, /* BTN_LS_TOUCHDOWN_DEBOUNCE */
	0xF9, 0x0A, /* Reserved1162 */
	0xF9, 0x0C, /* BTN_HS_ON_THRSH_MUT_0 */
	0xF9, 0x0D, /* BTN_HS_ON_THRSH_MUT_1 */
	0xF9, 0x0E, /* BTN_HS_ON_THRSH_MUT_2 */
	0xF9, 0x0F, /* BTN_HS_ON_THRSH_MUT_3 */
	0xF9, 0x10, /* BTN_HS_OFF_THRSH_MUT_0 */
	0xF9, 0x11, /* BTN_HS_OFF_THRSH_MUT_1 */
	0xF9, 0x12, /* BTN_HS_OFF_THRSH_MUT_2 */
	0xF9, 0x13, /* BTN_HS_OFF_THRSH_MUT_3 */
	0xF9, 0x14, /* BTN_HS_ON_THRSH_SELF_0 */
	0xF9, 0x15, /* BTN_HS_ON_THRSH_SELF_1 */
	0xF9, 0x16, /* BTN_HS_ON_THRSH_SELF_2 */
	0xF9, 0x17, /* BTN_HS_ON_THRSH_SELF_3 */
	0xF9, 0x18, /* BTN_HS_OFF_THRSH_SELF_0 */
	0xF9, 0x19, /* BTN_HS_OFF_THRSH_SELF_1 */
	0xF9, 0x1A, /* BTN_HS_OFF_THRSH_SELF_2 */
	0xF9, 0x1B, /* BTN_HS_OFF_THRSH_SELF_3 */
	0xF9, 0x1C, /* BTN_HS_TOUCHDOWN_DEBOUNCE */
	0xF9, 0x1E, /* Reserved1182 */
	0xF9, 0x20, /* GLOVE_BTN_FORBID_DEBOUNCE */
	0xF9, 0x22, /* GLOVE_BTN_TO_HIGHSEN_MODE_SWITCH_THRSH_MUT */
	0xF9, 0x24, /* GLOVE_BTN_TO_HIGHSEN_MODE_SWITCH_THRSH_SELF */
	0xF9, 0x26, /* GLOVE_BTN_TO_LOWSEN_MODE_SWITCH_THRSH_MUT */
	0xF9, 0x28, /* GLOVE_BTN_TO_LOWSEN_MODE_SWITCH_THRSH_SELF */
	0xF9, 0x2A, /* GLOVE_BTN_MODE_SWITCH_DEBOUNCE */
	0xF9, 0x2C, /* BTN_REPORT_IF_TOUCH_DETECTED */
	0xF9, 0x2D, /* Reserved1197 */
	0xF9, 0x2E, /* Reserved1198 */
	0xF9, 0x30, /* TOUCHMODE_GLOVE_MAX_PEAK */
	0xF9, 0x32, /* GLOVE_ON_THRSH_MUTUAL */
	0xF9, 0x34, /* GLOVE_OFF_THRSH_MUTUAL */
	0xF9, 0x36, /* GLOVE_FIRST_TOUCH_DEBOUNCE */
	0xF9, 0x37, /* GLOVE_FIRST_TOUCH_DEBOUNCE_EDGE_MASK */
	0xF9, 0x38, /* GLOVE_MULTI_TOUCH_DEBOUNCE */
	0xF9, 0x39, /* GLOVE_Z8_FILTER_SCALE */
	0xF9, 0x3A, /* GLOVE_Z9_FILTER_SCALE */
	0xF9, 0x3B, /* GLOVE_GRIP_FILTER_SCALE */
	0xF9, 0x3C, /* GLOVE_Z_SCALING */
	0xF9, 0x3E, /* GLOVE_MAX_FAT_FINGER_SIZE */
	0xF9, 0x40, /* GLOVE_MAX_FAT_FINGER_HYST */
	0xF9, 0x42, /* GLOVE_MIN_FAT_FINGER_SIZE */
	0xF9, 0x43, /* GLOVE_MIN_FAT_FINGER_HYST */
	0xF9, 0x44, /* GLOVE_SIGNAL_THRESHOLD_MULTIPLIER */
	0xF9, 0x45, /* GLOVE_INNER_EDGE_GAIN */
	0xF9, 0x46, /* GLOVE_OUTER_EDGE_GAIN */
	0xF9, 0x47, /* Reserved1223 */
	0xF9, 0x48, /* XY_FILTER_MASK */
	0xF9, 0x4C, /* XY_FILT_IIR_COEFF */
	0xF9, 0x50, /* XY_FILT_Z_IIR_COEFF */
	0xF9, 0x54, /* XY_FILT_XY_FAST_THR */
	0xF9, 0x55, /* XY_FILT_XY_SLOW_THR */
	0xF9, 0x56, /* XY_FILT_IIR_FAST_COEFF */
	0xF9, 0x57, /* XY_FILT_PREDICTION_COEF */
	0xF9, 0x58, /* XY_FILTER_MASK_CA */
	0xF9, 0x5C, /* XY_FILT_IIR_COEFF_CA */
	0xF9, 0x60, /* XY_FILT_Z_IIR_COEFF_CA */
	0xF9, 0x64, /* XY_FILT_XY_FAST_THR_CA */
	0xF9, 0x65, /* XY_FILT_XY_SLOW_THR_CA */
	0xF9, 0x66, /* XY_FILT_IIR_FAST_COEFF_CA */
	0xF9, 0x67, /* XY_FILT_PREDICTION_COEF_CA */
	0xF9, 0x68, /* XY_FILT_EXTRA_IIR_FILTER */
	0xF9, 0x69, /* XY_FILT_TOUCH_SIZE_IIR_COEFF */
	0xF9, 0x6A, /* XY_FILT_TOUCH_SIZE_HYST */
	0xF9, 0x6B, /* XY_FILT_TOUCH_ORIENTATION_IIR_COEFF */
	0xF9, 0x6C, /* XY_FILT_TOUCH_ORIENTATION_HYST */
	0xF9, 0x6D, /* Reserved1261 */
	0xF9, 0x70, /* SIZE_ORIENTATION_ENABLE */
	0xF9, 0x71, /* Reserved1265 */
	0xF9, 0x74, /* ACTIVE_AREA_TO_EDGE */
	0xF9, 0x75, /* SINGLE_OR_DOUBLE_CLICK_SEL */
	0xF9, 0x76, /* SINGLE_CLICK_MAX_JITTER */
	0xF9, 0x78, /* SINGLE_CLICK_MIN_DURATION */
	0xF9, 0x7A, /* SINGLE_CLICK_MAX_DURATION */
	0xF9, 0x7C, /* DCLICK_MIN_INTERVAL */
	0xF9, 0x7D, /* Reserved1277 */
	0xF9, 0x7E, /* DCLICK_MAX_INTERVAL */
	0xF9, 0x80, /* DCLICK_MAX_JITTER_DIST */
	0xF9, 0x82, /* SLIDE_MAX_SPACE */
	0xF9, 0x84, /* SLIDE_MAX_JITTER_DIST */
	0xF9, 0x85, /* Reserved1285 */
	0xF9, 0x88, /* POST_CFG */
	0xF9, 0x89, /* PWR_CFG */
	0xF9, 0x8A, /* SEND_REPORT_AFTER_ACTIVE_INTERVAL_CFG */
	0xF9, 0x8B, /* PIP_REPORTING_DISABLE */
	0xF9, 0x8C, /* INTERRUPT_PIN_OVERRIDE */
	0xF9, 0x8E, /* Reserved1294 */
	0xF9, 0x8F, /* IMO_CLOCK_FREQUENCY_SELECT */
	0xF9, 0x90, /* CONFIG_CRC */
};

