; *
; * Roman numerals generator by lai
; * 
; * Usage:
; * set_roman x
; * 
; * A string equate called 'roman' is now the number x represented 
; * in roman numerals for usage such as
; *
; * db "{roman}"
; * printt "{roman}\n"
; *  ...
; *  etc


IF	!DEF(ROMAN_INC)
ROMAN_INC	SET 1

roman		EQUS ""

set_roman: MACRO
	IF (\1) <= 0
	WARN "Roman numerals cannot express numbers lower than or equal to zero."
	ENDC
	PURGE roman
roman	EQUS	""
_roman_tmp EQUS "{roman}"
_roman_numerals EQUS "IVXLCDM"
	IF (\1) >= 1000
	_rom0 (\1)-1000
	ENDC
	_rom1 (\1), 100, 2
	PURGE _roman_tmp
	PURGE _roman_numerals
	ENDM
_rom0:	MACRO
	PURGE _roman_tmp
_roman_tmp EQUS strcat("{roman}",strsub("{_roman_numerals}",7,1))
	PURGE roman
roman	EQUS "{_roman_tmp}"
	IF (\1) >= 1000
	_rom0 (\1)-1000
	ENDC
	ENDM
_rom1: 	MACRO
	IF (\3) >= 0
	_rom2 0,(\1) / (\2) % 10,(\3)
	_rom1 (\1), (\2) / 10, (\3)-1
	ENDC
	ENDM
_rom2: 	MACRO
	IF (\1) < (\2)-(\2)/2&$E-(\2)/5*2+(\2)/4&$E-(\2)/9*3
	PURGE _roman_tmp
_roman_tmp EQUS strcat("{roman}",strsub("{_roman_numerals}",1+((\1)==0)*((\2)/5-((\2)==9))+((\1)==1)*(((\2)==4)+((\2)==9)*2)+(\3)*2,1))
	PURGE roman
roman	EQUS "{_roman_tmp}"
	_rom2 (\1)+1,(\2),(\3)
	ENDC
	ENDM

ENDC ;ROMAN_INC


