/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.aspectj;

import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import org.aspectj.lang.ProceedingJoinPoint;

class AsynchronousAspectTask
extends Task {
    ProceedingJoinPoint pjp;
    Settable returnValue = new Settable();

    public AsynchronousAspectTask(Boolean daemon, ProceedingJoinPoint pjp, Promise[] waitFor) {
        super(daemon, "_aroundBody", true, 7, waitFor);
        this.pjp = pjp;
    }

    protected void doExecute() throws Throwable {
        Object result = this.pjp.proceed();
        if (result != null && !(result instanceof Promise)) {
            throw new RuntimeException("@Asynchronous annotation is allowed only for methods with void or Promise return types: " + this.pjp.getStaticPart().getSignature().getName());
        }
        if (result != null) {
            this.returnValue.chain((Promise)result);
        } else {
            this.returnValue.set(null);
        }
    }

    public Promise getReturnValue() {
        return this.returnValue;
    }
}

