/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.datamodeling;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class PaginatedList<T>
implements List<T> {
    private static final String UNMODIFIABLE_MESSAGE = "This is an unmodifiable list";
    protected final DynamoDBMapper mapper;
    protected final Class<T> clazz;
    protected final AmazonDynamoDB dynamo;
    protected boolean allResultsLoaded = false;
    protected final List<T> allResults;
    protected final List<T> nextResults = new LinkedList<T>();

    public PaginatedList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo) {
        this.mapper = mapper;
        this.clazz = clazz;
        this.dynamo = dynamo;
        this.allResults = new ArrayList<T>();
    }

    public synchronized void loadAllResults() {
        if (this.allResultsLoaded) {
            return;
        }
        while (this.nextResultsAvailable()) {
            this.moveNextResults();
        }
        this.allResultsLoaded = true;
    }

    private boolean nextResultsAvailable() {
        return !this.nextResults.isEmpty() || this.loadNextResults();
    }

    private synchronized boolean loadNextResults() {
        if (this.atEndOfResults()) {
            return false;
        }
        do {
            this.nextResults.addAll(this.fetchNextPage());
        } while (!this.atEndOfResults() && this.nextResults.isEmpty());
        return !this.nextResults.isEmpty();
    }

    private void moveNextResults() {
        this.allResults.addAll(this.nextResults);
        this.nextResults.clear();
    }

    protected abstract List<T> fetchNextPage();

    protected abstract boolean atEndOfResults();

    @Override
    public Iterator<T> iterator() {
        final ArrayList<T> allResultsCopy = new ArrayList<T>();
        allResultsCopy.addAll(this.allResults);
        final Iterator iter = allResultsCopy.iterator();
        return new Iterator<T>(){
            Iterator<T> iterator;
            int pos;
            {
                this.iterator = iter;
                this.pos = 0;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || PaginatedList.this.nextResultsAvailable();
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext()) {
                    if (PaginatedList.this.allResults.size() == allResultsCopy.size()) {
                        if (!PaginatedList.this.nextResultsAvailable()) {
                            throw new NoSuchElementException();
                        }
                        PaginatedList.this.moveNextResults();
                    }
                    if (PaginatedList.this.allResults.size() > allResultsCopy.size()) {
                        allResultsCopy.addAll(PaginatedList.this.allResults.subList(allResultsCopy.size(), PaginatedList.this.allResults.size()));
                    }
                    this.iterator = allResultsCopy.listIterator(this.pos);
                }
                ++this.pos;
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(PaginatedList.UNMODIFIABLE_MESSAGE);
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public T get(int n) {
        while (this.allResults.size() <= n && this.nextResultsAvailable()) {
            this.moveNextResults();
        }
        return this.allResults.get(n);
    }

    @Override
    public boolean contains(Object arg0) {
        if (this.allResults.contains(arg0)) {
            return true;
        }
        while (this.nextResultsAvailable()) {
            boolean found = this.nextResults.contains(arg0);
            this.moveNextResults();
            if (!found) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        while (this.allResults.size() < arg1 && this.nextResultsAvailable()) {
            this.moveNextResults();
        }
        return Collections.unmodifiableList(this.allResults.subList(arg0, arg1));
    }

    @Override
    public int indexOf(Object arg0) {
        int indexOf = this.allResults.indexOf(arg0);
        if (indexOf >= 0) {
            return indexOf;
        }
        while (this.nextResultsAvailable()) {
            indexOf = this.nextResults.indexOf(arg0);
            int size = this.allResults.size();
            this.moveNextResults();
            if (indexOf < 0) continue;
            return indexOf + size;
        }
        return -1;
    }

    @Override
    public int size() {
        this.loadAllResults();
        return this.allResults.size();
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        this.loadAllResults();
        return this.allResults.containsAll(arg0);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        this.loadAllResults();
        return this.allResults.lastIndexOf(arg0);
    }

    @Override
    public Object[] toArray() {
        this.loadAllResults();
        return this.allResults.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        this.loadAllResults();
        return this.allResults.toArray(a);
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("ListIterators are not supported for this list");
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        throw new UnsupportedOperationException("ListIterators are not supported for this list");
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public T remove(int arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public T set(int arg0, T arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean add(T arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }
}

