:: RUNNING TIME (dedicated environment on 486DX2/50 VLB):  3 hours

:: This batch file is finished and could be the easiest and quickest to use, or
:: the hardest and longest (it is the shortest running).  It strips every cross
:: file duplicate description (including the first occurrence) from all your
:: categorized DIRS (1 through 59) and masses them together, then you have to
:: decide what to do with them.  See the comments at the end of this file for
:: ways to use the results.

:: Run DIRDUPE.BAT on the individual DIRs before using this batch file.  These
:: commands are written for MERGESYS; for MERGEPRO, /s will always have to be
:: added to the command line and /f1 if no other field options are shown.

@echo off
if %1x==crossdupx goto MERGEDUPE
if %1x==CROSSDUPx goto MERGEDUPE

::
:: COMPARE THE REALLY BIG DIRS TO REMOVE CATEGORIZED "CROSS FILE DUPLICATES"
:: Compare each list in turn to DIR60, since it is a huge "misc" directory.
:: The upload directory will come next, but DIR60 is done first so when it is
:: compared to DIR61, there will be fewer comparisons because of the duplicates
:: already removed from it (DIR61 is not compared to DIR60 here).  Also, if it
:: was done the other way around and a duplicate was removed from DIR61 that
:: was in DIR60 when DIR60 was compared to DIR61, then the same description was
:: was removed from DIR60 because it was in DIR59, etc. etc., it would be hard
:: to track down the DIR where the description was finally kept.  This way,
:: when DIR60 is compared to DIR61 and a cross duplicate description is removed
:: from DIR61, you know it will still be in DIR60.  The trash files will have
:: all the duplicates stripped from DIRs 60 and 61 respectively preceded by the
:: description that was kept (they will also be sorted by name).  You can use
:: them to check that a file name is really a dupe and not another program with
:: the same name to add back later if you like.

:: NOTE:  PCBFiler chops off a description line at 78 characters.  If you use
:: it to sort a trash file that has "happy faces" to mark kept descriptions
:: and the first line of a kept description is 78 characters long, the "happy
:: face" will disappear because it ended up in column 79.  And you can't tell
:: by which description comes first because PCBFiler does not necessarily keep
:: the relative order of same named descriptions.  All descriptions will still
:: be sorted on name ascending, but same named descriptions may have had their
:: positions in relation to each other switched (same as the date problem).  If
:: you want to inspect trash file descriptions, do it before running PCBFiler.
:: The setup below creates a sorted trash file of dupes without using PCBFiler.
:: This method may actually take longer (there could be up to 60 extra merges)
:: than if the new stripped duplicate descriptions were just appended to the
:: same trash file each time, then sorted with PCBFiler, but it automates the
:: process and you don't have to be concerned about PCBFiler's idiosyncrasies.
:: If a DIR's heading is still in place, add /b1?? /b2??h (don't add it to each
:: line just above "if errorlevel" since the trash files won't have headings).
:: When a "compare" is done, file 2's heading is written to the merged list if
:: it's being kept, so the correct heading will be on the finished DIR.

MERGE /o /1t /td:\temp\comp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir1 d:\pcb\dirc\dir60
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir2 d:\pcb\dirc\dir60

:: If an input file doesn't exist, MERGE exits with an "errorlevel" other than
:: zero.  You could just as well have used "if exist ...", but this shows an
:: example of how you can examine MERGE's exit codes to take a certain action.
:: Although it's always a good idea to use a log, I'm not using one here since
:: a "file not found" error doesn't necessarily mean anything went wrong (it
:: should just mean there weren't any cross duplicates after the last compare).

MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup

MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir3 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir4 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir5 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir6 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir7 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir8 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir9 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir10 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir11 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir12 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir13 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir14 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir15 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir16 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir17 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir18 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir19 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir20 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir21 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir22 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir23 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir24 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir25 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir26 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir27 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir28 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir29 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir30 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir31 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir32 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir33 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir34 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir35 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir36 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir37 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir38 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir39 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir40 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir41 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir42 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir43 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir44 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir45 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir46 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir47 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir48 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir49 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir50 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir51 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir52 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir53 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir54 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir55 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir56 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir57 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir58 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup
MERGE /o /1t /td:\temp\temp_d60.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir59 d:\pcb\dirc\dir60
MERGE /o /k d:\temp\temp_d60.dup d:\temp\comp_d60.dup
if errorlevel==0 del d:\temp\temp_d60.dup

:: Now compare each list in turn to the upload directory.

MERGE /o /1t /td:\temp\comp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir1 d:\pcb\dirc\dir61
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir2 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir3 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir4 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir5 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir6 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir7 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir8 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir9 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir10 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir11 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir12 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir13 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir14 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir15 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir16 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir17 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir18 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir19 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir20 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir21 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir22 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir23 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir24 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir25 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir26 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir27 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir28 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir29 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir30 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir31 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir32 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir33 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir34 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir35 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir36 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir37 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir38 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir39 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir40 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir41 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir42 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir43 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir44 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir45 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir46 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir47 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir48 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir49 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir50 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir51 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir52 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir53 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir54 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir55 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir56 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir57 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir58 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup
MERGE /o /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log /vl1 d:\pcb\dirc\dir59 d:\pcb\dirc\dir61
MERGE /o /k d:\temp\temp_d61.dup d:\temp\comp_d61.dup
if errorlevel==0 del d:\temp\temp_d61.dup

:: Since you're using the CHK4DES/ADDTODAY system to "upload" files to your bbs
:: which often results in DIR61 descriptions being the best, if the same type
:: of "compare" was done here as with the other DIRs, you could lose a good
:: description in DIR61 because of a duplicate name from DIR60.  These steps
:: perform a little slight of hand, removing a duplicate description from DIR61
:: and replacing DIR60's description with it (since DIR60 is a "misc" category,
:: you needn't be concerned that if this isn't really a duplicate you'll get a
:: program in the wrong place).  The trash file will get both descriptions as
:: usual, and the "happy face" will indicate which is kept, but this time it is
:: from DIR61 (it's not the "first occurrence" that was in DIR60).  Instead of
:: the "happy face" description preceding the stripped one, it will come after
:: it in the trash file (the first occurrence from DIR60 is still first).  If
:: DIRs still have headings, add /b1?? /b2??h to line 1 and /b2??h to line 3.

MERGE /o /1 /td:\temp\keep_d61.dup+n /ld:\temp\comp_dir.log d:\pcb\dirc\dir60 d:\pcb\dirc\dir61
if not exist d:\temp\keep_d61.dup goto MASTER
MERGE /o /td:\temp\stripd60.dup+n /ld:\temp\comp_dir.log /vl1 d:\temp\keep_d61.dup d:\pcb\dirc\dir60
MERGE /o /k /1t /td:\temp\temp_d61.dup+n /ld:\temp\comp_dir.log d:\temp\keep_d61.dup d:\temp\stripd60.dup
MERGE /o /k /ld:\temp\comp_dir.log d:\temp\stripd60.dup d:\temp\temp_d61.dup
MERGE /o /k /ld:\temp\comp_dir.log d:\temp\temp_d61.dup d:\temp\comp_d61.dup
echo.
del d:\temp\temp_d61.dup
del d:\temp\keep_d61.dup
del d:\temp\stripd60.dup

::
:: MAKE THE "MASTER" LIST TO GET THE NAMES OF ALL CROSS FILE DUPLICATES
:: Merge all the lists together using the "+K+N" trash option.  The trash file,
:: CROSSDUP.TMP, is written without headers or footers ("+N") and gets only the
:: the key ("+K") of all duplicates (there will end up being a list of just
:: duplicate file names when everything is done).  You need a lot of disk space
:: for this, but you should have it (I ran out!  You'll need at least 30 megs).
:: DIR60 and DIR61 are also merged, but that's only for obtaining the "master"
:: list; they don't have to be since they were done above.  This "master" may
:: not have the same descriptions that you'll end up with in the individual
:: DIRs depending on what you do with the descriptions that are stripped.
:: However, by using /f1 /f3ddt on the command line, you can get a master that
:: always has the description with the latest date (the master will be merged
:: on itself after all the DIRs are merged to remove earlier dated dupes).  In
:: the case of matching names and dates, the kept description will be from the
:: DIR that was last merged, since the file in the first position has its
:: description retained over the file in the second position (the master list).
:: To completely automate this process, you'll need a third party sort program
:: (see the comments below the "pause" after the master is completed).  Another
:: alternative is to MERGE the new trash file each time as was done above.  If
:: the DIR heading is still in place, add /b1?? to all the lines below and /b21
:: to every line except the first.

::                               W A R N I N G
::
:: If you did not merge all DIRs with /f1 /f3ddt prior to starting this batch
:: file to fix any date errors and one is encountered below, MERGE will halt on
:: that file with an error and it will not be included (/ea is not used because
:: these trash files should only contain duplicates).

:MASTER
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir2 d:\pcb\dirc\dir1 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir3 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir4 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir5 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir6 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir7 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir8 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir9 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir10 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir11 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir12 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir13 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir14 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir15 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir16 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir17 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir18 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir19 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir20 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir21 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir22 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir23 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir24 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir25 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir26 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir27 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir28 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir29 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir30 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir31 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir32 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir33 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir34 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir35 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir36 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir37 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir38 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir39 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir40 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir41 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir42 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir43 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir44 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir45 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir46 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir47 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir48 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir49 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir50 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir51 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir52 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir53 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir54 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir55 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir56 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir57 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir58 d:\temp\master
MERGE /o /f1 /f3ddt /td:\temp\crossdup.tmp+k+n /ld:\temp\master.log d:\pcb\dirc\dir59 d:\temp\master

:: To get rid of the date (since it was part of the key above, it was written
:: in its "coded" form along with the file name), copy CROSSDUP.TMP to CROSS2
:: and merge them using +k+n again (because the names are not sorted, also add
:: /ns so MERGE does not perform its out of sequence test).  CROSSDUP.NAM, the
:: new trash file, will be a list of only duplicate file names (all the names
:: that are merged are duplicates of each other).  Then merge the master on
:: itself without /f1 /f3ddt to add any duplicate names with different dates.
:: The list of names could have been obtained by creating a master with /k and
:: no trash file, then making CROSSDUP.NAM when the master is merged on itself,
:: but this way probably takes less time and disk space (the master may not get
:: as big depending on how many dupes have the same date and are stripped).

copy d:\temp\crossdup.tmp d:\temp\cross2
MERGE /o /ns /td:\temp\crossdup.nam+k+n /ld:\temp\master.log d:\temp\cross2 d:\temp\crossdup.tmp
del d:\temp\cross2
del d:\temp\crossdup.tmp
MERGE /o /td:\temp\crossdup.nam+k+n /ld:\temp\master.log d:\temp\master

:: Add DIR60 and DIR61 to get all descriptions in the master (there will not be
:: any duplicates because all occurrences of the same name in a lower numbered
:: DIR were removed from DIRs 60 and 61 during the earlier "compares").  If the
:: heading is still in place, add /b1?? /b21 to the two lines below.

MERGE /o /ld:\temp\master.log d:\pcb\dirc\dir60 d:\temp\master
MERGE /o /ld:\temp\master.log d:\pcb\dirc\dir61 d:\temp\master

:: Now merge the master with the two trash files of duplicates already stripped
:: from DIRs 60 and 61 (each TEMP_D?? trash file was merged with its COMP_D??
:: file to keep the descriptions in order), but without writing duplicate names
:: to CROSSDUP.NAM so dupes that are already removed won't be stripped again
:: from the lower numbered DIRs (this just gets the latest dated description).
:: The descriptions in these trash files have both occurrences, which is not
:: wanted here.  BUT -- MERGE has another new switch, /1s, which will delete
:: the "happy face" first occurrence description in a trash file that was
:: created with /1t.  There is a minor problem using /f1 /f3ddt on these trash
:: files:  the first occurrence date may be earlier than the next date, causing
:: an out of sequence error.  Add /ns to the command line again to not perform
:: the out of sequence test.  The "happy face" description in the merged dupe
:: list, DIR61_60.DUP, may not come just before its corresponding stripped
:: description anymore if the same description was stripped from both DIR60 and
:: DIR61, but this isn't important here.  The same named "happy faces" will be
:: together, followed by the descriptions from DIRs 60 and 61, with the latest
:: date between them coming first if the dates are different.  If both the name
:: and date are the same, DIR61's description will be kept since its dupe file
:: is in the first position (you can reverse the positions of COMP_D60.DUP and
:: COMP_D61.DUP if you'd rather keep DIR60's).

MERGE /o /k /ns /f1 /f3ddt /ld:\temp\master.log d:\temp\comp_d61.dup d:\temp\comp_d60.dup d:\temp\dir61_60.dup
MERGE /o /1s /ld:\temp\master.log d:\temp\dir61_60.dup

MERGE /o /f1 /f3ddt /ld:\temp\master.log d:\temp\dir61_60.dup d:\temp\master
MERGE /o /ld:\temp\master.log d:\temp\master

:: Delete the 4 lines below if you have a sort program (see next paragraph).

echo 
echo Enter ^C to abort and sort CROSSDUP.NAM, then restart this batch file with:
echo CRSDUPE1 CROSSDUP
pause

::
:: REMOVE CROSS FILE DUPLICATES FROM DIR1 THROUGH DIR59
:: Sort CROSSDUP.NAM in name ascending order.  Since it is only file names,
:: almost any sort program should do (the maximum file size DOS's "sort" can
:: handle is 64K, so avoid it), and you won't have to manually intervene here
:: or make some special PCBoard setup files so you can use the command line to
:: sort with PCBFiler (I suppose it works on just names).  I used a program
:: called PCSORT, which accepts redirection for input/output files.  I'm also
:: deleting the unsorted CROSSDUP.NAM before copying the sorted one over it in
:: case you have an "alias" like I do that prompts you before an overwrite.

PCSORT < d:\temp\crossdup.nam > d:\temp\sortdupe
del d:\temp\crossdup.nam
copy d:\temp\sortdupe d:\temp\crossdup.nam
del d:\temp\sortdupe

:: Merge CROSSDUP.NAM on itself (the same description may have been in more
:: than one directory, so CROSSDUP.NAM could have duplicates).

:MERGEDUPE
MERGE d:\temp\crossdup.nam /o /ld:\temp\master.log /vl

:: Do a "compare" of the duplicate names to each list (don't use /1t and you
:: can omit DIR60 and DIR61).  Use the trash option again without "+K" (whether
:: you use "+N" depends on your preference for the last step).  This example
:: uses +n and merges the stripped descriptions after each compare so that they
:: are sorted by name and date.  If you don't use +n, you need to delete the
:: merge phase and change CROSSDUP.TMP to CROSSDUP.DES for DIR2 through DIR59.
:: If the DIRs still have headings, add /b2??h to each line where CROSSDUP.NAM
:: is compared to the DIR.

MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir1 /o /1 /td:\temp\crossdup.des+n /ld:\temp\crossdup.log /vl
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir2 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir3 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir4 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir5 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir6 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir7 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir8 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir9 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir10 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir11 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir12 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir13 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir14 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir15 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir16 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir17 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir18 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir19 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir20 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir21 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir22 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir23 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir24 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir25 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir26 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir27 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir28 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir29 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir30 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir31 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir32 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir33 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir34 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir35 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir36 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir37 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir38 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir39 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir40 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir41 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir42 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir43 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir44 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir45 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir46 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir47 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir48 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir49 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir50 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir51 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir52 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir53 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir54 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir55 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir56 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir57 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir58 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp
MERGE d:\temp\crossdup.nam d:\pcb\dirc\dir59 /o /1 /td:\temp\crossdup.tmp+n /ld:\temp\crossdup.log /vl
MERGE /o /k /f1 /f3ddt d:\temp\crossdup.tmp d:\temp\crossdup.des
if errorlevel==0 del d:\temp\crossdup.tmp

::
:: ALMOST "THE END", BUT FIRST RESTORE THE REMOVED CROSS FILE DUPLICATES
:: The resulting lists have all occurrences of cross file duplicates removed
:: (they are in CROSSDUP.DES).  If the method above was used, you can merge
:: CROSSDUP.DES with DIR61 and the latest dated duplicate will always be kept:

:: MERGE /o crossdup.des dir61
:: This is the quicker way to finish, but now your uploads DIR (which did get
:: shrunk in size) is huge again and a lot of the descriptions there used to be
:: categorized.  Since many of the names in CROSSDUP.DES will not actually be
:: duplicates but different programs (and some that are really duplicates will
:: have better descriptions than others), you may first want to look at it with
:: an editor and see what you've got before taking any action.  You can also
:: use MERGE to reduce its size so that it is more manageable by selectively
:: merging it with different keys (see the TRICKS file).

:: If you used "+N" above but didn't "merge" the trash file each time, you can
:: just append the stripped duplicates to DIR61.  If you don't want to sort the
:: entire uploads directory afterwards (and merge it on itself), sort and run
:: MERGE on the stripped duplicates before appending (or just "merging") them.
:: After sorting CROSSDUP.DES, to insure the latest date is kept, merge first
:: with /k /f1 /f3ddt /ea /ttrash+n and edit the trash file if needed so you
:: can remerge any errors (the only errors should be out of sequence dates).
:: Or you can use MERGE's new /ef switch to "sort" the dates (this batch file
:: was originally written before that switch was available; see BATNOTES for a
:: description of SORT.BAT).  Then merge it on itself without /k /f1 /f3ddt.

:: If you didn't use "+N", the original directory of each duplicate is included
:: with the descriptions in CROSSDUP.DES.  You can go through this list with an
:: editor and move descriptions to the desired directory (if some descriptions
:: were in several directories, you can decide which is the most appropriate).
:: See TRICKS if you want to get a list of all file names that were duplicated.

:END
