program ppls;

{$M $4000,0,0}
uses dos,crt;

const pgm_hdr = 'PCBoard Programming Language Seeker 1.00 freeware       Copyright 1997 Flux / pr';
      days    : array [0..6] of string[9] = ('sunday','monday','tuesday',
                                             'wednesday','thursday','friday','saturday');
type  buffer = array[1..4000] of char;
var   p : ^buffer;

function dir(f : string) : string;
var d : dirstr; n : namestr; e : extstr;
begin
  f := fexpand(f);
  fsplit(f,d,n,e);
  dir := copy(d,1,length(d)-1);
end;

function replace(s1,s2,s3 : string) : string;
var j : integer;
begin
  replace := s1;
  j := pos(s2,s1);
  if j = 0 then exit;

  delete(s1,j,length(s2));
  insert(s3,s1,j);
  replace := s1;
end;

function exepath : string;
var d : dirstr; n : namestr; e : extstr;
begin
  fsplit(paramstr(0),d,n,e);
  exepath := d;
end;

function prog : string;
var d : dirstr; n : namestr; e : extstr;
begin
  fsplit(paramstr(0),d,n,e);
  prog := n;
end;

function ltrim(s : string) : string;
begin
  if s[1] = ' ' then
  repeat
    delete(s,1,1);
  until s[1] <> ' ';
  ltrim := s;
end;

function rtrim(s : string) : string;
var j : integer;
begin
  for j := length(s) downto 1 do if s[j] = ' ' then delete(s,j,1) else break;
  rtrim := s;
end;

procedure savescrn(var screen : buffer);
begin
  move(p^[1],screen[1],4000);
end;

procedure restscrn(var screen : buffer);
begin
  move(screen[1],p^[1],4000);
end;

function i2s(i : longint) : string;
var s : string;
begin
  str(i,s);
  if i < 10 then s := '0'+s;
  i2s := s;
end;

function thisdt : string;
var year,month,day,dow,hour,min,sec,hund : word;
begin
  getdate(year,month,day,dow);
  gettime(hour,min,sec,hund);
  thisdt := days[dow]+' '+i2s(day)+'.'+i2s(month)+'.'+i2s(year)+' '+i2s(hour)+':'+i2s(min)+':'+i2s(sec);
end;

function ch(s : string; i : byte) : char;
begin
  ch := s[i];
end;

function upper(s : string) : string;
var j : byte;
begin
  for j := 1 to ord(s[0]) do s[j] := upcase(s[j]);
  upper := s;
end;

function checkline(ln : string) : byte;
begin
  checkline := 0;

  ln := upper(ln);
  if pos(';', ln) > 0 then ln := copy(ln,1,pos(';', ln));
  if pos('*', ln) > 0 then ln := copy(ln,1,pos('*', ln));
  if pos('''',ln) > 0 then ln := copy(ln,1,pos('''',ln));
  if pos('"', ln) > 0 then ln := copy(ln,1,pos('"',ln)-1);

  if (pos('GETUSER',   ln) > 0) or
     (pos('GETALTUSER',ln) > 0) or
     (pos('PUTUSER',   ln) > 0) or
     (pos('PUTALTUSER',ln) > 0) or
     (pos('ADJBYTES',  ln) > 0) or
     (pos('ADJDBYTES', ln) > 0) or
     (pos('ADJTBYTES', ln) > 0) or
     (pos('ADJTFILES', ln) > 0) or
     (pos('ADJTIME',   ln) > 0) or
     (pos('SYSOPSEC',  ln) > 0) or
     (pos('U_',        ln) > 0) or
     (pos('ACCOUNT',   ln) > 0) then checkline := 1 else
  if (pos('CALL',      ln) > 0) or
     (pos('COPY',      ln) > 0) or
     (pos('PCBDAT',    ln) > 0) or
     (pos('DOWNLOAD',  ln) > 0) then checkline := 2;
end;

function readcfg(name : string) : string;
var line : string; cfg : text; found : boolean; j : integer; s : string;
begin
  assign(cfg,exepath+prog+'.cfg');
  reset(cfg);

  found := false; readcfg := '';
  repeat
    readln(cfg,line);
    if copy(line,1,length(name)) = name then
    begin
      s := copy(line,length(name)+1,length(line)-(length(name)+1));
      if pos(';',s) > 0 then s := copy(s,1,pos(';',s)-1);
      readcfg := ltrim(rtrim(s));
      found := true;
    end;
  until found or eof(cfg);

  close(cfg);
end;

var   sr  : searchrec;
      log,decomp,det,leave : boolean; logfile : string; lg : text;
      pplx,pplx2,ppld,ppld2 : string;
      curdir,st : string;
      pps : text; ppsname,line : string; lines,errors : longint;
      result,x,y,i : byte; s : buffer;

label notppe;
begin
  clrscr;
  writeln('   __________');
  writeln('  |___  \ _  \');
  writeln('  /  __/ /  /         this is a psychic release production');
  writeln(' /___\___\\ \_');
  write('==========\___|=================================================================');
  write(pgm_hdr);
        p := ptr($B800,0000);
     pplx := readcfg('pplx');
     ppld := readcfg('ppld');
  logfile := readcfg('logfile');
  getdir(0,curdir);

  writeln;
  st := '';
  for i := 1 to paramcount do st := st+paramstr(i)+' ';
  if length(rtrim(st)) = 0 then st := 'none';
  writeln('Parameters: ',st);

  if (paramcount < 2) or (ch(paramstr(1),1) = '?') or (ch(paramstr(1),2) = '?') then
  begin
    writeln;
    writeln('Usage:   ppls <command> <ppe_name> <options>');
    writeln('Example: ppls x *.ppe -d');
    writeln;
    writeln('<Commands>');
    writeln('  x: Will decompile PPE using PPLX (c) Aegis');
    writeln('  d: Will decompile PPE using PPLD (c) ECR,SCD');
    writeln('  s: Will seek through pure PPS');
    writeln;
    writeln('<Options>');
    writeln(' -c: leave decompiled PPX/PPD after Checked');
    writeln(' -d: do not Display detailed information at runtime');
    writeln(' -l: do not Log session');
    halt;
  end;

  det := false; log := true; leave := false;
  if paramcount > 2 then
  for i := 3 to paramcount do
    if upper(paramstr(i)) = '-D' then det := true else
    if upper(paramstr(i)) = '-C' then leave := true else
    if upper(paramstr(i)) = '-L' then log := false;

  if length(logfile) = 0 then log := false;

  if log then
  begin
    assign(lg,logfile);
    {$i-} append(lg); {$i+}
    if ioresult <> 0 then rewrite(lg);
  end;

  findfirst(paramstr(2),archive,sr);
  if doserror <> 0 then
  begin
    writeln;
    writeln('File(s) was not found, try again.');
    halt;
  end;
  while doserror = 0 do
  begin
    chdir(dir(paramstr(2)));
    decomp := false;
    if log then writeln(lg,'Processing: ',sr.name,' - ',thisdt);
    writeln;
    writeln('Processing: ',sr.name,' - ',thisdt);
    case upcase(ch(paramstr(1),1)) of
      'X' : begin
              decomp := true;
              if log then writeln(lg,'  Decompiling using PPLX ..');
              writeln('  Decompiling using PPLX ..');
              swapvectors;
              savescrn(s);
              x := wherex; y := wherey; clrscr;
              pplx2 := replace(upper(pplx),'%F',sr.name);
              exec(copy(pplx2,1,pos(' ',pplx2)-1),copy(pplx2,pos(' ',pplx2),length(pplx2)));
              restscrn(s); gotoxy(x,y);
              swapvectors;
              ppsname := sr.name;
              delete(ppsname,pos('.',ppsname)+1,3);
              ppsname := ppsname+'ppx';
            end;
      'D' : begin
              decomp := true;
              if log then writeln(lg,'  Decompiling using PPLD ..');
              writeln('  Decompiling using PPLD ..');
              swapvectors;
              savescrn(s); x := wherex; y := wherey; clrscr;
              ppld2 := replace(upper(ppld),'%F',sr.name);
              exec(copy(ppld2,1,pos(' ',ppld2)-1),copy(ppld2,pos(' ',ppld2),length(ppld2)));
              restscrn(s); gotoxy(x,y);
              swapvectors;
              ppsname := sr.name;
              delete(ppsname,pos('.',ppsname)+1,3);
              ppsname := ppsname+'ppd';
            end;
      'S' : ppsname := sr.name;
    end;
    if log then writeln(lg,'  Seeking through source file ..');
    writeln('  Seeking through source file ..');
    assign(pps,ppsname);
    reset(pps);
    lines := 0;
    errors := 0;
    repeat
      inc(lines);
      readln(pps,line);
      if lines = 1 then if copy(line,1,39) = 'PCBoard Programming Language Executable' then
      begin
        if log then
        begin
          writeln(lg,'  Closed source file (not source, ppe)');
          writeln(lg);
        end;
        writeln('  Closed source file (not source, ppe)');
        if decomp and not leave then erase(pps) else close(pps);
        goto notppe;
      end;
      result := checkline(line);
      if result <> 0 then
      begin
        case result of
          1 : begin
                if log then  writeln(lg,'    ',lines:4,' Used some useraccess variables or functions/procedures');
                if not det then writeln('    ',lines:4,' Used some useraccess variables or functions/procedures');
              end;
          2 : begin
                if log then  writeln(lg,'    ',lines:4,' Used some fileaccess functions/procedures');
                if not det then writeln('    ',lines:4,' Used some fileaccess functions/procedures');
              end;
        end;
        inc(errors);
      end;
    until eof(pps);
    if decomp and not leave then erase(pps) else close(pps);

    if log then
    begin
      writeln(lg,'    ',lines:4,' Total line(s)  ',errors:4,' Warning(s)');
      writeln(lg,'  Closed source file');
      writeln(lg);
    end;
    writeln('    ',lines:4,' Total line(s)  ',errors:4,' Warning(s)');
    writeln('  Closed source file');

    notppe:
    chdir(curdir);
    findnext(sr);
  end;
  if log then close(lg);
end.
