;Gets the latest stock quotes (15 min. delay during trading days). To specify
;the stocks you want to track, select "Services|Stock Quotes..." in OzCIS.

;****************************************************************************
; ClockMan95 Automation Assistant support file
; (c) 1995 Graphical Dynamics, Inc. The "Common helper functions" are placed
; in the public domain; otherwise permission is granted to use/modify this
; script file as long as it's not for resale.
;
; Written by: Jennifer Palonus
;
; Date    Who	Major changes
;-------  ---	-------------------------------------------------------------
;16aug95  jlp	Created.
;****************************************************************************
	define $QuotesFile		; used by GetQuotes
	define $ServiceName		; used by GoService
	define #ServiceHasHdr	; used by GoService
	define $MenuItem		; used by ChooseMenuItem & FindMenuItem
	define $SubjectLine		; used by CaptureMsg
	define $Prompt			; used by WaitForPrompt
	define #OK				; used everywhere. Routines return %TRUE or %FALSE
	onerror HandleErrors
	timeout 90


;****************************************************************************
; Main processing section.
;****************************************************************************
	set $QuotesFile %HOSTPATH "OZCIS.QTS"
	set #OK fexists $QuotesFile
	if #OK = %FALSE fail
	fopen &1 $QuotesFile

	set $SubjectLine    "Latest Stock Quotes"
	gosub StartCapture
	capture off

	MainWhileTickers:
	if #OK = %FALSE goto MainWend
		set $ServiceName    "CIS:BASICQUOTES"
		set #ServiceHasHdr  %FALSE
		gosub GoService

		capture on CISMAIL.MSG
		gosub GetQuotes
		capture off
	goto MainWhileTickers
	MainWend:

	fclose &1
	end


;****************************************************************************
; GetQuotes
;
; Gets up to 20 stock quotes from BASICQUOTES, using the ticker symbols
; listed in $QuotesFile. It assumes you've just sent a "GO CIS:BASICQUOTES".
;
; You must open the $QuotesFile as &1 before calling GetQuotes, and close it
; after GetQuotes returns #OK=%FALSE.
;
; Returns #OK=%TRUE if tickers were retrieved, else %FALSE if there was a
; problem or we're at EOF in the $QuotesFile.
;****************************************************************************
GetQuotes:
	define $GQTickers

	; Extract up to 20 ticker symbols from the quotes file...
	set $Prompt ^M^J "Issue: "
	GQWhileNotEOF:
	if #OK = %FALSE goto GQWend
		gosub WaitForPrompt

		gosub BuildTickerList
		if #OK = %TRUE sendln $GQTickers
	goto GQWhileNotEOF
	GQWend:

	return


;****************************************************************************
; BuildTickerList
;
; Builds up a comma-delimited list of ticker symbols as specified in OzCIS'
; Services|Stock Quotes... dialog & saved in the file OZCIS.QTS.
;
; Returns #OK=%TRUE if tickers were found in OZCIS.QTS, else %FALSE if there
; was a problem or no tickers in the file. Returns the list of tickers (if
; any) to $GQTickers.
;****************************************************************************
BuildTickerList:
	define #BTLNumTickers
	define #BTLTemp
	define $BTLThisTicker

	set #OK %TRUE
	set #BTLNumTickers 0
	set $GQTickers ""
	
	BTLWhileNotEOF:
	if feof &1 goto BTLWend
	if #BTLNumTickers = 20 goto BTLWend
		freadln &1 $1
		inc #BTLNumTickers

		; Parse this line...
		delstr $1 1 1
		pos #BTLTemp ";" $1
		dec #BTLTemp  ;End of ticker symbol or company name
		midstr $1 1 #BTLTemp $BTLThisTicker
		concat $GQTickers $BTLThisTicker
		concat $GQTickers ","
	goto BTLWhileNotEOF
	BTLWend:

	; Trim off trailing ","...
	length #BTLTemp $GQTickers
	if #BTLTemp > 0 delstr $GQTickers #BTLTemp 1
	
	if #BTLNumTickers <= 0 set #OK %FALSE
	return


;****************************************************************************
; Common helper functions. (These are placed in the "public domain" by GDI.)
;****************************************************************************
; GoService
;
; Carries out a GO command & passes over the introductory text (if any).
; When this returns, you're ready to capture or parse the service's top menu.
;
; $ServiceName		The CIS service you want to GO to.
; #ServiceHasHdr	Does this service have an intro paragraph ending with a
;					"MORE !" prompt?
;****************************************************************************
GoService:
	set #OK %TRUE
	sendln "GO " $ServiceName

	if #ServiceHasHdr = %FALSE return
	set $Prompt ^M^J "MORE !"		 
	gosub WaitForPrompt
	send %CR
	return

	
;****************************************************************************
; CaptureMsg
;
; Assuming CIS is about to send us the text that we want to place into a mail
; message, this routine captures the text 'till we get a <CR> & ! prompt.
;
; $SubjectLine		The custom subject line if different than the default.
; $Prompt			The prompt that ends the article. Usu. ^M^J "!".
;****************************************************************************
CaptureMsg:
	set #OK %TRUE
	gosub StartCapture
	gosub WaitForPrompt
	capture off
	return


;****************************************************************************
; StartCapture
;
; Assuming CIS is about to send us the text that we want to place into a mail
; message, this routine creates the mail message & starts capturing the text.
;
; $SubjectLine		The custom subject line if different than the default.
;****************************************************************************
StartCapture:
	set #OK %TRUE
	capture on CISMAIL.MSG
	if $SubjectLine =  "" WMH
	if $SubjectLine <> "" WMH $SubjectLine
	set $SubjectLine ""
	return


;****************************************************************************
; WaitForPrompt
;
; Wait till the end of a menu or opening text. This routine handles menus
; split up into multiple chunks, each of which end in "MORE !" prompts.
; If you DO want to wait for "MORE !", then set $Prompt to it.
;
; $Prompt			The prompt you're waiting for. Usu. ^M^J "!".
;****************************************************************************
WaitForPrompt:
	define #WFPToken
	set #OK %TRUE
	
	add 1 $Prompt
	add 2 ^M^J "MORE !"
	mwait #WFPToken
	if #WFPToken = 2 send %CR
	if #WFPToken = 2 goto WaitForPrompt

	return


;****************************************************************************
HandleErrors:
	fail

