/* This file is only included by chmap.c.  It is separated from it for easy
 * maintainence of the various character sets.
 */

#define HAVE_NEXT_CHARMAP	1
#define HAVE_IBM850_CHARMAP	1

#define MAX_CHARMAPS		3      /* add 1 for ISO Latin (default) */

typedef struct
{
   char *map_name;
   unsigned char display_eight_bit;
   unsigned char to_iso_map [256];
   unsigned char from_iso_map [256];
}
CharMap_Type;

#if HAVE_IBM850_CHARMAP
static CharMap_Type IBM850_Char_Map =
{
   "ibm850", 128,
   /* to_iso_map */
     {
     /* Conversion table from `cp850' charset to `iso88591' charset.
      * Generated mechanically by GNU recode 3.4.
      * 
      *  The recoding should be reversible.
      */
	0,   1,   2,   3,   4,   5,   6,   7,	/*   0 -   7 */
	8,   9,  10,  11,  12,  13,  14,  15,	/*   8 -  15 */
	16,  17,  18,  19,  20,  21,  22,  23,	/*  16 -  23 */
	24,  25,  26,  27,  28,  29,  30,  31,	/*  24 -  31 */
	32,  33,  34,  35,  36,  37,  38,  39,	/*  32 -  39 */
	40,  41,  42,  43,  44,  45,  46,  47,	/*  40 -  47 */
	48,  49,  50,  51,  52,  53,  54,  55,	/*  48 -  55 */
	56,  57,  58,  59,  60,  61,  62,  63,	/*  56 -  63 */
	64,  65,  66,  67,  68,  69,  70,  71,	/*  64 -  71 */
	72,  73,  74,  75,  76,  77,  78,  79,	/*  72 -  79 */
	80,  81,  82,  83,  84,  85,  86,  87,	/*  80 -  87 */
	88,  89,  90,  91,  92,  93,  94,  95,	/*  88 -  95 */
	96,  97,  98,  99, 100, 101, 102, 103,	/*  96 - 103 */
	104, 105, 106, 107, 108, 109, 110, 111,	/* 104 - 111 */
	112, 113, 114, 115, 116, 117, 118, 119,	/* 112 - 119 */
	120, 121, 122, 123, 124, 125, 126, 127,	/* 120 - 127 */
	199, 252, 233, 226, 228, 224, 229, 231,	/* 128 - 135 */
	234, 235, 232, 239, 238, 236, 196, 197,	/* 136 - 143 */
	201, 230, 198, 244, 246, 242, 251, 249,	/* 144 - 151 */
	255, 214, 220, 248, 163, 216, 215, 159,	/* 152 - 159 */
	225, 237, 243, 250, 241, 209, 170, 186,	/* 160 - 167 */
	191, 174, 172, 189, 188, 161, 171, 187,	/* 168 - 175 */
	155, 157, 141, 129, 139, 193, 194, 192,	/* 176 - 183 */
	169, 150, 132, 175, 184, 162, 165, 151,	/* 184 - 191 */
	183, 181, 147, 128, 142, 143, 227, 195,	/* 192 - 199 */
	131, 144, 146, 133, 135, 153, 158, 164,	/* 200 - 207 */
	240, 208, 202, 203, 200, 134, 205, 206,	/* 208 - 215 */
	207, 137, 130, 136, 154, 166, 204, 152,	/* 216 - 223 */
	211, 223, 212, 210, 245, 213, 145, 222,	/* 224 - 231 */
	254, 218, 219, 217, 253, 221, 140, 180,	/* 232 - 239 */
	173, 177, 149, 190, 182, 167, 247, 148,	/* 240 - 247 */
	176, 168, 156, 185, 179, 178, 138, 160	/* 248 - 255 */
     },
   /* from_iso_map */
     {
     /* Conversion table from `iso88591' charset to `cp850' charset.
      * Generated mechanically by GNU recode 3.4.
      *
      * The recoding should be reversible.
      */
	0,   1,   2,   3,   4,   5,   6,   7,	/*   0 -   7 */
	8,   9,  10,  11,  12,  13,  14,  15,	/*   8 -  15 */
	16,  17,  18,  19,  20,  21,  22,  23,	/*  16 -  23 */
	24,  25,  26,  27,  28,  29,  30,  31,	/*  24 -  31 */
	32,  33,  34,  35,  36,  37,  38,  39,	/*  32 -  39 */
	40,  41,  42,  43,  44,  45,  46,  47,	/*  40 -  47 */
	48,  49,  50,  51,  52,  53,  54,  55,	/*  48 -  55 */
	56,  57,  58,  59,  60,  61,  62,  63,	/*  56 -  63 */
	64,  65,  66,  67,  68,  69,  70,  71,	/*  64 -  71 */
	72,  73,  74,  75,  76,  77,  78,  79,	/*  72 -  79 */
	80,  81,  82,  83,  84,  85,  86,  87,	/*  80 -  87 */
	88,  89,  90,  91,  92,  93,  94,  95,	/*  88 -  95 */
	96,  97,  98,  99, 100, 101, 102, 103,	/*  96 - 103 */
	104, 105, 106, 107, 108, 109, 110, 111,	/* 104 - 111 */
	112, 113, 114, 115, 116, 117, 118, 119,	/* 112 - 119 */
	120, 121, 122, 123, 124, 125, 126, 127,	/* 120 - 127 */
	195, 179, 218, 200, 186, 203, 213, 204,	/* 128 - 135 */
	219, 217, 254, 180, 238, 178, 196, 197,	/* 136 - 143 */
	201, 230, 202, 194, 247, 242, 185, 191,	/* 144 - 151 */
	223, 205, 220, 176, 250, 177, 206, 159,	/* 152 - 159 */
	255, 173, 189, 156, 207, 190, 221, 245,	/* 160 - 167 */
	249, 184, 166, 174, 170, 240, 169, 187,	/* 168 - 175 */
	248, 241, 253, 252, 239, 193, 244, 192,	/* 176 - 183 */
	188, 251, 167, 175, 172, 171, 243, 168,	/* 184 - 191 */
	183, 181, 182, 199, 142, 143, 146, 128,	/* 192 - 199 */
	212, 144, 210, 211, 222, 214, 215, 216,	/* 200 - 207 */
	209, 165, 227, 224, 226, 229, 153, 158,	/* 208 - 215 */
	157, 235, 233, 234, 154, 237, 231, 225,	/* 216 - 223 */
	133, 160, 131, 198, 132, 134, 145, 135,	/* 224 - 231 */
	138, 130, 136, 137, 141, 161, 140, 139,	/* 232 - 239 */
	208, 164, 149, 162, 147, 228, 148, 246,	/* 240 - 247 */
	155, 151, 163, 150, 129, 236, 232, 152	/* 248 - 255 */
     }
};
#endif

#if HAVE_NEXT_CHARMAP
static CharMap_Type NeXT_Char_Map =
{
   "NeXT", 128,
   
   /* to_iso_map */
     {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
	0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0xa0,0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc7,
	0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
	0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd9,
	0xda,0xdb,0xdc,0xdd,0xde,0xb5,0xd7,0xf7,
	0xa9,0xa1,0xa2,0xa3,0x2f,0xa5,0x66,0xa7,
	0xa4,0xb4,0x22,0xab,0x5b,0x5d,0x3f,0x3f,
	0xae,0x3f,0x3f,0x3f,0xb7,0xa6,0xb6,0xb7,
	0xb8,0x22,0x22,0xbb,0xb0,0x3f,0xac,0xbf,
	0xb9,0x60,0xb4,0x5e,0x7e,0xaf,0x3f,0xb7,
	0xa8,0x82,0xb0,0xb8,0xb3,0xa8,0x3f,0x3f,
	0x3f,0xb1,0xbc,0xbd,0xbe,0xe0,0xe1,0xe2,
	0xe3,0xe4,0xe5,0xe7,0xe8,0xe9,0xea,0xeb,
	0xec,0xc6,0xed,0xaa,0xee,0xef,0xf0,0xf1,
	0xa3,0xd8,0x4f,0xba,0xf2,0xf3,0xf4,0xf5,
	0xf6,0xe6,0xf9,0xfa,0xfb,0x69,0xfc,0xfd,
	0x6c,0xf8,0x6f,0xdf,0xfe,0xff,0x3f,0x3f
     },
   
   /* from_iso_map */
     {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
	0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
	0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
	0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
	0x80,0xa1,0xa2,0xa3,0xa8,0xa5,0xb5,0xa7,
	0xc8,0xa0,0xe3,0xab,0xbe,0x2d,0xb0,0xc5,
	0xca,0xd1,0xc9,0xcc,0xc2,0x9d,0xb6,0xb4,
	0xcb,0xc0,0xeb,0xbb,0xd2,0xd3,0xd4,0xbf,
	0x81,0x82,0x83,0x84,0x85,0x86,0xe1,0x87,
	0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x9e,
	0xe9,0x97,0x98,0x99,0x9a,0x9b,0x9c,0xfb,
	0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xf1,0xdb,
	0xdc,0xdd,0xde,0xdf,0xe0,0xe2,0xe4,0xe5,
	0xe6,0xe7,0xec,0xed,0xee,0xef,0xf0,0x9f,
	0xf9,0xf2,0xf3,0xf4,0xf6,0xf7,0xfc,0xfd
     }
};
#endif

#if HAVE_IBM850_CHARMAP && defined(__os2__)
# define DEFAULT_CHARSET_NAME "ibm850"
#else
# if HAVE_NEXT_CHARMAP && defined(__NeXT__)
#  define DEFAULT_CHARSET_NAME "NeXT"
# endif
#endif

#ifndef DEFAULT_CHARSET_NAME
# define DEFAULT_CHARSET_NAME "isolatin"
#endif

static CharMap_Type *Char_Maps [MAX_CHARMAPS] =
{
#if HAVE_IBM850_CHARMAP
   &IBM850_Char_Map,
#endif
#if HAVE_NEXT_CHARMAP
   &NeXT_Char_Map,
#endif
   NULL				       /* MUST be NULL terminated */
};


