// Heavily based on POV 2.0 sample file polywood.pov by Eduard Schwan;
// Please, warn me if i shouldn't distribute this file, i'm not sure.
//
// With my unofficial POV-Ray 2.2 enhancements, point light sources become
// directly visible, surrounded by a user adjustable glow due to scattering 
// by the particles in the atmosphere.
// 
// This scene tries to be an indecent imitation of the jack-o-lantern image
// in Max's 1986 Siggraph paper. Note the absence of atmospheric shadows, or 
// inversely, the absence of shafts of light. If people show interest in
// such stuff, i could implement it for POVAFX v2.0, but i mean a *fast*
// implementation, unlike POV-Ray 3.0 which *seems* to use pure volume 
// sampling (please correct me if i'm wrong, i haven't seen it in action! :-)
//
//      Marcos Fajardo
//      mailto://mfajardo@freenet.hut.fi
//      http://www.geocities.com/TimesSquare/2143/povafx10.html

include "shapes.inc"
include "colors.inc"
include "textures.inc"

camera {
   location   <-3.3,  5.0, -21.0>
   direction  <0.0,   0.0,   1.0>
   up         <0.0,   1.0,   0.0>
   right      <4/3,   0.0,   0.0>
   look_at    <0,     5,     0> 
}

 // A bit of ground fog
fog { color rgb <.6, .6, .6> distance 20 height 3 }
background { color RichBlue }

 // Reddish glowing light source inside polyhedron
light_source
{
  <0, 3, 0>
  color red 1.0 green 0.3 blue 0.1
  glow 0.5
  glow_type_a
}

 // Something for the polyhedron to rest on
plane {
  y, 0 
  pigment { color red 0.3 green 1.0 blue 0.4 }
  finish {
      ambient 0.1
      diffuse 0.5
      roughness 1
  }
}


// The Wooden Polyhedron
// The idea here is to take a few cubes rotated at 45 degrees
// along different axes from each other and intersect them,
// thus cutting some corners.  Then we carve out the center
// with a slightly oversized sphere, which protrudes slightly
// through the sides of the cubes, cutting portholes in the
// facets of the polyhedron.  Then we get out the wooden paint..
intersection {
   // polyhedron
   // Add small amount to each box to account for normal numerical inacurracies.
   // This fixes surface acne on coplanar surfaces.
   box { <-4.000, -4.000, -4.000>, <4.000, 4.000, 4.000> }
   box { <-4.001, -4.001, -4.001>, <4.001, 4.001, 4.001>   rotate 45*x }
   box { <-4.002, -4.002, -4.002>, <4.002, 4.002, 4.002>   rotate 45*y }
   box { <-4.003, -4.003, -4.003>, <4.003, 4.003, 4.003>   rotate 45*z }
   // hollow it out
   sphere { <0, 0, 0>, 4.25 inverse }

   // semi-dark wood with dark greenish rings
   pigment {
      wood
      turbulence 0.04
      colour_map {
        [0.0 0.4  color red 0.8 green 0.4 blue 0.2
                  color red 0.8 green 0.4 blue 0.1]
        [0.4 0.5  color red 0.1 green 0.3 blue 0.1
                  color red 0.1 green 0.3 blue 0.2]
        [0.5 0.8  color red 0.1 green 0.3 blue 0.2
                  color red 0.8 green 0.4 blue 0.1]
        [0.8 1.0  color red 0.8 green 0.4 blue 0.1
                  color red 0.8 green 0.4 blue 0.2]
      }
      scale <0.2, 0.2, 1>
      rotate <45, 0, 5>
      translate <2, 2, -4>
   }
   finish {
      // make it look wood-like
      ambient 0.15
      diffuse 0.6
      // make it a little bit shiny
      specular 0.3 roughness 0.01
      phong 0.3 phong_size 60
   }
   bounded_by { sphere { <0, 0, 0>, 5 } }
   translate <0, 4, 0>
}


