VERSION 2.00
Begin Form frmSearch 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Search"
   ClientHeight    =   4095
   ClientLeft      =   990
   ClientTop       =   1725
   ClientWidth     =   6960
   ForeColor       =   &H00C0C0C0&
   Height          =   4620
   Left            =   930
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   273
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   464
   Top             =   1260
   Width           =   7080
   Begin SSFrame fra3dGroup 
      Height          =   2415
      Left            =   240
      TabIndex        =   12
      Top             =   1440
      Width           =   6495
      Begin SSPanel pan3dGroups 
         BevelOuter      =   1  'Inset
         Caption         =   "Panel3D2"
         Height          =   1695
         Left            =   2400
         TabIndex        =   0
         Top             =   480
         Width           =   3855
         Begin ListBox lbGroups 
            Enabled         =   0   'False
            Height          =   1590
            Left            =   15
            MultiSelect     =   1  'Simple
            Sorted          =   -1  'True
            TabIndex        =   8
            Top             =   15
            Width           =   3825
         End
      End
      Begin SSOption opt3dAllTopics 
         Caption         =   "All &Topics"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   1680
         Value           =   -1  'True
         Width           =   1695
      End
      Begin SSOption opt3dGroups 
         Caption         =   "&Groups"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         TabStop         =   0   'False
         Top             =   1080
         Width           =   1575
      End
      Begin SSOption opt3dCurrentTopic 
         Caption         =   "&Current Topic"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         TabStop         =   0   'False
         Top             =   480
         Width           =   1695
      End
      Begin Label lblGroups 
         BackStyle       =   0  'Transparent
         Caption         =   "G&roups:"
         Height          =   255
         Left            =   2400
         TabIndex        =   7
         Top             =   240
         Width           =   2055
      End
   End
   Begin SSCheck chk3dAnd 
      Caption         =   "&AND multiple search words"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   960
      Width           =   3135
   End
   Begin SSPanel pan3dSearchText 
      BevelOuter      =   1  'Inset
      Caption         =   "Panel3D1"
      Height          =   375
      Left            =   240
      TabIndex        =   11
      Top             =   480
      Width           =   4695
      Begin TextBox ebSearchText 
         Height          =   345
         Left            =   15
         TabIndex        =   2
         Top             =   15
         Width           =   4665
      End
   End
   Begin CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   372
      Left            =   5400
      TabIndex        =   10
      Top             =   720
      Width           =   1332
   End
   Begin CommandButton cmdFind 
      Caption         =   "&Find"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   372
      Left            =   5400
      TabIndex        =   9
      Top             =   240
      Width           =   1332
   End
   Begin Label lblSearchString 
      BackStyle       =   0  'Transparent
      Caption         =   "&Search word or phrase:"
      Height          =   252
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   2172
   End
End
Option Explicit

Sub cmdCancel_Click ()
    'Hide the form so execution can continue in calling subroutine
    Me.Visible = False
End Sub

Sub cmdFind_Click ()
    Dim nImplicit As Integer
    Dim htlLimit As Integer
    Dim nTemp As Integer
    Dim lpQError As QUERYERR

    Call WaitCursor
    'Set the implicit flag
    If chk3dAnd.Value Then
        nImplicit = IMPLICIT_AND
    Else
        nImplicit = IMPLICIT_OR
    End If
    
    If opt3dGroups.Value Then
        'Get the selected groups to search in
        htlLimit = GetGroups()
    ElseIf opt3dCurrentTopic.Value Then
        'Create a topic list containing only the current topic
        htlLimit = TopicListFromTopicNo(gblhTitle, frmMain.MediaView1.TopicIndex)
    Else
        'No limiting group
        htlLimit = 0
    End If

    If htlLimit = 0 And opt3dGroups.Value Then
        'Error: either groups not loaded or not selected
        Call DefaultCursor
        'Show the error message
        nTemp = ViewMVError(ERR_NOGROUPS, "")
    Else
        'Submit the query
        gblhTList = TopicListFromQuery(gblhTitle, nImplicit, ebSearchText.Text, htlLimit, 0, 0&, gbllpHighLight, lpQError)
        'Destroy any created topic list
        If htlLimit <> 0 Then Call TopicListDestroy(htlLimit)
    
        Me.Visible = False
        Call DefaultCursor
        If gblhTList = 0 Then
            'Set active search flag to FALSE
            gblbSearchActive = False
            'Show the error message
            nTemp = MVError(lpQError.iError, "")
        Else
            If TopicListLength(gblhTList) = 0 Then
                'There were no hits, so destroy the topic list
                Call TopicListDestroy(gblhTList)
                'Show the error message
                nTemp = ViewMVError(ERR_NOTOPICS, CStr(ebSearchText.Text))
                'Set active search flag to FALSE
                gblbSearchActive = False
            Else
                'Set active search flag to TRUE
                gblbSearchActive = True
            End If
        End If
        'Set the View/Search results enabled state
        frmMain.mnuView_SearchResults.Enabled = gblbSearchActive
    End If
End Sub

Sub ebSearchText_Change ()
    'Set the enabled state of the Find command button
    cmdFind.Enabled = (ebSearchText <> "")
End Sub

Sub Form_Load ()
    Dim szBaggageContents As String
    Dim bSuccess As Integer
    
    Call WaitCursor
    
    'Read the baggage file into szBaggageContents
    bSuccess = ReadBaggageMVP(szBaggageContents)
    'Fill the group list box
    If bSuccess Then bSuccess = FillGroupListBox(szBaggageContents, frmSearch.lbGroups, "group=")
    If Not bSuccess Then
        'There was a problem adding the groups so disable and grey the appropriate controls
        opt3dGroups.Enabled = False
        lblGroups.ForeColor = &H808080
    End If
    
    pan3dGroups.Height = lbGroups.Height + 30
    Me.Move frmMain.Left + (frmMain.Width - Me.Width) / 2, frmMain.Top + (frmMain.Height - Me.Height) / 2
    Call DefaultCursor
    'Show the form modally
    Me.Show 1
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
    'This prevents an error if the user closes the form with the control menu
    Cancel = (UnloadMode <> 1)
    Me.Visible = False
End Sub

Function GetGroups () As Integer
    'This creates the topic list to limit a search to particular groups
    
    Dim nIndex, nTemp, hTListTemp1  As Integer
    Dim hTListTemp2 As Integer
    Dim hTList As Integer

    hTList = 0
    'Step through the list box
    For nIndex = 0 To lbGroups.ListCount - 1
        If lbGroups.Selected(nIndex) Then
            'The item is selected, so get the group name
            nTemp = InStr(lbGroups.List(nIndex), Chr$(9)) + 1
            'Is this the first one?
            If hTList = 0 Then
                'Load the topic list for this group
                hTList = TopicListLoad(gblhTitle, Mid$(lbGroups.List(nIndex), nTemp))
                If hTList = 0 Then
                    'Show the error message
                    'NOTE: If this first one fails, then I leave the loop
                    nTemp = ViewMVError(ERR_TLFATAL, "")
                    Exit For
                End If
            Else
                'Save the current topic list
                hTListTemp1 = hTList
                'Load the topic list for this group
                hTListTemp2 = TopicListLoad(gblhTitle, Mid$(lbGroups.List(nIndex), nTemp))
                If hTListTemp2 = 0 Then
                    'Show the error message
                    nTemp = ViewMVError(ERR_TLCREATE, "")
                Else
                    'Combine the topic lists
                    hTList = TopicListCombine(TL_OR, hTListTemp1, hTListTemp2, False)
                    If hTList = 0 Then
                        'Reset the topic list
                        hTList = hTListTemp1
                        'Show the error message
                        nTemp = ViewMVError(ERR_TLCOMBINE, "")
                    Else
                        'Destroy the first temporary topic list
                        Call TopicListDestroy(hTListTemp1)
                    End If
                    'Destroy the second temporary topic list
                    Call TopicListDestroy(hTListTemp2)
                End If
            End If
        End If
    Next nIndex
    'Set the return value
    GetGroups = hTList
End Function

Sub opt3dAllTopics_Click (Value As Integer)
    'Disabled the groups list box
    lbGroups.Enabled = False
End Sub

Sub opt3dCurrentTopic_Click (Value As Integer)
    'Disable the groups list box
    lbGroups.Enabled = False
End Sub

Sub opt3dGroups_Click (Value As Integer)
    'Enable the groups list box
    lbGroups.Enabled = True
End Sub

