VERSION 2.00
Begin Form frmResults 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Search Results"
   ClientHeight    =   3405
   ClientLeft      =   6270
   ClientTop       =   4170
   ClientWidth     =   4350
   Height          =   3930
   Icon            =   RESULTS.FRX:0000
   Left            =   6210
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3405
   ScaleWidth      =   4350
   Top             =   3705
   Width           =   4470
   Begin CommandButton cmdClose 
      Caption         =   "&Close"
      Height          =   390
      Left            =   2310
      TabIndex        =   4
      Top             =   2835
      Width           =   1395
   End
   Begin CommandButton cmdGoto 
      Caption         =   "&Go To"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   390
      Left            =   480
      TabIndex        =   3
      Top             =   2835
      Width           =   1395
   End
   Begin SSPanel pan3dResults 
      BevelOuter      =   1  'Inset
      Caption         =   "Panel3D1"
      Height          =   2295
      Left            =   120
      TabIndex        =   0
      Top             =   480
      Width           =   4095
      Begin ListBox lbResults 
         Height          =   2175
         Left            =   15
         TabIndex        =   2
         Top             =   15
         Width           =   4065
      End
   End
   Begin Timer Timer1 
      Enabled         =   0   'False
      Left            =   3480
      Top             =   0
   End
   Begin Label lblNumHits 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   " Topics Found"
      Height          =   255
      Left            =   0
      TabIndex        =   1
      Top             =   120
      Width           =   4335
   End
End
Option Explicit

Dim frmgbllTopicListLen, frmgbllCurTopic As Long
Dim hHwndOrigParent As Integer

Sub cmdClose_Click ()
    Unload Me
End Sub

Sub cmdGoto_Click ()
    'Let lbResults_DblClick handle this event
    Call lbResults_DblClick
End Sub

Sub Form_Load ()
    Call WaitCursor
    'Set the topic list length
    frmgbllTopicListLen = TopicListLength(gblhTList)
    'This will set the caption appropriately if no matter how many hits are found
    If frmgbllTopicListLen > 1 Then
        lblNumHits.Caption = Str$(frmgbllTopicListLen) & lblNumHits.Caption
    Else
        lblNumHits.Caption = "1 Topic Found"
    End If
    pan3dResults.Height = lbResults.Height + 30
    frmgbllCurTopic = 0
    Timer1.Interval = 500
    Timer1.Enabled = True
    'Set the window word so that this form behaves like a child of frmMain
    hHwndOrigParent = SetWindowWord(Me.hWnd, GWW_HWNDPARENT, frmMain.hWnd)
    Me.Move frmMain.Left + (frmMain.Width - Me.Width) / 2, frmMain.Top + (frmMain.Height - Me.Height) / 2
End Sub

Sub Form_Resize ()
    'If the form is not minimized then reposition the controls appropriately
    If Me.WindowState <> 1 Then
        If Me.Width < 3500 Then Me.Width = 3500
        If Me.Height < 2500 Then Me.Height = 2500
        lblNumHits.Width = Me.ScaleWidth
        lbResults.Move 15, 15, Me.ScaleWidth - 285, Me.ScaleHeight - 1230
        pan3dResults.Move 120, 480, lbResults.Width + 30, lbResults.Height + 30
        cmdGoto.Move Me.ScaleWidth / 2 - cmdGoto.Width - 150, Me.ScaleHeight - 570
        cmdClose.Move Me.ScaleWidth / 2 + 150, cmdGoto.Top
    End If
End Sub

Sub Form_Unload (Cancel As Integer)
    Dim nTemp As Integer

    gblbSearchActive = False
    'Deactivate View/Search results menu item
    frmMain.mnuView_SearchResults.Enabled = False
    'Reset the window word back to the original parent
    hHwndOrigParent = SetWindowWord(Me.hWnd, GWW_HWNDPARENT, hHwndOrigParent)
    'Destroy the topic list
    Call TopicListDestroy(gblhTList)
    'Turn off the the search hit highlights
    Call ShowSearchHits(False)
End Sub

Sub lbResults_Click ()
    cmdGoto.Enabled = True
End Sub

Sub lbResults_DblClick ()
    Call WaitCursor
    'Set the new topic number in the VBX
    frmMain.MediaView1.TopicIndex = TopicListLookup(gblhTList, lbResults.ListIndex)
    'Set up the app for the new topic
    Call NewTopic(False)
    Call DefaultCursor
End Sub

Sub Timer1_Timer ()
    'This timer takes care of filling the hit results list box
    
    Dim nTemp, hHistHwnd, nTopicTitleLen As Integer
    Dim szTopicTitle As String
    Dim lTemp As Long

    nTemp = 0
    While (nTemp < 25) And (frmgbllCurTopic < frmgbllTopicListLen)
        'Initialize the string
        szTopicTitle = String(128, 0)
        'Get the topic address
        lTemp = TopicListLookup(gblhTList, frmgbllCurTopic)
        If lTemp = -1 Then
            'Show the error message
            lTemp = ViewMVError(ERR_TLLOOKUP, format$(frmgbllCurTopic, "0"))
        Else
            'Get the topic title
            nTopicTitleLen = TitleGetInfo(gblhTitle, TTLINF_TOPICTITLE, lTemp, szTopicTitle)
            If nTopicTitleLen = -1 Then
                'Show the error message
                lTemp = ViewMVError(ERR_TOPICTITLE, Format$(lTemp, "0"))
            Else
                'Add the title to the search results list
                lbResults.AddItem Left$(szTopicTitle, nTopicTitleLen)
            End If
        End If
        'Increment the counters
        frmgbllCurTopic = frmgbllCurTopic + 1
        nTemp = nTemp + 1
    Wend
    'Disable the timer if appropriate
    If frmgbllCurTopic >= frmgbllTopicListLen Then Timer1.Enabled = False
    If Not Me.Visible Then
        'Show the results
        Me.Visible = True
        'Turn on the search highlighting if the menu item is checked
        Call ShowSearchHits(CInt(frmMain.mnuHighlight_SearchHits.Checked))
    End If
    Call DefaultCursor
End Sub

