/*
 * VFWDIB.H - definitions necessary for VFWDIB.DLL
 *
 * You must have Video For Windows installed in order to build
 * and execute the VFWDIB.DLL.
 */

/*
 * This structure tracks information on each instance of a VFWDIB
 * embedded window.  A pointer to the structure is stored in the
 * HWND of the embedded window.
 */
typedef struct tagDIBINFO
	{
	EWDATA ew;							/* the Create time EWDATA */
	LPSTR szBagFileName;				/* the (baggage) file name */
	LPBITMAPINFOHEADER lpBI;		/* the bitmap (possibly compressed) */
	HDRAWDIB hdd;						/* DrawDibOpen session handle */
	int width;							/* in case author overrides bitmap size */
	int height;							/* in case author overrides bitmap size */
	} DIBINFO, FAR * LPDIBINFO;

/* MACROS for getting and setting the data from the window */
#define GWL_LPDIB		0
#define GetLPDIB(hWnd) (LPDIBINFO)GetWindowLong(hWnd, GWL_LPDIB)
#define SetLPDIB(hWnd, lpDIB) SetWindowLong(hWnd, GWL_LPDIB, (long)lpDIB)

