#include <stdlib.h>
#include <windows.h>
#include <mvew12.h>

/* forward declarations */
extern	int WINAPI InitiateMVSampEW(HINSTANCE hInstance);
extern	int WINAPI TerminateMVSampEW(HINSTANCE hInstance);
extern	int WINAPI LibMain(HINSTANCE hInstance,unsigned short wDataSeg,unsigned short wHeapSize,char __far *lpCmdLine);
extern	long CALLBACK EWProc(HWND hWnd,unsigned int msg,unsigned int wParam,long lParam);
extern	long InitEW(HWND hWnd, WPARAM wParam, LPARAM lParam);
extern	long DestroyEW(HWND hWnd, WPARAM wParam, LPARAM lParam);
extern	long PrintEW(HWND hWnd, LPRENDERINFO lpRI);
extern	long GetEWSize(HWND hWnd, HDC hDC, LPPOINT lpP);
extern	long ActivateEW(HWND hWnd, WPARAM wParam, LPARAM lParam);
extern	long GetEWPalette(HWND hWnd, WPARAM wParam, LPARAM lParam);
extern	long CopyEW(HWND hWnd, UINT flags, LPRENDERINFO lpRI);
extern	long PaintEW(HWND hWnd, HDC hDC, LPRECT lprc);

/* preserve the instance handle */
HINSTANCE ghInst = 0;

/*
 * This file is a template for a MediaView DLL.  It contains
 * contains placeholder routines for ahandling all of the
 * calls and messages that MediaView will generate when using
 * the DLL.
 */

char szEWClassName[] = "MV12_EW";


/*
 * The documentation calls for these two routines in the DLL without
 * specifying what they need to do.
 */
int WINAPI InitiateMVSampEW(HINSTANCE hInst)
	{
	WNDCLASS wc;

	wc.lpszClassName  = szEWClassName;
	wc.style          = CS_VREDRAW | CS_HREDRAW;
	wc.hCursor        = 0;
	wc.hIcon          = 0;
	wc.lpszMenuName   = 0;
	wc.hbrBackground  = COLOR_WINDOW + 1;
	wc.hInstance      = hInst;
	wc.lpfnWndProc    = EWProc;
	wc.cbClsExtra     = 0;
	wc.cbWndExtra     = 0;

	if (!RegisterClass(&wc))
		return FALSE;

	/* any other initialization code goes here */
	
	return TRUE;
	}

int WINAPI TerminateMVSampEW(HINSTANCE hInst)
	{
	UnregisterClass(szEWClassName, hInst);
	return(0);
	}

/****************************************************************************
 **     FUNCTION: LibMain                                                  **
 **     PURPOSE: initialize the embedded window DLL                        **
 **     COMMENTS:                                                          **
 ****************************************************************************/
BOOL WINAPI LibMain( HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpCmdLine)
	{
	return(InitiateMVSampEW(hInstance));
	}

/****************************************************************************
 **     FUNCTION: EWProc                                                   **
 **     PURPOSE: Embedded Window procedure. Handles all messages,          **
 **        including the EWM_* messages sent from MediaView.					 **
 **     COMMENTS:                                                          **
 **        Return TRUE/FALSE for EWM_* messages, or Windows message        **
 **        returns as needed.                                              **
 ****************************************************************************/
long CALLBACK EWProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
	long iRet;
	PAINTSTRUCT ps;
	RECT rect;

	switch(msg)
		{
			
		case WM_CREATE:
			/* put any window initialization code here */
			return InitEW(hWnd, wParam, lParam);

    case WM_DESTROY:
			return DestroyEW(hWnd, wParam, lParam);
        break;
        
		case WM_PAINT:
			{
			BeginPaint( hWnd, &ps );
			GetClientRect(hWnd, &rect);
			iRet = PaintEW(hWnd, ps.hdc, &rect);
			EndPaint( hWnd, &ps );
        return(iRet);
			}
    
		case EWM_COPY:
			/* Copy text if there is any. */
        return CopyEW(hWnd, wParam, (LPRENDERINFO)lParam);

		case EWM_PRINT:
			/* render the embedded window ... it might be a screen or a printer DC */
        return PrintEW(hWnd, (LPRENDERINFO)lParam);

		case EWM_QUERYSIZE:
			/* return the embedded window size */
        return GetEWSize(hWnd, (HDC)wParam, (LPPOINT)lParam);
        
		case EWM_ACTIVATE:
			/* if there are any media engines, activate them */
			return ActivateEW(hWnd, wParam, lParam);

		case EWM_ASKPALETTE:
			/* return palette information to MediaView */
			return GetEWPalette(hWnd, wParam, lParam);

		default:
			return DefWindowProc(hWnd, msg, wParam, lParam);
		}
	}

/****************************************************************************
 **     FUNCTION: InitEW                                                   **
 **     PURPOSE: Initialize the embedded window.                           **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long InitEW(HWND hWnd, WPARAM wParam, LPARAM lParam)
	{
	LPCREATESTRUCT lpCreate;
	LPEWDATA lpEW;

	/*
	 * The Embedded Window is being created.  The lpCreateParams
	 * contains an EWDATA structure.
	 */
	lpCreate = (LPCREATESTRUCT)lParam;
	lpEW = (LPEWDATA)lpCreate->lpCreateParams;

	if (lpEW == NULL)
		return -1;

	return(0);
	}

/****************************************************************************
 **     FUNCTION: DestroyEW                                                **
 **     PURPOSE: Destroy the embedded window.                              **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long DestroyEW(HWND hWnd, WPARAM wParam, LPARAM lParam)
	{
	return(FALSE);
	}

/****************************************************************************
 **     FUNCTION: PrintEW                                                  **
 **     PURPOSE: Render the Embedded Window.                               **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long PrintEW(HWND hWnd, LPRENDERINFO lpRI)
	{
	return(TRUE);
	}

/****************************************************************************
 **     FUNCTION: GetEWSize                                                **
 **     PURPOSE: Tell MediaView the Embedded Window size (or tell          **
 **       it to use the default size).                                     **
 **     COMMENTS:                                                          **
 **       This is called so that MediaView can layout text around it.      **
 **       The code below is only placeholder ... the actual size depends   **
 **       on what the DLL is displaying.                                   **
 ****************************************************************************/
long GetEWSize(HWND hWnd, HDC hDC, LPPOINT lpP)
	{
	RECT rect;

	GetClientRect(hWnd, &rect);
	lpP->x = rect.right;
	lpP->y = rect.bottom;
	return(TRUE);
	}

/****************************************************************************
 **     FUNCTION: ActivateEW                                               **
 **     PURPOSE: MediaView wants any Media engines in this EW activated.   **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long ActivateEW(HWND hWnd, WPARAM wParam, LPARAM lParam)
	{
	return(TRUE);
	}

/****************************************************************************
 **     FUNCTION: GetEWPalette                                             **
 **     PURPOSE: Return a palette if one is needed.                        ** 
 **     COMMENTS:                                                          **
 ****************************************************************************/
long GetEWPalette(HWND hWnd, WPARAM wParam, LPARAM lParam)
	{
	return(0);
	}

/****************************************************************************
 **     FUNCTION: CopyEW                                                   **
 **     PURPOSE: If this EW contains text, pass the CF_TEXT back to        **
 **        MediaView.                                                      **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long CopyEW(HWND hWnd, WPARAM flags, LPRENDERINFO lpRI)
	{
	return(FALSE);
	}

/****************************************************************************
 **     FUNCTION: PaintEW                                                  **
 **     PURPOSE: Render the window display.  It may be a DC for the screen **
 **       or for a printer, so render it accordingly.                      **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long PaintEW(HWND hWnd, HDC hDC, LPRECT lpR)
	{
	return(TRUE);	
	}

/****************************************************************************
 **     FUNCTION: WEP                                                      **
 **     PURPOSE: Standard Windows Exit Procedure                           **
 **     COMMENTS:                                                          **
 **        The _export makes sure we can access the global variable in DS. **
 ****************************************************************************/
int CALLBACK _export WEP(int nExitType)
	{
	TerminateMVSampEW(ghInst);
	return(1);
	}
