
#ifndef __MVTITLE_H_
#define __MVTITLE_H_

#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************
*
* MVTtl12.H
*
* Copyright (c) Microsoft Corporation 1993
* All rights reserved.
*
*************************************************************************
*
*   The MVTitle API
*
* Module intent: Header file for the MVTTL12.DLL.
*
*************************************************************************
*
* Current owner: RHobbs
*
************************************************************************/

typedef HANDLE HTITLE;    // Handle to a Title
typedef struct _TITLE TITLE, NEAR *PTITLE, FAR *LPTITLE;
typedef HANDLE HTLIST;    // handle to a Topic List
typedef HANDLE HWHEEL;
typedef DWORD  HASH;

typedef struct
  {
  int iError;
  int iStart;
  int iLength;
  } QUERYERR, FAR * LPQUERYERR;

#define IMPLICIT_AND    0
#define IMPLICIT_OR     1

#define TL_AND  0
#define TL_OR   1
#define TL_NOT  2

#define TTLINF_TITLE           1
#define TTLINF_COPYRIGHT       2
#define TTLINF_NUMTOPICS      11
#define TTLINF_HASINDEX      100
#define TTLINF_TOPICADDR     101
#define TTLINF_TOPICTITLE    102
#define TTLINF_FILESYS       105
#define TTLINF_FILENAME      106
#define TTLINF_ADDRTITLE     110
#define TTLINF_FONTTABLE     111

// These must be the same as equivalents in FONT.H!
#define fSMALLCAPS     0x0004
#define fNOUNDERLINE   0x0008
#define fDOTUNDERLINE  0x0010
#define fWORDUNDERLINE 0x0020
#define fDBLUNDERLINE  0x0030

#define STYLESIZE      64

#define addrNil ((ADDR)-1)



extern HTITLE FAR PASCAL _loadds TitleOpen(LPCSTR);
extern HTITLE FAR PASCAL _loadds TitleOpenEx(LPCSTR, FARPROC, LPVOID, BOOL);
extern void   FAR PASCAL _loadds TitleClose(HTITLE);


extern ADDR   FAR PASCAL _loadds addrConvertHash(HTITLE, HASH);
extern ADDR   FAR PASCAL _loadds addrConvertTopicNumber(HTITLE, LONG);
extern ADDR   FAR PASCAL _loadds addrConvertContextString(HTITLE, LPCSTR);
extern ADDR   FAR PASCAL _loadds addrGetContents(HTITLE);
extern VA     FAR PASCAL _loadds vaConvertAddr(HTITLE, ADDR);
extern VA     FAR PASCAL _loadds vaConvertHash(HTITLE, HASH);
extern VA     FAR PASCAL _loadds vaConvertTopicNumber(HTITLE, LONG);
extern VA     FAR PASCAL _loadds vaConvertContextString(HTITLE, LPCSTR);
extern VA     FAR PASCAL _loadds vaGetContents(HTITLE);

// use the following to manage topic lists
extern HTLIST FAR PASCAL _loadds TopicListLoad(HTITLE, LPCSTR);
extern HTLIST FAR PASCAL _loadds TopicListFromQuery(HTITLE, WORD, LPCSTR,
                                                    HTLIST, WORD, FARPROC,
                                                    LPHANDLE, LPQUERYERR);
extern HTLIST FAR PASCAL _loadds TopicListFromTopicNo(HTITLE, long);
extern void   FAR PASCAL _loadds TopicListDestroy(HTLIST);
extern long   FAR PASCAL _loadds TopicListLength(HTLIST);
extern long   FAR PASCAL _loadds TopicListLookup(HTLIST, long);
extern HTLIST FAR PASCAL _loadds TopicListCombine(int,HTLIST,HTLIST,BOOL);

// Use the following for access to the Highlight API.
long   FAR PASCAL _loadds HighlightMatchFind(HANDLE, long, DWORD,
                                             DWORD FAR *, DWORD FAR *);
int    FAR PASCAL _loadds HighlightMatchGet(HANDLE, long, long,
                                            DWORD FAR *, DWORD FAR *);
long   FAR PASCAL _loadds HighlightMatchCount(HANDLE, long);
HANDLE FAR PASCAL _loadds HighlightsInTopic(HANDLE, long);

//  Use the following for access to the Word Wheel API.
extern HWHEEL FAR PASCAL _loadds WordWheelOpen(LPCSTR, LPCSTR);
extern void   FAR PASCAL _loadds WordWheelClose(HWHEEL);
extern long   FAR PASCAL _loadds WordWheelLength(HWHEEL);
extern long   FAR PASCAL _loadds WordWheelPrefix(HWHEEL,LPCSTR);
extern BOOL   FAR PASCAL _loadds WordWheelLookup(HWHEEL,long,LPBYTE,int);
extern long   FAR PASCAL _loadds KeyIndexGetAddrs (HWHEEL,LPBYTE,int,int,LPBYTE);
extern WORD   FAR PASCAL _loadds KeyIndexGetCount (HWHEEL,LPBYTE);

// Get the resource string corresponding to an error number
// returned from TopicListFromQuery()
extern int    FAR PASCAL _loadds QueryGetErrorMessage(WORD, LPSTR, int);

extern long   FAR PASCAL _loadds TitleGetInfo(HTITLE, int, long, long);
extern BOOL   FAR PASCAL _loadds TitleValid(HTITLE);


extern long _loadds FAR PASCAL lFontTableSize(HANDLE, LPERR);
extern int  _loadds FAR PASCAL iCharStyleCount(HANDLE, LPERR);

extern BOOL _loadds FAR PASCAL fGetCharStyle(HANDLE, LPINT,
                                             LPSTR, LPLOGFONT, 
                                             RGBTRIPLE FAR *, RGBTRIPLE FAR *,
                                             LPINT, LPBYTE, LPERR);

extern BOOL _loadds FAR PASCAL fSetCharStyle(HANDLE, int,
                                             LPSTR, LPLOGFONT,
                                             RGBTRIPLE FAR *, RGBTRIPLE FAR *,
                                             LPINT, LPBYTE, LPERR);

#ifdef __cplusplus
}
#endif

#endif  // __MVTITLE_H_

