// vogonvw.h : interface of the CVogonView class
//
/////////////////////////////////////////////////////////////////////////////

class CVogonCntrItem;

class CVogonView : public CView
{
protected: // create from serialization only
   CVogonView();
   DECLARE_DYNCREATE(CVogonView)

// Attributes
public:
   CVogonDoc* GetDocument();
   // m_pSelection holds the selection to the current CVogonCntrItem.
   // For many applications, such a member variable isn't adequate to
   //  represent a selection, such as a multiple selection or a selection
   //  of objects that are not CVogonCntrItem objects.  This selection
   //  mechanism is provided just to help you get started.

   // TODO: replace this selection mechanism with one appropriate to your app.
   CVogonCntrItem* m_pSelection;
   // The slide show timer ID (also timer-active flag)
   UINT            m_idTimerSlides;
   CTime           m_timeLastSlide;

// Operations
public:
   void doActiveSelection() {if (m_pSelection) m_pSelection->DoVerb(OLEIVERB_UIACTIVATE, this);};

// Implementation
public:
   virtual ~CVogonView();
   virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
   virtual void AssertValid() const;
   virtual void Dump(CDumpContext& dc) const;
#endif

protected:
   virtual void OnInitialUpdate(); // called first time after construct

   // OLE Container support
   virtual BOOL IsSelected(const CObject* pDocItem) const;

// Generated message map functions
protected:
   //{{AFX_MSG(CVogonView)
   afx_msg void OnSetFocus(CWnd* pOldWnd);
   afx_msg void OnSize(UINT nType, int cx, int cy);
   afx_msg void OnInsertWebster();
	afx_msg void OnAboutWebster();
	afx_msg void OnShowPropertyInspector();
	afx_msg void OnUpdateShowPropertyInspector(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewAboutwebster(CCmdUI* pCmdUI);
	afx_msg void OnActivateWebster();
	afx_msg void OnUpdateSlideShow(CCmdUI* pCmdUI);
	afx_msg void OnSlideShow();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	//}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in vogonvw.cpp
inline CVogonDoc* CVogonView::GetDocument()
   { return (CVogonDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
