unit X_detect;
(*                                                                       *)
(* ****** XLIB - Mode X graphics library                **************** *)
(*                                                                       *)
(* X_Dectect                                                             *)
(*                                                                       *)
(* Hardware detection module                                             *)
(*                                                                       *)
(* x_graphics,x_mousedriver       Written By Themie Gouthas              *)
(* x_processor,x_coprocessor      Written By Martin Althaus (DOS 2'91)   *)
(* Converted in TP                By Christian Harms                     *)
(*                                                                       *)
(* Gouthas : egg@dstos3.dsto.gov.au or teg@bart.dsto.gov.au              *)
(* Harms   : harms@minnie.informatik.uni-stuttgart.de                    *)
(*                                                                       *)
(* Attention: x_coprocessor are irrespective of x_processor , because    *)
(*            the following combinations are possible:                   *)
(*                                                                       *)
(*            8087   :  8086,8088,80186,80188                            *)
(*            80287  :  80286,80386DX,80386SX                            *)
(*            80387  :  80386,80486SX,(80486DX intern)                   *)


interface

const pz8086    = 0    ;           (* Processor    *)
      pz8088    = 1    ;
      pzV20     = 2    ;
      pzV30     = 3    ;
      pz80186   = 4    ;
      pz80188   = 5    ;
      pz80286   = 6    ;
      pz80386   = 7    ;
      pz80486   = 8    ;

      cp_no     = 0    ;           (* Co-Processor *)
      cp8087    = 1    ;
      cp80287   = 2    ;
      cp80387   = 3    ; (* He is in all 486DX ! *)

      NONE      = 0    ;           (* Video-Card   *)
      MDA       = 1    ;
      CGA       = 2    ;
      EGAMono   = 3    ;
      EGAColor  = 4    ;
      VGAMono   = 5    ;
      VGAColor  = 6    ;
      MCGAMono  = 7    ;
      MCGAColor = 8    ;

      BUS_MOUSE    = 1 ;           (* Mouse Driver *)
      SERIAL_MOUSE = 2 ;
      INPORT_MOUSE = 3 ;
      PS2_MOUSE    = 4 ;
      HP_MOUSE     = 5 ;


var   MouseButtonCount,MouseVersion : Word;
      MouseType,MouseIRQ            : Byte;

function x_graphics_card : Word;
function x_mousedriver   : Boolean;
function x_processor     : Word;
function x_coprocessor   : Word;

(* Strings for constants of pzXXX,cpXXX and Video-Modes. *)
const pzNames  : Array[0..8] of String[11] =
        ('Intel 8086' ,'Intel 8088','NEC V20','NEC V30','Intel 80186','Intel 80188','Intel 80286','Intel 80386','Intel 80486');
      (* Example : WriteLn('CPU :',pzNames[GetCPU]);        *)
      cpNames  : Array[0..3] of String[11] =
        ('none','Intel 8087','Intel 80287','Intel 80387');
      VideoNames : Array[0..8] of String[10] =
        ('NONE','MDA','CGA','EGA Mono','EGA Color','VGA Mono','VGA Color','MCGA Mono','MCGA Color');


implementation

uses My_Asm;

const  PS2_CARDS : Array[0..12] of Byte = (0,1,2,2,4,3,2,5,6,2,8,7,8);

function x_graphics_card:Word;       assembler;
asm
	mov  ax,$1A00           (* Try calling VGA Identity Adapter function *)
	int  10h
	cmp  al,1Ah             (* Do we have PS/2 video bios ?             *)
	jne  @@not_PS2          (* No!                                      *)

	cmp  bl,0Ch             (* bl > 0Ch => CGA hardware                 *)
	jg   @@is_CGA           (* Jump if we have CGA                      *)
	xor  bh,bh
	xor  ah,ah
	mov  al,ds:[offset PS2_CARDS+bx](* Load ax from PS/2 hardware table *)
	jmp  @@done             (* return ax                                *)
@@is_CGA:
	mov  ax,CGA             (* Have detected CGA, return id             *)
	jmp  @@done
@@not_PS2:                      (* OK We don't have PS/2 Video bios         *)
	mov  ah,12h             (* Set alternate function service           *)
	mov  bx,10h             (* Set to return EGA information            *)
	int  10h                (* call video service                       *)
	cmp  bx,10h             (* Is EGA there ?                           *)
	je   @@simple_adapter   (* Nop!                                     *)
	mov  ah,12h             (* Since we have EGA bios, get details      *)
	mov  bl,10h
	int  10h
	or   bh,bh              (* Do we have colour EGA ?                  *)
	jz   @@ega_color        (* Yes                                      *)
	mov  ax,EGAMono         (* Otherwise we have Mono EGA               *)
	jmp  @@done
@@ega_color:
	mov  ax,EGAColor        (* Have detected EGA Color, return id       *)
	jmp  @@done
@@simple_adapter:
	int  11h                (* Lets try equipment determination service *)
	and  al,30h
        mov  cl,4
	shr  al,cl
	xor  ah,ah
	or   al,al              (* Do we have any graphics card at all ?    *)
	jz   @@done             (* No ? This is a stupid machine!           *)
	cmp  al,3               (* Do We have a Mono adapter                *)
	jne  @@is_CGA           (* No                                       *)
	mov  ax,MDA             (* Have detected MDA, return id             *)
@@done:
end;


(*  Returns True, if mouse driver found, false otherwise.                   *)
function x_mousedriver:Boolean;     assembler;
asm
	       mov  ax,$3533       (* Get int 33 interrupt vector           *)
	       int  21h            (* Call dos                              *)
	       mov  cx,false       (* Clear "found" flag                    *)
	       mov  ax,es          (* Is the vector null (ES==0 && BX==0) ? *)
	       or   bx,ax
	       jz   @@NoMouseDriver(* Yes! No mouse driver installed - Jump *)

	      (* Just make absolutely sure the vector points to the mouse   *)
	      (* driver (just in case)                                      *)

	       xor  ax,ax          (* FUNC 0: Mouse Initialization          *)
	       int   33h
	       or    ax,ax         (* Do we have an installed mouse driver ?*)
	       jz    @@NoMouseDriver (* No ? *)
	       mov   MouseButtonCount,bx

	       mov   ax,24h
	       int   33h
	       mov   MouseVersion,bx
	       mov   MouseType,ch
	       mov   MouseIRQ,cl

	       mov  cx,true        (* Yes! set flag                         *)

@@NoMouseDriver:
	       mov  ax,cx          (* Return "found" flag                   *)
end;

function x_processor:Word; assembler;
label queue486; (* forward declaration necessary for TP *)
asm
    pushf
    xor   bx,bx
    push  bx
    popf
    pushf
    pop   bx              (* get flags      *)
    and   bx,$f000        (* higher 4 bits  *)
    cmp   bx,$f000        (* all equal ?    *)
    je   @No286_386
    mov   dx,pz80386
    mov   bx,$7000        (* set bits 12-14 *)
    push  bx
    popf
    pushf
    pop   bx              (* get flags      *)
    and   bx,$7000        (* all bit = 0?   *)
    jne  @it_is486
    mov   dx,pz80286
    jmp  @ende
@it_is486:
    xor   si,si
    mov   byte ptr [cs:offset queue486+11],$46  (* $46 means <inc si> *)
queue486:
    db    $90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90,$90
    cmp   si,0
    jne  @ende
    mov   dx,pz80486
    jmp  @ende
@No286_386:
    mov   dx,pz80188
    mov   al,$ff
    mov   cl,$21
    shr   al,cl
    jne  @TestDatabus     (* difference between 80186 and 80188 *)
    mov   dx,pzv20
    sti
    mov   si,0
    mov   cx,$ffff
    db    $F3,$26,$AC     (* => rep lods byte ptr es:[si]  , but TP-asm *)
                          (* would not compile this expression :-(      *)
    cmp   cx,0
    je   @TestDatabus
    mov   dx,pz8086       (* It's an 8086 or 8088               *)
@TestDatabus:
    push  cs
    pop   es
    xor   bx,bx
    std
    mov   al,$90
    mov   cx,3

      pop   di
      push  di
      add   di,9

    cli
    rep   stosb
    cld
    nop
    nop
    nop
    inc   bx
    nop
    sti
    cmp   bx,0
    je   @ende
    cmp   dx,pz8086
    je   @it_is8088
    cmp   dx,pzV20
    je   @it_isV20
    cmp   dx,pz80186
    jne  @ende
    mov   dx,pz80188
    jmp  @ende
@it_is8088:
    mov   dx,pz8088
    jmp  @ende
@it_isV20:
    mov   dx,pzV20
    jmp  @ende
@ende:
    popf
    mov ax,dx
end;

(* Attention : TP make some changes on asm-code with coprozessor.          *)
(* Therefor some asm-commands are as dw xx, so can't TP change coproz.- *)
(* code. Tasm/Masm-friends can use the original-code in the comments.      *)
function x_coprocessor:Word; assembler;
label n1,n2;    (* forward declaration necessary for TP *)
var cputest:Word;
asm;
      mov    dx,cp_no
      mov    byte ptr [cs:offset n1],$90 (* If no Coproz., wait can make trouble. *)
      mov    byte ptr [cs:offset n2],$90
n1:   wait       (* ! <wait> would automaticly insert by Tasm/Masm ! -> If  *)
                 (* you want to use this code in really asm-code, you should*)
                 (* remove all wait-commands in this source-code.           *)
                 (* ASM-Freaks: <;> is here not the begin of a comment !    *)
      fninit
      mov    byte ptr [offset cputest+1],0
n2:   wait
      fnstcw word ptr [offset cputest]
      mov    ah,byte ptr [offset cputest+1]
      cmp    ah,3
      jne   @cpende
      mov    dx,8087
      and    cputest,$ff7f
 wait;dw _fldcw,Offset Cputest (* fldcw word ptr [offset cputest] *)
 wait;fndisi
 wait;fnstcw word ptr [offset cputest]
      test   cputest,$80
      jne   @cpende
      mov    dx,cp80287
 wait;fninit
 wait;dw _fld1                 (*  fld1             *)
 wait;dw _fldz                 (*  fldz             *)
 wait;dw _fdivp                (*  fdivp st(1),st   *)
 wait;dw _fld                  (*  fld   st(0)      *)
 wait;dw _fchs                 (*  fchs             *)
 wait;dw _fcompp               (*  fcompp           *)
 wait;fnstcw word ptr [offset cputest]
      mov    ax,cputest
 wait;sahf
      je    @cpende
      mov    dx,cp80387
@cpende:
      mov    ax,dx
end;

end.