procedure LOADPCX(filename:string;paletteptr,gfxdataptr:pointer);
(*
  24/2/95 11:10
  PCX loader routine writen by Zorlim (Sami Lehtinen)
  E-Mail: Zorlim@freenet.hut.fi (All questions are welcome)

  PLEASE NOTIFY!

  1) This routine decodes only "normal" (type 5) pcx pictures, with
     resolution 320*200!

  2) If your .pcx file is bigger than 64000 bytes this routine will mess up
     end of picture and palette. (coz input buffer is only 64000 bytes)
     Reason why there is size limit was that I wantted just do as simple
     pcx decoder as possible.

  Usage 
  {$I pcxload.pas}
*)
type
  tdata=array[0..$F9FF] of byte; {Data type}
  tpal=array[0..$2FF] of byte;   {Palette type}
var
 dfile:file; {Data file}
 {Position meters}
 ibp:word;  {Input data position meter}
 {Decoding}
 rc:byte;   {Repeat count counter}
 {Scanline thigns}
 sls:word;  {How much data is already decoded}
 slp:word;  {Position on scanline being to processed}
 {Buffers}
 ibf:^tdata; {Input buffer}
 obf:^tdata; {Output buffer}
 {Paltte things}
 pal:^tpal;  {Array for palette values}
 plp:byte;   {Palette position, used when decoding}
begin {Begin of LOADPCX procedure}
  {Set up}
  new(ibf);               {Get memory for input buffer}
  obf:=gfxdataptr;        {Locate output to given memory address}
  pal:=paletteptr;        {Locate palette to given memory address}
  {Loading stuff}
  assign(dfile,filename); {Open data file}
  reset(dfile,1);         {Reset datafile}
  blockread(dfile,ibf^,$80); {Discard header}
  blockread(dfile,ibf^,filesize(dfile)-$80); {Read data from file}
  close(dfile); {Close file, if you didnt figure that out}
  {Decode PCX image}
  ibp:=0;  {Set input pointer to 0}
  sls:=0;  {Set amout of data decoded to zere}
  while sls<$FA00 do begin {Relpeat decoding until whole picture is decoded}
    slp:=0; {Reset amount decoded for this gfx line}
    while slp<$140 do begin {Decode all pixels for one gfx line}
      if (ibf^[ibp] and $C0)=$C0 then begin {Determinate if data is compressed}
        {Data is compressed so it must be expanded}
        fillchar(obf^[sls+slp],ibf^[ibp] and $3F,ibf^[ibp+1]); {Move data to it's position}
        inc(slp,ibf^[ibp] and $3F); {Advance amount decoded of this line}
        inc(ibp,2); {Advance input buffer position}
      end else begin
        {And if data is NOT compressed}
        obf^[sls+slp]:=ibf^[ibp]; {Just move data from input to output}
        inc(slp); {Advance amount decoded of this line}
        inc(ibp); {Adanvce input buffer position}
      end;
    end;
    inc(sls,$140); {Advance gfx line to be decoded}
  end;
  {End of image decoding}
  {Get the damn palette}
  inc(ibp); {Advance input buffer position to start of the palette}
  for plp:=0 to $FF do begin {Decode all colors}
    pal^[plp*3+0]:=ibf^[ibp+plp*3+0] shr 2; {Get red   value of color and divide it with 4}
    pal^[plp*3+1]:=ibf^[ibp+plp*3+1] shr 2; {Get green value of color and divide it with 4}
    pal^[plp*3+2]:=ibf^[ibp+plp*3+2] shr 2; {Get blue  value of color and divide it with 4}
  end;
  {End of palette loading}
  dispose(ibf); {Dump input data buffer out}
end; {End of LOADPCX procedure}
