Unit LimitKey;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ A unit to ensure that only a set of prescribed key presses will  }
{ be accepted by the program. The procedure LimitChar has three    }
{ parameters, one to declare the set of acceptable characters as a }
{ string, the second the variable name for the entered character   }
{ and the third a boolean value indicating whether the keypress    }
{ involved an Escape Sequence (27;nn) or an Extended Code (0;nn).  }
{ Based on a unit by David Arber of David Arber Associates.        }
{                                                                  }
{ LIMITKEY.PAS  ->  .TPU      R Shaw            3.12.92            }
{__________________________________________________________________}

Interface

Uses Crt;

Procedure LimitChar(s : string; var Key : char; var Ekey : boolean);

Implementation

Procedure LimitChar(s : string; var Key : char; var Ekey : boolean);
begin
  repeat
    Ekey := False;
    Key  := Readkey;
    if Key = #0 then
      begin
        Ekey := True;
        Key  := Readkey;
        exit;
      end;
    if Key = #27 then
      begin
        Ekey := True;
        Key  := Readkey;
        exit;
      end;
  until pos(Key,s) > 0;
end;

end.
