
{******************************************}
{*                                        *}
{* Example for MGFOSSIL unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses crt,mgmisc,mgkeyb,mgfossil,mgstring;

var
  Com  : word;
 _mx5,
 _x00  : boolean;


procedure terminal; { Small terminal to test functions }
label
 _exit;
var
 key : word;
 c   : char;
 i   : integer;
 x,y : byte;

begin
   clrscr;
   writeln(' alt-o purgeout');
   writeln(' alt-i purgein');
   writeln(' alt-f flushout');
   writeln(' alt-c cold reboot');
   writeln(' alt-w warm reboot');
   writeln(' alt-b send break');
   writeln(' alt-h hang up');
   writeln(' esc   exit');

     repeat
           if iskeypressed then
           begin
                key := getkey;
                c:=char(lo(Key));

                { write character in output buffer. }
                if not foswrite (com, byte(c)) then;
                (* These function can also be use...
                foswritew (com: word; character: char);}
                foswriteblock (com var userbuffer; maxwrite: word): word;}
                *)

                if      key = keyalto then fospurgeout(com)
                else if key = keyalti then fospurgein(com)
                else if key = keyaltf then fosflushout(com)
                else if key = keyaltc then foscoldreboot
                else if key = keyaltw then foswarmreboot
                else if key = keyaltb then fossendbreak (com, 500)

                else if key = keyalth then
                begin
                     fossetdtr(com, false);
                     delayms(500);
                     fossetdtr(com, true);
                end
                else if key = keyesc then goto _exit
                else write(c);
           end;

           if fosdataavail (com) then
           begin
            { input buffer not empty.  Another way to find if input buffer, }
            { is not empty is to test (fosbufferleft=inputsize)            }

            {read character from port.}
            c := char(fosreadw(com));
            {fosreadw (com: word): char;
            {fospeekch (com: word): integer;}
            {fosrecvblock (com, var userbuffer; maxwrite: word): word;}

            fosdoswrite (char(c));
            {fosbioswrite (character: char);}
           end;


           { Save cursor position }
           x:=wherex;
           y:=wherey;

           { Write information }
           window(1,24,80,25);
           gotoxy(1,1);
           write('CD=',foscdstatus(com),' OutputLeft:', fosgetoutleft(com),
           ' InputLeft:', fosgetinleft(com));

           { restore screen size and cursor }
           window(1,1,80,23);
           gotoxy(x,y);

     until false = true;

_exit:
     window(1,80,25,80);
end;

var
 FosInfo : fosstruct;
 row,col : byte;
 tickint,
 ticksec : byte;
 tickms  : word;
 mx5     : mx5structptr;
 b       : byte;
 l       : longint;
 w       : word;
 bool    : boolean;
 c       : char;

begin

 clrscr;
 fossetcrsloc (10,10);    { set cursor pos using fossil }
 fosgetcrsloc (row, col); { get cursor pos using fossil }

 com := 1;
 _mx5 := mx5init(com);    { Try to init mx5 }
 _x00 := X00init(com);    { Try to init x00 }

 if _mx5 or _x00 or (fosinit(Com)) then
 begin
      { Set 2400,8,N,1 }
      fossetparams(com, Bauds2400+datalen8+Paritynone+stopbitone);
      fossetflowctrl (com, $0); { disable CTS/CTS/XonXoff }
      fosctrlck (com, false,false);
      fossetwatchdog (com, false);

      { get driver information }
      fosgetinfo (com, @fosinfo);
      writeln('Major version       = ',fosinfo.majver);
      writeln('Minor version       = ',fosinfo.minver);
      writeln('space in out buffer = ',fosgetoutleft(com));
      writeln('space in in buffer  = ',fosgetinleft(com));
      writeln('inbuffer size       = ',fosgetinsize (com));
      writeln('outbuffer size      = ',fosgetoutsize (com));
      writeln('baud                = ',fosgetbaud (com));

      writeln('screen width           = ', fosgetswidth(com));
      writeln('screen height          = ', fosgetsheight(com));
      writeln('fossil name            = ', Null2Pascal(fosgetnameptr(com)));
      writeln('is inbuffer overrun    = ', fosinoverrun(com));
      writeln('is output buffer full  = ', fosspaceinoutbuf(com));
      writeln('is output buffer empty = ', fosoutbufempty(com));

      Terminal;

 end;

 if _mx5 then { if mx5 as been detect... }
 begin
       mx5 := mx5getinfo (com);
       writeln('max speed received = ',mx5^.maxrcvspeed);

       b := mx5setmnplvl (com, 5);
       b := mx5getmnplvl (com);
       b := mx5getmnpansorgmode (com);
       b := mx5setmnpansorgmode (com, 1);
       b := mx5getmnpwaittck (com);
       b := mx5setmnpwaittck (com, 5);
       b := mx5getmnpconnectsndlvl (com);
       b := mx5setmnpconnectsndlvl (com, 1);

       {mx5waitticks (100); this one seem to freeze some systeme}

       writeln(mx5getactiveflag (com));
       b:=mx5getid (com);
       l:=mx5getpacketssend (com);
       l:=mx5getmaxsndspeed (com);
       l:=mx5gettotalpacketrecv (com);
       l:=mx5getduppacketrecv (com);
       l:=mx5getduppackets (com);
       l:=mx5getmaxrcvspeed (com);

       mx5uninstall(false);
 end;

 if _x00 then { X00 specific commands }
 begin
      X00extinit (com, 0, Bauds2400, Datalen8, Paritynone, stopbitone);

      bool := X00getrts (com);
      bool := X00getout1 (com);
      bool := X00getout2 (com);
      bool := X00getlooptest (com);

      X00setrts (com, false);
      X00setout1 (com, false);
      X00setout2 (com, false);
      X00setlooptest (com, false);

      if X00writein (com, 65) then
      begin
       { character put in input buffer }
      end;

      if X00peek (com, c) then
      begin
      {}
      end;

      X00done (com);
 end;

 fosdeinit(com);

end.
