
{******************************************}
{*                                        *}
{* Example for MGWINDOW unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgscreen, mgkeyb, mgwindow;

var
  i,j,
  key     : word;
  wins    : Array[1..5] of pwinrec;
  b,c     : byte;
  buffer  : array[1..2000] of byte;
  pos     : array[1..5] of record x,y,xd,yd:integer; end;

begin

  { Window as been initialize ??? }
  if Not WinInit Then halt;

  fastcls('',$7A);

  { Open five windows... }

  wins[1] := WinOpen(50, 5, 75, 15,
                     $0E, $0F, $0F, fdouble, 0, true,  $07, 'Window #1');


  wins[5] := WinOpen(3, 3, 40, 13,
                     $27, $29, $03, fnone, 0, true,  $07, 'Window #5');

  wins[2] := WinOpen(2, 15, 60, 20,
                     $37, $3F, $3F, fsingle, 0, true,  $07, 'Window #2');


  wins[4] := WinOpen(60, 15, 80, 24,
                     $0E, $0A, $0A, fdoublesingle, 0, false, $07, 'Window #4');


  wins[3] := WinOpen(30, 15, 50, 18,
                     $7F, $2E, $7F, fnone,   0, true,  $07, '');


  { Set position of window... This is use to move all windows }
  pos[1].x := 50; pos[1].y := 5;  pos[1].xd := 2;  pos[1].yd := -1;
  pos[2].x := 2;  pos[2].y := 15;  pos[2].xd := 2; pos[2].yd := -3;
  pos[3].x := 30; pos[3].y := 15; pos[3].xd := 0;  pos[3].yd := -2;
  pos[4].x := 60; pos[4].y := 15;  pos[4].xd := -1; pos[4].yd := 2;
  pos[5].x := 3;  pos[5].y := 3;  pos[5].xd := 1;  pos[5].yd := 1;

  repeat

    for i := 1 to 1000 do
    begin
      { Write characters inside each window }
      if wins[1] <> nil then winch(wins[1],chr(i mod 9 + ord('0')));
      if wins[2] <> nil then winch(wins[2],chr(i mod 9 + ord('0')));
      if wins[3] <> nil then winch(wins[3],chr(i mod 9 + ord('0')));
      if wins[4] <> nil then winch(wins[4],chr(i mod 9 + ord('0')));
      if wins[5] <> nil then winch(wins[5],chr(i mod 9 + ord('0')));
    end;


    for i := 1 to 5 do
    begin
      { Change destination of window }
      pos[i].x := pos[i].x + pos[i].xd;
      if pos[i].x <= 0 then
      begin
        pos[i].x := 1;
        pos[i].xd := pos[i].xd * -1;
      end;
      if pos[i].x > screenwidth then
      begin
        pos[i].x := screenwidth;
        pos[i].xd := pos[i].xd * -1;
      end;
      pos[i].y := pos[i].y + pos[i].yd;
      if pos[i].y <= 0 then
      begin
        pos[i].y := 1;
        pos[i].yd := pos[i].yd * -1;
      end;
      if pos[i].y > screenheight then
      begin
        pos[i].y := screenheight;
        pos[i].yd := pos[i].yd * -1;
      end;

      if wins[i] <> nil then
        { Move window }
        if not winmove(wins[i], pos[i].x, pos[i].y) then
        begin
           pos[i].xd := pos[i].xd * -1;
           pos[i].yd := pos[i].yd * -1;
        end;

    end;

  until iskeypressed;
  key := getkey;

  { Save part of window 1 }
  wingetscreen (wins[1], 2,2,10,10,@buffer);

  { Clear window 1 }
  Wincls(wins[1],' ',wins[1]^.textattr);

  { Close window 2 }
  if not WinClose(wins[2]) then;

  { Win in two window }
  Winwriteln(wins[1], 'allo');
  Winwriteln(wins[3], 'TEST');

  { write character at specific position in window 1 }
  WinChxy (wins[1],#2,2,2,$80+$0A);

  Wingotoxy(wins[1],3,3);

  { Make next window active -> On TOP }
  winnext;

  winblink (wins[1], true);
  winforeground (wins[1], 13);
  winbackground (wins[1], 0);
  winwrite (wins[1],'Mglibs');
  winwriteln (wins[1],' For Turbo Pascal');

  { Make window 1 active -> On TOP }
  winactive(wins[1]);

  wingotoxy (wins[1], 5, wins[1]^.y - 1);
  winclreol (wins[1], ' ', wins[1]^.textattr);
  winhomecrs(wins[1]);
  b := lo(wingetca(wins[1]));
  c := hi(wingetca(wins[1]));

  wincursordown(wintop);
  wincursorup(wintop);
  wincursorleft(wintop);
  wincursorright(wintop);

  winchattr (wins[5], #2, $8A);

  winnext;
  winscrollup (wintop, 1);
  winscrolldown (wintop, 2);

  winputscreen (wins[1], 2, 2, @buffer);
  winputscreen (wins[3], 2, 2, @buffer);

  winnext;
  Wincls (wins[3],'',$0F);

  { Redraw window on top }
  winrefresh (wintop);

  { Redraw all window }
  winredrawall;


 {close all automatically}
end.
