
{******************************************}
{*                                        *}
{* Example for MGCOM unit.                *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses crt,mgcom,mgkeyb;

{ This procedure is use to intercept character receive from COM }
procedure KeyFromCom(b:byte);far;
var s:byte;
begin
  s:= textattr;    { save current screen color }
  textattr := $0A; { color = green }
  write(char(b));  { write character }
  textattr := s;   { restore screen color }
end;


procedure terminal; { Simulation of small terminal }
label
 _exit;
var
  key : word;
  c   : byte;
  i   : word;
  s   : string;
begin
     textattr := $07;
     clrscr;

     s := 'ATZ'#13;
     i := portwritestr(s, 500); { Send INIT string }

     delay(1000); { wait for one second }

     { read com port buffer. }
     i := portrecvblock (@s[1], sizeof(s)-1);
     s[0] := char(i);
     write('read from com = ',s);
     write(' : press enter to continue');
     readln;

     { send 2000 bytes of anything to comport... }
     writeln('sending block of bytes');
     i := portwriteblock (@s[1], 2000);
     repeat
       gotoxy(1,wherey);
       write('OutputLeft:', portgetoutleft);
     until portgetoutleft = bufferoutsize;

     writeln;
     { Insert character 'Z' into INPUT buffer }
     if portputchin (byte('Z')) then writeln('Character { Z } insert...');
     writeln;

     {activate hook: procedure KeyFromCom is call if character are receive }
     writeln('Receive hook activated.');
     hookrecvstatus  := true;

     repeat
           if keypressed then
           begin
                textattr := $07;
                key := getkey;
                c:=lo(Key);

                { Send key press to comport }
                if not portwrite(c) then;
                if      key = keyalto then
                begin
                  portpurgeout;
                  writeln('purge output');
                end
                else if key = keyaltz then
                begin
                   hookrecvstatus  := not hookrecvstatus;
                end
                else if key = keyalti then
                begin
                  portpurgein;
                  writeln('purge input');
                end
                else if key = keyaltf then
                begin
                  portflushout;
                  writeln('flush output');
                end
                else if key = keyalth then
                begin
                     writeln('hangup');
                     portsetdtr(false);
                     delay(250);
                     portsetdtr(true);
                end
                else if key = keyesc then goto _exit
                else write(char(c));
           end;

           if (comstatus and $01) = 0 then
           begin
            { input buffer not empty.  }
            c := portread;
            {function  portreadw :  integer;external;}
            write(char(c));
           end;

     until false = true;

_exit:
end;

var
 IBuf,                           { Declaration of 2 Buffer (I/O) }
 OBuf : Array[1..1024] of byte;

begin

 portaddr := $3f8;{ Port Address = 1016 for COM1 }
 portint  := $04; { IRQ = 4 for COM1 }

 { Buffer must be allocate or static, portopen doesn't allocate memory }
 if not portopencom (@IBuf, @OBuf, 1024, 1024) then
 begin
  writeln;
  writeln('error: port not open');
  halt;
 end;

 { install hook procedure }
 hookrecv  := KeyFromCom;

 { set default parameters = 2400,8,N,1 CTS/RTS/XOFF = off }
 portsetparams(pbauds2400, pdatalen8+pstopbitone+pparitynone);
 portsetrtsmode(true);
 portsetctsmode(true);
 portsofthandshake(false);

 Terminal;

 portclosecom; { Close comport This is optional, if you don't close comport
 at end of your program interupt vector will automatically be restore. }


end.

