{$I e_types.inc}

var
  queue_hdr_file  : file of queue_hdr_type;   {Mail queue header file}
  queue_hdr_rec   : queue_hdr_type;

const
  max_retries     = 3;
  queue_hdr_fname : file_path_type = '\EMAIL\E_MQUE.HDR';


procedure cleanup;

var
  last_unit_rn,
  rn            : integer;
  queue_hdr_rec : queue_hdr_type;
  now           : dt_block_type;

begin

  last_unit_rn := filesize(queue_hdr_file) - 1;
  for rn := 1 to last_unit_rn do begin
    seek(queue_hdr_file,rn);
    read(queue_hdr_file,queue_hdr_rec);
    with queue_hdr_rec do begin
      pass_a_retry_count := max_retries;
      pass_b_retry_count := max_retries
    end;
    seek(queue_hdr_file,rn);
    write(queue_hdr_file,queue_hdr_rec);
  end

end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
begin {main}

  assign(queue_hdr_file,queue_hdr_fname);
  reset(queue_hdr_file);

  cleanup;

  close(queue_hdr_file);

end. {main}

