type
  menuitem = array[1..10] of str80;
  menurec  = record
               heading     : str80;
               first_chars : str10;
               item        : menuitem
             end;
{Example :
const
  mainmenu : menurec =
               (heading : 'MAIN MENU';
                first_chars : 'FSNVE';
                item    : ('Function one',
                           'Second function',
                           'None of the above',
                           'Very long menu item',
                           'Exit',
                           '',
                           '',
                           '',
                           '',
                           ''));
}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function menu(m : menurec) : integer;

var
  menuwidth : integer;
  lastitem  : integer;
  i,oldi,j  : integer;
  x1,y1,
  x2,y2     : integer;
  menukey : char;

begin
  clrscr;
  write(chr(27),'y1');

  menuwidth := length(m.heading);
  for i := 1 to 10 do begin
    if length(m.item[i])>menuwidth
      then menuwidth := length(m.item[i]);
    if length(m.item[i])>0
      then lastitem := i
  end;

  showframe;

  ingraph;
  x1 := 40 - (menuwidth shr 1) - 2;
  y1 := 12 - lastitem;
  x2 := x1 + menuwidth + 4;
  y2 := y1 + (lastitem shl 1) + 3;
  textwindow(x1,y1,x2,y2);
  outgraph;
  gotoxy(40 - (length(m.heading) shr 1),y1 + 1);
  write(m.heading);
  for i := 1 to lastitem do
    unliteitem(x1+2,y1+1+(i shl 1),m.item[i]);

  cursoroff;
  i := 1;
  repeat
    hiliteitem(x1+2,y1+1+(i shl 1),m.item[i]);
    oldi := i;
    repeat until keypressed;
    read(kbd,menukey);
    if menukey=#27
      then begin
        read(kbd,menukey);
        if menukey='A'
          then begin
            i := i - 1;
            if i<1
              then i := lastitem
          end
          else if menukey='B'
            then begin
              i := i + 1;
              if i>lastitem
                then i := 1
            end
      end
      else begin
        j := pos(upcase(menukey),m.first_chars);
        if j<>0
          then begin
            i := j;
            unliteitem(x1+2,y1+1+(oldi shl 1),m.item[oldi]);
            hiliteitem(x1+2,y1+1+(i shl 1),m.item[i]);
            delay(200);
            menukey := ^M
          end
      end;
    unliteitem(x1+2,y1+1+(oldi shl 1),m.item[oldi]);
  until menukey=^M;

  cursoron;

  menu := i
end;

