{****************************************************************************

                     Copyright (c) 1994,95 by Florian Klmpfl

 ****************************************************************************}

unit basesym;

  interface

    uses
       cobjects,globals,asmgen,dos,strings;


    type
       { Symboltabelleneintrge }

       tsymtyp = (abstractsym,varsym,typesym,procsym,unitsym,programsym,
                  constsym,aufzaehlsym,typedconstsym,errorsym,syssym);

       pbasesym = ^tbasesym;

       tbasesym = object
          typ : tsymtyp;
          _name : pchar;
          left : pbasesym;
          right : pbasesym;
          speedvalue : longint;
          constructor init(const n : string);
          destructor done;virtual;
          function name : string;
          procedure setname(const s : string);
       end;



       tbasesymtable=object
       end;

  implementation

    constructor tbasesym.init(const n : string);

      begin
         left:=nil;
         right:=nil;
         setname(n);
         typ:=abstractsym;
      end;

    destructor tbasesym.done;

      begin
         if not(use_big) then
           strdispose(_name);
         if assigned(left) then dispose(left,done);
         if assigned(right) then dispose(right,done);
      end;

    function tbasesym.name : string;

      var
         oldpos : longint;
         s : string;
         b : byte;

      begin
         if use_big then
           begin
              oldpos:=symbolstream.getpos;
              symbolstream.seek(longint(_name));
              symbolstream.read(b,1);
              symbolstream.read(s[1],b);
              s[0]:=chr(b);
              symbolstream.seek(oldpos);
              name:=s;
           end
         else
           begin
              name:=strpas(_name);
           end;
      end;

    procedure tbasesym.setname(const s : string);

      begin
         setstring(_name,s);
      end;

end.
